#
# Gtkinter: Wrapper for the gtk module.  This one gives an object oriented
#           feel for the library.  Just type "from Gtkinter import *"
#
# Author: James Henstridge <james@daa.com.au>
#
# TODO
# 1. fix up GtkDrawingArea, GtkImage and GtkPixmap
# 2. document some of this (maybe all of it)
# 3. add wrappers for some of the GDK types.
# 4. make more info about a GtkStyle available to Python code.

# the noinit argument to the constructor of each object should not be used
# when calling the constructor directly.  When it is set to something like
# 1, the corresponding GTK object is not created.  This feature is used to
# implement the new() function, and is used for methods that return Gtk
# Objects, so that the corresponding Gtkinter objects have the correct
# methods.

from GTK import *
import gtk; _gtk = gtk; del gtk
import sys; _sys = sys; del sys
import os ; _os  = os ; del os

# initialise GTK (only if it can find the display -- this avoids segfaults)
if '--display' in _sys.argv or _os.environ.has_key('DISPLAY'):
	_gtk.gtk_init()
else:
	print 'No display information -- gtk_init not called'
_gtk.gtk_rc_init()

class GtkObject:
	def __init__(self, noinit=None):
		if noinit: return
	def set(self, dict):
		_filtprops(dict)
		_gtk.gtk_object_set(self._o, dict)
	def __getitem__(self, key):
		ret = _gtk.gtk_object_get(self._o, key)
		if type(ret) == type(self._o):
			return _obj2inst(ret)
		else:
			return ret
	def __setitem__(self, key, v):
		if hasattr(v, '__class__') and v.__class__ in _supported:
			v = v._o
		_gtk.gtk_object_set(self._o, {key: v});
	def connect(self, name, f):
		_gtk.gtk_signal_connect(self._o, name, f)
	def connect_after(self, name, f):
		_gtk.gtk_signal_connect_after(self._o, name, f)

class GtkData(GtkObject):
	def __init__(self, noinit=None):
		if noinit: return

class GtkAdjustment(GtkData):
	def __init__(self=0, lower=0, upper=0, step_incr=0, page_incr=0,
			page_size=0, noinit=None):
		if noinit: return
		self._o = _gtk.gtk_adjustment_new(lower, upper, step_incr,
			page_incr, page_size)

class GtkWidget(GtkObject):
	def __init__(self, noinit=None):
		if noinit: return
	# extra parameter is so that these funcs can be used as signal funcs
	def activate(self, obj=None):
		_gtk.gtk_widget_activate(self._o)
	def basic(self, obj=None):
		_gtk.gtk_widget_basic(self._o)
	def destroy(self, obj=None):
		_gtk.gtk_widget_destroy(self._o)
	def draw(self, rect):
		_gtk.gtk_widget_draw(self._o, rect)
	def draw_default(self, obj=None):
		_gtk.gtk_widget_draw_default(self._o)
	def draw_focus(self, obj=None):
		_gtk.gtk_widget_draw_focus(self._o)
	def get_ancestor(self, type):
		return _obj2inst(_gtk.gtk_widget_get_ancestor(self._o, type))
	def get_events(self):
		return _gtk.gtk_widget_get_events(self._o)
	def get_extension_events(self):
		return _gtk.gtk_widget_get_extension_events(self._o)
	def get_name(self):
		return _gtk.gtk_widget_get_name(self._o)
	def get_pointer(self):
		return _gtk.gtk_widget_get_pointer(self._o)
	def get_style(self):
		return _gtk.gtk_widget_get_style(self._o)
	def get_toplevel(self):
		return _obj2inst(_gtk.gtk_widget_get_toplevel(self._o))
	def grab_focus(self, obj=None):
		_gtk.gtk_widget_grab_focus(self._o)
	def grab_default(self, obj=None):
		_gtk.gtk_widget_grab_default(self._o)
	def hide(self, obj=None):
		_gtk.gtk_widget_hide(self._o)
	def hide_all(self, obj=None):
		_gtk.gtk_widget_hide_all(self._o)
	def intersect(self, rect):
		return _gtk.gtk_widget_intersect(self._o, rect)
	def is_ancestor(self, a):
		return _gtk.gtk_widget_is_ancestor(self._o, a._o)
	def is_child(self, c):
		return _gtk.gtk_widget_is_child(self._o, c._o)
	def map(self, obj=None):
		_gtk.gtk_widget_map(self._o)
	def popup(self, x, y):
		_gtk.gtk_widget_popup(self._o, x, y)
	def queue_draw(self, obj=None):
		_gtk.gtk_widget_queue_draw(self._o)
	def queue_resize(self, obj=None):
		_gtk.gtk_widget_queue_resize(self._o)
	def realize(self, obj=None):
		_gtk.gtk_widget_realize(self._o)
	def reparent(self, new_parent):
		_gtk.gtk_widget_reparent(self._o, new_parent._o)
	def set_events(self, events):
		_gtk.gtk_widget_set_events(self._o, events)
	def set_extension_events(self, exevents):
		_gtk.gtk_widget_set_extension_events(self._o, exevents)
	def set_name(self, name):
		_gtk.gtk_widget_set_name(self._o, name)
	def set_parent(self, parent):
		_gtk.gtk_widget_set_parent(self._o, parent._o)
	def set_sensitive(self, s):
		_gtk.gtk_widget_set_sensitive(self._o, s)
	def set_state(self, s):
		_gtk.gtk_widget_set_state(self._o, s)
	def set_uposition(self, x, y):
		_gtk.gtk_widget_set_uposition(self._o, x, y)
	def set_usize(self, w, h):
		_gtk.gtk_widget_set_usize(self._o, w, h)
	def show(self, obj=None):
		_gtk.gtk_widget_show(self._o)
	def show_all(self, obj=None):
		_gtk.gtk_widget_show_all(self._o)
	def size_allocate(self, a):
		_gtk.gtk_widget_size_allocate(self._o, a)
	def size_request(self, r):
		_gtk.gtk_widget_size_request(self._o, r)
	def unmap(self, obj=None):
		_gtk.gtk_widget_unmap(self._o)
	def unparent(self):
		_gtk.gtk_widget_unparent(self._o)
	def unrealize(self, obj=None):
		_gtk.gtk_widget_unrealize(self._o)
	
class GtkContainer(GtkWidget):
	def __init__(self, noinit=None):
		if noinit: return
	def add(self, child):
		_gtk.gtk_container_add(self._o, child._o)
	def block_resize(self, obj=None):
		_gtk.gtk_container_block_resize(self._o)
	def border_width(self, bw):
		_gtk.gtk_container_border_width(self._o, bw)
	def children(self):
		l =  _gtk.gtk_container_children(self._o)
		return map(_obj2inst, l)
	def disable_resize(self, obj=None):
		_gtk.gtk_container_disable_resize(self._o)
	def enable_resize(self, obj=None):
		_gtk.gtk_container_enable_resize(self._o)
	def focus(self, d):
		_gtk.gtk_container_focus(self._o, d)
	def foreach(self, f):
		for child in self.children():
			f(child)
	def need_resize(self, obj=None):
		_gtk.gtk_container_need_resize(self._o)
	def remove(self, child):
		_gtk.gtk_container_remove(self._o, child._o)
	def unblock_resize(self, obj=None):
		_gtk.gtk_container_unblock_resize(self._o)

class GtkBin(GtkContainer):
	def __init__(self, noinit=None):
		if noinit: return

class GtkAlignment(GtkBin):
	def __init__(self, xa=0, ya=0, xs=0, ys=0, noinit=None):
		if noinit: return
		self._o = _gtk.gtk_alignment_newe(xa, ya, xs, ys)
	def set(self, xa, ya, xs, ys):
		_gtk.gtk_alignment_set(self._o, xa, ya, xs, ys)

class GtkButton(GtkBin):
	def __init__(self, label=None, noinit=None):
		if noinit: return
		if label == None:
			self._o = _gtk.gtk_button_new()
		else:
			self._o = _gtk.gtk_button_new_with_label(label)
	def pressed(self, obj=None):
		_gtk.gtk_button_pressed(self._o)
	def released(self, obj=None):
		_gtk.gtk_button_released(self._o)
	def enter(self, obj=None):
		_gtk.gtk_button_enter(self._o)
	def leave(self, obj=None):
		_gtk.gtk_button_leave(self._o)

class GtkOptionMenu(GtkButton):
	def __init__(self, noinit=None):
		if noinit: return
		self._o = _gtk.gtk_option_menu_new()
	def get_menu(self):
		return _obj2inst(_gtk.gtk_option_menu_get_menu(self._o))
	def set_menu(self, menu):
		_gtk.gtk_option_menu_set_menu(self._o, menu._o)
	def remove_menu(self):
		_gtk.gtk_option_menu_remove_menu(self._o)
	def set_history(self, index):
		_gtk.gtk_option_menu_set_history(self._o, index)

class GtkToggleButton(GtkButton):
	def __init__(self, label=None, noinit=None):
		if noinit: return
		if label == None:
			self._o = _gtk.gtk_toggle_button_new()
		else:
			self._o = _gtk.gtk_toggle_button_new_with_label(label)
	def set_mode(self, di):
		_gtk.gtk_toggle_button_set_mode(self._o, di)
	def set_state(self, state):
		_gtk.gtk_toggle_button_set_state(self._o, state)
	def toggled(self, obj):
		_gtk.gtk_toggle_button_toggled(self._o)

class GtkCheckButton(GtkToggleButton):
	def __init__(self, label=None, noinit=None):
		if noinit: return
		if label == None:
			self._o = _gtk.gtk_check_button_new()
		else:
			self._o = _gtk.gtk_check_button_new_with_label(label)

class GtkRadioButton(GtkCheckButton):
	def __init__(self, group=None, label=None, noinit=None):
		if noinit: return
		if label == None:
			if group == None:
				self._o = _gtk.gtk_radio_button_new()
			else:
				self._o = _gtk.gtk_radio_button_new(group)
		else:
			self._o = _gtk.gtk_radio_button_new_with_label(group,
				label)

class GtkFrame(GtkBin):
	def __init__(self, label="", noinit=None):
		if noinit: return
		self._o = _gtk.gtk_frame_new(label)
	def set_label(self, label):
		_gtk.gtk_frame_set_label(self._o, label)
	def set_label_align(self, x, y):
		_gtk.gtk_frame_set_label_align(self._o, x, y)
	def set_shadow_type(self, tp=SHADOW_ETCHED_IN):
		_gtk.gtk_frame_set_shadow_type(self._o, tp)

class GtkAspectFrame(GtkFrame):
	def __init__(self, xa=0, ya=0, ratio=1, obey_child=1, noinit=None):
		if noinit: return
		self._o = _gtk.gtk_aspect_frame_new(xa, ya, ratio, obey_child)
	def set(self, xa, ya, ratio, obey_child):
		_gtk.gtk_aspect_frame_set(self._o, xa, ya, ratio, obey_child)

class GtkEventBox(GtkBin):
	def __init__(self, noinit=None):
		if noinit: return
		self._o = _gtk.gtk_event_box_new()

class GtkHandleBox(GtkBin):
	def __init__(self, noinit=None):
		if noinit: return
		self._o = _gtk.gtk_handle_box_new()

class GtkItem(GtkBin):
	def __init__(self, noinit=None):
		if noinit: return
	def select(self, obj=None):
		_gtk.gtk_item_select(self._o)
	def deselect(self, obj=None):
		_gtk.gtk_item_deselect(self._o)
	def toggle(self, obj=None):
		_gtk.gtk_item_toggle(self._o)

class GtkMenuItem(GtkItem):
	def __init__(self, label=None, noinit=None):
		if noinit: return
		if label == None:
			self._o = _gtk.gtk_menu_item_new()
		else:
			self._o = _gtk.gtk_menu_item_new_with_label(label)
	def set_submenu(self, sub):
		_gtk.gtk_menu_item_set_submenu(self._o, sub._o)
	def set_placement(self, placement):
		_gtk.gtk_menu_item_set_placement(self._o, placement)
	def accelerator_size(self):
		_gtk.gtk_menu_item_accelerator_size(self._o)
	def accelerator_text(self, buf):
		_gtk.gtk_menu_item_accelerator_text(self._o, buf)
	def configure(self, show_toggle, show_sub):
		_gtk.gtk_menu_item_configure(self._o, show_toggle. show_sub)
	def select(self, obj=None):
		_gtk.gtk_menu_item_select(self._o)
	def deselect(self, obj=None):
		_gtk.gtk_menu_item_deselect(self._o)
	def toggle(self, obj=None):
		_gtk.gtk_menu_item_toggle(self._o)
		
class GtkCheckMenuItem(GtkMenuItem):
	def __init__(self, label=None, noinit=None):
		if noinit: return
		if label == None:
			self._o = _gtk.gtk_check_menu_item_new()
		else:
			self._o =_gtk.gtk_check_menu_item_new_with_label(label)
	def set_show_toggle(self, always):
		_gtk.gtk_check_menu_item_set_show_toggle(self._o, always)
	def set_state(self, state):
		_gtk.gtk_check_menu_item_set_state(self._o, state)
	def toggled(self, obj=None):
		_gtk.gtk_check_menu_item_toggled(self._o)

class GtkRadioMenuItem(GtkCheckMenuItem):
	def __init__(self, group=None, label=None, noinit=None):
		if noinit: return
		if label == None:
			if group == None:
				self._o = _gtk.gtk_radio_menu_item_new()
			else:
				self._o = _gtk.gtk_radio_menu_item_new(group)
		else:
			self._o = _gtk.gtk_radio_menu_item_new_with_label(
				group, label)

class GtkListItem(GtkItem):
	def __init__(self, label=None, noinit=None):
		if noinit: return
		if label == None:
			self._o = _gtk.gtk_list_item_new()
		else:
			self._o = _gtk.gtk_list_item_new_with_label(label)
	def select(self, obj=None):
		_gtk.gtk_list_item_select(self._o)
	def deselect(self, obj=None):
		_gtk.gtk_list_item_deselect(self._o)

class GtkTreeItem(GtkItem):
	def __init__(self, label=None, noinit=None):
		if noinit: return
		if label == None:
			self._o = _gtk.gtk_tree_item_new()
		else:
			self._o = _gtk.gtk_tree_item_new_with_label(label)
	def set_subtree(self, subtree):
		_gtk.gtk_tree_item_set_subtree(self._o, subtree._o)
	def select(self, obj=None):
		_gtk.gtk_tree_item_select(self._o)
	def deselect(self, obj=None):
		_gtk.gtk_tree_item_deselect(self._o)
	def expand(self, obj=None):
		_gtk.gtk_tree_item_expand(self._o)
	def collapse(self, obj=None):
		_gtk.gtk_tree_item_collapse(self._o)
	def remove_subtree(self):
		_gtk.gtk_tree_item_remove_subtree(self._o)

class GtkViewport(GtkBin):
	def __init__(self, ha=None, va=None, noinit=None):
		if noinit: return
		if ha or va:
			self._o = _gtk.gtk_viewport_new(ha._o, va._o)
		else:
			self._o = _gtk.gtk_viewport_new()
	def get_hadjustment(self):
		return _obj2inst(_gtk.gtk_viewport_get_hadjustment(self._o))
	def get_vdjustment(self):
		return _obj2inst(_gtk.gtk_viewport_get_vadjustment(self._o))
	def set_hadjustment(self, ha):
		_gtk.gtk_viewport_set_hadjustment(self._o, ha._o)
	def set_vadjustment(self, va):
		_gtk.gtk_viewport_set_vadjustment(self._o, va._o)
	def set_shadow_type(self, tp=SHADOW_ETCHED_IN):
		_gtk.gtk_viewport_set_shadow_type(self._o, tp)

class GtkWindow(GtkBin):
	def __init__(self, type=WINDOW_TOPLEVEL, title=None, noinit=None):
		if noinit: return
		self._o = _gtk.gtk_window_new(type)
		if title is not None:
			self.set_title(title)
	def set_title(self, title):
		_gtk.gtk_window_set_title(self._o, title)
	def set_focus(self, focus):
		_gtk.gtk_window_set_foxus(self._o, focus._o)
	def set_default(self, defaultw):
		_gtk.gtk_window_set_default(self._o, defaultw._o)
	def set_policy(self, as, ag, autos):
		_gtk.gtk_window_set_policy(self._o, as, ag, autos)
	def add_accelerator_table(self, t):
		_gtk.gtk_window_add_accelerator_table(self._o, t._at)
	def remove_accelerator_table(self, t):
		_gtk.gtk_window_remove_accelerator_table(self._o, t._at)
	def position(self, pos):
		_gtk.gtk_window_position(self._o, pos)

class GtkColorSelectionDialog(GtkWindow):
	def __init__(self, noinit=None):
		if noinit: return
		self._o = _gtk.gtk_color_selection_dialog_new()
	def __getattr__(self, attr):
		attrs = {
			'colorsel':_gtk.gtk_color_selection_dialog_get_colorsel,
			'main_vbox':_gtk.gtk_color_selection_dialog_get_main_vbox,
			'ok_button': _gtk.gtk_color_selection_dialog_get_ok_button,
			'reset_button': _gtk.gtk_color_selection_dialog_get_reset_button,
			'cancel_button': _gtk.gtk_color_selection_dialog_get_cancel_button,
			'help_button': _gtk.gtk_color_selection_dialog_get_help_button
		}
		if attrs.has_key(attr):
			return _obj2inst(attrs[attr](self._o))
		raise AttributeError, attr

class GtkDialog(GtkWindow):
	def __init__(self, noinit=None):
		if noinit: return
		self._o = _gtk.gtk_dialog_new()

class GtkFileSelection(GtkWindow):
	def __init__(self, title='', noinit=None):
		if noinit: return
		self._o = _gtk.gtk_file_selection_new(title)

	def set_filename(self, filename):
		_gtk.gtk_file_selection_set_filename(self._o, filename)
	def get_filename(self):
		return _gtk.gtk_file_selection_get_filename(self._o)
	def __getattr__(self, attr):
		attrs = {
		'cancel_button':   _gtk.gtk_file_selection_get_cancel_button,
		'dir_list':        _gtk.gtk_file_selection_get_dir_list,
		'file_list':       _gtk.gtk_file_selection_get_file_list,
		'help_button':     _gtk.gtk_file_selection_get_help_button,
		'main_vbox':       _gtk.gtk_file_selection_get_main_vbox,
		'ok_button':       _gtk.gtk_file_selection_get_ok_button,
		'selection_entry': _gtk.gtk_file_selection_get_selection_entry,
		'selection_text':  _gtk.gtk_file_selection_get_selection_text
		}
		if not attrs.has_key(attr): raise AttributeError, attr
		return _obj2inst(attrs[attr](self._o))

class GtkInputDialog(GtkWindow):
	def __init__(self, noinit=None):
		if noinit: return
		self._o = _gtk.gtk_input_dialog_new()

class GtkBox(GtkContainer):
	def __init__(self, noinit=None):
		if nonint: return
	def pack_start(self, child, expand=TRUE, fill=TRUE, padding=0):
		_gtk.gtk_box_pack_start(self._o, child._o, expand,fill,padding)
	def pack_end(self, child, expand=TRUE, fill=TRUE, padding=0):
		_gtk.gtk_box_pack_end(self._o, child._o, expand,fill,padding)
	def reorder_child(self, child, pos):
		_gtk.gtk_box_reorder_child(self._o, child._o, pos)
	def set_homogeneous(self, homogeneous):
		_gtk.gtk_box_set_homogeneous(self._o, homogeneous)
	def set_spacing(self, spacing):
		_gtk.gtk_box_set_spacing(self._o, spacing)

class GtkHBox(GtkBox):
	def __init__(self, homogeneous=0, spacing=0, noinit=None):
		if noinit: return
		self._o = _gtk.gtk_hbox_new(homogeneous, spacing)

class GtkCombo(GtkHBox):
	def __init__(self, noinit=None):
		if noinit: return
		self._o = _gtk.gtk_combo_new()
	def set_use_arrows(self, val):
		_gtk.gtk_combo_set_use_arrows(self._o, val)
	def set_use_arrows_always(self, val):
		_gtk.gtk_combo_set_use_arrows_always(self._o, val)
	def set_case_sensitive(self, val):
		_gtk.gtk_combo_set_case_sensitive(self._o, val)
	def set_item_string(self, item, val):
		_gtk.gtk_combo_set_item_string(self._o, item._o, val)
	def set_value_in_list(self, val, ok_if_empty):
		_gtk.gtk_combo_set_value_in_list(self._o, val, ok_if_empty)
	def __getattr__(self, attr):
		attrs = {
			'entry': _gtk.gtk_combo_get_entry,
			'list':  _gtk.gtk_combo_get_list
	        }
		if attrs.has_key(attr):
			return _obj2inst(attrs[attr](self._o))
		raise AttributeError, attr

class GtkStatusbar(GtkHBox):
	def __init__(self, noinit=None):
		if noinit: return
		self._o = _gtk.gtk_statusbar_new()
	def pop(self, sid):
		_gtk.gtk_statusbar_pop(self._o, sid)
	def push(self, text):
		return _gtk.gtk_statusbar_push(self._o, text)

class GtkVBox(GtkBox):
	def __init__(self, homogeneous=0, spacing=0, noinit=None):
		if noinit: return
		self._o = _gtk.gtk_vbox_new(homogeneous, spacing)

class GtkColorSelection(GtkVBox):
	def __init__(self, noinit=None):
		if noinit: return
		self._o = _gtk.gtk_color_selection_new()
	def set_update_policy(self, p):
		_gtk.gtk_color_selection_set_update_policy(self._o, p)
	def set_opacity(self, use_opacity):
		_gtk.gtk_color_selection_set_opacity(self._o, use_opacity)
	def set_color(self, c):
		_gtk.gtk_color_selection_set_color(self._o, c)
	def get_color(self):
		return _gtk.gtk_color_selection_get_color(self._o)

class GtkGammaCurve(GtkVBox):
	def __init__(self, noinit=None):
		if noinit: return
		self._o = _gtk.gtk_gamma_curve_new()

class GtkButtonBox(GtkBox):
	def __init__(self, noinit=None):
		if noinit: return
	def get_child_size_default(self):
		return _gtk.gtk_button_box_get_child_size_default()
	def get_child_ipadding_default(self):
		return _gtk.gtk_button_box_get_child_ipadding_default()
	def set_child_size_default(self, mw, mh):
		_gtk.gtk_button_box_set_child_size_default(mw, mh)
	def set_child_ipadding_default(self, ix, iy):
		_gtk.gtk_button_box_set_child_ipadding_default(ix, iy)
	def get_spacing(self):
		return _gtk.gtk_button_box_get_spacing(self._o)
	def get_layout(self):
		return _gtk.gtk_button_box_get_layout(self._o)
	def get_child_size(self):
		return _gtk.gtk_button_box_get_child_size(self._o)
	def get_child_ipadding(self):
		return _gtk.gtk_button_box_get_child_ipadding(self._o)
	def set_spacing(self, spacing):
		_gtk.gtk_button_box_set_spacing(self._o, spacing)
	def set_layout(self, layout):
		_gtk.gtk_button_box_set_layout(self._o, layout)
	def set_child_size(self, mw, mh):
		_gtk.gtk_button_box_set_child_size(self._o, mw, mh)
	def set_child_ipadding(self, ix, iy):
		_gtk.gtk_button_box_set_child_ipadding(self._o, ix, iy)

class GtkHButtonBox(GtkButtonBox):
	def __init__(self, noinit=None):
		if noinit: return
		self._o = _gtk.gtk_hbutton_box_new()
	def get_spacing_default(self):
		return _gtk.gtk_hbutton_box_get_spacing_default()
	def get_layout_default(self):
		return _gtk.gtk_hbutton_box_get_layout_default()
	def set_spacing_default(self, spacing):
		_gtk.gtk_hbutton_box_set_spacing_default(spacing)
	def set_layout_default(self, layout):
		_gtk.gtk_hbutton_box_set_layout_default(layout)

class GtkVButtonBox(GtkButtonBox):
	def __init__(self, noinit=None):
		if noinit: return
		self._o = _gtk.gtk_vbutton_box_new()
	def get_spacing_default(self):
		return _gtk.gtk_vbutton_box_get_spacing_default()
	def get_layout_default(self):
		return _gtk.gtk_vbutton_box_get_layout_default()
	def set_spacing_default(self, spacing):
		_gtk.gtk_vbutton_box_set_spacing_default(spacing)
	def set_layout_default(self, layout):
		_gtk.gtk_vbutton_box_set_layout_default(layout)

class GtkCList(GtkContainer):
	def __init__(self, cols=1, titles=None, noinit=None):
		if noinit: return
		if titles == None:
			self._o = _gtk.gtk_clist_new(cols)
		else:
			self._o = _gtk.gtk_clist_new_with_titles(cols, titles)
	def append(self, values):
		_gtk.gtk_clist_append(self._o, values)
	def clear(self, obj=None):
		_gtk.gtk_clist_clear(self._o)
	def column_title_active(self, col):
		_gtk.gtk_clist_column_title_active(self._o, col)
	def column_title_passive(self, col):
		_gtk.gtk_clist_column_title_passive(self._o, col)
	def column_titles_active(self, obj=None):
		_gtk.gtk_clist_column_titles_active(self._o)
	def column_titles_hide(self, obj=None):
		_gtk.gtk_clist_column_titles_hide(self._o)
	def column_titles_passive(self, obj=None):
		_gtk.gtk_clist_column_titles_passive(self._o)
	def column_titles_show(self, obj=None):
		_gtk.gtk_clist_column_titles_show(self._o)
	def freeze(self, obj=None):
		_gtk.gtk_clist_freeze(self._o)
	def insert(self, row, values):
		_gtk.gtk_clist_insert(self._o, row, values)
	def moveto(self, row=-1, col=-1, row_align=0.5, col_align=0.5):
		_gtk.gtk_clist_moveto(self._o, row, col, row_align, col_align)
	def remove(self, row):
		_gtk.gtk_clist_remove(self._o, row)
	def select_row(self, row, col):
		_gtk.gtk_clist_select_row(self._o, row, col)
	def set_background(self, row, colour):
		_gtk.gtk_clist_set_background(self._o, row, colour)
	def set_border(self, border):
		_gtk.gtk_clist_set_border(self._o, border)
	def set_column_widget(self, col, w):
		_gtk.gtk_clist_set_column_widget(self._o, col, w._o)
	def set_column_justification(self, col, just):
		_gtk.gtk_clist_set_column_justification(self._o, col, just)
	def set_column_width(self, col, width):
		_gtk.gtk_clist_set_column_width(self._o, col, width)
	def set_foreground(self, row, colour):
		_gtk.gtk_clist_set_foreground(self._o, row, colour)
	def set_policy(self, vsp, hsp):
		_gtk.gtk_clist_set_policy(self._o, vsp, hsp)
	def set_row_height(self, height):
		_gtk.gtk_clist_set_row_height(self._o, height)
	def set_shift(self, row, col, v, h):
		_gtk.gtk_clist_set_shift(self._o, row, col, v, h)
	def set_text(self, r, c, text):
		_gtk.gtk_clist_set_text(self._o, r, c, text)
	def thaw(self):
		_gtk.gtk_clist_thaw(self._o)
	def unselect_row(self, row, col):
		_gtk.gtk_clist_unselect_row(self._o, row, col)

class GtkFixed(GtkContainer):
	def __init__(self, noinit=None):
		if noinit: return
		self._o = _gtk.gtk_fixed_new()
	def put(self, child, x, y):
		_gtk.gtk_fixed_put(self._o, child._o, x, y)
	def move(self, child, x, y):
		_gtk.gtk_fixed_move(self._o, child._o, x, y)

class GtkList(GtkContainer):
	def __init__(self, noinit=None):
		if noinit: return
		self._o = _gtk.gtk_list_new()
	def insert_items(self, items, pos):
		_gtk.gtk_list_insert_items(self._o, items, pos)
	def append_items(self, items):
		items = map(lambda i: i._o, items)
		_gtk.gtk_list_append_items(self._o, items)
	def prepend_items(self, items):
		items = map(lambda i: i._o, items)
		_gtk.gtk_list_prepend_items(self._o, items)
	def remove_items(self, items):
		items = map(lambda i: i._o, items)
		_gtk.gtk_list_remove_items(self._o, items)
	def clear_items(self, start, end):
		_gtk.gtk_list_clear_items(self._o, start, end)
	def select_item(self, item):
		_gtk.gtk_list_select_item(self._o, item._o)
	def unselect_item(self, item):
		_gtk.gtk_list_unselect_item(self._o, item._o)
	def select_child(self, child):
		_gtk.gtk_list_select_child(self._o, child._o)
	def unselect_child(self, child):
		_gtk.gtk_list_unselect_child(self._o, child._o)
	def child_position(self, child):
		return _gtk.gtk_list_child_position(self._o, child._o)
	def set_selection_mode(self, mode):
		_gtk.gtk_list_set_selection_mode(self._o, mode)

class GtkMenuShell(GtkContainer):
	def __init__(self, noinit=None):
		if noinit: return
	def append(self, child):
		_gtk.gtk_menu_shell_append(self._o, child._o)
	def prepend(self, child):
		_gtk.gtk_menu_shell_prepend(self._o, child._o)
	def insert(self, child, pos):
		_gtk.gtk_menu_shell_insert(self._o, child._o, pos)
	def deactivate(self, obj=None):
		_gtk.gtk_menu_shell_deactivate(self._o)

class GtkMenuBar(GtkMenuShell):
	def __init__(self, noinit=None):
		if noinit: return
		self._o = _gtk.gtk_menu_bar_new()
	def append(self, child):
		_gtk.gtk_menu_bar_append(self._o, child._o)
	def prepend(self, child):
		_gtk.gtk_menu_bar_prepend(self._o, child._o)
	def insert(self, child, pos):
		_gtk.gtk_menu_bar_insert(self._o, child._o, pos)

class GtkMenu(GtkMenuShell):
	def __init__(self, noinit=None):
		if noinit: return
		self._o = _gtk.gtk_menu_new()
	def append(self, child):
		_gtk.gtk_menu_append(self._o, child._o)
	def prepend(self, child):
		_gtk.gtk_menu_prepend(self._o, child._o)
	def insert(self, child, pos):
		_gtk.gtk_menu_insert(self._o, child._o, pos)
	def popup(self, pms, pmi, func, button, time):
		_gtk.gtk_menu_popup(self._o, pms._o, pmi._o, func,button,time)
	def popdown(self, obj=None):
		_gtk.gtk_menu_popdown(self._o)
	def get_active(self):
		return _obj2inst(_gtk.gtk_menu_get_active(self._o))
	def set_active(self, index):
		_gtk.gtk_menu_set_active(self._o, index)
	def set_accelerator_table(self, table):
		_gtk.gtk_menu_set_accelerator_table(self._o, table._at)

class GtkNotebook(GtkContainer):
	def __init__(self, noinit=None):
		if noinit: return
		self._o = _gtk.gtk_notebook_new()
	def append_page(self, child, tab):
		_gtk.gtk_notebook_append_page(self._o, child._o, tab._o)
	def prepend_page(self, child, tab):
		_gtk.gtk_notebook_prepend_page(self._o, child._o, tab._o)
	def insert_page(self, child, tab, pos):
		_gtk.gtk_notebook_insert_page(self._o, child._o, tab._o, pos)
	def remove_page(self, pos):
		_gtk.gtk_notebook_remove_page(self._o, pos)
	def current_page(self):
		return _gtk.gtk_notebook_current_page(self._o)
	def set_page(self, pos):
		_gtk.gtk_notebook_set_page(self._o, pos)
	def next_page(self, obj):
		_gtk.gtk_notebook_next_page(self._o)
	def prev_page(self, obj):
		_gtk.gtk_notebook_prev_page(self._o)
	def set_tab_pos(self, pos):
		_gtk.gtk_notebook_set_tab_pos(self._o, pos)
	def set_show_tabs(self, show):
		_gtk.gtk_notebook_set_show_tabs(self._o, show)
	def set_show_border(self, show):
		_gtk.gtk_notebook_set_show_border(self._o, show)

class GtkPaned(GtkContainer):
	def __init__(self, noinit=None):
		if noinit: return
	def add1(self, child):
		_gtk.gtk_paned_add1(self._o, child._o)
	def add2(self, child):
		_gtk.gtk_paned_add2(self._o, child._o)
	def handle_size(self, size):
		_gtk.gtk_paned_handle_size(self._o, size)
	def gutter_size(self, size):
		_gtk.gtk_paned_gutter_size(self._o, size)

class GtkHPaned(GtkPaned):
	def __init__(self, noinit=None):
		if noinit: return
		self._o = _gtk.gtk_hpaned_new()

class GtkVPaned(GtkPaned):
	def __init__(self, noinit=None):
		if noinit: return
		self._o = _gtk.gtk_vpaned_new()

class GtkScrolledWindow(GtkContainer):
	def __init__(self, hadj=None, vadj=None, noinit=None):
		if noinit: return
		if not (vadj or hadj):
			self._o = _gtk.gtk_scrolled_window_new()
		else:
			self._o = _gtk.gtk_scrolled_window_new(hadj._o, vadj._o)
	def get_hadjustment(self):
		return _obj2inst(_gtk.gtk_scrolled_window_get_hadjustment(
			self._o))
	def get_vadjustment(self):
		return _obj2inst(_gtk.gtk_scrolled_window_get_vadjustment(
			self._o))
	def set_policy(self, hp, vp):
		_gtk.gtk_scrolled_window_set_policy(self._o, hp, vp)

class GtkTable(GtkContainer):
	def __init__(self, rows=1, cols=1, homogeneous=0, noinit=None):
		if noinit: return
		self._o = _gtk.gtk_table_new(rows, cols, homogeneous)
	def attach(self, child, la, ra, ta, ba, xoptions=EXPAND|FILL,
			yoptions=EXPAND|FILL, xpadding=0, ypadding=0):
		_gtk.gtk_table_attach(self._o, child._o, la,ra,ta,ba,
			xoptions,yoptions, xpadding,ypadding)
	def set_row_spacing(self, row, s):
		_gtk.gtk_table_set_row_spacing(self._o, row, s)
	def set_col_spacing(self, col, s):
		_gtk.gtk_table_set_col_spacing(self._o, col, s)
	def set_row_spacings(self, s):
		_gtk.gtk_table_set_row_spacings(self._o, s)
	def set_col_spacings(self, s):
		_gtk.gtk_table_set_col_spacings(self._o, s)

class GtkTree(GtkContainer):
	def __init__(self, noinit=None):
		if noinit: return
		self._o = _gtk.gtk_tree_new()
	def append(self, child):
		_gtk.gtk_tree_append(self._o, child._o)
	def prepend(self, child):
		_gtk.gtk_tree_prepend(self._o, child._o)
	def insert(self, child, pos):
		_gtk.gtk_tree_insert(self._o, child._o, pos)
#	def remove_item(self, child):
#		_gtk.gtk_tree_remove_item(self._o, child._o)
	def clear_items(self, start, end):
		_gtk.gtk_tree_clear_items(self._o, start, end)
	def select_item(self, item):
		_gtk.gtk_tree_select_item(self._o, item)
	def unselect_item(self, item):
		_gtk.gtk_tree_unselect_item(self._o, item)
	def select_child(self, child):
		_gtk.gtk_tree_select_child(self._o, child._o)
	def unselect_child(self, child):
		_gtk.gtk_tree_unselect_child(self._o, child._o)
	def child_position(self, child):
		return _gtk.gtk_tree_child_position(self._o, child._o)
	def set_selection_mode(self, mode):
		_gtk.gtk_tree_set_selection_mode(self._o, mode)
	def set_view_mode(self, mode):
		_gtk.gtk_tree_set_view_mode(self._o, mode)
	def set_view_lines(self, flag):
		_gtk.gtk_tree_set_view_lines(self._o, flag)

class GtkToolbar(GtkContainer):
	def __init__(self, orientation=ORIENTATION_HORIZONTAL,
		     style=TOOLBAR_ICONS, noinit=None):
		if noinit: return
		self._o = _gtk.gtk_toolbar_new(orientation, style)
        def append_item(self, text, tooltip, icon, callback):
		_gtk.gtk_toolbar_append_item(self._o, text, tooltip, icon._o,
					     callback)
	def append_space(self):
		_gtk.gtk_toolbar_append_space(self._o)
	def append_widget(self, w, tooltip):
		_gtk.gtk_toolbar_append_widget(self._o, w._o, tooltip)
	def insert_item(self, text, tooltip, icon, callback, pos):
		_gtk.gtk_toolbar_insert_item(self._o, text, tooltip, icon._o,
					     callback, pos)
	def insert_space(self, pos):
		_gtk.gtk_toolbar_insert_space(self._o, pos)
	def insert_widget(self, w, tooltip, pos):
		_gtk.gtk_toolbar_insert_widget(self._o, w._o, tooltip, pos)
	def prepend_item(self, text, tooltip, icon, callback):
		_gtk.gtk_toolbar_prepend_item(self._o, text, tooltip, icon._o,
					      callback)
	def prepend_space(self):
		_gtk.gtk_toolbar_prepend_space(self._o)
	def prepend_widget(self, w, tooltip):
		_gtk.gtk_toolbar_prepend_widget(self._o, w._o, tooltip)
       	def set_orientation(self, orientation):
		_gtk.gtk_toolbar_set_orientation(self._o, orientation)
	def set_style(self, style):
		_gtk.gtk_toolbar_set_style(self._o, style)
	def set_tooltips(self, enable):
		_gtk.gtk_toolbar_set_tooltips(self._o, enable)

class GtkDrawingArea(GtkWidget):
	def __init__(self, noinit=None):
		if noinit: return
		self._o = _gtk.gtk_drawing_area_new()
	def size(self, w, h):
		_gtk.gtk_drawing_area_size(self._o, w, h)

class GtkCurve(GtkDrawingArea):
	def __init__(self, noinit=None):
		if noinit: return
		self._o = _gtk.gtk_curve_new()
	def reset(self):
		_gtk.gtk_curve_reset(self._o)
	def set_gamma(self, g):
		_gtk.gtk_curve_set_gamma(self._o, g)
	def set_range(self, minx,maxx, miny,maxy):
		_gtk.gtk_curve_set_range(self._o, minx,maxx, miny,maxy)
	def set_curve_type(self, tp):
		_gtk.gtk_curve_set_curve_type(self._o, tp)

class GtkEntry(GtkWidget):
	def __init__(self, maxlen=-1, noinit=None):
		if noinit: return
		if maxlen == -1:
			self._o = _gtk.gtk_entry_new()
		else:
			self._o = _gtk.gtk_entry_new_with_max_length(maxlen)
	def set_text(self, text):
		_gtk.gtk_entry_set_text(self._o, text)
	def append_text(self, text):
		_gtk.gtk_entry_append_text(self._o, text)
	def prepend_text(self, text):
		_gtk.gtk_entry_prepend_text(self._o, text)
	def set_position(self, pos):
		_gtk.gtk_entry_set_position(self._o, pos)
	def get_text(self):
		return _gtk.gtk_entry_get_text(self._o)
	def select_region(self, start, stop):
		_gtk.gtk_entry_select_region(self._o, start, stop)
	def set_visibility(self, visible):
		_gtk.gtk_entry_set_visibility(self._o, visible)
	def set_editable(self, editable):
		_gtk.gtk_entry_set_editable(self._o, editable)
	def set_max_length(self, max):
		_gtk.gtk_entry_set_max_length(self._o, max)

class GtkMisc(GtkWidget):
	def __init__(self, noinit=None):
		if noinit: return
	def set_alignment(self, xa, ya):
		_gtk.gtk_misc_set_alignment(self._o, xa, ya)
	def set_padding(self, xp, yp):
		_gtk.gtk_misc_set_padding(self._o, xp, yp)

class GtkArrow(GtkMisc):
	def __init__(self, at=DIR_RIGHT, st=SHADOW_OUT, noinit=None):
		if noinit: return
		self._o = _gtk.gtk_arrow_new(at, st)
	def set(self, at, st):
		_gtk.gtk_arrow_set(self._o, at, st)

class GtkImage(GtkMisc):
	def __init__(self, noinit=None):
		if noinit: return
	# XXX should have __init__, set, get

class GtkPixmap(GtkMisc):
	def __init__(self, parent=None, xpm=None, bg=None, noinit=None):
		if noinit: return
		if bg:
			self._o =_gtk.gtk_pixmap_new_from_xpm(parent._o,xpm,bg)
		else:
			self._o = _gtk.gtk_pixmap_new_from_xpm(parent._o, xpm)

class GtkLabel(GtkMisc):
	def __init__(self, label="", noinit=None):
		if noinit: return
		self._o = _gtk.gtk_label_new(label)
	def set(self, str):
		_gtk.gtk_label_set(self._o, str)
	def set_justify(self, jtype):
		_gtk.gtk_label_set_justify(self._o, jtype)
	def get(self):
		return _gtk.gtk_labelget(self._o)

class GtkPreview(GtkWidget):
	def uninit(self):
		_gtk.gtk_preview_uninit()
	def __init__(self, tp=0):
		if noinit: return
		self._o = _gtk.gtk_preview_new(tp)
	def size(self, w, h):
		_gtk.gtk_preview_size(self._o, w, h)
	def set_expand(self, expand):
		_gtk.gtk_preview_set_expand(self._o, expand)
	def set_gamma(self, gamma):
		_gtk.gtk_preview_set_gamma(self._o, gamma)
	def set_color_cube(self, nr, ng, nb, ngrey):
		_gtk.gtk_preview_set_color_cube(self._o, nr,ng,nb, ngrey)
	def set_install_cmap(self, install):
		_gtk.gtk_preview_set_install_cmap(install)
	def set_reserved(self, reserved):
		_gtk.gtk_preview_set_reserved(reserved)

class GtkProgressBar(GtkWidget):
	def __init__(self, noinit=None):
		if noinit: return
		self._o = _gtk.gtk_progress_bar_new()
	def update(self, pcnt):
		_gtk.gtk_progress_bar_update(self._o, pcnt)

class GtkRange(GtkWidget):
	def __init__(self, noinit=None):
		if noinit: return
	def get_adjustment(self):
		return _obj2inst(_gtk.gtk_range_get_adjustment(self._o))
	def set_update_policy(self, pol):
		_gtk.gtk_range_set_update_policy(self._o, pol)
	def set_adjustment(self, adj):
		_gtk.gtk_range_set_adjustment(self._o, adj._o)
	def draw_background(self, obj=None):
		_gtk.gtk_range_draw_background(self._o)
	def draw_trough(self, obj=None):
		_gtk.gtk_range_draw_trough(self._o)
	def draw_step_forw(self, obj=None):
		_gtk.gtk_range_draw_step_forw(self._o)
	def draw_step_back(self, obj=None):
		_gtk.gtk_range_draw_step_back(self._o)
	def trough_click(self, x, y):
		_gtk.gtk_range_trough_click(self._o, x, y)
	def default_hslider_update(self, obj=None):
		_gtk.gtk_range_default_hslider_update(self._o)
	def default_vslider_update(self, obj=None):
		_gtk.gtk_range_default_vslider_update(self._o)
	def default_htrough_click(self, x, y):
		_gtk.gtk_range_default_htrough_click(self._o, x, y)
	def default_vtrough_click(self, x, y):
		_gtk.gtk_range_default_vtrough_click(self._o, x, y)
	def default_hmotion(self, dx, dy):
		_gtk.gtk_range_default_hmotion(self._o, dx, dy)
	def default_vmotion(self, dx, dy):
		_gtk.gtk_range_default_vmotion(self._o, dx, dy)
	def calc_value(self, pos):
		return _gtk.gtk_range_calc_value(self._o, pos)

class GtkScale(GtkRange):
	def __init__(self, noinit=None):
		if noinit: return
	def set_digits(self, digits):
		_gtk.gtk_scale_set_digits(self._o, digits)
	def set_draw_value(self, draw_value):
		_gtk.gtk_scale_set_draw_value(self._o, draw_value)
	def set_value_pos(self, pos):
		_gtk.gtk_scale_set_value_pos(self._o, pos)
	def value_width(self):
		return _gtk.gtk_scale_value_width(self._o)
	def draw_value(self, obj=None):
		_gtk.gtk_scale_draw_value(self._o)

class GtkHScale(GtkScale):
	def __init__(self, adj=None, noinit=None):
		if noinit: return
		if adj:
			self._o = _gtk.gtk_hscale_new(adj._o)
		else:
			self._o = _gtk.gtk_hscale_new()

class GtkVScale(GtkScale):
	def __init__(self, adj=None, noinit=None):
		if noinit: return
		if adj:
			self._o = _gtk.gtk_vscale_new(adj._o)
		else:
			self._o = _gtk.gtk_vscale_new()

class GtkScrollbar(GtkRange):
	def __init__(self, noinit=None):
		if noinit: return

class GtkHScrollbar(GtkScrollbar):
	def __init__(self, adj=None, noinit=None):
		if noinit: return
		if adj:
			self._o = _gtk.gtk_hscrollbar_new(adj._o)
		else:
			self._o = _gtk.gtk_hscrollbar_new()

class GtkVScrollbar(GtkScrollbar):
	def __init__(self, adj=None, noinit=None):
		if noinit: return
		if adj:
			self._o = _gtk.gtk_vscrollbar_new(adj._o)
		else:
			self._o = _gtk.gtk_vscrollbar_new()

class GtkRuler(GtkWidget):
	def __init__(self, noinit=None):
		if noinit: return
	def set_metric(self, metric):
		_gtk.gtk_ruler_set_metric(self._o, metric)
	def set_range(self, lo, up, pos, max):
		_gtk.gtk_ruler_set_range(self._o, lo, up, pos, max)
	def draw_ticks(self, obj=None):
		_gtk.gtk_ruler_draw_ticks(self._o)
	def draw_pos(self, obj=None):
		_gtk.gtk_ruler_draw_pos(self._o)

class GtkHRuler(GtkRuler):
	def __init__(self, noinit=None):
		if noinit: return
		self._o = _gtk.gtk_hruler_new()

class GtkVRuler(GtkRuler):
	def __init__(self, noinit=None):
		if noinit: return
		self._o = _gtk.gtk_vruler_new()

class GtkSeparator(GtkWidget):
	def __init__(self, noinit=None):
		if noinit: return

class GtkHSeparator(GtkSeparator):
	def __init__(self, noinit=None):
		if noinit: return
		self._o = _gtk.gtk_hseparator_new()

class GtkVSeparator(GtkSeparator):
	def __init__(self, noinit=None):
		if noinit: return
		self._o = _gtk.gtk_vseparator_new()

class GtkText(GtkWidget):
	def __init__(self, hadj=None, vadj=None, noinit=None):
		if noinit: return
		if not (hadj or vadj):
			self._o = _gtk.gtk_text_new()
		else:
			self._o = _gtk.gtk_text_new(hadj._o, vadj._o)
	def set_editable(self, editable):
		_gtk.gtk_text_set_editable(self._o, editable)
	def set_adjustments(self, hadj, vadj):
		_gtk.gtk_text_set_adjustments(self._o, hadj._o, vadj._o)
	def get_hadjustment(self):
		return _obj2inst(_gtk.gtk_text_get_hadjustment(self._o))
	def get_vadjustment(self):
		return _obj2inst(_gtk.gtk_text_get_vadjustment(self._o))
	def set_point(self, point):
		_gtk.gtk_text_set_point(self._o, point)
	def get_point(self):
		return _gtk.gtk_text_get_point(self._o)
	def get_length(self):
		return _gtk.gtk_text_get_length(self._o)
	def freeze(self, obj=None):
		_gtk.gtk_text_freeze(self._o)
	def thaw(self, obj=None):
		_gtk.gtk_text_thaw(self._o)
	def insert(self, font, fg, bg, string):
		_gtk.gtk_text_insert(self._o, font, fg, bg, string,
				     len(string))
	def insert_defaults(self, chars):
		_gtk.gtk_text_insert_defaults(self._o, chars)
	def backward_delete(self, nchars):
		_gtk.gtk_text_backward_delete(self._o, nchars)
	def forward_delete(self, nchars):
		_gtk.gtk_text_forward_delete(self._o, nchars)

_name2cls = {}
_supported = map(lambda x: eval(x), filter(lambda x: x[:3] == 'Gtk', dir()))
for m in _supported:
	_name2cls[m.__name__] = m

del m

class GtkAcceleratorTable:
	def __init__(self, noinit=None):
		if noinit: return
		self._at = _gtk.gtk_accelerator_table_new()
	def install(self, obj, signame, acc_key, acc_mods):
		_gtk.gtk_accelerator_table_install(self._at, obj._o, signame,
						   acc_key, acc_mods)
	def remove(self, obj, signame):
		_gtk.gtk_accelerator_table_remove(self._at, obj._o, signame)
	def check(self, acc_key, acc_mods):
		return _gtk.gtk_accelerator_table_check(self._at, acc_key,
							acc_mods)
	def set_mod_mask(self, mod_mask):
		_gtk.gtk_accelerator_table_set_mod_mask(self._at, mod_mask)

class GtkTooltips:
	def __init__(self, noinit=None):
		if noinit: return
		self._tt = _gtk.gtk_tooltips_new()
	def enable(self):
		_gtk.gtk_tooltips_enable(self._tt)
	def set_delay(self, delay):
		_gtk.gtk_tooltips_set_delay(self._tt, delay)
	def set_tips(self, w, tip):
		_gtk.gtk_tooltips_set_tips(self._tt, w._o, tip)

def _obj2inst(obj):
	objname = _gtk.gtk_type_name(_gtk.GTK_OBJECT_TYPE(obj))
	ret = _name2cls[objname](noinit=1)
	ret._o = obj
	return ret

def _filtprops(props):
	for k in props.keys():
		v = props[k]
		if hasattr(v, '__class__') and v.__class__ in _supported:
			props[k] = v._o

def new(tp, props={}):
	if type(tp) != type(''):
		tp = tp.__name__
	_filtprops(props)
	return _obj2inst(_gtk.gtk_object_new(tp, props))

def mainloop():
	_gtk.gtk_main()
def mainquit(*args):
	_gtk.gtk_main_quit()
def idle_add(callback):
	return _gtk.gtk_idle_add(callback)
def idle_remove(tag):
	_gtk.gtk_idle_remove(tag)
def timeout_add(timeout, callback):
	return _gtk.gtk_timeout_add(timeout, callback)
def timeout_remove(tag):
	_gtk.gtk_timeout_remove(tag)
def rc_parse(fname):
	_gtk.gtk_rc_parse(fname)
def rc_parse_string(string):
	_gtk.gtk_rc_parse_string(string)
def load_font(font):
	return _gtk.gdk_font_load(font)
def load_fontset(fontset):
	return _gtk.gdk_fondset_load(fontset)
