# code to define wrapper for a Gtk object
%{
typedef struct {
        PyObject_HEAD
        GtkObject *go;
} PyGtk_Object;

staticforward PyTypeObject PyGtk_Type;

#define PyGtk_Check(v) ((v)->ob_type == &PyGtk_Type)
#define PyGtk_Get(v) (((PyGtk_Object *)(v))->go)

static PyObject *
PyGtk_New(GtkObject *go) {
  PyGtk_Object *self;

  self = (PyGtk_Object *)PyObject_NEW(PyGtk_Object, &PyGtk_Type);
  if (self == NULL)
    return NULL;
  self->go = go;
  return (PyObject *)self;
}

static void 
PyGtk_dealloc(PyGtk_Object *self) {
  PyMem_DEL(self);
}

static int
PyGtk_compare(PyGtk_Object *self, PyGtk_Object *v) {
  if (self->go == v->go) return 0;
  if (self->go > v->go) return -1;
  return 1;
}

static PyObject *
PyGtk_repr(PyGtk_Object *self) {
  char buf[100];

  sprintf(buf, "<GtkObject of type %s at %lx>",
    gtk_type_name(PyGtk_Get(self)->klass->type), (long)PyGtk_Get(self));
  return PyString_FromString(buf);
}

static char PyGtk_Type__doc__[] = "This is the type of GTK Objects";

static PyTypeObject PyGtk_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,                              /*ob_size*/
  "GtkObject",                    /*tp_name*/
  sizeof(PyGtk_Object),           /*tp_basicsize*/
  0,                              /*tp_itemsize*/
  (destructor)PyGtk_dealloc,      /*tp_dealloc*/
  (printfunc)0,                   /*tp_print*/
  (getattrfunc)0,                 /*tp_getattr*/
  (setattrfunc)0,                 /*tp_setattr*/
  (cmpfunc)PyGtk_compare,         /*tp_compare*/
  (reprfunc)PyGtk_repr,           /*tp_repr*/
  0,                              /*tp_as_number*/
  0,                              /*tp_as_sequence*/
  0,                              /*tp_as_mapping*/
  (hashfunc)0,                    /*tp_hash*/
  (ternaryfunc)0,                 /*tp_call*/
  (reprfunc)0,                    /*tp_str*/
  0L,0L,0L,0L,
  PyGtk_Type__doc__
};
	
%}

