%{
#pragma }

typedef struct {
	PyObject_HEAD
	GtkAcceleratorTable *obj;
} PyGtkAccelerator_Object;
staticforward PyTypeObject PyGtkAccelerator_Type;

typedef struct {
	PyObject_HEAD
	GtkStyle *obj;
} PyGtkStyle_Object;
staticforward PyTypeObject PyGtkStyle_Type;

typedef struct {
	PyObject_HEAD
	GdkFont *obj;
} PyGdkFont_Object;
staticforward PyTypeObject PyGdkFont_Type;

typedef struct {
	PyObject_HEAD
	GdkColor obj;
} PyGdkColor_Object;
staticforward PyTypeObject PyGdkColor_Type;

typedef struct {
	PyObject_HEAD
	GdkEvent *obj;
	PyObject *attrs;
} PyGdkEvent_Object;
staticforward PyTypeObject PyGdkEvent_Type;

typedef struct {
        PyObject_HEAD
        GdkWindow *obj;
        const char *type;
} PyGdkWindow_Object;
staticforward PyTypeObject PyGdkWindow_Type;

typedef struct {
        PyObject_HEAD
        GdkGC *obj;
} PyGdkGC_Object;
staticforward PyTypeObject PyGdkGC_Type;

typedef struct {
        PyObject_HEAD
	GdkColormap *obj;
} PyGdkColormap_Object;
staticforward PyTypeObject PyGdkColormap_Type;

#define PyGtkAccelerator_Check(v) ((v)->ob_type == &PyGtkAccelerator_Type)
#define PyGtkAccelerator_Get(v) (((PyGtkAccelerator_Object *)(v))->obj)
#define PyGtkStyle_Check(v) ((v)->ob_type == &PyGtkStyle_Type)
#define PyGtkStyle_Get(v) (((PyGtkStyle_Object *)(v))->obj)
#define PyGdkFont_Check(v) ((v)->ob_type == &PyGdkFont_Type)
#define PyGdkFont_Get(v) (((PyGdkFont_Object *)(v))->obj)
#define PyGdkColor_Check(v) ((v)->ob_type == &PyGdkColor_Type)
#define PyGdkColor_Get(v) (&((PyGdkColor_Object *)(v))->obj)
#define PyGdkEvent_Check(v) ((v)->ob_type == &PyGdkEvent_Type)
#define PyGdkEvent_Get(v) (((PyGdkEvent_Object *)(v))->obj)
#define PyGdkWindow_Check(v) ((v)->ob_type == &PyGdkWindow_Type)
#define PyGdkWindow_Get(v) (((PyGdkWindow_Object *)(v))->obj)
#define PyGdkGC_Check(v) ((v)->ob_type == &PyGdkGC_Type)
#define PyGdkGC_Get(v) (((PyGdkGC_Object *)(v))->obj)
#define PyGdkColormap_Check(v) ((v)->ob_type == &PyGdkColormap_Type)
#define PyGdkColormap_Get(v) (((PyGdkColormap_Object *)(v))->obj)


static PyObject *
PyGtkAccelerator_New(GtkAcceleratorTable *obj) {
  PyGtkAccelerator_Object  *self;

  self = (PyGtkAccelerator_Object *)PyObject_NEW(PyGtkAccelerator_Object ,
              &PyGtkAccelerator_Type);
  if (self == NULL)
    return NULL;
  self->obj = obj;
  gtk_accelerator_table_ref(self->obj);
  return (PyObject *)self;
}

static PyObject *
PyGtkStyle_New(GtkStyle *obj) {
  PyGtkStyle_Object *self;

  self = (PyGtkStyle_Object *)PyObject_NEW(PyGtkStyle_Object,
                                           &PyGtkStyle_Type);
  if (self == NULL)
    return NULL;
  self->obj = obj;
  gtk_style_ref(self->obj);
  return (PyObject *)self;
}

static PyObject *
PyGdkFont_New(GdkFont *obj) {
  PyGdkFont_Object *self;

  self = (PyGdkFont_Object *)PyObject_NEW(PyGdkFont_Object, &PyGdkFont_Type);
  /*gdk_font_ref(obj);*/
  if (self == NULL)
    return NULL;
  self->obj = obj;
  return (PyObject *)self;
}

static PyObject *
PyGdkColor_New(GdkColor *obj) {
  PyGdkColor_Object *self;

  self = (PyGdkColor_Object *)PyObject_NEW(PyGdkColor_Object,&PyGdkColor_Type);
  if (self == NULL)
    return NULL;
  self->obj.pixel = obj->pixel;
  self->obj.red   = obj->red;
  self->obj.green = obj->green;
  self->obj.blue  = obj->blue;
  return (PyObject *)self;
}

static PyObject *
PyGdkWindow_New(GdkWindow *win, const char *type) {
  PyGdkWindow_Object *self;

  self = (PyGdkWindow_Object *)PyObject_NEW(PyGdkWindow_Object,
					    &PyGdkWindow_Type);
  if (self == NULL)
    return NULL;
  self->obj = win;
  if (type)
    self->type = type;
  else
    self->type = "GdkWindow";
  gdk_window_ref(self->obj);
  return (PyObject *)self;
}

static PyObject *
PyGdkGC_New(GdkGC *gc) {
  PyGdkGC_Object *self;

  self = (PyGdkGC_Object *)PyObject_NEW(PyGdkGC_Object, &PyGdkGC_Type);
  if (self == NULL)
    return NULL;
  self->obj = gc;
  gdk_gc_ref(self->obj);
  return (PyObject *)self;
}

static PyObject *
PyGdkColormap_New(GdkColormap *cmap) {
  PyGdkColormap_Object *self;

  self = (PyGdkColormap_Object *)PyObject_NEW(PyGdkColormap_Object,
					      &PyGdkColormap_Type);
  if (self == NULL)
    return NULL;
  self->obj = cmap;
  gdk_colormap_ref(self->obj);
  return (PyObject *)self;
}

static void
PyGtkAccelerator_Dealloc(PyGtkAccelerator_Object *self) {
  gtk_accelerator_table_unref(self->obj); 
  PyMem_DEL(self);
}

static int
PyGtkAccelerator_Compare(PyGtkAccelerator_Object *self,
                            PyGtkAccelerator_Object *v) {
  if (self->obj == v->obj) return 0;
  if (self->obj > v->obj) return -1;
  return 1;
}

static PyTypeObject PyGtkAccelerator_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "GtkAcceleratorTable",
  sizeof(PyGtkAccelerator_Object),
  0,
  (destructor)PyGtkAccelerator_Dealloc,
  (printfunc)0,
  (getattrfunc)0,
  (setattrfunc)0,
  (cmpfunc)PyGtkAccelerator_Compare,
  (reprfunc)0,
  0,
  0,
  0,
  (hashfunc)0,
  (ternaryfunc)0,
  (reprfunc)0,
  0L,0L,0L,0L,
  NULL
};

static void
PyGtkStyle_Dealloc(PyGtkStyle_Object *self) {
  gtk_style_unref(self->obj);
  PyMem_DEL(self);
}

static int
PyGtkStyle_Compare(PyGtkStyle_Object *self, PyGtkStyle_Object *v) {
  if (self->obj == v->obj) return 0;
  if (self->obj > v->obj) return -1;
  return 1;
}

static PyObject *PyGtkStyle_GetAttr(PyGtkStyle_Object *self, char *attr) {
  GtkStyle *style = self->obj;
  PyObject *ret;
  int i;

  if (!strcmp(attr, "__members__"))
    return Py_BuildValue("[ssssssssssssssssssss]", "base", "base_gc", "bg",
			 "bg_gc", "bg_pixmap", "black", "black_gc", "colormap",
			 "dark", "dark_gc", "fg", "fg_gc", "font", "light",
			 "light_gc", "mid", "mid_gc", "text", "text_gc",
			 "white", "white_gc");
  if (!strcmp(attr, "fg")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkColor_New(&style->fg[i]));
    return ret;
  }
  if (!strcmp(attr, "bg")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkColor_New(&style->bg[i]));
    return ret;
  }
  if (!strcmp(attr, "light")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkColor_New(&style->light[i]));
    return ret;
  }
  if (!strcmp(attr, "dark")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkColor_New(&style->dark[i]));
    return ret;
  }
  if (!strcmp(attr, "mid")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkColor_New(&style->mid[i]));
    return ret;
  }
  if (!strcmp(attr, "text")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkColor_New(&style->text[i]));
    return ret;
  }
  if (!strcmp(attr, "base")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkColor_New(&style->base[i]));
    return ret;
  }
  if (!strcmp(attr, "black"))
    return PyGdkColor_New(&style->black);
  if (!strcmp(attr, "white"))
    return PyGdkColor_New(&style->white);
  if (!strcmp(attr, "font")) {
    gdk_font_ref(style->font);
    return PyGdkFont_New(style->font);
  }
  if (!strcmp(attr, "fg_gc")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkGC_New(style->fg_gc[i]));
    return ret;
  }
  if (!strcmp(attr, "bg_gc")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkGC_New(style->bg_gc[i]));
    return ret;
  }
  if (!strcmp(attr, "light_gc")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkGC_New(style->light_gc[i]));
    return ret;
  }
  if (!strcmp(attr, "dark_gc")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkGC_New(style->dark_gc[i]));
    return ret;
  }
  if (!strcmp(attr, "mid_gc")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkGC_New(style->mid_gc[i]));
    return ret;
  }
  if (!strcmp(attr, "text_gc")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkGC_New(style->text_gc[i]));
    return ret;
  }
  if (!strcmp(attr, "base_gc")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkGC_New(style->base_gc[i]));
    return ret;
  }
  if (!strcmp(attr, "black_gc"))
    return PyGdkGC_New(style->black_gc);
  if (!strcmp(attr, "white_gc"))
    return PyGdkGC_New(style->white_gc);
  if (!strcmp(attr, "bg_pixmap")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i,PyGdkWindow_New(style->bg_pixmap[i],"GdkPixmap"));
    return ret;
  }
  if (!strcmp(attr, "colormap")) {
    if (style->colormap)
      return PyGdkColormap_New(style->colormap);
    Py_INCREF(Py_None);
    return Py_None;
  }

  PyErr_SetString(PyExc_AttributeError, attr);
  return NULL;
}

static PyTypeObject PyGtkStyle_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "GtkStyle",
  sizeof(PyGtkStyle_Object),
  0,
  (destructor)PyGtkStyle_Dealloc,
  (printfunc)0,
  (getattrfunc)PyGtkStyle_GetAttr,
  (setattrfunc)0,
  (cmpfunc)PyGtkStyle_Compare,
  (reprfunc)0,
  0,
  0,
  0,
  (hashfunc)0,
  (ternaryfunc)0,
  (reprfunc)0,
  0L,0L,0L,0L,
  NULL
};

static void
PyGdkFont_Dealloc(PyGdkFont_Object *self) {
  gdk_font_unref(self->obj);
  PyMem_DEL(self);
}

static PyObject *
PyGdkFont_Width(PyGdkFont_Object *self, PyObject *args) {
  char *text;
  int length;

  if (!PyArg_ParseTuple(args, "s#:GdkFont.width", &text, &length))
    return NULL;
  return PyInt_FromLong(gdk_text_width(self->obj, text, length));
}

static PyObject *
PyGdkFont_Measure(PyGdkFont_Object *self, PyObject *args) {
  char *text;
  int length;

  if (!PyArg_ParseTuple(args, "s#:GdkFont.measure", &text, &length))
    return NULL;
  return PyInt_FromLong(gdk_text_measure(self->obj, text, length));
}

static PyMethodDef PyGdkFont_methods[] = {
  {"width",   (PyCFunction)PyGdkFont_Width,   METH_VARARGS, NULL},
  {"measure", (PyCFunction)PyGdkFont_Measure, METH_VARARGS, NULL},
  {NULL, 0, 0, NULL}
};

static PyObject *
PyGdkFont_GetAttr(PyGdkFont_Object *self, char *key) {
  if (!strcmp(key, "__members__"))
    return Py_BuildValue("[sss]", "ascent", "descent", "type");
  if (!strcmp(key, "ascent"))
    return PyInt_FromLong(self->obj->ascent);
  if (!strcmp(key, "descent"))
    return PyInt_FromLong(self->obj->descent);
  if (!strcmp(key, "type"))
    return PyInt_FromLong(self->obj->type);
  return Py_FindMethod(PyGdkFont_methods, (PyObject *)self, key);
}

static int
PyGdkFont_Compare(PyGdkFont_Object *self, PyGdkFont_Object *v) {
  if (self->obj == v->obj) return 0;
  if (self->obj > v->obj) return -1;
  return 1;
}

static PyTypeObject PyGdkFont_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "GdkFont",
  sizeof(PyGdkFont_Object),
  0,
  (destructor)PyGdkFont_Dealloc,
  (printfunc)0,
  (getattrfunc)PyGdkFont_GetAttr,
  (setattrfunc)0,
  (cmpfunc)PyGdkFont_Compare,
  (reprfunc)0,
  0,
  0,
  0,
  (hashfunc)0,
  (ternaryfunc)0,
  (reprfunc)0,
  0L,0L,0L,0L,
  NULL
};

static void
PyGdkColor_Dealloc(PyGdkColor_Object *self) {
  PyMem_DEL(self);
}

static PyObject *
PyGdkColor_GetAttr(PyGdkColor_Object *self, char *key) {
  if (!strcmp(key, "red"))
    return PyInt_FromLong(self->obj.red);
  if (!strcmp(key, "green"))
    return PyInt_FromLong(self->obj.green);
  if (!strcmp(key, "blue"))
    return PyInt_FromLong(self->obj.blue);
  if (!strcmp(key, "pixel"))
    return PyInt_FromLong(self->obj.pixel);
  PyErr_SetString(PyExc_AttributeError, key);
  return NULL;
}

static int
PyGdkColor_Compare(PyGdkColor_Object *self, PyGdkColor_Object *v) {
  if (self->obj.pixel == v->obj.pixel) return 0;
  if (self->obj.pixel > v->obj.pixel) return -1;
  return 1;
}

static PyObject *
PyGdkColor_Repr(PyGdkColor_Object *self) {
  char buf[80];

  g_snprintf(buf, 79, "<GdkColor (%hu, %hu, %hu)>", self->obj.red,
	     self->obj.green, self->obj.blue);
  return PyString_FromString(buf);
}

static PyTypeObject PyGdkColor_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "GdkColor",
  sizeof(PyGdkColor_Object),
  0,
  (destructor)PyGdkColor_Dealloc,
  (printfunc)0,
  (getattrfunc)PyGdkColor_GetAttr,
  (setattrfunc)0,
  (cmpfunc)PyGdkColor_Compare,
  (reprfunc)PyGdkColor_Repr,
  0,
  0,
  0,
  (hashfunc)0,
  (ternaryfunc)0,
  (reprfunc)0,
  0L,0L,0L,0L,
  NULL
};

static PyObject *
PyGdkEvent_New(GdkEvent *obj) {
  PyGdkEvent_Object *self;
  PyObject *v;

  self = (PyGdkEvent_Object *)PyObject_NEW(PyGdkEvent_Object,&PyGdkEvent_Type);
  if (self == NULL)
    return NULL;
  self->obj = obj;
  self->attrs = PyDict_New();
  PyDict_SetItemString(self->attrs, "type", v=PyInt_FromLong(obj->type));
  Py_DECREF(v);
  PyDict_SetItemString(self->attrs, "window", v=PyGdkWindow_New(
						obj->any.window, "GdkWindow"));
  Py_DECREF(v);
  PyDict_SetItemString(self->attrs, "send_event", v=PyInt_FromLong(
    obj->any.send_event));
  Py_DECREF(v);
  /* XXX Does anyone need the window attribute?? */
  switch(obj->type) {
    case GDK_NOTHING: break;
    case GDK_DELETE: break;
    case GDK_DESTROY: break;
    case GDK_EXPOSE:            /*GdkEventExpose            expose*/
      PyDict_SetItemString(self->attrs, "area", v=Py_BuildValue("(iiii)",
        obj->expose.area.x, obj->expose.area.y, obj->expose.area.width,
        obj->expose.area.height));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "count", v=PyInt_FromLong(
        obj->expose.count));
      Py_DECREF(v);
      break;
    case GDK_MOTION_NOTIFY:     /*GdkEventMotion            motion*/
      PyDict_SetItemString(self->attrs, "time", v=PyInt_FromLong(
        obj->motion.time));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs,"x",v=PyFloat_FromDouble(obj->motion.x));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs,"y",v=PyFloat_FromDouble(obj->motion.y));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "pressure", v=PyFloat_FromDouble(
        obj->motion.pressure));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "xtilt", v=PyFloat_FromDouble(
        obj->motion.xtilt));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "ytilt", v=PyFloat_FromDouble(
        obj->motion.ytilt));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "state", v=PyInt_FromLong(
        obj->motion.state));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "is_hint", v=PyInt_FromLong(
        obj->motion.is_hint));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "source", v=PyInt_FromLong(
        obj->motion.source));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "deviceid", v=PyInt_FromLong(
        obj->motion.deviceid));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "x_root", v=PyFloat_FromDouble(
        obj->motion.x_root));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "y_root", v=PyFloat_FromDouble(
        obj->motion.y_root));
      Py_DECREF(v);
      break;
    case GDK_BUTTON_PRESS:      /*GdkEventButton            button*/
    case GDK_2BUTTON_PRESS:     /*GdkEventButton            button*/
    case GDK_3BUTTON_PRESS:     /*GdkEventButton            button*/
      PyDict_SetItemString(self->attrs, "time", v=PyInt_FromLong(
        obj->button.time));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs,"x",v=PyFloat_FromDouble(obj->button.x));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs,"y",v=PyFloat_FromDouble(obj->button.y));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "pressure", v=PyFloat_FromDouble(
        obj->button.pressure));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "xtilt", v=PyFloat_FromDouble(
        obj->button.xtilt));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "ytilt", v=PyFloat_FromDouble(
        obj->button.ytilt));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "state", v=PyInt_FromLong(
        obj->button.state));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "button", v=PyInt_FromLong(
        obj->button.button));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "source", v=PyInt_FromLong(
        obj->button.source));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "deviceid", v=PyInt_FromLong(
        obj->button.deviceid));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "x_root", v=PyFloat_FromDouble(
        obj->button.x_root));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "y_root", v=PyFloat_FromDouble(
        obj->button.y_root));
      Py_DECREF(v);
      break;
    case GDK_KEY_PRESS:         /*GdkEventKey               key*/
    case GDK_KEY_RELEASE:       /*GdkEventKey               key*/
      PyDict_SetItemString(self->attrs, "time", v=PyInt_FromLong(
							obj->key.time));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "state", v=PyInt_FromLong(
        obj->key.state));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "keyval", v=PyInt_FromLong(
        obj->key.keyval));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "string", v=PyString_FromStringAndSize(
        obj->key.string, obj->key.length));
      Py_DECREF(v);
      break;
    case GDK_ENTER_NOTIFY:      /*GdkEventCrossing          crossing*/
    case GDK_LEAVE_NOTIFY:      /*GdkEventCrossing          crossing*/
      /*subwindow*/
      PyDict_SetItemString(self->attrs, "detail", v=PyInt_FromLong(
        obj->crossing.detail));
      Py_DECREF(v);
      break;
    case GDK_FOCUS_CHANGE:      /*GdkEventFocus             focus_change*/
      PyDict_SetItemString(self->attrs, "_in", v=PyInt_FromLong(
        obj->focus_change.in));
      Py_DECREF(v);
      break;
    case GDK_CONFIGURE:         /*GdkEventConfigure         configure*/
      PyDict_SetItemString(self->attrs, "x", v=PyInt_FromLong(obj->configure.x));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "y", v=PyInt_FromLong(obj->configure.y));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "width", v=PyInt_FromLong(
        obj->configure.width));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "height", v=PyInt_FromLong(
        obj->configure.height));
      Py_DECREF(v);
      break;
    case GDK_MAP: break;
    case GDK_UNMAP: break;
    case GDK_PROPERTY_NOTIFY:   /*GdkEventProperty          property*/
      PyDict_SetItemString(self->attrs, "atom", v=PyInt_FromLong(
        obj->property.atom));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "time", v=PyInt_FromLong(
        obj->property.time));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "state", v=PyInt_FromLong(
        obj->property.state));
      Py_DECREF(v);
      break;
    case GDK_SELECTION_CLEAR:   /*GdkEventSelection         selection*/
    case GDK_SELECTION_REQUEST: /*GdkEventSelection         selection*/
    case GDK_SELECTION_NOTIFY:  /*GdkEventSelection         selection*/
      PyDict_SetItemString(self->attrs, "selection", v=PyInt_FromLong(
        obj->selection.selection));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "target", v=PyInt_FromLong(
        obj->selection.target));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "property", v=PyInt_FromLong(
        obj->selection.property));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "requestor", v=PyInt_FromLong(
        obj->selection.requestor));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "time", v=PyInt_FromLong(
        obj->selection.time));
      Py_DECREF(v);
      break;
    case GDK_PROXIMITY_IN:      /*GdkEventProximity         proximity*/
    case GDK_PROXIMITY_OUT:     /*GdkEventProximity         proximity*/
      PyDict_SetItemString(self->attrs, "time", v=PyInt_FromLong(
        obj->proximity.time));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "source", v=PyInt_FromLong(
        obj->proximity.source));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "deviceid", v=PyInt_FromLong(
        obj->proximity.deviceid));
      Py_DECREF(v);
      break;
    case GDK_DRAG_BEGIN:        /*GdkEventDragBegin         dragbegin*/
      PyDict_SetItemString(self->attrs, "protocol_version", v=PyInt_FromLong(
        obj->dragbegin.u.flags.protocol_version));
      Py_DECREF(v);
      break;
    case GDK_DRAG_REQUEST:      /*GdkEventDragRequest       dragrequest*/
      PyDict_SetItemString(self->attrs, "protocol_version", v=PyInt_FromLong(
        obj->dragrequest.u.flags.protocol_version));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "sendreply", v=PyInt_FromLong(
        obj->dragrequest.u.flags.sendreply));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "willaccept", v=PyInt_FromLong(
        obj->dragrequest.u.flags.willaccept));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "delete_data", v=PyInt_FromLong(
        obj->dragrequest.u.flags.delete_data));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "senddata", v=PyInt_FromLong(
        obj->dragrequest.u.flags.senddata));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "isdrop", v=PyInt_FromLong(
        obj->dragrequest.isdrop));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "drop_coords", v=Py_BuildValue("(ii)",
        obj->dragrequest.drop_coords.x, obj->dragrequest.drop_coords.y));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "data_type", v=PyString_FromString(
        obj->dragrequest.data_type));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "timestamp", v=PyInt_FromLong(
        obj->dragrequest.timestamp));
      Py_DECREF(v);
      break;
    case GDK_DROP_ENTER:        /*GdkEventDropEnter         dropenter*/
      PyDict_SetItemString(self->attrs, "requestor", v=PyInt_FromLong(
        obj->dropenter.requestor));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "protocol_version", v=PyInt_FromLong(
        obj->dropenter.u.flags.protocol_version));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "sendreply", v=PyInt_FromLong(
        obj->dropenter.u.flags.sendreply));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "extended_typelist", v=PyInt_FromLong(
        obj->dropenter.u.flags.extended_typelist));
      Py_DECREF(v);
      break;
    case GDK_DROP_LEAVE:        /*GdkEventDropLeave         dropleave*/
      PyDict_SetItemString(self->attrs, "requestor", v=PyInt_FromLong(
        obj->dropleave.requestor));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "protocol_version", v=PyInt_FromLong(
        obj->dropleave.u.flags.protocol_version));
      Py_DECREF(v);
      break;
    case GDK_DROP_DATA_AVAIL:   /*GdkEventDropDataAvailable dropdataavailable*/
      PyDict_SetItemString(self->attrs, "requestor", v=PyInt_FromLong(
        obj->dropdataavailable.requestor));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "protocol_version", v=PyInt_FromLong(
        obj->dropdataavailable.u.flags.protocol_version));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "isdrop", v=PyInt_FromLong(
        obj->dropdataavailable.u.flags.isdrop));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "data_type", v=PyString_FromString(
        obj->dropdataavailable.data_type));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "data", v=PyString_FromStringAndSize(
        obj->dropdataavailable.data, obj->dropdataavailable.data_numbytes));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "timestamp", v=PyInt_FromLong(
        obj->dropdataavailable.timestamp));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "coords", v=Py_BuildValue("(ii)",
        obj->dropdataavailable.coords.x, obj->dropdataavailable.coords.y));
      Py_DECREF(v);
      break;
    case GDK_CLIENT_EVENT:      /*GdkEventClient            client*/
      PyDict_SetItemString(self->attrs, "message_type", v=PyInt_FromLong(
        obj->client.message_type));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "data_format", v=PyInt_FromLong(
        obj->client.data_format));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "data", v=PyString_FromStringAndSize(
        obj->client.data.b, 20));
      Py_DECREF(v);
      break;
    case GDK_VISIBILITY_NOTIFY: /*GdkEventVisibility        visibility*/
      PyDict_SetItemString(self->attrs, "state", v=PyInt_FromLong(
        obj->visibility.state));
      Py_DECREF(v);
      break;
    case GDK_NO_EXPOSE:         /*GdkEventNoExpose          no_expose*/
      break;
    case GDK_OTHER_EVENT:
    default:
      break;
  }
  return (PyObject *)self;
}

static void
PyGdkEvent_Dealloc(PyGdkEvent_Object *self) {
  Py_XDECREF(self->attrs);
  PyMem_DEL(self);
}

static PyObject *
PyGdkEvent_GetAttr(PyGdkEvent_Object *self, char *attr) {
  PyObject *ret;
  ret = PyDict_GetItemString(self->attrs, attr);
  if (ret != NULL) {
    Py_INCREF(ret);
    return ret;
  }
  PyErr_SetString(PyExc_AttributeError, attr);
  return NULL;
}

static int
PyGdkEvent_Compare(PyGdkEvent_Object *self, PyGdkEvent_Object *v) {
  if (self->obj == v->obj) return 0;
  if (self->obj > v->obj) return -1;
  return 1;
}

static PyTypeObject PyGdkEvent_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "GdkEvent",
  sizeof(PyGdkEvent_Object),
  0,
  (destructor)PyGdkEvent_Dealloc,
  (printfunc)0,
  (getattrfunc)PyGdkEvent_GetAttr,
  (setattrfunc)0,
  (cmpfunc)PyGdkEvent_Compare,
  (reprfunc)0,
  0,
  0,
  0,
  (hashfunc)0,
  (ternaryfunc)0,
  (reprfunc)0,
  0L,0L,0L,0L,
  NULL
};

static void
PyGdkWindow_Dealloc(PyGdkWindow_Object *self) {
  if (gdk_window_get_type(self->obj) == GDK_WINDOW_PIXMAP)
    gdk_pixmap_unref(self->obj);
  else
    gdk_window_unref(self->obj);
  PyMem_DEL(self);
}

static int
PyGdkWindow_Compare(PyGdkWindow_Object *self, PyGdkWindow_Object *v) {
  if (self->obj == v->obj) return 0;
  if (self->obj > v->obj) return -1;
  return 1;
}

static PyObject *
PyGdkWindow_Repr(PyGdkWindow_Object *self) {
  char buf[100];
  sprintf(buf, "<%s at %lx>", self->type, (long)PyGdkWindow_Get(self));
  return PyString_FromString(buf);
}

static PyObject *
PyGdkWindow_NewGC(PyGdkWindow_Object *self, PyObject *args, PyObject *kws) {
  int i = 0;
  PyObject *key, *value;
  char *strkey;
  GdkGCValues values;
  GdkGCValuesMask mask = 0;
  GdkGC *gc;

  if (kws != NULL)
    while (PyDict_Next(kws, &i, &key, &value)) {
      strkey = PyString_AsString(key);
      if (!strcmp(strkey, "foreground")) {
	if (!PyGdkColor_Check(value)) {
	  PyErr_SetString(PyExc_TypeError, "foreground argument takes a GdkColor");
	  return NULL;
	}
	mask |= GDK_GC_FOREGROUND;
	values.foreground.red = PyGdkColor_Get(value)->red;
	values.foreground.green = PyGdkColor_Get(value)->green;
	values.foreground.blue = PyGdkColor_Get(value)->blue;
	values.foreground.pixel = PyGdkColor_Get(value)->pixel;
      } else if (!strcmp(strkey, "background")) {
	if (!PyGdkColor_Check(value)) {
	  PyErr_SetString(PyExc_TypeError, "background argument takes a GdkColor");
	  return NULL;
	}
	mask |= GDK_GC_BACKGROUND;
	values.background.red = PyGdkColor_Get(value)->red;
	values.background.green = PyGdkColor_Get(value)->green;
	values.background.blue = PyGdkColor_Get(value)->blue;
	values.background.pixel = PyGdkColor_Get(value)->pixel;
      } else if (!strcmp(strkey, "font")) {
	if (!PyGdkFont_Check(value)) {
	  PyErr_SetString(PyExc_TypeError, "font argument takes a GdkFont");
	  return NULL;
	}
	mask |= GDK_GC_FONT;
	values.font = PyGdkFont_Get(value);
      } else if (!strcmp(strkey, "tile")) {
	if (!PyGdkWindow_Check(value)) {
	  PyErr_SetString(PyExc_TypeError, "tile argument takes a GdkPixmap");
	  return NULL;
	}
	mask |= GDK_GC_TILE;
	values.tile = PyGdkWindow_Get(value);
      } else if (!strcmp(strkey, "stipple")) {
	if (!PyGdkWindow_Check(value)) {
	  PyErr_SetString(PyExc_TypeError, "stipple argument takes a GdkPixmap");
	  return NULL;
	}
	mask |= GDK_GC_STIPPLE;
	values.stipple = PyGdkWindow_Get(value);
      } else if (!strcmp(strkey, "clip_mask")) {
	if (!PyGdkWindow_Check(value)) {
	  PyErr_SetString(PyExc_TypeError, "clip_mask argument takes a GdkPixmap");
	  return NULL;
	}
	mask |= GDK_GC_CLIP_MASK;
	values.clip_mask = PyGdkWindow_Get(value);
      } else {
	int i = 0;
#ifndef offsetof
#define offsetof(type, member) ( (int) &((type*)0)->member)
#endif
#define OFF(x) offsetof(GdkGCValues, x)
	static struct {char *name;GdkGCValuesMask mask;int offs; } others[] = {
	  {"function", GDK_GC_FUNCTION, OFF(function)},
	  {"fill",     GDK_GC_FILL,     OFF(fill)},
	  {"subwindow_mode", GDK_GC_SUBWINDOW, OFF(subwindow_mode)},
	  {"ts_x_origin", GDK_GC_TS_X_ORIGIN, OFF(ts_x_origin)},
	  {"ts_y_origin", GDK_GC_TS_Y_ORIGIN, OFF(ts_y_origin)},
	  {"clip_x_origin", GDK_GC_CLIP_X_ORIGIN, OFF(clip_x_origin)},
	  {"clip_y_origin", GDK_GC_CLIP_Y_ORIGIN, OFF(clip_y_origin)},
	  {"graphics_exposures", GDK_GC_EXPOSURES, OFF(graphics_exposures)},
	  {"line_width", GDK_GC_LINE_WIDTH, OFF(line_width)},
	  {"line_style", GDK_GC_LINE_STYLE, OFF(line_style)},
	  {"cap_style", GDK_GC_CAP_STYLE, OFF(cap_style)},
	  {"join_style", GDK_GC_JOIN_STYLE, OFF(join_style)},
	  {NULL, 0, 0}
	};
#undef OFF
	while (others[i].name != NULL) {
	  if (!strcmp(strkey, others[i].name)) {
	    if (!PyInt_Check(value)) {
	      char buf[80];
	      g_snprintf(buf, 79, "%s argument expects an integer",
			 others[i].name);
	      PyErr_SetString(PyExc_TypeError, buf);
	      return NULL;
	    }
	    mask |= others[i].mask;
	    *((int *)((char *)&values + others[i].offs)) = PyInt_AsLong(value);
	    break;
	  }
	  i++;
	}
	if (others[i].name == NULL) {
	  PyErr_SetString(PyExc_TypeError, "unknown argument");
	  return NULL;
	}
      }
    }
  if (!PyArg_ParseTuple(args, ":GdkWindow.new_gc"))
    return NULL;
  gc = gdk_gc_new_with_values(PyGdkWindow_Get(self), &values, mask);
  value = PyGdkGC_New(gc);
  gdk_gc_unref(gc);
  return value;
}

static PyMethodDef PyGdkWindow_methods[] = {
  {"new_gc", (PyCFunction)PyGdkWindow_NewGC, METH_VARARGS|METH_KEYWORDS, NULL},
  {NULL, 0, 0, NULL}
};

static PyObject *
PyGdkWindow_GetAttr(PyGdkWindow_Object *self, char *key) {
  GdkWindow *win = PyGdkWindow_Get(self);
  gint x, y;
  GdkModifierType p_mask;

  if (!strcmp(key, "__members__"))
    return Py_BuildValue("[sssssssssss]", "children", "colormap", "height",
			 "parent", "pointer", "pointer_state", "toplevel",
			 "type", "width", "x", "y");
  if (!strcmp(key, "width")) {
    gdk_window_get_size(win, &x, NULL);
    return PyInt_FromLong(x);
  }
  if (!strcmp(key, "height")) {
    gdk_window_get_size(win, NULL, &y);
    return PyInt_FromLong(y);
  }
  if (!strcmp(key, "x")) {
    gdk_window_get_position(win, &x, NULL);
    return PyInt_FromLong(x);
  }
  if (!strcmp(key, "y")) {
    gdk_window_get_position(win, NULL, &y);
    return PyInt_FromLong(y);
  }
  if (!strcmp(key, "colormap"))
    return PyGdkColormap_New(gdk_window_get_colormap(win));
  if (!strcmp(key, "pointer")) {
    gdk_window_get_pointer(win, &x, &y, NULL);
    return Py_BuildValue("(ii)", x, y);
  }
  if (!strcmp(key, "pointer_state")) {
    gdk_window_get_pointer(win, NULL, NULL, &p_mask);
    return PyInt_FromLong(p_mask);
  }
  if (!strcmp(key, "parent"))
    return PyGdkWindow_New(gdk_window_get_parent(win), "GdkWindow");
  if (!strcmp(key, "toplevel"))
    return PyGdkWindow_New(gdk_window_get_toplevel(win), "GdkWindow");
  if (!strcmp(key, "children")) {
    GList *children, *tmp;
    PyObject *ret;
    children = gdk_window_get_children(win);
    ret = PyList_New(0);
    for (tmp = children; tmp != NULL; tmp = tmp->next)
      PyList_Append(ret, PyGdkWindow_New(tmp->data, "GdkWindow"));
    g_list_free(children);
    return ret;
  }
  if (!strcmp(key, "type"))
    return PyInt_FromLong(gdk_window_get_type(win));
  return Py_FindMethod(PyGdkWindow_methods, (PyObject *)self, key);
}

static PyTypeObject PyGdkWindow_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "GdkWindow",
  sizeof(PyGdkWindow_Object),
  0,
  (destructor)PyGdkWindow_Dealloc,
  (printfunc)0,
  (getattrfunc)PyGdkWindow_GetAttr,
  (setattrfunc)0,
  (cmpfunc)PyGdkWindow_Compare,
  (reprfunc)PyGdkWindow_Repr,
  0,
  0,
  0,
  (hashfunc)0,
  (ternaryfunc)0,
  (reprfunc)0,
  0L,0L,0L,0L,
  NULL
};

static void
PyGdkGC_Dealloc(PyGdkGC_Object *self) {
  gdk_gc_unref(self->obj);
  PyMem_DEL(self);
}

static PyObject *
PyGdkGC_GetAttr(PyGdkGC_Object *self, char *key) {
  GdkGCValues gc;

  if (!strcmp(key, "__members__"))
    return Py_BuildValue("[ssssssssssssssssss]", "background", "cap_style",
			 "clip_mask", "clip_x_origin", "clip_y_origin",
			 "fill", "font", "foreground", "function",
			 "graphics_exposures", "join_style", "line_style",
			 "line_width", "stipple", "sub_window", "tile",
			 "ts_x_origin", "ts_y_origin");
  gdk_gc_get_values(self->obj, &gc);
  if (!strcmp(key, "foreground")) return PyGdkColor_New(&(gc.foreground));
  if (!strcmp(key, "background")) return PyGdkColor_New(&(gc.background));
  if (!strcmp(key, "font")) return PyGdkFont_New(gc.font);
  if (!strcmp(key, "function")) return PyInt_FromLong(gc.function);
  if (!strcmp(key, "fill")) return PyInt_FromLong(gc.fill);
  if (!strcmp(key, "tile")) {
    if (gc.tile != NULL) return PyGdkWindow_New(gc.tile, "GdkPixmap");
    Py_INCREF(Py_None); return Py_None;
  }
  if (!strcmp(key, "stipple")) {
    if (gc.stipple != NULL) return PyGdkWindow_New(gc.stipple, "GdkPixmap");
    Py_INCREF(Py_None); return Py_None;
  }
  if (!strcmp(key, "clip_mask")) {
    if (gc.clip_mask!=NULL) return PyGdkWindow_New(gc.clip_mask, "GdkBitmap");
    Py_INCREF(Py_None); return Py_None;
  }
  if (!strcmp(key, "subwindow_mode"))
    return PyInt_FromLong(gc.subwindow_mode);
  if (!strcmp(key, "ts_x_origin")) return PyInt_FromLong(gc.ts_x_origin);
  if (!strcmp(key, "ts_y_origin")) return PyInt_FromLong(gc.ts_y_origin);
  if (!strcmp(key, "clip_x_origin")) return PyInt_FromLong(gc.clip_x_origin);
  if (!strcmp(key, "clip_y_origin")) return PyInt_FromLong(gc.clip_y_origin);
  if (!strcmp(key, "graphics_exposures"))
    return PyInt_FromLong(gc.graphics_exposures);
  if (!strcmp(key, "line_width")) return PyInt_FromLong(gc.line_width);
  if (!strcmp(key, "line_style")) return PyInt_FromLong(gc.line_style);
  if (!strcmp(key, "cap_style")) return PyInt_FromLong(gc.cap_style);
  if (!strcmp(key, "join_style")) return PyInt_FromLong(gc.join_style);
  PyErr_SetString(PyExc_AttributeError, key);
  return NULL;
}

static int
PyGdkGC_SetAttr(PyGdkGC_Object *self, char *key, PyObject *value) {
  GdkGC *gc = self->obj;

  if (value == NULL) {
    PyErr_SetString(PyExc_TypeError, "can't delete attributes");
    return -1;
  }
  if (PyInt_Check(value)) {
    int i = PyInt_AsLong(value);
    GdkGCValues v;
    gdk_gc_get_values(gc, &v);
    if (!strcmp(key, "function")) gdk_gc_set_function(gc, i);
    else if (!strcmp(key, "fill")) gdk_gc_set_fill(gc, i);
    else if (!strcmp(key, "subwindow_mode")) gdk_gc_set_subwindow(gc, i);
    else if (!strcmp(key, "ts_x_origin"))
      gdk_gc_set_ts_origin(gc, i, v.ts_y_origin);
    else if (!strcmp(key, "ts_y_origin"))
      gdk_gc_set_ts_origin(gc, v.ts_x_origin, i);
    else if (!strcmp(key, "clip_x_origin"))
      gdk_gc_set_clip_origin(gc, i, v.clip_y_origin);
    else if (!strcmp(key, "clip_y_origin"))
      gdk_gc_set_clip_origin(gc, v.clip_x_origin, i);
    else if (!strcmp(key, "graphics_exposures")) gdk_gc_set_exposures(gc, i);
    else if (!strcmp(key, "line_width"))
      gdk_gc_set_line_attributes(gc, i,v.line_style,v.cap_style,v.join_style);
    else if (!strcmp(key, "line_style"))
      gdk_gc_set_line_attributes(gc, v.line_width,i,v.cap_style,v.join_style);
    else if (!strcmp(key, "cap_style"))
      gdk_gc_set_line_attributes(gc, v.line_width,v.line_style,i,v.join_style);
    else if (!strcmp(key, "join_style"))
      gdk_gc_set_line_attributes(gc, v.line_width,v.line_style,v.cap_style,i);
    else {
      PyErr_SetString(PyExc_TypeError,"type mismatch");
      return -1;
    }
  } else if (PyGdkColor_Check(value)) {
    GdkColor *c = PyGdkColor_Get(value);
    if (!strcmp(key, "foreground")) gdk_gc_set_foreground(gc, c);
    else if (!strcmp(key, "background")) gdk_gc_set_background(gc, c);
    else {
      PyErr_SetString(PyExc_TypeError,"type mismatch");
      return -1;
    }
  } else if (PyGdkFont_Check(value)) {
    if (!strcmp(key, "font")) gdk_gc_set_font(gc, PyGdkFont_Get(value));
    else{
      PyErr_SetString(PyExc_TypeError,"type mismatch");
      return -1;
    }
  } else if (PyGdkWindow_Check(value) || value == Py_None) {
    GdkWindow *w = (value==Py_None)?NULL:PyGdkWindow_Get(value);
    if (!strcmp(key, "tile")) gdk_gc_set_tile(gc, w);
    else if (!strcmp(key, "stipple")) gdk_gc_set_stipple(gc, w);
    else if (!strcmp(key, "clip_mask")) gdk_gc_set_clip_mask(gc, w);
    else {
      PyErr_SetString(PyExc_TypeError,"type mismatch");
      return -1;
    }
  } else {
    PyErr_SetString(PyExc_TypeError,"type mismatch");
      return -1;
  }
  return 0;
}

static int
PyGdkGC_Compare(PyGdkGC_Object *self, PyGdkGC_Object *v) {
  if (self->obj == v->obj) return 0;
  if (self->obj > v->obj) return -1;
  return 1;
}

static PyTypeObject PyGdkGC_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "GdkGC",
  sizeof(PyGdkGC_Object),
  0,
  (destructor)PyGdkGC_Dealloc,
  (printfunc)0,
  (getattrfunc)PyGdkGC_GetAttr,
  (setattrfunc)PyGdkGC_SetAttr,
  (cmpfunc)PyGdkGC_Compare,
  (reprfunc)0,
  0,
  0,
  0,
  (hashfunc)0,
  (ternaryfunc)0,
  (reprfunc)0,
  0L,0L,0L,0L,
  NULL
};

static void
PyGdkColormap_Dealloc(PyGdkColormap_Object *self) {
  gdk_colormap_unref(self->obj);
  PyMem_DEL(self);
}

static PyObject *
PyGdkColor_Alloc(PyGdkColormap_Object *self, PyObject *args) {
  GdkColor color = {0, 0, 0, 0};
  gchar *color_name;
  if (!PyArg_ParseTuple(args, "iii:GdkColormap.alloc",
			&(color.red), &(color.green), &(color.blue))) {
    PyErr_Clear();
    if (!PyArg_ParseTuple(args, "s:GdkColormap.alloc", &color_name))
      return NULL;
    if (!gdk_color_parse(color_name, &color)) {
      PyErr_SetString(PyExc_TypeError, "unable to parse color specification");
      return NULL;
    }
  }
  if (!gdk_color_alloc(self->obj, &color)) {
    PyErr_SetString(PyExc_RuntimeError, "couldn't allocate color");
    return NULL;
  }
  return PyGdkColor_New(&color);
}

static PyMethodDef PyGdkColormap_methods[] = {
  {"alloc", (PyCFunction)PyGdkColor_Alloc, METH_VARARGS, NULL},
  {NULL, 0, 0, NULL}
};

static PyObject *
PyGdkColormap_GetAttr(PyObject *self, char *key) {
  return Py_FindMethod(PyGdkColormap_methods, self, key);
}

static int
PyGdkColormap_Compare(PyGdkColormap_Object *self, PyGdkColormap_Object *v) {
  if (self->obj == v->obj) return 0;
  if (self->obj > v->obj) return -1;
  return 1;
}

static int
PyGdkColormap_Length(PyGdkColormap_Object *self) {
  return self->obj->size;
}

static PyObject *
PyGdkColormap_GetItem(PyGdkColormap_Object *self, int pos) {
  if (pos < 0 || pos >= self->obj->size) {
    PyErr_SetString(PyExc_IndexError, "index out of range");
    return NULL;
  }
  return PyGdkColor_New(&(self->obj->colors[pos]));
}

static PyObject *
PyGdkColormap_GetSlice(PyGdkColormap_Object *self, int lo, int up) {
  PyObject *ret;
  int i;

  if (lo < 0) lo = 0;
  if (up > self->obj->size) up = self->obj->size;
  if (up < lo) up = lo;

  ret = PyTuple_New(up - lo);
  if (ret == NULL) return NULL;
  for (i = lo; i < up; i++)
    PyTuple_SetItem(ret, i - lo, PyGdkColor_New(&(self->obj->colors[i])));
  return ret;
}

static PySequenceMethods PyGdkColormap_Sequence = {
  (inquiry)PyGdkColormap_Length,
  (binaryfunc)0,
  (intargfunc)0,
  (intargfunc)PyGdkColormap_GetItem,
  (intintargfunc)PyGdkColormap_GetSlice,
  (intobjargproc)0,
  (intintobjargproc)0
};

static PyTypeObject PyGdkColormap_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "GdkColormap",
  sizeof(PyGdkGC_Object),
  0,
  (destructor)PyGdkColormap_Dealloc,
  (printfunc)0,
  (getattrfunc)PyGdkColormap_GetAttr,
  (setattrfunc)0,
  (cmpfunc)PyGdkColormap_Compare,
  (reprfunc)0,
  0,
  &PyGdkColormap_Sequence,
  0,
  (hashfunc)0,
  (ternaryfunc)0,
  (reprfunc)0,
  0L,0L,0L,0L,
  NULL
};
%}

