/* -*- Mode: C; c-basic-offset: 4 -*- */

#include <Python.h>



#line 4 "gdk.override"
#define NO_IMPORT_PYGOBJECT
#include "pygobject.h"
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "pygtk-private.h"

extern PyTypeObject PyGtkWidget_Type;

#line 17 "gdk.c"


/* ---------- types from other modules ---------- */
static PyTypeObject *_PyGObject_Type;
#define PyGObject_Type (*_PyGObject_Type)
static PyTypeObject *_PyPangoContext_Type;
#define PyPangoContext_Type (*_PyPangoContext_Type)
static PyTypeObject *_PyPangoFont_Type;
#define PyPangoFont_Type (*_PyPangoFont_Type)
static PyTypeObject *_PyPangoLayout_Type;
#define PyPangoLayout_Type (*_PyPangoLayout_Type)


/* ---------- forward type declarations ---------- */
PyTypeObject PyGdkEvent_Type;
PyTypeObject PyGdkFont_Type;
PyTypeObject PyGdkColor_Type;
PyTypeObject PyGdkCursor_Type;
PyTypeObject PyGdkRectangle_Type;
PyTypeObject PyGdkColormap_Type;
PyTypeObject PyGdkDevice_Type;
PyTypeObject PyGdkDragContext_Type;
PyTypeObject PyGdkDrawable_Type;
PyTypeObject PyGdkWindow_Type;
PyTypeObject PyGdkPixmap_Type;
PyTypeObject PyGdkGC_Type;
PyTypeObject PyGdkImage_Type;
PyTypeObject PyGdkPixbuf_Type;
PyTypeObject PyGdkPixbufAnimation_Type;
PyTypeObject PyGdkPixbufAnimationIter_Type;
PyTypeObject PyGdkVisual_Type;


/* ----------- GdkEvent ----------- */

static PyObject *
_wrap_gdk_event_get_time(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkEvent.get_time", kwlist))
        return NULL;

    return PyInt_FromLong(gdk_event_get_time(pyg_boxed_get(self, GdkEvent)));
}

static PyMethodDef _PyGdkEvent_methods[] = {
    { "get_time", (PyCFunction)_wrap_gdk_event_get_time, METH_VARARGS|METH_KEYWORDS },
    { NULL, NULL, 0 }
};

PyObject *
_wrap_gdk_event_getattr(PyObject *self, char *attr)
{
    GdkEvent *event = pyg_boxed_get(self, GdkEvent);
    guint i;

    if (!strcmp(attr, "type"))
	return PyInt_FromLong(event->type);
    if (!strcmp(attr, "window"))
	return pygobject_new((GObject *)event->any.window);
    if (!strcmp(attr, "send_event"))
	return PyInt_FromLong(event->any.send_event);

    switch(event->type) {
    case GDK_NOTHING: break;
    case GDK_DELETE: break;
    case GDK_DESTROY: break;
    case GDK_EXPOSE:            /*GdkEventExpose            expose*/
	if (!strcmp(attr, "area"))
	    return Py_BuildValue("(iiii)",
				 event->expose.area.x,
				 event->expose.area.y,
				 event->expose.area.width,
				 event->expose.area.height);
	if (!strcmp(attr, "count"))
	    return PyInt_FromLong(event->expose.count);
	break;
    case GDK_MOTION_NOTIFY:     /*GdkEventMotion            motion*/
	if (!strcmp(attr, "time"))
	    return PyInt_FromLong(event->motion.time);
	if (!strcmp(attr, "x"))
	    return PyFloat_FromDouble(event->motion.x);
	if (!strcmp(attr, "y"))
	    return PyFloat_FromDouble(event->motion.y);
	if (!strcmp(attr, "axes")) {
	    if (event->motion.axes) {
		PyObject *v = PyTuple_New(event->motion.device->num_axes);
		if (!v) return NULL;
		for (i = 0; i < event->motion.device->num_axes; i++)
		    PyTuple_SetItem(v, i,PyFloat_FromDouble(
						event->motion.axes[i]));
		return v;
	    } else {
		Py_INCREF(Py_None);
		return Py_None;
	    }
	}
	if (!strcmp(attr, "state"))
	    return PyInt_FromLong(event->motion.state);
	if (!strcmp(attr, "is_hint"))
	    return PyInt_FromLong(event->motion.is_hint);
	if (!strcmp(attr, "device"))
	    return pygobject_new((GObject *)event->motion.device);
	if (!strcmp(attr, "x_root"))
	    return PyFloat_FromDouble(event->motion.x_root);
	if (!strcmp(attr, "y_root"))
	    return PyFloat_FromDouble(event->motion.y_root);
	break;
    case GDK_BUTTON_PRESS:      /*GdkEventButton            button*/
    case GDK_2BUTTON_PRESS:     /*GdkEventButton            button*/
    case GDK_3BUTTON_PRESS:     /*GdkEventButton            button*/
    case GDK_BUTTON_RELEASE:    /*GdkEventButton            button*/
	if (!strcmp(attr, "time"))
	    return PyInt_FromLong(event->button.time);
	if (!strcmp(attr, "x"))
	    return PyFloat_FromDouble(event->button.x);
	if (!strcmp(attr, "y"))
	    return PyFloat_FromDouble(event->button.y);
	if (!strcmp(attr, "axes")) {
	    if (event->button.axes) {
		PyObject *v = PyTuple_New(event->button.device->num_axes);
		if (!v) return NULL;
		for (i = 0; i < event->button.device->num_axes; i++)
		    PyTuple_SetItem(v, i,PyFloat_FromDouble(
						event->button.axes[i]));
		return v;
	    } else {
		Py_INCREF(Py_None);
		return Py_None;
	    }
	}
	if (!strcmp(attr, "state"))
	    return PyInt_FromLong(event->button.state);
	if (!strcmp(attr, "button"))
	    return PyInt_FromLong(event->button.button);
	if (!strcmp(attr, "device"))
	    return pygobject_new((GObject *)event->button.device);
	if (!strcmp(attr, "x_root"))
	    return PyFloat_FromDouble(event->button.x_root);
	if (!strcmp(attr, "y_root"))
	    return PyFloat_FromDouble(event->button.y_root);
	break;
    case GDK_KEY_PRESS:         /*GdkEventKey               key*/
    case GDK_KEY_RELEASE:       /*GdkEventKey               key*/
	if (!strcmp(attr, "time"))
	    return PyInt_FromLong(event->key.time);
	if (!strcmp(attr, "state"))
	    return PyInt_FromLong(event->key.state);
	if (!strcmp(attr, "keyval"))
	    return PyInt_FromLong(event->key.keyval);
	if (!strcmp(attr, "string"))
	    return PyString_FromStringAndSize(event->key.string,
					      event->key.length);
	break;
    case GDK_ENTER_NOTIFY:      /*GdkEventCrossing          crossing*/
    case GDK_LEAVE_NOTIFY:      /*GdkEventCrossing          crossing*/
	if (!strcmp(attr, "subwindow"))
	    return pygobject_new((GObject *)event->crossing.subwindow);
	if (!strcmp(attr, "time"))
	    return PyInt_FromLong(event->crossing.time);
	if (!strcmp(attr, "x"))
	    return PyFloat_FromDouble(event->crossing.x);
	if (!strcmp(attr, "y"))
	    return PyFloat_FromDouble(event->crossing.y);
	if (!strcmp(attr, "x_root"))
	    return PyFloat_FromDouble(event->crossing.x_root);
	if (!strcmp(attr, "y_root"))
	    return PyFloat_FromDouble(event->crossing.y_root);
	if (!strcmp(attr, "mode"))
	    return PyInt_FromLong(event->crossing.mode);
	if (!strcmp(attr, "detail"))
	    return PyInt_FromLong(event->crossing.detail);
	if (!strcmp(attr, "focus"))
	    return PyInt_FromLong(event->crossing.focus);
	if (!strcmp(attr, "state"))
	    return PyInt_FromLong(event->crossing.state);
	break;
    case GDK_FOCUS_CHANGE:      /*GdkEventFocus             focus_change*/
	if (!strcmp(attr, "in_"))
	    return PyInt_FromLong(event->focus_change.in);
	break;
    case GDK_CONFIGURE:         /*GdkEventConfigure         configure*/
	if (!strcmp(attr, "x"))
	    return PyInt_FromLong(event->configure.x);
	if (!strcmp(attr, "y"))
	    return PyInt_FromLong(event->configure.y);
	if (!strcmp(attr, "width"))
	    return PyInt_FromLong(event->configure.width);
	if (!strcmp(attr, "height"))
	    return PyInt_FromLong(event->configure.height);
	break;
    case GDK_MAP: break;
    case GDK_UNMAP: break;
    case GDK_PROPERTY_NOTIFY:   /*GdkEventProperty          property*/
	if (!strcmp(attr, "atom"))
	    return PyGdkAtom_New(event->property.atom);
	if (!strcmp(attr, "time"))
	    return PyInt_FromLong(event->property.time);
	if (!strcmp(attr, "state"))
	    return PyInt_FromLong(event->property.state);
	break;
    case GDK_SELECTION_CLEAR:   /*GdkEventSelection         selection*/
    case GDK_SELECTION_REQUEST: /*GdkEventSelection         selection*/
    case GDK_SELECTION_NOTIFY:  /*GdkEventSelection         selection*/
	if (!strcmp(attr, "selection"))
	    return PyGdkAtom_New(event->selection.selection);
	if (!strcmp(attr, "target"))
	    return PyGdkAtom_New(event->selection.target);
	if (!strcmp(attr, "property"))
	    return PyGdkAtom_New(event->selection.property);
	if (!strcmp(attr, "requestor"))
	    return PyInt_FromLong(event->selection.requestor);
	if (!strcmp(attr, "time"))
	    return PyInt_FromLong(event->selection.time);
	break;
    case GDK_PROXIMITY_IN:      /*GdkEventProximity         proximity*/
    case GDK_PROXIMITY_OUT:     /*GdkEventProximity         proximity*/
	if (!strcmp(attr, "time"))
	    return PyInt_FromLong(event->proximity.time);
	if (!strcmp(attr, "device"))
	    return pygobject_new((GObject *)event->proximity.device);
	break;
    case GDK_DRAG_ENTER:        /*GdkEventDND               dnd*/
    case GDK_DRAG_LEAVE:        /*GdkEventDND               dnd*/
    case GDK_DRAG_MOTION:       /*GdkEventDND               dnd*/
    case GDK_DRAG_STATUS:       /*GdkEventDND               dnd*/
    case GDK_DROP_START:        /*GdkEventDND               dnd*/
    case GDK_DROP_FINISHED:     /*GdkEventDND               dnd*/
	if (!strcmp(attr, "context"))
	    return pygobject_new((GObject *)event->dnd.context);
	if (!strcmp(attr, "time"))
	    return PyInt_FromLong(event->dnd.time);
	if (!strcmp(attr, "x_root"))
	    return PyFloat_FromDouble(event->dnd.x_root);
	if (!strcmp(attr, "y_root"))
	    return PyFloat_FromDouble(event->dnd.y_root);
	break;
    case GDK_CLIENT_EVENT:      /*GdkEventClient            client*/
	if (!strcmp(attr, "message_type"))
	    return PyGdkAtom_New(event->client.message_type);
	if (!strcmp(attr, "data_format"))
	    return PyInt_FromLong(event->client.data_format);
	if (!strcmp(attr, "data"))
	    return PyString_FromStringAndSize(event->client.data.b, 20);
	break;
    case GDK_VISIBILITY_NOTIFY: /*GdkEventVisibility        visibility*/
	if (!strcmp(attr, "state"))
	    return PyInt_FromLong(event->visibility.state);
	break;
    case GDK_NO_EXPOSE:         /*GdkEventNoExpose          no_expose*/
	break;
    case GDK_SCROLL:            /*GdkEventScroll            scroll*/
	if (!strcmp(attr, "time"))
	    return PyInt_FromLong(event->scroll.time);
	if (!strcmp(attr, "x"))
	    return PyFloat_FromDouble(event->scroll.x);
	if (!strcmp(attr, "y"))
	    return PyFloat_FromDouble(event->scroll.y);
	if (!strcmp(attr, "state"))
	    return PyInt_FromLong(event->scroll.state);
	if (!strcmp(attr, "direction"))
	    return PyInt_FromLong(event->scroll.direction);
	if (!strcmp(attr, "device"))
	    return pygobject_new((GObject *)event->scroll.device);
	if (!strcmp(attr, "x_root"))
	    return PyFloat_FromDouble(event->scroll.x_root);
	if (!strcmp(attr, "y_root"))
	    return PyFloat_FromDouble(event->scroll.y_root);
	break;
    case GDK_WINDOW_STATE:      /*GdkEventWindowState       window_state*/
	if (!strcmp(attr, "changed_mask"))
	    return PyInt_FromLong(event->window_state.changed_mask);
	if (!strcmp(attr, "new_window_state"))
	    return PyInt_FromLong(event->window_state.new_window_state);
	break;
    case GDK_SETTING:           /*GdkEventSetting           setting*/
	if (!strcmp(attr, "action"))
	    return PyInt_FromLong(event->setting.action);
	if (!strcmp(attr, "name"))
	    return PyString_FromString(event->setting.name);
	break;
    default:
	break;
    }
    PyErr_SetString(PyExc_AttributeError, attr);
    return NULL;
}


PyTypeObject PyGdkEvent_Type = {
    PyObject_HEAD_INIT(NULL)
    0,				/* ob_size */
    "GdkEvent",			/* tp_name */
    sizeof(PyGBoxed),		/* tp_basicsize */
    0,				/* tp_itemsize */
    /* methods */
    (destructor)0,			/* tp_dealloc */
    (printfunc)0,			/* tp_print */
    (getattrfunc)_wrap_gdk_event_getattr,	/* tp_getattr */
    (setattrfunc)0,			/* tp_setattr */
    (cmpfunc)0,			/* tp_compare */
    (reprfunc)0,			/* tp_repr */
    0,				/* tp_as_number */
    0,				/* tp_as_sequence */
    0,				/* tp_as_mapping */
    (hashfunc)0,			/* tp_hash */
    (ternaryfunc)0,			/* tp_call */
    (reprfunc)0,			/* tp_str */
    (getattrofunc)0,		/* tp_getattro */
    (setattrofunc)0,		/* tp_setattro */
    0,				/* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /* tp_flags */
    NULL, /* Documentation string */
    (traverseproc)0,		/* tp_traverse */
    (inquiry)0,			/* tp_clear */
    (richcmpfunc)0,		/* tp_richcompare */
    0,				/* tp_weaklistoffset */
    (getiterfunc)0,			/* tp_iter */
    (iternextfunc)0,		/* tp_iternext */
    _PyGdkEvent_methods,			/* tp_methods */
    0,				/* tp_members */
    0,				/* tp_getset */
    NULL,				/* tp_base */
    NULL,				/* tp_dict */
    (descrgetfunc)0,		/* tp_descr_get */
    (descrsetfunc)0,		/* tp_descr_set */
    0,				/* tp_dictoffset */
    (initproc)0,	/* tp_init */
};



/* ----------- GdkFont ----------- */

static int
_wrap_gdk_font_load(PyGBoxed *self, PyObject *args, PyObject *kwargs)
{
    char *font_name;
    static char *kwlist[] = { "font_name", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s:GdkFont.__init__", kwlist, &font_name))
        return -1;

    self->gtype = GDK_TYPE_FONT;
    self->free_on_dealloc = FALSE;
    self->boxed = gdk_font_load(font_name);
    if (!self->boxed) {
        PyErr_SetString(PyExc_RuntimeError, "could not create GdkFont object");
        return -1;
    }
    self->free_on_dealloc = TRUE;
    return 0;
}

static PyObject *
_wrap_gdk_font_id(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkFont.id", kwlist))
        return NULL;

    return PyInt_FromLong(gdk_font_id(pyg_boxed_get(self, GdkFont)));
}

static PyObject *
_wrap_gdk_string_width(PyObject *self, PyObject *args, PyObject *kwargs)
{
    char *string;
    static char *kwlist[] = { "string", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s:GdkFont.string_width", kwlist, &string))
        return NULL;

    return PyInt_FromLong(gdk_string_width(pyg_boxed_get(self, GdkFont), string));
}

static PyObject *
_wrap_gdk_text_width(PyObject *self, PyObject *args, PyObject *kwargs)
{
    char *text;
    static char *kwlist[] = { "text", "text_length", NULL };
    int text_length = -1;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s|i:GdkFont.width", kwlist, &text, &text_length))
        return NULL;

    return PyInt_FromLong(gdk_text_width(pyg_boxed_get(self, GdkFont), text, text_length));
}

static PyObject *
_wrap_gdk_char_width(PyObject *self, PyObject *args, PyObject *kwargs)
{
    char character;
    static char *kwlist[] = { "character", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "c:GdkFont.char_width", kwlist, &character))
        return NULL;

    return PyInt_FromLong(gdk_char_width(pyg_boxed_get(self, GdkFont), character));
}

static PyObject *
_wrap_gdk_string_measure(PyObject *self, PyObject *args, PyObject *kwargs)
{
    char *string;
    static char *kwlist[] = { "string", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s:GdkFont.string_measure", kwlist, &string))
        return NULL;

    return PyInt_FromLong(gdk_string_measure(pyg_boxed_get(self, GdkFont), string));
}

static PyObject *
_wrap_gdk_text_measure(PyObject *self, PyObject *args, PyObject *kwargs)
{
    char *text;
    static char *kwlist[] = { "text", "text_length", NULL };
    int text_length = -1;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s|i:GdkFont.measure", kwlist, &text, &text_length))
        return NULL;

    return PyInt_FromLong(gdk_text_measure(pyg_boxed_get(self, GdkFont), text, text_length));
}

static PyObject *
_wrap_gdk_char_measure(PyObject *self, PyObject *args, PyObject *kwargs)
{
    char character;
    static char *kwlist[] = { "character", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "c:GdkFont.char_measure", kwlist, &character))
        return NULL;

    return PyInt_FromLong(gdk_char_measure(pyg_boxed_get(self, GdkFont), character));
}

static PyObject *
_wrap_gdk_string_height(PyObject *self, PyObject *args, PyObject *kwargs)
{
    char *string;
    static char *kwlist[] = { "string", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s:GdkFont.string_height", kwlist, &string))
        return NULL;

    return PyInt_FromLong(gdk_string_height(pyg_boxed_get(self, GdkFont), string));
}

static PyObject *
_wrap_gdk_text_height(PyObject *self, PyObject *args, PyObject *kwargs)
{
    char *text;
    static char *kwlist[] = { "text", "text_length", NULL };
    int text_length = -1;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s|i:GdkFont.height", kwlist, &text, &text_length))
        return NULL;

    return PyInt_FromLong(gdk_text_height(pyg_boxed_get(self, GdkFont), text, text_length));
}

static PyObject *
_wrap_gdk_char_height(PyObject *self, PyObject *args, PyObject *kwargs)
{
    char character;
    static char *kwlist[] = { "character", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "c:GdkFont.char_height", kwlist, &character))
        return NULL;

    return PyInt_FromLong(gdk_char_height(pyg_boxed_get(self, GdkFont), character));
}

#line 256 "gdk.override"
static PyObject *
_wrap_gdk_text_extents(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "text", NULL };
    gchar *text;
    gint length;
    gint lbearing, rbearing, width, ascent, descent;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#:GdkFont.extents",
				     kwlist, &text, &length))
	return NULL;
    gdk_text_extents(pyg_boxed_get(self, GdkFont), text, length,
		     &lbearing, &rbearing, &width, &ascent, &descent);
    return Py_BuildValue("(iiiii)", lbearing, rbearing, width,
			 ascent, descent);
}
#line 512 "gdk.c"


static PyMethodDef _PyGdkFont_methods[] = {
    { "id", (PyCFunction)_wrap_gdk_font_id, METH_VARARGS|METH_KEYWORDS },
    { "string_width", (PyCFunction)_wrap_gdk_string_width, METH_VARARGS|METH_KEYWORDS },
    { "width", (PyCFunction)_wrap_gdk_text_width, METH_VARARGS|METH_KEYWORDS },
    { "char_width", (PyCFunction)_wrap_gdk_char_width, METH_VARARGS|METH_KEYWORDS },
    { "string_measure", (PyCFunction)_wrap_gdk_string_measure, METH_VARARGS|METH_KEYWORDS },
    { "measure", (PyCFunction)_wrap_gdk_text_measure, METH_VARARGS|METH_KEYWORDS },
    { "char_measure", (PyCFunction)_wrap_gdk_char_measure, METH_VARARGS|METH_KEYWORDS },
    { "string_height", (PyCFunction)_wrap_gdk_string_height, METH_VARARGS|METH_KEYWORDS },
    { "height", (PyCFunction)_wrap_gdk_text_height, METH_VARARGS|METH_KEYWORDS },
    { "char_height", (PyCFunction)_wrap_gdk_char_height, METH_VARARGS|METH_KEYWORDS },
    { "extents", (PyCFunction)_wrap_gdk_text_extents, METH_VARARGS|METH_KEYWORDS },
    { NULL, NULL, 0 }
};

static PyObject *
_wrap_gdk_font_getattr(PyObject *self, char *attr)
{
    if (!strcmp(attr, "__members__"))
        return Py_BuildValue("[sss]", "type", "ascent", "descent");
    if (!strcmp(attr, "type")) {
        return PyInt_FromLong(pyg_boxed_get(self, GdkFont)->type);
    }
    if (!strcmp(attr, "ascent")) {
        return PyInt_FromLong(pyg_boxed_get(self, GdkFont)->ascent);
    }
    if (!strcmp(attr, "descent")) {
        return PyInt_FromLong(pyg_boxed_get(self, GdkFont)->descent);
    }
    PyErr_SetString(PyExc_AttributeError, attr);
    return NULL;
}

PyTypeObject PyGdkFont_Type = {
    PyObject_HEAD_INIT(NULL)
    0,				/* ob_size */
    "GdkFont",			/* tp_name */
    sizeof(PyGBoxed),		/* tp_basicsize */
    0,				/* tp_itemsize */
    /* methods */
    (destructor)0,			/* tp_dealloc */
    (printfunc)0,			/* tp_print */
    (getattrfunc)_wrap_gdk_font_getattr,	/* tp_getattr */
    (setattrfunc)0,			/* tp_setattr */
    (cmpfunc)0,			/* tp_compare */
    (reprfunc)0,			/* tp_repr */
    0,				/* tp_as_number */
    0,				/* tp_as_sequence */
    0,				/* tp_as_mapping */
    (hashfunc)0,			/* tp_hash */
    (ternaryfunc)0,			/* tp_call */
    (reprfunc)0,			/* tp_str */
    (getattrofunc)0,		/* tp_getattro */
    (setattrofunc)0,		/* tp_setattro */
    0,				/* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /* tp_flags */
    NULL, /* Documentation string */
    (traverseproc)0,		/* tp_traverse */
    (inquiry)0,			/* tp_clear */
    (richcmpfunc)0,		/* tp_richcompare */
    0,				/* tp_weaklistoffset */
    (getiterfunc)0,			/* tp_iter */
    (iternextfunc)0,		/* tp_iternext */
    _PyGdkFont_methods,			/* tp_methods */
    0,				/* tp_members */
    0,				/* tp_getset */
    NULL,				/* tp_base */
    NULL,				/* tp_dict */
    (descrgetfunc)0,		/* tp_descr_get */
    (descrsetfunc)0,		/* tp_descr_set */
    0,				/* tp_dictoffset */
    (initproc)_wrap_gdk_font_load,	/* tp_init */
};



/* ----------- GdkColor ----------- */

static PyMethodDef _PyGdkColor_methods[] = {
    { NULL, NULL, 0 }
};

static PyObject *
_wrap_gdk_color_getattr(PyObject *self, char *attr)
{
    if (!strcmp(attr, "__members__"))
        return Py_BuildValue("[ssss]", "pixel", "red", "green", "blue");
    if (!strcmp(attr, "pixel")) {
        return PyInt_FromLong(pyg_boxed_get(self, GdkColor)->pixel);
    }
    if (!strcmp(attr, "red")) {
        return PyInt_FromLong(pyg_boxed_get(self, GdkColor)->red);
    }
    if (!strcmp(attr, "green")) {
        return PyInt_FromLong(pyg_boxed_get(self, GdkColor)->green);
    }
    if (!strcmp(attr, "blue")) {
        return PyInt_FromLong(pyg_boxed_get(self, GdkColor)->blue);
    }
    PyErr_SetString(PyExc_AttributeError, attr);
    return NULL;
}

PyTypeObject PyGdkColor_Type = {
    PyObject_HEAD_INIT(NULL)
    0,				/* ob_size */
    "GdkColor",			/* tp_name */
    sizeof(PyGBoxed),		/* tp_basicsize */
    0,				/* tp_itemsize */
    /* methods */
    (destructor)0,			/* tp_dealloc */
    (printfunc)0,			/* tp_print */
    (getattrfunc)_wrap_gdk_color_getattr,	/* tp_getattr */
    (setattrfunc)0,			/* tp_setattr */
    (cmpfunc)0,			/* tp_compare */
    (reprfunc)0,			/* tp_repr */
    0,				/* tp_as_number */
    0,				/* tp_as_sequence */
    0,				/* tp_as_mapping */
    (hashfunc)0,			/* tp_hash */
    (ternaryfunc)0,			/* tp_call */
    (reprfunc)0,			/* tp_str */
    (getattrofunc)0,		/* tp_getattro */
    (setattrofunc)0,		/* tp_setattro */
    0,				/* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /* tp_flags */
    NULL, /* Documentation string */
    (traverseproc)0,		/* tp_traverse */
    (inquiry)0,			/* tp_clear */
    (richcmpfunc)0,		/* tp_richcompare */
    0,				/* tp_weaklistoffset */
    (getiterfunc)0,			/* tp_iter */
    (iternextfunc)0,		/* tp_iternext */
    _PyGdkColor_methods,			/* tp_methods */
    0,				/* tp_members */
    0,				/* tp_getset */
    NULL,				/* tp_base */
    NULL,				/* tp_dict */
    (descrgetfunc)0,		/* tp_descr_get */
    (descrsetfunc)0,		/* tp_descr_set */
    0,				/* tp_dictoffset */
    (initproc)0,	/* tp_init */
};



/* ----------- GdkCursor ----------- */

#line 496 "gdk.override"
static int
_wrap_gdk_cursor_new(PyGBoxed *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist1[] = { "cursor_type", NULL };
    static char *kwlist2[] = { "source", "mask", "fg", "bg", "x", "y", NULL };
    PyObject *py_cursor_type;

    self->gtype = GDK_TYPE_CURSOR;
    self->free_on_dealloc = FALSE;
    self->boxed = NULL;
    if (PyArg_ParseTupleAndKeywords(args, kwargs, "O:GdkCursor.__init__",
				    kwlist1, &py_cursor_type)) {
	GdkCursorType cursor_type;

        if (pyg_enum_get_value(GDK_TYPE_CURSOR_TYPE, py_cursor_type,
			       (gint *)&cursor_type))
	    return -1;
	self->boxed = gdk_cursor_new(cursor_type);
	if (!self->boxed) {
	    PyErr_SetString(PyExc_RuntimeError,
			    "could not create GdkCursor object");
	    return -1;
	}
	self->free_on_dealloc = TRUE;
    } else {
	PyGObject *source, *mask;
	PyObject *fg, *bg;
	gint x, y;
	PyErr_Clear();

	if (!PyArg_ParseTupleAndKeywords(args, kwargs,
					 "OOOOii:GdkCursor.__init__", kwlist2,
					 &source, &mask, &fg, &bg, &x, &y))
	    return -1;
	if (!pygobject_check(source, &PyGdkPixmap_Type)) {
	    PyErr_SetString(PyExc_TypeError, "source should be a GdkPixmap");
	    return -1;
	}
	if (!pygobject_check(mask, &PyGdkPixmap_Type)) {
	    PyErr_SetString(PyExc_TypeError, "mask should be a GdkPixmap");
	    return -1;
	}
	if (!pyg_boxed_check(fg, GDK_TYPE_COLOR)) {
	    PyErr_SetString(PyExc_TypeError, "fg should be a GdkColor");
	    return -1;
	}
	if (!pyg_boxed_check(bg, GDK_TYPE_COLOR)) {
	    PyErr_SetString(PyExc_TypeError, "bg should be a GdkColor");
	    return -1;
	}
	self->boxed = gdk_cursor_new_from_pixmap(GDK_PIXMAP(source->obj),
						 GDK_PIXMAP(mask->obj),
						 pyg_boxed_get(fg, GdkColor),
						 pyg_boxed_get(bg, GdkColor),
						 x, y);
	if (!self->boxed) {
	    PyErr_SetString(PyExc_RuntimeError,
			    "could not create GdkCursor object");
	    return -1;
	}
	self->free_on_dealloc = TRUE;
    }
    return 0;
}
#line 728 "gdk.c"


static PyMethodDef _PyGdkCursor_methods[] = {
    { NULL, NULL, 0 }
};

static PyObject *
_wrap_gdk_cursor_getattr(PyObject *self, char *attr)
{
    if (!strcmp(attr, "__members__"))
        return Py_BuildValue("[s]", "type");
    if (!strcmp(attr, "type")) {
        return PyInt_FromLong(pyg_boxed_get(self, GdkCursor)->type);
    }
    PyErr_SetString(PyExc_AttributeError, attr);
    return NULL;
}

PyTypeObject PyGdkCursor_Type = {
    PyObject_HEAD_INIT(NULL)
    0,				/* ob_size */
    "GdkCursor",			/* tp_name */
    sizeof(PyGBoxed),		/* tp_basicsize */
    0,				/* tp_itemsize */
    /* methods */
    (destructor)0,			/* tp_dealloc */
    (printfunc)0,			/* tp_print */
    (getattrfunc)_wrap_gdk_cursor_getattr,	/* tp_getattr */
    (setattrfunc)0,			/* tp_setattr */
    (cmpfunc)0,			/* tp_compare */
    (reprfunc)0,			/* tp_repr */
    0,				/* tp_as_number */
    0,				/* tp_as_sequence */
    0,				/* tp_as_mapping */
    (hashfunc)0,			/* tp_hash */
    (ternaryfunc)0,			/* tp_call */
    (reprfunc)0,			/* tp_str */
    (getattrofunc)0,		/* tp_getattro */
    (setattrofunc)0,		/* tp_setattro */
    0,				/* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /* tp_flags */
    NULL, /* Documentation string */
    (traverseproc)0,		/* tp_traverse */
    (inquiry)0,			/* tp_clear */
    (richcmpfunc)0,		/* tp_richcompare */
    0,				/* tp_weaklistoffset */
    (getiterfunc)0,			/* tp_iter */
    (iternextfunc)0,		/* tp_iternext */
    _PyGdkCursor_methods,			/* tp_methods */
    0,				/* tp_members */
    0,				/* tp_getset */
    NULL,				/* tp_base */
    NULL,				/* tp_dict */
    (descrgetfunc)0,		/* tp_descr_get */
    (descrsetfunc)0,		/* tp_descr_set */
    0,				/* tp_dictoffset */
    (initproc)_wrap_gdk_cursor_new,	/* tp_init */
};



/* ----------- GdkRectangle ----------- */

static PyMethodDef _PyGdkRectangle_methods[] = {
    { NULL, NULL, 0 }
};

static PyObject *
_wrap_gdk_rectangle_getattr(PyObject *self, char *attr)
{
    if (!strcmp(attr, "__members__"))
        return Py_BuildValue("[ssss]", "x", "y", "width", "height");
    if (!strcmp(attr, "x")) {
        return PyInt_FromLong(pyg_boxed_get(self, GdkRectangle)->x);
    }
    if (!strcmp(attr, "y")) {
        return PyInt_FromLong(pyg_boxed_get(self, GdkRectangle)->y);
    }
    if (!strcmp(attr, "width")) {
        return PyInt_FromLong(pyg_boxed_get(self, GdkRectangle)->width);
    }
    if (!strcmp(attr, "height")) {
        return PyInt_FromLong(pyg_boxed_get(self, GdkRectangle)->height);
    }
    PyErr_SetString(PyExc_AttributeError, attr);
    return NULL;
}

PyTypeObject PyGdkRectangle_Type = {
    PyObject_HEAD_INIT(NULL)
    0,				/* ob_size */
    "GdkRectangle",			/* tp_name */
    sizeof(PyGBoxed),		/* tp_basicsize */
    0,				/* tp_itemsize */
    /* methods */
    (destructor)0,			/* tp_dealloc */
    (printfunc)0,			/* tp_print */
    (getattrfunc)_wrap_gdk_rectangle_getattr,	/* tp_getattr */
    (setattrfunc)0,			/* tp_setattr */
    (cmpfunc)0,			/* tp_compare */
    (reprfunc)0,			/* tp_repr */
    0,				/* tp_as_number */
    0,				/* tp_as_sequence */
    0,				/* tp_as_mapping */
    (hashfunc)0,			/* tp_hash */
    (ternaryfunc)0,			/* tp_call */
    (reprfunc)0,			/* tp_str */
    (getattrofunc)0,		/* tp_getattro */
    (setattrofunc)0,		/* tp_setattro */
    0,				/* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /* tp_flags */
    NULL, /* Documentation string */
    (traverseproc)0,		/* tp_traverse */
    (inquiry)0,			/* tp_clear */
    (richcmpfunc)0,		/* tp_richcompare */
    0,				/* tp_weaklistoffset */
    (getiterfunc)0,			/* tp_iter */
    (iternextfunc)0,		/* tp_iternext */
    _PyGdkRectangle_methods,			/* tp_methods */
    0,				/* tp_members */
    0,				/* tp_getset */
    NULL,				/* tp_base */
    NULL,				/* tp_dict */
    (descrgetfunc)0,		/* tp_descr_get */
    (descrsetfunc)0,		/* tp_descr_set */
    0,				/* tp_dictoffset */
    (initproc)0,	/* tp_init */
};



/* ----------- GdkColormap ----------- */

static int
_wrap_gdk_colormap_new(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *visual;
    static char *kwlist[] = { "visual", "allocate", NULL };
    int allocate;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "Oi:GdkColormap.__init__", kwlist, &visual, &allocate))
        return -1;
    if (!pygobject_check(visual, &PyGdkVisual_Type)) {
        PyErr_SetString(PyExc_TypeError, "visual should be a GdkVisual");
        return -1;
    }

    self->obj = (GObject *)gdk_colormap_new(GDK_VISUAL(visual->obj), allocate);
    if (!self->obj) {
        PyErr_SetString(PyExc_RuntimeError, "could not create GdkColormap object");
        return -1;
    }
    pygobject_register_wrapper((PyObject *)self);
    return 0;
}

static PyObject *
_wrap_gdk_colormap_change(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int ncolors;
    static char *kwlist[] = { "ncolors", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "i:GdkColormap.change", kwlist, &ncolors))
        return NULL;

    gdk_colormap_change(GDK_COLORMAP(self->obj), ncolors);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_colormap_alloc_color(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_color;
    static char *kwlist[] = { "color", "writeable", "best_match", NULL };
    int writeable, best_match;
    GdkColor *color = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "Oii:GdkColormap.alloc_color", kwlist, &py_color, &writeable, &best_match))
        return NULL;
    if (pyg_boxed_check(py_color, GDK_TYPE_COLOR))
        color = pyg_boxed_get(py_color, GdkColor);
    else {
        PyErr_SetString(PyExc_TypeError, "color should be a GdkColor");
        return NULL;
    }

    return PyInt_FromLong(gdk_colormap_alloc_color(GDK_COLORMAP(self->obj), color, writeable, best_match));
}

static PyObject *
_wrap_gdk_colormap_get_visual(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkColormap.get_visual", kwlist))
        return NULL;

    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)gdk_colormap_get_visual(GDK_COLORMAP(self->obj)));
}

static PyObject *
_wrap_gdk_color_white(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_color;
    static char *kwlist[] = { "color", NULL };
    GdkColor *color = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:GdkColormap.white", kwlist, &py_color))
        return NULL;
    if (pyg_boxed_check(py_color, GDK_TYPE_COLOR))
        color = pyg_boxed_get(py_color, GdkColor);
    else {
        PyErr_SetString(PyExc_TypeError, "color should be a GdkColor");
        return NULL;
    }

    return PyInt_FromLong(gdk_color_white(GDK_COLORMAP(self->obj), color));
}

static PyObject *
_wrap_gdk_color_black(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_color;
    static char *kwlist[] = { "color", NULL };
    GdkColor *color = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:GdkColormap.black", kwlist, &py_color))
        return NULL;
    if (pyg_boxed_check(py_color, GDK_TYPE_COLOR))
        color = pyg_boxed_get(py_color, GdkColor);
    else {
        PyErr_SetString(PyExc_TypeError, "color should be a GdkColor");
        return NULL;
    }

    return PyInt_FromLong(gdk_color_black(GDK_COLORMAP(self->obj), color));
}

static PyObject *
_wrap_gdk_color_alloc(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_color;
    static char *kwlist[] = { "color", NULL };
    GdkColor *color = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:GdkColormap.alloc", kwlist, &py_color))
        return NULL;
    if (pyg_boxed_check(py_color, GDK_TYPE_COLOR))
        color = pyg_boxed_get(py_color, GdkColor);
    else {
        PyErr_SetString(PyExc_TypeError, "color should be a GdkColor");
        return NULL;
    }

    return PyInt_FromLong(gdk_color_alloc(GDK_COLORMAP(self->obj), color));
}

static PyObject *
_wrap_gdk_color_change(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_color;
    static char *kwlist[] = { "color", NULL };
    GdkColor *color = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:GdkColormap.change", kwlist, &py_color))
        return NULL;
    if (pyg_boxed_check(py_color, GDK_TYPE_COLOR))
        color = pyg_boxed_get(py_color, GdkColor);
    else {
        PyErr_SetString(PyExc_TypeError, "color should be a GdkColor");
        return NULL;
    }

    return PyInt_FromLong(gdk_color_change(GDK_COLORMAP(self->obj), color));
}

static PyMethodDef _PyGdkColormap_methods[] = {
    { "change", (PyCFunction)_wrap_gdk_colormap_change, METH_VARARGS|METH_KEYWORDS },
    { "alloc_color", (PyCFunction)_wrap_gdk_colormap_alloc_color, METH_VARARGS|METH_KEYWORDS },
    { "get_visual", (PyCFunction)_wrap_gdk_colormap_get_visual, METH_VARARGS|METH_KEYWORDS },
    { "white", (PyCFunction)_wrap_gdk_color_white, METH_VARARGS|METH_KEYWORDS },
    { "black", (PyCFunction)_wrap_gdk_color_black, METH_VARARGS|METH_KEYWORDS },
    { "alloc", (PyCFunction)_wrap_gdk_color_alloc, METH_VARARGS|METH_KEYWORDS },
    { "change", (PyCFunction)_wrap_gdk_color_change, METH_VARARGS|METH_KEYWORDS },
    { NULL, NULL, 0 }
};

PyTypeObject PyGdkColormap_Type = {
    PyObject_HEAD_INIT(NULL)
    0,				/* ob_size */
    "Colormap",		/* tp_name */
    sizeof(PyGObject),		/* tp_basicsize */
    0,				/* tp_itemsize */
    /* methods */
    (destructor)0,			/* tp_dealloc */
    (printfunc)0,			/* tp_print */
    (getattrfunc)0,			/* tp_getattr */
    (setattrfunc)0,			/* tp_setattr */
    (cmpfunc)0,			/* tp_compare */
    (reprfunc)0,			/* tp_repr */
    0,				/* tp_as_number */
    0,				/* tp_as_sequence */
    0,				/* tp_as_mapping */
    (hashfunc)0,			/* tp_hash */
    (ternaryfunc)0,			/* tp_call */
    (reprfunc)0,			/* tp_str */
    (getattrofunc)0,		/* tp_getattro */
    (setattrofunc)0,		/* tp_setattro */
    0,				/* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /* tp_flags */
    NULL, /* Documentation string */
    (traverseproc)0,		/* tp_traverse */
    (inquiry)0,			/* tp_clear */
    (richcmpfunc)0,			/* tp_richcompare */
    offsetof(PyGObject, weakreflist), /* tp_weaklistoffset */
    (getiterfunc)0,			/* tp_iter */
    (iternextfunc)0,		/* tp_iternext */
    _PyGdkColormap_methods,			/* tp_methods */
    0,				/* tp_members */
    0,			/* tp_getset */
    NULL,				/* tp_base */
    NULL,				/* tp_dict */
    (descrgetfunc)0,		/* tp_descr_get */
    (descrsetfunc)0,		/* tp_descr_set */
    offsetof(PyGObject, inst_dict),	/* tp_dictoffset */
    (initproc)_wrap_gdk_colormap_new,		/* tp_init */
};



/* ----------- GdkDevice ----------- */

static int
pygobject_no_constructor(PyObject *self, PyObject *args, PyObject *kwargs)
{
    gchar buf[512];

    g_snprintf(buf, sizeof(buf), "%s is an abstract widget", self->ob_type->tp_name);
    PyErr_SetString(PyExc_NotImplementedError, buf);
    return -1;
}

static PyObject *
_wrap_gdk_device_set_source(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_source = NULL;
    static char *kwlist[] = { "source", NULL };
    GdkInputSource source;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:GdkDevice.set_source", kwlist, &py_source))
        return NULL;
    if (pyg_enum_get_value(GDK_TYPE_INPUT_SOURCE, py_source, (gint *)&source))
        return NULL;

    gdk_device_set_source(GDK_DEVICE(self->obj), source);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_device_set_mode(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_mode = NULL;
    static char *kwlist[] = { "mode", NULL };
    GdkInputMode mode;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:GdkDevice.set_mode", kwlist, &py_mode))
        return NULL;
    if (pyg_enum_get_value(GDK_TYPE_INPUT_MODE, py_mode, (gint *)&mode))
        return NULL;

    return PyInt_FromLong(gdk_device_set_mode(GDK_DEVICE(self->obj), mode));
}

static PyObject *
_wrap_gdk_device_set_key(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int index, keyval;
    static char *kwlist[] = { "index", "keyval", "modifiers", NULL };
    GdkModifierType modifiers;
    PyObject *py_modifiers = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "iiO:GdkDevice.set_key", kwlist, &index, &keyval, &py_modifiers))
        return NULL;
    if (pyg_flags_get_value(GDK_TYPE_MODIFIER_TYPE, py_modifiers, (gint *)&modifiers))
        return NULL;

    gdk_device_set_key(GDK_DEVICE(self->obj), index, keyval, modifiers);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_device_set_axis_use(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int index;
    static char *kwlist[] = { "index", "use", NULL };
    GdkAxisUse use;
    PyObject *py_use = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "iO:GdkDevice.set_axis_use", kwlist, &index, &py_use))
        return NULL;
    if (pyg_enum_get_value(GDK_TYPE_AXIS_USE, py_use, (gint *)&use))
        return NULL;

    gdk_device_set_axis_use(GDK_DEVICE(self->obj), index, use);
    Py_INCREF(Py_None);
    return Py_None;
}

#line 834 "gdk.override"
static PyObject *
_wrap_gdk_device_get_state(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "window", NULL };
    GdkDevice *device = GDK_DEVICE(self->obj);
    PyGObject *window;
    gdouble *axes;
    GdkModifierType mask;
    PyObject *py_axes;
    guint i;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:GdkDevice.get_state",
				     kwlist, &window))
	return NULL;
    if (!pygobject_check(window, &PyGdkWindow_Type)) {
	PyErr_SetString(PyExc_TypeError, "window should be a GdkWindow");
	return NULL;
    }
    axes = g_new0(gdouble, device->num_axes);
    gdk_device_get_state(device, GDK_WINDOW(window->obj), axes, &mask);
    py_axes = PyTuple_New(device->num_axes);
    for (i = 0; i < device->num_axes; i++)
	PyTuple_SetItem(py_axes, i, PyFloat_FromDouble(axes[i]));
    g_free(axes);
    return Py_BuildValue("(Ni)", py_axes, mask);
}
#line 1168 "gdk.c"


#line 864 "gdk.override"
static PyObject *
_wrap_gdk_device_get_history(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "window", "start", "stop", NULL };
    GdkDevice *device = GDK_DEVICE(self->obj);
    PyGObject *window;
    guint start, stop;
    GdkTimeCoord **events;
    gint n_events;
    PyObject *pyevents;
    guint i;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,
				     "Oii:GdkDevice.get_history", kwlist,
				     &window, &start, &stop))
	return NULL;
    if (!pygobject_check(window, &PyGdkWindow_Type)) {
	PyErr_SetString(PyExc_TypeError, "window should be a GdkWindow");
	return NULL;
    }
    gdk_device_get_history(device, GDK_WINDOW(window->obj), start, stop,
			   &events, &n_events);
    pyevents = PyTuple_New(n_events);
    for (i = 0; i < n_events; i++) {
	PyObject *axes;
	gint j;

	axes = PyTuple_New(device->num_axes);
	for (j = 0; j < device->num_axes; j++)
	    PyTuple_SetItem(axes, j, PyFloat_FromDouble(events[i]->axes[j]));
	PyTuple_SetItem(pyevents, i, Py_BuildValue("(iN)", events[i]->time,
						   axes));
    }
    gdk_device_free_history(events, n_events);
    return pyevents;
}
#line 1208 "gdk.c"


#line 902 "gdk.override"
static PyObject *
_wrap_gdk_device_get_axis(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "axes", "use", NULL };
    GdkDevice *device = GDK_DEVICE(self->obj);
    PyObject *py_axes;
    gdouble *axes, value;
    GdkAxisUse use;
    gboolean ret;
    gint i;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "Oi:GdkDevice.get_axis",
				     kwlist, &py_axes, &use))
	return NULL;
    if (!PySequence_Check(py_axes)) {
	PyErr_SetString(PyExc_TypeError, "axes must be a sequence");
	return NULL;
    }
    if (PySequence_Length(py_axes) != device->num_axes) {
	PyErr_SetString(PyExc_TypeError, "axes has the wrong length");
	return NULL;
    }
    axes = g_new(gdouble, device->num_axes);
    for (i = 0; i < device->num_axes; i++) {
	PyObject *item = PySequence_GetItem(py_axes, i);

	axes[i] = PyFloat_AsDouble(item);
	Py_DECREF(item);
	if (PyErr_Occurred()) {
	    g_free(axes);
	    return NULL;
       }
    }
    ret = gdk_device_get_axis(device, axes, use, &value);
    g_free(axes);
    if (ret)
	return PyFloat_FromDouble(value);
    Py_INCREF(Py_None);
    return Py_None;
}
#line 1252 "gdk.c"


static PyMethodDef _PyGdkDevice_methods[] = {
    { "set_source", (PyCFunction)_wrap_gdk_device_set_source, METH_VARARGS|METH_KEYWORDS },
    { "set_mode", (PyCFunction)_wrap_gdk_device_set_mode, METH_VARARGS|METH_KEYWORDS },
    { "set_key", (PyCFunction)_wrap_gdk_device_set_key, METH_VARARGS|METH_KEYWORDS },
    { "set_axis_use", (PyCFunction)_wrap_gdk_device_set_axis_use, METH_VARARGS|METH_KEYWORDS },
    { "get_state", (PyCFunction)_wrap_gdk_device_get_state, METH_VARARGS|METH_KEYWORDS },
    { "get_history", (PyCFunction)_wrap_gdk_device_get_history, METH_VARARGS|METH_KEYWORDS },
    { "get_axis", (PyCFunction)_wrap_gdk_device_get_axis, METH_VARARGS|METH_KEYWORDS },
    { NULL, NULL, 0 }
};

static PyObject *
_wrap_gdk_device__get_name(PyGObject *self, void *closure)
{
    gchar *ret;

    ret = GDK_DEVICE(self->obj)->name;
    if (ret) {
        PyObject *py_ret = PyString_FromString(ret);
        g_free(ret);
        return py_ret;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_device__get_source(PyGObject *self, void *closure)
{
    return PyInt_FromLong(GDK_DEVICE(self->obj)->source);
}

static PyObject *
_wrap_gdk_device__get_mode(PyGObject *self, void *closure)
{
    return PyInt_FromLong(GDK_DEVICE(self->obj)->mode);
}

static PyObject *
_wrap_gdk_device__get_has_cursor(PyGObject *self, void *closure)
{
    return PyInt_FromLong(GDK_DEVICE(self->obj)->has_cursor);
}

static PyObject *
_wrap_gdk_device__get_num_axes(PyGObject *self, void *closure)
{
    return PyInt_FromLong(GDK_DEVICE(self->obj)->num_axes);
}

#line 801 "gdk.override"
static PyObject *
_wrap_gdk_device__get_axes(PyGObject *self, void *closure)
{
    GdkDevice *device = GDK_DEVICE(self->obj);
    PyObject *ret;
    gint i;

    ret = PyTuple_New(device->num_axes);
    for (i = 0; i < device->num_axes; i++)
	PyTuple_SetItem(ret, i, Py_BuildValue("(idd)",
					      device->axes[i].use,
					      device->axes[i].min,
					      device->axes[i].max));
    return ret;
}
#line 1321 "gdk.c"
static PyObject *
_wrap_gdk_device__get_num_keys(PyGObject *self, void *closure)
{
    return PyInt_FromLong(GDK_DEVICE(self->obj)->num_keys);
}

#line 818 "gdk.override"
static PyObject *
_wrap_gdk_device__get_keys(PyGObject *self, void *closure)
{
    GdkDevice *device = GDK_DEVICE(self->obj);
    PyObject *ret;
    gint i;

    ret = PyTuple_New(device->num_keys);
    for (i = 0; i < device->num_keys; i++)
	PyTuple_SetItem(ret, i, Py_BuildValue("(ii)",
					      device->keys[i].keyval,
					      device->keys[i].modifiers));
    return ret;
}
#line 1343 "gdk.c"
static PyGetSetDef gdk_device_getsets[] = {
    { "name", (getter)_wrap_gdk_device__get_name, (setter)0 },
    { "source", (getter)_wrap_gdk_device__get_source, (setter)0 },
    { "mode", (getter)_wrap_gdk_device__get_mode, (setter)0 },
    { "has_cursor", (getter)_wrap_gdk_device__get_has_cursor, (setter)0 },
    { "num_axes", (getter)_wrap_gdk_device__get_num_axes, (setter)0 },
    { "axes", (getter)_wrap_gdk_device__get_axes, (setter)0 },
    { "num_keys", (getter)_wrap_gdk_device__get_num_keys, (setter)0 },
    { "keys", (getter)_wrap_gdk_device__get_keys, (setter)0 },
    { NULL, (getter)0, (setter)0 },
};

PyTypeObject PyGdkDevice_Type = {
    PyObject_HEAD_INIT(NULL)
    0,				/* ob_size */
    "Device",		/* tp_name */
    sizeof(PyGObject),		/* tp_basicsize */
    0,				/* tp_itemsize */
    /* methods */
    (destructor)0,			/* tp_dealloc */
    (printfunc)0,			/* tp_print */
    (getattrfunc)0,			/* tp_getattr */
    (setattrfunc)0,			/* tp_setattr */
    (cmpfunc)0,			/* tp_compare */
    (reprfunc)0,			/* tp_repr */
    0,				/* tp_as_number */
    0,				/* tp_as_sequence */
    0,				/* tp_as_mapping */
    (hashfunc)0,			/* tp_hash */
    (ternaryfunc)0,			/* tp_call */
    (reprfunc)0,			/* tp_str */
    (getattrofunc)0,		/* tp_getattro */
    (setattrofunc)0,		/* tp_setattro */
    0,				/* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /* tp_flags */
    NULL, /* Documentation string */
    (traverseproc)0,		/* tp_traverse */
    (inquiry)0,			/* tp_clear */
    (richcmpfunc)0,			/* tp_richcompare */
    offsetof(PyGObject, weakreflist), /* tp_weaklistoffset */
    (getiterfunc)0,			/* tp_iter */
    (iternextfunc)0,		/* tp_iternext */
    _PyGdkDevice_methods,			/* tp_methods */
    0,				/* tp_members */
    gdk_device_getsets,			/* tp_getset */
    NULL,				/* tp_base */
    NULL,				/* tp_dict */
    (descrgetfunc)0,		/* tp_descr_get */
    (descrsetfunc)0,		/* tp_descr_set */
    offsetof(PyGObject, inst_dict),	/* tp_dictoffset */
    (initproc)pygobject_no_constructor,		/* tp_init */
};



/* ----------- GdkDragContext ----------- */

static int
_wrap_gdk_drag_context_new(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkDragContext.__init__", kwlist))
        return -1;

    self->obj = (GObject *)gdk_drag_context_new();
    if (!self->obj) {
        PyErr_SetString(PyExc_RuntimeError, "could not create GdkDragContext object");
        return -1;
    }
    pygobject_register_wrapper((PyObject *)self);
    return 0;
}

static PyObject *
_wrap_gdk_drag_context_ref(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkDragContext.ref", kwlist))
        return NULL;

    gdk_drag_context_ref(GDK_DRAG_CONTEXT(self->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_drag_context_unref(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkDragContext.unref", kwlist))
        return NULL;

    gdk_drag_context_unref(GDK_DRAG_CONTEXT(self->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_drag_status(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_action = NULL;
    static char *kwlist[] = { "action", "time", NULL };
    int time;
    GdkDragAction action;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "Oi:GdkDragContext.drag_status", kwlist, &py_action, &time))
        return NULL;
    if (pyg_flags_get_value(GDK_TYPE_DRAG_ACTION, py_action, (gint *)&action))
        return NULL;

    gdk_drag_status(GDK_DRAG_CONTEXT(self->obj), action, time);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_drop_reply(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int ok, time;
    static char *kwlist[] = { "ok", "time", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "ii:GdkDragContext.drop_reply", kwlist, &ok, &time))
        return NULL;

    gdk_drop_reply(GDK_DRAG_CONTEXT(self->obj), ok, time);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_drop_finish(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int success, time;
    static char *kwlist[] = { "success", "time", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "ii:GdkDragContext.drop_finish", kwlist, &success, &time))
        return NULL;

    gdk_drop_finish(GDK_DRAG_CONTEXT(self->obj), success, time);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_drag_get_selection(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkDragContext.drag_get_selection", kwlist))
        return NULL;

    return PyGdkAtom_New(gdk_drag_get_selection(GDK_DRAG_CONTEXT(self->obj)));
}

#line 944 "gdk.override"
static PyObject *
_wrap_gdk_drag_find_window(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "drag_window", "x_root", "y_root", NULL };
    PyGObject *drag_window;
    gint x_root, y_root;
    GdkWindow *dest_window;
    GdkDragProtocol protocol;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,
				     "Oii:GdkDragContext.drag_find_window",
				     kwlist, &drag_window, &x_root, &y_root))
	return NULL;
    if (!pygobject_check(drag_window, &PyGdkWindow_Type)) {
	PyErr_SetString(PyExc_TypeError, "drag_window must be a GdkWindow");
	return NULL;
    }
    gdk_drag_find_window(GDK_DRAG_CONTEXT(self->obj),
			 GDK_WINDOW(drag_window->obj), x_root, y_root,
			 &dest_window, &protocol);
    return Py_BuildValue("(Ni)", pygobject_new((GObject *)dest_window),
			 protocol);
}
#line 1525 "gdk.c"


static PyObject *
_wrap_gdk_drag_motion(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_protocol = NULL, *py_suggested_action = NULL, *py_possible_actions = NULL;
    int x_root, y_root, time;
    GdkDragAction suggested_action, possible_actions;
    GdkDragProtocol protocol;
    PyGObject *dest_window;
    static char *kwlist[] = { "dest_window", "protocol", "x_root", "y_root", "suggested_action", "possible_actions", "time", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOiiOOi:GdkDragContext.drag_motion", kwlist, &dest_window, &py_protocol, &x_root, &y_root, &py_suggested_action, &py_possible_actions, &time))
        return NULL;
    if (!pygobject_check(dest_window, &PyGdkWindow_Type)) {
        PyErr_SetString(PyExc_TypeError, "dest_window should be a GdkWindow");
        return NULL;
    }
    if (pyg_enum_get_value(GDK_TYPE_DRAG_PROTOCOL, py_protocol, (gint *)&protocol))
        return NULL;
    if (pyg_flags_get_value(GDK_TYPE_DRAG_ACTION, py_suggested_action, (gint *)&suggested_action))
        return NULL;
    if (pyg_flags_get_value(GDK_TYPE_DRAG_ACTION, py_possible_actions, (gint *)&possible_actions))
        return NULL;

    return PyInt_FromLong(gdk_drag_motion(GDK_DRAG_CONTEXT(self->obj), GDK_WINDOW(dest_window->obj), protocol, x_root, y_root, suggested_action, possible_actions, time));
}

static PyObject *
_wrap_gdk_drag_drop(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int time;
    static char *kwlist[] = { "time", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "i:GdkDragContext.drag_drop", kwlist, &time))
        return NULL;

    gdk_drag_drop(GDK_DRAG_CONTEXT(self->obj), time);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_drag_abort(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int time;
    static char *kwlist[] = { "time", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "i:GdkDragContext.drag_abort", kwlist, &time))
        return NULL;

    gdk_drag_abort(GDK_DRAG_CONTEXT(self->obj), time);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_drag_finish(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int success, del, time = GDK_CURRENT_TIME;
    static char *kwlist[] = { "success", "del_", "time", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "ii|i:GdkDragContext.finish", kwlist, &success, &del, &time))
        return NULL;

    gtk_drag_finish(GDK_DRAG_CONTEXT(self->obj), success, del, time);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_drag_get_source_widget(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkDragContext.get_source_widget", kwlist))
        return NULL;

    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)gtk_drag_get_source_widget(GDK_DRAG_CONTEXT(self->obj)));
}

static PyObject *
_wrap_gtk_drag_set_icon_widget(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *widget;
    static char *kwlist[] = { "widget", "hot_x", "hot_y", NULL };
    int hot_x, hot_y;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "Oii:GdkDragContext.set_icon_widget", kwlist, &widget, &hot_x, &hot_y))
        return NULL;
    if (!pygobject_check(widget, &PyGtkWidget_Type)) {
        PyErr_SetString(PyExc_TypeError, "widget should be a GtkWidget");
        return NULL;
    }

    gtk_drag_set_icon_widget(GDK_DRAG_CONTEXT(self->obj), GTK_WIDGET(widget->obj), hot_x, hot_y);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_drag_set_icon_pixmap(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *colormap, *pixmap, *mask;
    static char *kwlist[] = { "colormap", "pixmap", "mask", "hot_x", "hot_y", NULL };
    int hot_x, hot_y;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOii:GdkDragContext.set_icon_pixmap", kwlist, &colormap, &pixmap, &mask, &hot_x, &hot_y))
        return NULL;
    if (!pygobject_check(colormap, &PyGdkColormap_Type)) {
        PyErr_SetString(PyExc_TypeError, "colormap should be a GdkColormap");
        return NULL;
    }
    if (!pygobject_check(pixmap, &PyGdkPixmap_Type)) {
        PyErr_SetString(PyExc_TypeError, "pixmap should be a GdkPixmap");
        return NULL;
    }
    if (!pygobject_check(mask, &PyGdkPixmap_Type)) {
        PyErr_SetString(PyExc_TypeError, "mask should be a GdkPixmap");
        return NULL;
    }

    gtk_drag_set_icon_pixmap(GDK_DRAG_CONTEXT(self->obj), GDK_COLORMAP(colormap->obj), GDK_PIXMAP(pixmap->obj), GDK_PIXMAP(mask->obj), hot_x, hot_y);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_drag_set_icon_default(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkDragContext.set_icon_default", kwlist))
        return NULL;

    gtk_drag_set_icon_default(GDK_DRAG_CONTEXT(self->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyMethodDef _PyGdkDragContext_methods[] = {
    { "ref", (PyCFunction)_wrap_gdk_drag_context_ref, METH_VARARGS|METH_KEYWORDS },
    { "unref", (PyCFunction)_wrap_gdk_drag_context_unref, METH_VARARGS|METH_KEYWORDS },
    { "drag_status", (PyCFunction)_wrap_gdk_drag_status, METH_VARARGS|METH_KEYWORDS },
    { "drop_reply", (PyCFunction)_wrap_gdk_drop_reply, METH_VARARGS|METH_KEYWORDS },
    { "drop_finish", (PyCFunction)_wrap_gdk_drop_finish, METH_VARARGS|METH_KEYWORDS },
    { "drag_get_selection", (PyCFunction)_wrap_gdk_drag_get_selection, METH_VARARGS|METH_KEYWORDS },
    { "drag_find_window", (PyCFunction)_wrap_gdk_drag_find_window, METH_VARARGS|METH_KEYWORDS },
    { "drag_motion", (PyCFunction)_wrap_gdk_drag_motion, METH_VARARGS|METH_KEYWORDS },
    { "drag_drop", (PyCFunction)_wrap_gdk_drag_drop, METH_VARARGS|METH_KEYWORDS },
    { "drag_abort", (PyCFunction)_wrap_gdk_drag_abort, METH_VARARGS|METH_KEYWORDS },
    { "finish", (PyCFunction)_wrap_gtk_drag_finish, METH_VARARGS|METH_KEYWORDS },
    { "get_source_widget", (PyCFunction)_wrap_gtk_drag_get_source_widget, METH_VARARGS|METH_KEYWORDS },
    { "set_icon_widget", (PyCFunction)_wrap_gtk_drag_set_icon_widget, METH_VARARGS|METH_KEYWORDS },
    { "set_icon_pixmap", (PyCFunction)_wrap_gtk_drag_set_icon_pixmap, METH_VARARGS|METH_KEYWORDS },
    { "set_icon_default", (PyCFunction)_wrap_gtk_drag_set_icon_default, METH_VARARGS|METH_KEYWORDS },
    { NULL, NULL, 0 }
};

static PyObject *
_wrap_gdk_drag_context__get_protocol(PyGObject *self, void *closure)
{
    return PyInt_FromLong(GDK_DRAG_CONTEXT(self->obj)->protocol);
}

static PyObject *
_wrap_gdk_drag_context__get_is_source(PyGObject *self, void *closure)
{
    return PyInt_FromLong(GDK_DRAG_CONTEXT(self->obj)->is_source);
}

static PyObject *
_wrap_gdk_drag_context__get_source_window(PyGObject *self, void *closure)
{
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)GDK_DRAG_CONTEXT(self->obj)->source_window);
}

static PyObject *
_wrap_gdk_drag_context__get_dest_window(PyGObject *self, void *closure)
{
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)GDK_DRAG_CONTEXT(self->obj)->dest_window);
}

#line 969 "gdk.override"
static PyObject *
_wrap_gdk_drag_context__get_targets(PyGObject *self, void *closure)
{
    PyObject *atom, *ret = PyList_New(0);
    GList *tmp;
    if (ret == NULL)
	return NULL;
    for (tmp = GDK_DRAG_CONTEXT(self->obj)->targets; tmp; tmp = tmp->next) {
	if ((atom = PyGdkAtom_New(GPOINTER_TO_INT(tmp->data))) == NULL) {
	    Py_DECREF(ret);
	    return NULL;
	}
	PyList_Append(ret, atom);
	Py_DECREF(atom);
    }
    return ret;
}
#line 1730 "gdk.c"
static PyObject *
_wrap_gdk_drag_context__get_actions(PyGObject *self, void *closure)
{
    return PyInt_FromLong(GDK_DRAG_CONTEXT(self->obj)->actions);
}

static PyObject *
_wrap_gdk_drag_context__get_suggested_action(PyGObject *self, void *closure)
{
    return PyInt_FromLong(GDK_DRAG_CONTEXT(self->obj)->suggested_action);
}

static PyObject *
_wrap_gdk_drag_context__get_action(PyGObject *self, void *closure)
{
    return PyInt_FromLong(GDK_DRAG_CONTEXT(self->obj)->action);
}

static PyObject *
_wrap_gdk_drag_context__get_start_time(PyGObject *self, void *closure)
{
    return PyInt_FromLong(GDK_DRAG_CONTEXT(self->obj)->start_time);
}

static PyGetSetDef gdk_drag_context_getsets[] = {
    { "protocol", (getter)_wrap_gdk_drag_context__get_protocol, (setter)0 },
    { "is_source", (getter)_wrap_gdk_drag_context__get_is_source, (setter)0 },
    { "source_window", (getter)_wrap_gdk_drag_context__get_source_window, (setter)0 },
    { "dest_window", (getter)_wrap_gdk_drag_context__get_dest_window, (setter)0 },
    { "targets", (getter)_wrap_gdk_drag_context__get_targets, (setter)0 },
    { "actions", (getter)_wrap_gdk_drag_context__get_actions, (setter)0 },
    { "suggested_action", (getter)_wrap_gdk_drag_context__get_suggested_action, (setter)0 },
    { "action", (getter)_wrap_gdk_drag_context__get_action, (setter)0 },
    { "start_time", (getter)_wrap_gdk_drag_context__get_start_time, (setter)0 },
    { NULL, (getter)0, (setter)0 },
};

PyTypeObject PyGdkDragContext_Type = {
    PyObject_HEAD_INIT(NULL)
    0,				/* ob_size */
    "DragContext",		/* tp_name */
    sizeof(PyGObject),		/* tp_basicsize */
    0,				/* tp_itemsize */
    /* methods */
    (destructor)0,			/* tp_dealloc */
    (printfunc)0,			/* tp_print */
    (getattrfunc)0,			/* tp_getattr */
    (setattrfunc)0,			/* tp_setattr */
    (cmpfunc)0,			/* tp_compare */
    (reprfunc)0,			/* tp_repr */
    0,				/* tp_as_number */
    0,				/* tp_as_sequence */
    0,				/* tp_as_mapping */
    (hashfunc)0,			/* tp_hash */
    (ternaryfunc)0,			/* tp_call */
    (reprfunc)0,			/* tp_str */
    (getattrofunc)0,		/* tp_getattro */
    (setattrofunc)0,		/* tp_setattro */
    0,				/* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /* tp_flags */
    NULL, /* Documentation string */
    (traverseproc)0,		/* tp_traverse */
    (inquiry)0,			/* tp_clear */
    (richcmpfunc)0,			/* tp_richcompare */
    offsetof(PyGObject, weakreflist), /* tp_weaklistoffset */
    (getiterfunc)0,			/* tp_iter */
    (iternextfunc)0,		/* tp_iternext */
    _PyGdkDragContext_methods,			/* tp_methods */
    0,				/* tp_members */
    gdk_drag_context_getsets,			/* tp_getset */
    NULL,				/* tp_base */
    NULL,				/* tp_dict */
    (descrgetfunc)0,		/* tp_descr_get */
    (descrsetfunc)0,		/* tp_descr_set */
    offsetof(PyGObject, inst_dict),	/* tp_dictoffset */
    (initproc)_wrap_gdk_drag_context_new,		/* tp_init */
};



/* ----------- GdkDrawable ----------- */

#line 1116 "gdk.override"
static PyObject *
_wrap_gdk_drawable_get_size(PyGObject *self, PyObject *args)
{
    gint width;
    gint height;

    if (!PyArg_ParseTuple(args, ":GdkDrawable.get_size"))
	return NULL;
    gdk_drawable_get_size(GDK_DRAWABLE(self->obj), &width, &height);
    return Py_BuildValue("(ii)", width, height);
}
#line 1825 "gdk.c"


static PyObject *
_wrap_gdk_drawable_set_colormap(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *colormap;
    static char *kwlist[] = { "colormap", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:GdkDrawable.set_colormap", kwlist, &colormap))
        return NULL;
    if (!pygobject_check(colormap, &PyGdkColormap_Type)) {
        PyErr_SetString(PyExc_TypeError, "colormap should be a GdkColormap");
        return NULL;
    }

    gdk_drawable_set_colormap(GDK_DRAWABLE(self->obj), GDK_COLORMAP(colormap->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_drawable_get_colormap(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkDrawable.get_colormap", kwlist))
        return NULL;

    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)gdk_drawable_get_colormap(GDK_DRAWABLE(self->obj)));
}

static PyObject *
_wrap_gdk_drawable_get_visual(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkDrawable.get_visual", kwlist))
        return NULL;

    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)gdk_drawable_get_visual(GDK_DRAWABLE(self->obj)));
}

static PyObject *
_wrap_gdk_drawable_get_depth(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkDrawable.get_depth", kwlist))
        return NULL;

    return PyInt_FromLong(gdk_drawable_get_depth(GDK_DRAWABLE(self->obj)));
}

static PyObject *
_wrap_gdk_drawable_ref(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkDrawable.ref", kwlist))
        return NULL;

    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)gdk_drawable_ref(GDK_DRAWABLE(self->obj)));
}

static PyObject *
_wrap_gdk_drawable_unref(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkDrawable.unref", kwlist))
        return NULL;

    gdk_drawable_unref(GDK_DRAWABLE(self->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_draw_point(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *gc;
    static char *kwlist[] = { "gc", "x", "y", NULL };
    int x, y;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "Oii:GdkDrawable.draw_point", kwlist, &gc, &x, &y))
        return NULL;
    if (!pygobject_check(gc, &PyGdkGC_Type)) {
        PyErr_SetString(PyExc_TypeError, "gc should be a GdkGC");
        return NULL;
    }

    gdk_draw_point(GDK_DRAWABLE(self->obj), GDK_GC(gc->obj), x, y);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_draw_line(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *gc;
    static char *kwlist[] = { "gc", "x1", "y1", "x2", "y2", NULL };
    int x1, y1, x2, y2;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "Oiiii:GdkDrawable.draw_line", kwlist, &gc, &x1, &y1, &x2, &y2))
        return NULL;
    if (!pygobject_check(gc, &PyGdkGC_Type)) {
        PyErr_SetString(PyExc_TypeError, "gc should be a GdkGC");
        return NULL;
    }

    gdk_draw_line(GDK_DRAWABLE(self->obj), GDK_GC(gc->obj), x1, y1, x2, y2);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_draw_rectangle(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *gc;
    static char *kwlist[] = { "gc", "filled", "x", "y", "width", "height", NULL };
    int filled, x, y, width, height;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "Oiiiii:GdkDrawable.draw_rectangle", kwlist, &gc, &filled, &x, &y, &width, &height))
        return NULL;
    if (!pygobject_check(gc, &PyGdkGC_Type)) {
        PyErr_SetString(PyExc_TypeError, "gc should be a GdkGC");
        return NULL;
    }

    gdk_draw_rectangle(GDK_DRAWABLE(self->obj), GDK_GC(gc->obj), filled, x, y, width, height);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_draw_arc(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *gc;
    static char *kwlist[] = { "gc", "filled", "x", "y", "width", "height", "angle1", "angle2", NULL };
    int filled, x, y, width, height, angle1, angle2;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "Oiiiiiii:GdkDrawable.draw_arc", kwlist, &gc, &filled, &x, &y, &width, &height, &angle1, &angle2))
        return NULL;
    if (!pygobject_check(gc, &PyGdkGC_Type)) {
        PyErr_SetString(PyExc_TypeError, "gc should be a GdkGC");
        return NULL;
    }

    gdk_draw_arc(GDK_DRAWABLE(self->obj), GDK_GC(gc->obj), filled, x, y, width, height, angle1, angle2);
    Py_INCREF(Py_None);
    return Py_None;
}

#line 22 "gdk.override"
static PyObject *
_wrap_gdk_draw_polygon(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "gc", "filled", "points", NULL };
    PyGObject *gc;
    PyObject *py_points;
    gint filled, npoints, i;
    GdkPoint *points;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,
				     "OiO:GdkDrawable.draw_polygon",
				     kwlist, &gc, &filled, &py_points))
	return NULL;
    if (!pygobject_check(gc, &PyGdkGC_Type)) {
	PyErr_SetString(PyExc_TypeError, "gc must be a GdkGC");
	return NULL;
    }
    if (!PySequence_Check(py_points)) {
	PyErr_SetString(PyExc_TypeError, "points must be a sequence");
	return NULL;
    }
    npoints = PySequence_Length(py_points);
    points = g_new(GdkPoint, npoints);
    for (i = 0; i < npoints; i++) {
	PyObject *item = PySequence_GetItem(py_points, i);
	Py_DECREF(item);
	if (!PyArg_ParseTuple(item, "hh", &points[i].x, &points[i].y)) {
	    PyErr_Clear();
	    PyErr_SetString(PyExc_TypeError,
			    "sequence members must be 2-tuples");
	    g_free(points);
	    return NULL;
	}
    }
    gdk_draw_polygon(GDK_DRAWABLE(self->obj), GDK_GC(gc->obj), filled,
		     points, npoints);
    g_free(points);
    Py_INCREF(Py_None);
    return Py_None;
}
#line 2023 "gdk.c"


static PyObject *
_wrap_gdk_draw_string(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    GdkFont *font = NULL;
    char *string;
    PyGObject *gc;
    int x, y;
    static char *kwlist[] = { "font", "gc", "x", "y", "string", NULL };
    PyObject *py_font;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOiis:GdkDrawable.draw_string", kwlist, &py_font, &gc, &x, &y, &string))
        return NULL;
    if (pyg_boxed_check(py_font, GDK_TYPE_FONT))
        font = pyg_boxed_get(py_font, GdkFont);
    else {
        PyErr_SetString(PyExc_TypeError, "font should be a GdkFont");
        return NULL;
    }
    if (!pygobject_check(gc, &PyGdkGC_Type)) {
        PyErr_SetString(PyExc_TypeError, "gc should be a GdkGC");
        return NULL;
    }

    gdk_draw_string(GDK_DRAWABLE(self->obj), font, GDK_GC(gc->obj), x, y, string);
    Py_INCREF(Py_None);
    return Py_None;
}

#line 64 "gdk.override"
static PyObject *
_wrap_gdk_draw_text(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "font", "gc", "x", "y", "text",NULL};
    PyGObject *gc;
    PyObject *font;
    int x, y, len;
    char *text;
    if (!PyArg_ParseTupleAndKeywords(args, kwargs,
				     "OOiis#:GdkDrawable.draw_text",
				     kwlist,  &font,
				     &gc, &x, &y, &text, &len))
	return NULL;
    if (!pyg_boxed_check(font, GDK_TYPE_FONT)) {
	PyErr_SetString(PyExc_TypeError, "font must be a GdkFont");
	return NULL;
    }
    if (!pygobject_check(gc, &PyGdkGC_Type)) {
	PyErr_SetString(PyExc_TypeError, "gc must be a GdkGC");
	return NULL;
    }
    gdk_draw_text(GDK_DRAWABLE(self->obj), pyg_boxed_get(font, GdkFont),
		  GDK_GC(gc->obj), x, y, text, len);
    Py_INCREF(Py_None);
    return Py_None;
}
#line 2081 "gdk.c"


static PyObject *
_wrap_gdk_draw_drawable(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *gc, *src;
    static char *kwlist[] = { "gc", "src", "xsrc", "ysrc", "xdest", "ydest", "width", "height", NULL };
    int xsrc, ysrc, xdest, ydest, width, height;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOiiiiii:GdkDrawable.draw_drawable", kwlist, &gc, &src, &xsrc, &ysrc, &xdest, &ydest, &width, &height))
        return NULL;
    if (!pygobject_check(gc, &PyGdkGC_Type)) {
        PyErr_SetString(PyExc_TypeError, "gc should be a GdkGC");
        return NULL;
    }
    if (!pygobject_check(src, &PyGdkDrawable_Type)) {
        PyErr_SetString(PyExc_TypeError, "src should be a GdkDrawable");
        return NULL;
    }

    gdk_draw_drawable(GDK_DRAWABLE(self->obj), GDK_GC(gc->obj), GDK_DRAWABLE(src->obj), xsrc, ysrc, xdest, ydest, width, height);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_draw_image(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *gc, *image;
    static char *kwlist[] = { "gc", "image", "xsrc", "ysrc", "xdest", "ydest", "width", "height", NULL };
    int xsrc, ysrc, xdest, ydest, width, height;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOiiiiii:GdkDrawable.draw_image", kwlist, &gc, &image, &xsrc, &ysrc, &xdest, &ydest, &width, &height))
        return NULL;
    if (!pygobject_check(gc, &PyGdkGC_Type)) {
        PyErr_SetString(PyExc_TypeError, "gc should be a GdkGC");
        return NULL;
    }
    if (!pygobject_check(image, &PyGdkImage_Type)) {
        PyErr_SetString(PyExc_TypeError, "image should be a GdkImage");
        return NULL;
    }

    gdk_draw_image(GDK_DRAWABLE(self->obj), GDK_GC(gc->obj), GDK_IMAGE(image->obj), xsrc, ysrc, xdest, ydest, width, height);
    Py_INCREF(Py_None);
    return Py_None;
}

#line 92 "gdk.override"
static PyObject *
_wrap_gdk_draw_points(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "gc", "points", NULL };
    PyGObject *gc;
    PyObject *py_points;
    gint npoints, i;
    GdkPoint *points;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,
				     "OO:GdkDrawable.draw_points",
				     kwlist, &gc, &py_points))
	return NULL;
    if (!pygobject_check(gc, &PyGdkGC_Type)) {
	PyErr_SetString(PyExc_TypeError, "gc must be a GdkGC");
	return NULL;
    }
    if (!PySequence_Check(py_points)) {
	PyErr_SetString(PyExc_TypeError, "points must be a sequence");
	return NULL;
    }
    npoints = PySequence_Length(py_points);
    points = g_new(GdkPoint, npoints);
    for (i = 0; i < npoints; i++) {
	PyObject *item = PySequence_GetItem(py_points, i);
	Py_DECREF(item);
	if (!PyArg_ParseTuple(item, "hh", &points[i].x, &points[i].y)) {
	    PyErr_Clear();
	    PyErr_SetString(PyExc_TypeError,
			    "sequence members must be 2-tuples");
	    g_free(points);
	    return NULL;
	}
    }
    gdk_draw_points(GDK_DRAWABLE(self->obj), GDK_GC(gc->obj), points, npoints);
    g_free(points);
    Py_INCREF(Py_None);
    return Py_None;
}
#line 2170 "gdk.c"


#line 133 "gdk.override"
static PyObject *
_wrap_gdk_draw_segments(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "gc", "segs", NULL };
    PyGObject *gc;
    PyObject *py_segs;
    gint nsegs, i;
    GdkSegment *segs;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,
				     "OO:GdkDrawable.draw_segments",
				     kwlist, &gc, &py_segs))
	return NULL;
    if (!pygobject_check(gc, &PyGdkGC_Type)) {
	PyErr_SetString(PyExc_TypeError, "gc must be a GdkGC");
	return NULL;
    }
    if (!PySequence_Check(py_segs)) {
	PyErr_SetString(PyExc_TypeError, "segs must be a sequence");
	return NULL;
    }
    nsegs = PySequence_Length(py_segs);
    segs = g_new(GdkSegment, nsegs);
    for (i = 0; i < nsegs; i++) {
	PyObject *item = PySequence_GetItem(py_segs, i);
	Py_DECREF(item);
	if (!PyArg_ParseTuple(item, "hhhh", &segs[i].x1, &segs[i].y1,
			      &segs[i].x2, &segs[i].y2)) {
	    PyErr_Clear();
	    PyErr_SetString(PyExc_TypeError,
			    "sequence members must be 4-tuples");
	    g_free(segs);
	    return NULL;
	}
    }
    gdk_draw_segments(GDK_DRAWABLE(self->obj), GDK_GC(gc->obj), segs, nsegs);
    g_free(segs);
    Py_INCREF(Py_None);
    return Py_None;
}
#line 2214 "gdk.c"


#line 175 "gdk.override"
static PyObject *
_wrap_gdk_draw_lines(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "gc", "points", NULL };
    PyGObject *gc;
    PyObject *py_points;
    gint npoints, i;
    GdkPoint *points;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:GdkDrawable.draw_lines",
				     kwlist, &gc, &py_points))
	return NULL;
    if (!pygobject_check(gc, &PyGdkGC_Type)) {
	PyErr_SetString(PyExc_TypeError, "gc must be a GdkGC");
	return NULL;
    }
    if (!PySequence_Check(py_points)) {
	PyErr_SetString(PyExc_TypeError, "points must be a sequence");
	return NULL;
    }
    npoints = PySequence_Length(py_points);
    points = g_new(GdkPoint, npoints);
    for (i = 0; i < npoints; i++) {
	PyObject *item = PySequence_GetItem(py_points, i);
	Py_DECREF(item);
	if (!PyArg_ParseTuple(item, "hh", &points[i].x, &points[i].y)) {
	    PyErr_Clear();
	    PyErr_SetString(PyExc_TypeError,
			    "sequence members must be 2-tuples");
	    g_free(points);
	    return NULL;
	}
    }
    gdk_draw_lines(GDK_DRAWABLE(self->obj), GDK_GC(gc->obj), points, npoints);
    g_free(points);
    Py_INCREF(Py_None);
    return Py_None;
}
#line 2256 "gdk.c"


static PyObject *
_wrap_gdk_draw_glyphs(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *gc, *font;
    static char *kwlist[] = { "gc", "font", "x", "y", "glyphs", NULL };
    int x, y;
    PangoGlyphString *glyphs = NULL;
    PyObject *py_glyphs;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOiiO:GdkDrawable.draw_glyphs", kwlist, &gc, &font, &x, &y, &py_glyphs))
        return NULL;
    if (!pygobject_check(gc, &PyGdkGC_Type)) {
        PyErr_SetString(PyExc_TypeError, "gc should be a GdkGC");
        return NULL;
    }
    if (!pygobject_check(font, &PyPangoFont_Type)) {
        PyErr_SetString(PyExc_TypeError, "font should be a PangoFont");
        return NULL;
    }
    if (pyg_boxed_check(py_glyphs, PANGO_TYPE_GLYPH_STRING))
        glyphs = pyg_boxed_get(py_glyphs, PangoGlyphString);
    else {
        PyErr_SetString(PyExc_TypeError, "glyphs should be a PangoGlyphString");
        return NULL;
    }

    gdk_draw_glyphs(GDK_DRAWABLE(self->obj), GDK_GC(gc->obj), PANGO_FONT(font->obj), x, y, glyphs);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_draw_layout(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *gc, *layout;
    static char *kwlist[] = { "gc", "x", "y", "layout", NULL };
    int x, y;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiiO:GdkDrawable.draw_layout", kwlist, &gc, &x, &y, &layout))
        return NULL;
    if (!pygobject_check(gc, &PyGdkGC_Type)) {
        PyErr_SetString(PyExc_TypeError, "gc should be a GdkGC");
        return NULL;
    }
    if (!pygobject_check(layout, &PyPangoLayout_Type)) {
        PyErr_SetString(PyExc_TypeError, "layout should be a PangoLayout");
        return NULL;
    }

    gdk_draw_layout(GDK_DRAWABLE(self->obj), GDK_GC(gc->obj), x, y, PANGO_LAYOUT(layout->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

#line 988 "gdk.override"
static PyObject *
_wrap_gdk_gc_new_with_values(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "foreground", "background", "font", "function",
			      "fill", "tile", "stipple", "clip_mask",
			      "subwindow_mode", "ts_x_origin", "ts_y_origin",
			      "clip_x_origin", "clip_y_origin",
			      "graphics_exposures", "line_width", "line_style",
			      "cap_style", "join_style", NULL };
    PyObject *foreground = Py_None, *background = Py_None;
    PyObject *font = Py_None;
    gint function = -1, fill = -1;
    PyObject *tile = Py_None, *stipple = Py_None, *clip_mask = Py_None;
    gint subwindow_mode = -1, ts_x_origin = -1, ts_y_origin = -1;
    gint clip_x_origin = -1, clip_y_origin = -1, graphics_exposures = -1;
    gint line_width = -1, line_style = -1, cap_style = -1, join_style = -1;
    GdkGCValues values;
    GdkGCValuesMask mask = 0;
    GdkGC *gc;
    PyObject *pygc;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,
				     "|OOOiiOOOiiiiiiiiii:GdkDrawable.new_gc",
				     kwlist, &foreground, &background, &font,
				     &function, &fill, &tile, &stipple,
				     &clip_mask, &subwindow_mode,
				     &ts_x_origin, &ts_y_origin,
				     &clip_x_origin, &clip_y_origin,
				     &graphics_exposures, &line_width,
				     &line_style, &cap_style, &join_style))
	return NULL;
    if (pyg_boxed_check(foreground, GDK_TYPE_COLOR)) {
	mask |= GDK_GC_FOREGROUND;
	values.foreground = *pyg_boxed_get(foreground, GdkColor);
    } else if (foreground != Py_None) {
	PyErr_SetString(PyExc_TypeError, "foreground must be a GdkColor");
	return NULL;
    }
    if (pyg_boxed_check(background, GDK_TYPE_COLOR)) {
	mask |= GDK_GC_BACKGROUND;
	values.background = *pyg_boxed_get(background, GdkColor);
    } else if (background != Py_None) {
	PyErr_SetString(PyExc_TypeError, "background must be a GdkColor");
	return NULL;
    }
    if (pyg_boxed_check(font, GDK_TYPE_FONT)) {
	mask |= GDK_GC_FONT;
	values.font = pyg_boxed_get(font, GdkFont);
    } else if (font != Py_None) {
	PyErr_SetString(PyExc_TypeError, "font must be a GdkFont");
	return NULL;
    }
    if (function != -1) {
	mask |= GDK_GC_FUNCTION;
	values.function = function;
    }
    if (fill != -1) {
	mask |= GDK_GC_FILL;
	values.fill = fill;
    }
    if (pygobject_check(tile, &PyGdkPixmap_Type)) {
	mask |= GDK_GC_TILE;
	values.tile = GDK_PIXMAP(pygobject_get(tile));
    } else if (tile != Py_None) {
	PyErr_SetString(PyExc_TypeError, "tile must be a GdkPixmap");
	return NULL;
    }
    if (pygobject_check(stipple, &PyGdkPixmap_Type)) {
	mask |= GDK_GC_STIPPLE;
	values.stipple = GDK_PIXMAP(pygobject_get(stipple));
    } else if (stipple != Py_None) {
	PyErr_SetString(PyExc_TypeError, "stipple must be a GdkPixmap");
	return NULL;
    }
    if (pygobject_check(clip_mask, &PyGdkPixmap_Type)) {
	mask |= GDK_GC_CLIP_MASK;
	values.clip_mask = GDK_PIXMAP(pygobject_get(clip_mask));
    } else if (clip_mask != Py_None) {
	PyErr_SetString(PyExc_TypeError, "clip_mask must be a GdkPixmap");
	return NULL;
    }
    if (subwindow_mode != -1) {
	mask |= GDK_GC_SUBWINDOW;
	values.subwindow_mode = subwindow_mode;
    }
    if (ts_x_origin != -1) {
	mask |= GDK_GC_TS_X_ORIGIN;
	values.ts_x_origin = ts_x_origin;
    }
    if (ts_y_origin != -1) {
	mask |= GDK_GC_TS_Y_ORIGIN;
	values.ts_y_origin = ts_y_origin;
    }
    if (clip_x_origin != -1) {
	mask |= GDK_GC_CLIP_X_ORIGIN;
	values.clip_x_origin = clip_x_origin;
    }
    if (clip_y_origin != -1) {
	mask |= GDK_GC_CLIP_Y_ORIGIN;
	values.clip_y_origin = clip_y_origin;
    }
    if (graphics_exposures != -1) {
	mask |= GDK_GC_EXPOSURES;
	values.graphics_exposures = graphics_exposures;
    }
    if (line_width != -1) {
	mask |= GDK_GC_LINE_WIDTH;
	values.line_width = line_width;
    }
    if (line_style != -1) {
	mask |= GDK_GC_LINE_STYLE;
	values.line_style = line_style;
    }
    if (cap_style != -1) {
	mask |= GDK_GC_CAP_STYLE;
	values.cap_style = cap_style;
    }
    if (join_style != -1) {
	mask |= GDK_GC_JOIN_STYLE;
	values.join_style = join_style;
    }
    gc = gdk_gc_new_with_values(GDK_DRAWABLE(self->obj), &values, mask);
    pygc = pygobject_new((GObject *)gc);
    gdk_gc_unref(gc);
    return pygc;
}
#line 2440 "gdk.c"


static PyObject *
_wrap_gdk_image_get(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int x, y, width, height;
    static char *kwlist[] = { "x", "y", "width", "height", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "iiii:GdkDrawable.image_get", kwlist, &x, &y, &width, &height))
        return NULL;

    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)gdk_image_get(GDK_DRAWABLE(self->obj), x, y, width, height));
}

static PyObject *
_wrap_gdk_draw_rgb_image(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_dith = NULL;
    int x, y, width, height, rgb_buf_len, rowstride;
    guchar *rgb_buf;
    GdkRgbDither dith;
    PyGObject *gc;
    static char *kwlist[] = { "gc", "x", "y", "width", "height", "dith", "rgb_buf", "rowstride", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiiiiOs#i:GdkDrawable.draw_rgb_image", kwlist, &gc, &x, &y, &width, &height, &py_dith, &rgb_buf, &rgb_buf_len, &rowstride))
        return NULL;
    if (!pygobject_check(gc, &PyGdkGC_Type)) {
        PyErr_SetString(PyExc_TypeError, "gc should be a GdkGC");
        return NULL;
    }
    if (pyg_enum_get_value(GDK_TYPE_RGB_DITHER, py_dith, (gint *)&dith))
        return NULL;

    gdk_draw_rgb_image(GDK_DRAWABLE(self->obj), GDK_GC(gc->obj), x, y, width, height, dith, rgb_buf, rowstride);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_draw_rgb_image_dithalign(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_dith = NULL;
    int x, y, width, height, rgb_buf_len, rowstride, xdith, ydith;
    guchar *rgb_buf;
    GdkRgbDither dith;
    PyGObject *gc;
    static char *kwlist[] = { "gc", "x", "y", "width", "height", "dith", "rgb_buf", "rowstride", "xdith", "ydith", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiiiiOs#iii:GdkDrawable.draw_rgb_image_dithalign", kwlist, &gc, &x, &y, &width, &height, &py_dith, &rgb_buf, &rgb_buf_len, &rowstride, &xdith, &ydith))
        return NULL;
    if (!pygobject_check(gc, &PyGdkGC_Type)) {
        PyErr_SetString(PyExc_TypeError, "gc should be a GdkGC");
        return NULL;
    }
    if (pyg_enum_get_value(GDK_TYPE_RGB_DITHER, py_dith, (gint *)&dith))
        return NULL;

    gdk_draw_rgb_image_dithalign(GDK_DRAWABLE(self->obj), GDK_GC(gc->obj), x, y, width, height, dith, rgb_buf, rowstride, xdith, ydith);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_draw_rgb_32_image(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_dith = NULL;
    int x, y, width, height, buf_len, rowstride;
    guchar *buf;
    GdkRgbDither dith;
    PyGObject *gc;
    static char *kwlist[] = { "gc", "x", "y", "width", "height", "dith", "buf", "rowstride", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiiiiOs#i:GdkDrawable.draw_rgb_32_image", kwlist, &gc, &x, &y, &width, &height, &py_dith, &buf, &buf_len, &rowstride))
        return NULL;
    if (!pygobject_check(gc, &PyGdkGC_Type)) {
        PyErr_SetString(PyExc_TypeError, "gc should be a GdkGC");
        return NULL;
    }
    if (pyg_enum_get_value(GDK_TYPE_RGB_DITHER, py_dith, (gint *)&dith))
        return NULL;

    gdk_draw_rgb_32_image(GDK_DRAWABLE(self->obj), GDK_GC(gc->obj), x, y, width, height, dith, buf, rowstride);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_draw_gray_image(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_dith = NULL;
    int x, y, width, height, buf_len, rowstride;
    guchar *buf;
    GdkRgbDither dith;
    PyGObject *gc;
    static char *kwlist[] = { "gc", "x", "y", "width", "height", "dith", "buf", "rowstride", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiiiiOs#i:GdkDrawable.draw_gray_image", kwlist, &gc, &x, &y, &width, &height, &py_dith, &buf, &buf_len, &rowstride))
        return NULL;
    if (!pygobject_check(gc, &PyGdkGC_Type)) {
        PyErr_SetString(PyExc_TypeError, "gc should be a GdkGC");
        return NULL;
    }
    if (pyg_enum_get_value(GDK_TYPE_RGB_DITHER, py_dith, (gint *)&dith))
        return NULL;

    gdk_draw_gray_image(GDK_DRAWABLE(self->obj), GDK_GC(gc->obj), x, y, width, height, dith, buf, rowstride);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyMethodDef _PyGdkDrawable_methods[] = {
    { "get_size", (PyCFunction)_wrap_gdk_drawable_get_size, METH_VARARGS },
    { "set_colormap", (PyCFunction)_wrap_gdk_drawable_set_colormap, METH_VARARGS|METH_KEYWORDS },
    { "get_colormap", (PyCFunction)_wrap_gdk_drawable_get_colormap, METH_VARARGS|METH_KEYWORDS },
    { "get_visual", (PyCFunction)_wrap_gdk_drawable_get_visual, METH_VARARGS|METH_KEYWORDS },
    { "get_depth", (PyCFunction)_wrap_gdk_drawable_get_depth, METH_VARARGS|METH_KEYWORDS },
    { "ref", (PyCFunction)_wrap_gdk_drawable_ref, METH_VARARGS|METH_KEYWORDS },
    { "unref", (PyCFunction)_wrap_gdk_drawable_unref, METH_VARARGS|METH_KEYWORDS },
    { "draw_point", (PyCFunction)_wrap_gdk_draw_point, METH_VARARGS|METH_KEYWORDS },
    { "draw_line", (PyCFunction)_wrap_gdk_draw_line, METH_VARARGS|METH_KEYWORDS },
    { "draw_rectangle", (PyCFunction)_wrap_gdk_draw_rectangle, METH_VARARGS|METH_KEYWORDS },
    { "draw_arc", (PyCFunction)_wrap_gdk_draw_arc, METH_VARARGS|METH_KEYWORDS },
    { "draw_polygon", (PyCFunction)_wrap_gdk_draw_polygon, METH_VARARGS|METH_KEYWORDS },
    { "draw_string", (PyCFunction)_wrap_gdk_draw_string, METH_VARARGS|METH_KEYWORDS },
    { "draw_text", (PyCFunction)_wrap_gdk_draw_text, METH_VARARGS|METH_KEYWORDS },
    { "draw_drawable", (PyCFunction)_wrap_gdk_draw_drawable, METH_VARARGS|METH_KEYWORDS },
    { "draw_image", (PyCFunction)_wrap_gdk_draw_image, METH_VARARGS|METH_KEYWORDS },
    { "draw_points", (PyCFunction)_wrap_gdk_draw_points, METH_VARARGS|METH_KEYWORDS },
    { "draw_segments", (PyCFunction)_wrap_gdk_draw_segments, METH_VARARGS|METH_KEYWORDS },
    { "draw_lines", (PyCFunction)_wrap_gdk_draw_lines, METH_VARARGS|METH_KEYWORDS },
    { "draw_glyphs", (PyCFunction)_wrap_gdk_draw_glyphs, METH_VARARGS|METH_KEYWORDS },
    { "draw_layout", (PyCFunction)_wrap_gdk_draw_layout, METH_VARARGS|METH_KEYWORDS },
    { "new_gc", (PyCFunction)_wrap_gdk_gc_new_with_values, METH_VARARGS|METH_KEYWORDS },
    { "image_get", (PyCFunction)_wrap_gdk_image_get, METH_VARARGS|METH_KEYWORDS },
    { "draw_rgb_image", (PyCFunction)_wrap_gdk_draw_rgb_image, METH_VARARGS|METH_KEYWORDS },
    { "draw_rgb_image_dithalign", (PyCFunction)_wrap_gdk_draw_rgb_image_dithalign, METH_VARARGS|METH_KEYWORDS },
    { "draw_rgb_32_image", (PyCFunction)_wrap_gdk_draw_rgb_32_image, METH_VARARGS|METH_KEYWORDS },
    { "draw_gray_image", (PyCFunction)_wrap_gdk_draw_gray_image, METH_VARARGS|METH_KEYWORDS },
    { NULL, NULL, 0 }
};

PyTypeObject PyGdkDrawable_Type = {
    PyObject_HEAD_INIT(NULL)
    0,				/* ob_size */
    "Drawable",		/* tp_name */
    sizeof(PyGObject),		/* tp_basicsize */
    0,				/* tp_itemsize */
    /* methods */
    (destructor)0,			/* tp_dealloc */
    (printfunc)0,			/* tp_print */
    (getattrfunc)0,			/* tp_getattr */
    (setattrfunc)0,			/* tp_setattr */
    (cmpfunc)0,			/* tp_compare */
    (reprfunc)0,			/* tp_repr */
    0,				/* tp_as_number */
    0,				/* tp_as_sequence */
    0,				/* tp_as_mapping */
    (hashfunc)0,			/* tp_hash */
    (ternaryfunc)0,			/* tp_call */
    (reprfunc)0,			/* tp_str */
    (getattrofunc)0,		/* tp_getattro */
    (setattrofunc)0,		/* tp_setattro */
    0,				/* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /* tp_flags */
    NULL, /* Documentation string */
    (traverseproc)0,		/* tp_traverse */
    (inquiry)0,			/* tp_clear */
    (richcmpfunc)0,			/* tp_richcompare */
    offsetof(PyGObject, weakreflist), /* tp_weaklistoffset */
    (getiterfunc)0,			/* tp_iter */
    (iternextfunc)0,		/* tp_iternext */
    _PyGdkDrawable_methods,			/* tp_methods */
    0,				/* tp_members */
    0,			/* tp_getset */
    NULL,				/* tp_base */
    NULL,				/* tp_dict */
    (descrgetfunc)0,		/* tp_descr_get */
    (descrsetfunc)0,		/* tp_descr_set */
    offsetof(PyGObject, inst_dict),	/* tp_dictoffset */
    (initproc)pygobject_no_constructor,		/* tp_init */
};



/* ----------- GdkWindow ----------- */

#line 1129 "gdk.override"
static PyObject *
_wrap_gdk_drag_begin(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "targets", NULL };
    PyObject *py_targets;
    GList *targets = NULL;
    guint i, len;
    GdkDragContext *context;
    PyObject *py_context;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:GdkWindow.drag_begin",
				     kwlist, &py_targets))
	return NULL;
    if (!PySequence_Check(py_targets)) {
	PyErr_SetString(PyExc_TypeError, "targets must be a list of ints");
	return NULL;
    }
    len = PySequence_Length(py_targets);
    for (i = 0; i < len; i++) {
	PyObject *item = PySequence_GetItem(py_targets, i);

	if (PyInt_Check(item)) {
	    targets = g_list_append(targets,
				    GUINT_TO_POINTER(PyInt_AsLong(item)));
	    Py_DECREF(item);
	} else {
	    PyErr_SetString(PyExc_TypeError, "targets must be a list of ints");
	    Py_DECREF(item);
	    g_list_free(targets);
	    return NULL;
	}
    }
    context = gdk_drag_begin(GDK_WINDOW(self->obj), targets);
    g_list_free(targets);
    py_context = pygobject_new((GObject *)context);
    gdk_drag_context_unref(context);
    return py_context;
}
#line 2667 "gdk.c"


static PyObject *
_wrap_gdk_input_set_extension_events(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int mask;
    static char *kwlist[] = { "mask", "mode", NULL };
    PyObject *py_mode = NULL;
    GdkExtensionMode mode;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "iO:GdkWindow.input_set_extension_events", kwlist, &mask, &py_mode))
        return NULL;
    if (pyg_enum_get_value(GDK_TYPE_EXTENSION_MODE, py_mode, (gint *)&mode))
        return NULL;

    gdk_input_set_extension_events(GDK_WINDOW(self->obj), mask, mode);
    Py_INCREF(Py_None);
    return Py_None;
}

#line 1169 "gdk.override"
static PyObject *
_wrap_gdk_property_get(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "property", "type", "pdelete", NULL };
    GdkAtom property, type = 0;
    gint pdelete = FALSE;

    GdkAtom atype;
    gint aformat, alength;
    guchar *data;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,
				     "i|ii:GdkWindow.property_get", kwlist,
				     &property, &type, &pdelete)) {
	gchar *propname;

	PyErr_Clear();
	if (!PyArg_ParseTupleAndKeywords(args, kwargs,
					 "s|ii:GdkWindow.property_get", kwlist,
					 &propname, &type, &pdelete))
	    return NULL;
	property = gdk_atom_intern(propname, FALSE);
    }
    if (gdk_property_get(GDK_WINDOW(self->obj), property, type, 0, 9999,
			 pdelete, &atype, &aformat, &alength, &data)) {
	/* success */
	PyObject *pdata = NULL;
	gint i;
	guint16 *data16;
	guint32 *data32;
	switch (aformat) {
	case 8:
	    if ((pdata = PyString_FromStringAndSize(data, alength)) == NULL)
	        return NULL;
	    break;
	case 16:
	    data16 = (guint16 *)data;
	    if ((pdata = PyTuple_New(alength)) == NULL)
	        return NULL;
	    for (i = 0; i < alength; i++)
		PyTuple_SetItem(pdata, i, PyInt_FromLong(data16[i]));
	    break;
	case 32:
	    data32 = (guint32 *)data;
	    if ((pdata = PyTuple_New(alength)) == NULL)
	        return NULL;
	    for (i = 0; i < alength; i++)
		PyTuple_SetItem(pdata, i, PyInt_FromLong(data32[i]));
	    break;
	default:
	    g_warning("got a property format != 8, 16 or 32");
	    g_assert_not_reached();
	}
	g_free(data);
	return Py_BuildValue("(NiN)", PyGdkAtom_New(atype), aformat, pdata);
    } else {
	Py_INCREF(Py_None);
	return Py_None;
    }
}
#line 2749 "gdk.c"


#line 1231 "gdk.override"
static PyObject *
_wrap_gdk_property_change(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "property","type","format","mode","data",NULL };
    GdkAtom property, type;
    gint format;
    PyObject *py_mode, *pdata;
    GdkPropMode mode;
    guchar *data = NULL;
    gint nelements;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,
				     "iiiOO:GdkWindow.property_change", kwlist,
				     &property, &type, &format, &py_mode,
				     &pdata)) {
	gchar *propname;

	PyErr_Clear();
	if (!PyArg_ParseTupleAndKeywords(args, kwargs,
					 "siiOO:GdkWindow.property_change",
					 kwlist, &propname, &type, &format,
					 &py_mode, &pdata))
	    return NULL;
	property = gdk_atom_intern(propname, FALSE);
    }
    if (pyg_enum_get_value(GDK_TYPE_PROP_MODE, py_mode, (gint *)&mode))
	return NULL;
    switch (format) {
    case 8:
	if (!PyString_Check(pdata)) {
	    PyErr_SetString(PyExc_TypeError, "data not a string and format=8");
	    return NULL;
	}
	data = PyString_AsString(pdata);
	nelements = PyString_Size(pdata);
	break;
    case 16:
	{
	    guint16 *data16;
	    gint i;

	    if (!PySequence_Check(pdata)) {
		PyErr_SetString(PyExc_TypeError,
				"data not a sequence and format=16");
		return NULL;
	    }
	    nelements = PySequence_Length(pdata);
	    data16 = g_new(guint16, nelements);
	    data = (guchar *)data16;
	    for (i = 0; i < nelements; i++) {
		PyObject *item = PySequence_GetItem(pdata, i);
		Py_DECREF(item);
		item = PyNumber_Int(item);
		if (!item) {
		    g_free(data16);
		    PyErr_Clear();
		    PyErr_SetString(PyExc_TypeError,"data element not an int");
		    return NULL;
		}
		data16[i] = PyInt_AsLong(item);
		Py_DECREF(item);
	    }
	}
	break;
    case 32:
	{
	    guint32 *data32;
	    gint i;

	    if (!PySequence_Check(pdata)) {
		PyErr_SetString(PyExc_TypeError,
				"data not a sequence and format=32");
		return NULL;
	    }
	    nelements = PySequence_Length(pdata);
	    data32 = g_new(guint32, nelements);
	    data = (guchar *)data32;
	    for (i = 0; i < nelements; i++) {
		PyObject *item = PySequence_GetItem(pdata, i);
		Py_DECREF(item);
		item = PyNumber_Int(item);
		if (!item) {
		    g_free(data32);
		    PyErr_Clear();
		    PyErr_SetString(PyExc_TypeError,"data element not an int");
		    return NULL;
		}
		data32[i] = PyInt_AsLong(item);
		Py_DECREF(item);
	    }
	}
	break;
    default:
	PyErr_SetString(PyExc_TypeError, "format must be 8, 16 or 32");
	return NULL;
	break;
    }
    gdk_property_change(GDK_WINDOW(self->obj), property, type, format, mode,
			data, nelements);
    if (format != 8)
	g_free(data);
    Py_INCREF(Py_None);
    return Py_None;
}
#line 2857 "gdk.c"


static PyObject *
_wrap_gdk_property_delete(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int property;
    static char *kwlist[] = { "property", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "i:GdkWindow.property_delete", kwlist, &property))
        return NULL;

    gdk_property_delete(GDK_WINDOW(self->obj), property);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_selection_convert(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int selection, target, time;
    static char *kwlist[] = { "selection", "target", "time", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "iii:GdkWindow.selection_convert", kwlist, &selection, &target, &time))
        return NULL;

    gdk_selection_convert(GDK_WINDOW(self->obj), selection, target, time);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_destroy(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkWindow.destroy", kwlist))
        return NULL;

    gdk_window_destroy(GDK_WINDOW(self->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_get_window_type(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkWindow.get_window_type", kwlist))
        return NULL;

    return PyInt_FromLong(gdk_window_get_window_type(GDK_WINDOW(self->obj)));
}

static PyObject *
_wrap_gdk_window_show(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkWindow.show", kwlist))
        return NULL;

    gdk_window_show(GDK_WINDOW(self->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_hide(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkWindow.hide", kwlist))
        return NULL;

    gdk_window_hide(GDK_WINDOW(self->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_withdraw(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkWindow.withdraw", kwlist))
        return NULL;

    gdk_window_withdraw(GDK_WINDOW(self->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_move(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int x, y;
    static char *kwlist[] = { "x", "y", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "ii:GdkWindow.move", kwlist, &x, &y))
        return NULL;

    gdk_window_move(GDK_WINDOW(self->obj), x, y);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_resize(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int width, height;
    static char *kwlist[] = { "width", "height", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "ii:GdkWindow.resize", kwlist, &width, &height))
        return NULL;

    gdk_window_resize(GDK_WINDOW(self->obj), width, height);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_move_resize(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int x, y, width, height;
    static char *kwlist[] = { "x", "y", "width", "height", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "iiii:GdkWindow.move_resize", kwlist, &x, &y, &width, &height))
        return NULL;

    gdk_window_move_resize(GDK_WINDOW(self->obj), x, y, width, height);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_reparent(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *new_parent;
    static char *kwlist[] = { "new_parent", "x", "y", NULL };
    int x, y;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "Oii:GdkWindow.reparent", kwlist, &new_parent, &x, &y))
        return NULL;
    if (!pygobject_check(new_parent, &PyGdkWindow_Type)) {
        PyErr_SetString(PyExc_TypeError, "new_parent should be a GdkWindow");
        return NULL;
    }

    gdk_window_reparent(GDK_WINDOW(self->obj), GDK_WINDOW(new_parent->obj), x, y);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_clear(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkWindow.clear", kwlist))
        return NULL;

    gdk_window_clear(GDK_WINDOW(self->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_clear_area(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int x, y, width, height;
    static char *kwlist[] = { "x", "y", "width", "height", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "iiii:GdkWindow.clear_area", kwlist, &x, &y, &width, &height))
        return NULL;

    gdk_window_clear_area(GDK_WINDOW(self->obj), x, y, width, height);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_clear_area_e(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int x, y, width, height;
    static char *kwlist[] = { "x", "y", "width", "height", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "iiii:GdkWindow.clear_area_e", kwlist, &x, &y, &width, &height))
        return NULL;

    gdk_window_clear_area_e(GDK_WINDOW(self->obj), x, y, width, height);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_raise(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkWindow.raise_", kwlist))
        return NULL;

    gdk_window_raise(GDK_WINDOW(self->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_lower(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkWindow.lower", kwlist))
        return NULL;

    gdk_window_lower(GDK_WINDOW(self->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_set_override_redirect(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int override_redirect;
    static char *kwlist[] = { "override_redirect", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "i:GdkWindow.set_override_redirect", kwlist, &override_redirect))
        return NULL;

    gdk_window_set_override_redirect(GDK_WINDOW(self->obj), override_redirect);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_scroll(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int dx, dy;
    static char *kwlist[] = { "dx", "dy", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "ii:GdkWindow.scroll", kwlist, &dx, &dy))
        return NULL;

    gdk_window_scroll(GDK_WINDOW(self->obj), dx, dy);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_shape_combine_mask(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *shape_mask;
    static char *kwlist[] = { "shape_mask", "offset_x", "offset_y", NULL };
    int offset_x, offset_y;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "Oii:GdkWindow.shape_combine_mask", kwlist, &shape_mask, &offset_x, &offset_y))
        return NULL;
    if (!pygobject_check(shape_mask, &PyGdkPixmap_Type)) {
        PyErr_SetString(PyExc_TypeError, "shape_mask should be a GdkPixmap");
        return NULL;
    }

    gdk_window_shape_combine_mask(GDK_WINDOW(self->obj), GDK_PIXMAP(shape_mask->obj), offset_x, offset_y);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_set_child_shapes(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkWindow.set_child_shapes", kwlist))
        return NULL;

    gdk_window_set_child_shapes(GDK_WINDOW(self->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_merge_child_shapes(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkWindow.merge_child_shapes", kwlist))
        return NULL;

    gdk_window_merge_child_shapes(GDK_WINDOW(self->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_is_visible(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkWindow.is_visible", kwlist))
        return NULL;

    return PyInt_FromLong(gdk_window_is_visible(GDK_WINDOW(self->obj)));
}

static PyObject *
_wrap_gdk_window_is_viewable(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkWindow.is_viewable", kwlist))
        return NULL;

    return PyInt_FromLong(gdk_window_is_viewable(GDK_WINDOW(self->obj)));
}

static PyObject *
_wrap_gdk_window_set_static_gravities(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int use_static;
    static char *kwlist[] = { "use_static", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "i:GdkWindow.set_static_gravities", kwlist, &use_static))
        return NULL;

    return PyInt_FromLong(gdk_window_set_static_gravities(GDK_WINDOW(self->obj), use_static));
}

static PyObject *
_wrap_gdk_window_set_hints(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int x, y, min_width, min_height, max_width, max_height, flags;
    static char *kwlist[] = { "x", "y", "min_width", "min_height", "max_width", "max_height", "flags", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "iiiiiii:GdkWindow.set_hints", kwlist, &x, &y, &min_width, &min_height, &max_width, &max_height, &flags))
        return NULL;

    gdk_window_set_hints(GDK_WINDOW(self->obj), x, y, min_width, min_height, max_width, max_height, flags);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_begin_paint_rect(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_rectangle;
    static char *kwlist[] = { "rectangle", NULL };
    GdkRectangle *rectangle = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:GdkWindow.begin_paint_rect", kwlist, &py_rectangle))
        return NULL;
    if (pyg_boxed_check(py_rectangle, GDK_TYPE_RECTANGLE))
        rectangle = pyg_boxed_get(py_rectangle, GdkRectangle);
    else {
        PyErr_SetString(PyExc_TypeError, "rectangle should be a GdkRectangle");
        return NULL;
    }

    gdk_window_begin_paint_rect(GDK_WINDOW(self->obj), rectangle);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_end_paint(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkWindow.end_paint", kwlist))
        return NULL;

    gdk_window_end_paint(GDK_WINDOW(self->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_set_title(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    char *title;
    static char *kwlist[] = { "title", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s:GdkWindow.set_title", kwlist, &title))
        return NULL;

    gdk_window_set_title(GDK_WINDOW(self->obj), title);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_set_role(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    char *role;
    static char *kwlist[] = { "role", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s:GdkWindow.set_role", kwlist, &role))
        return NULL;

    gdk_window_set_role(GDK_WINDOW(self->obj), role);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_set_transient_for(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *leader;
    static char *kwlist[] = { "leader", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:GdkWindow.set_transient_for", kwlist, &leader))
        return NULL;
    if (!pygobject_check(leader, &PyGdkWindow_Type)) {
        PyErr_SetString(PyExc_TypeError, "leader should be a GdkWindow");
        return NULL;
    }

    gdk_window_set_transient_for(GDK_WINDOW(self->obj), GDK_WINDOW(leader->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_set_background(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_color;
    static char *kwlist[] = { "color", NULL };
    GdkColor *color = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:GdkWindow.set_background", kwlist, &py_color))
        return NULL;
    if (pyg_boxed_check(py_color, GDK_TYPE_COLOR))
        color = pyg_boxed_get(py_color, GdkColor);
    else {
        PyErr_SetString(PyExc_TypeError, "color should be a GdkColor");
        return NULL;
    }

    gdk_window_set_background(GDK_WINDOW(self->obj), color);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_set_back_pixmap(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *pixmap;
    static char *kwlist[] = { "pixmap", "parent_relative", NULL };
    int parent_relative;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "Oi:GdkWindow.set_back_pixmap", kwlist, &pixmap, &parent_relative))
        return NULL;
    if (!pygobject_check(pixmap, &PyGdkPixmap_Type)) {
        PyErr_SetString(PyExc_TypeError, "pixmap should be a GdkPixmap");
        return NULL;
    }

    gdk_window_set_back_pixmap(GDK_WINDOW(self->obj), GDK_PIXMAP(pixmap->obj), parent_relative);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_set_cursor(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_cursor;
    static char *kwlist[] = { "cursor", NULL };
    GdkCursor *cursor = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:GdkWindow.set_cursor", kwlist, &py_cursor))
        return NULL;
    if (pyg_boxed_check(py_cursor, GDK_TYPE_CURSOR))
        cursor = pyg_boxed_get(py_cursor, GdkCursor);
    else {
        PyErr_SetString(PyExc_TypeError, "cursor should be a GdkCursor");
        return NULL;
    }

    gdk_window_set_cursor(GDK_WINDOW(self->obj), cursor);
    Py_INCREF(Py_None);
    return Py_None;
}

#line 1337 "gdk.override"
static PyObject *
_wrap_gdk_window_get_geometry(PyGObject *self, PyObject *args)
{
    gint x, y, width, height, depth;

    if (!PyArg_ParseTuple(args, ":GdkWindow.get_geometry"))
	return NULL;
    gdk_window_get_geometry(GDK_WINDOW(self->obj), &x, &y, &width, &height,
			    &depth);
    return Py_BuildValue("(iiiii)", x, y, width, height, depth);
}
#line 3353 "gdk.c"


#line 1350 "gdk.override"
static PyObject *
_wrap_gdk_window_get_position(PyGObject *self, PyObject *args)
{
    gint x, y;

    if (!PyArg_ParseTuple(args, ":GdkWindow.get_position"))
	return NULL;
    gdk_window_get_position(GDK_WINDOW(self->obj), &x, &y);
    return Py_BuildValue("(ii)", x, y);
}
#line 3367 "gdk.c"


#line 1362 "gdk.override"
static PyObject *
_wrap_gdk_window_get_origin(PyGObject *self, PyObject *args)
{
    gint x, y;

    if (!PyArg_ParseTuple(args, ":GdkWindow.get_origin"))
	return NULL;
    gdk_window_get_origin(GDK_WINDOW(self->obj), &x, &y);
    return Py_BuildValue("(ii)", x, y);
}
#line 3381 "gdk.c"


#line 1374 "gdk.override"
static PyObject *
_wrap_gdk_window_get_deskrelative_origin(PyGObject *self, PyObject *args)
{
    gint x, y;

    if (!PyArg_ParseTuple(args, ":GdkWindow.get_deskrelative_origin"))
	return NULL;
    gdk_window_get_deskrelative_origin(GDK_WINDOW(self->obj), &x, &y);
    return Py_BuildValue("(ii)", x, y);
}
#line 3395 "gdk.c"


#line 1386 "gdk.override"
static PyObject *
_wrap_gdk_window_get_root_origin(PyGObject *self, PyObject *args)
{
    gint x, y;

    if (!PyArg_ParseTuple(args, ":GdkWindow.get_root_origin"))
	return NULL;
    gdk_window_get_root_origin(GDK_WINDOW(self->obj), &x, &y);
    return Py_BuildValue("(ii)", x, y);
}
#line 3409 "gdk.c"


#line 1398 "gdk.override"
static PyObject *
_wrap_gdk_window_get_pointer(PyGObject *self, PyObject *args)
{
    gint x, y;
    GdkModifierType mask;

    if (!PyArg_ParseTuple(args, ":GdkWindow.get_pointer"))
	return NULL;
    gdk_window_get_pointer(GDK_WINDOW(self->obj), &x, &y, &mask);
    return Py_BuildValue("(iii)", x, y, (gint)mask);
}
#line 3424 "gdk.c"


static PyObject *
_wrap_gdk_window_get_parent(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkWindow.get_parent", kwlist))
        return NULL;

    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)gdk_window_get_parent(GDK_WINDOW(self->obj)));
}

static PyObject *
_wrap_gdk_window_get_toplevel(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkWindow.get_toplevel", kwlist))
        return NULL;

    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)gdk_window_get_toplevel(GDK_WINDOW(self->obj)));
}

#line 1411 "gdk.override"
static PyObject *
_wrap_gdk_window_get_children(PyGObject *self, PyObject *args)
{
    GList *children, *tmp;
    PyObject *list;

    if (!PyArg_ParseTuple(args, ":GdkWindow.get_children"))
	return NULL;
    children = gdk_window_get_children(GDK_WINDOW(self->obj));
    list = PyList_New(0);
    for (tmp = children; tmp != NULL; tmp = tmp->next) {
	PyObject *item = pygobject_new((GObject *)tmp->data);

	PyList_Append(list, item);
	Py_DECREF(item);
    }
    g_list_free(children);
    return list;
}
#line 3471 "gdk.c"


static PyObject *
_wrap_gdk_window_get_events(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkWindow.get_events", kwlist))
        return NULL;

    return PyInt_FromLong(gdk_window_get_events(GDK_WINDOW(self->obj)));
}

static PyObject *
_wrap_gdk_window_set_events(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_event_mask = NULL;
    static char *kwlist[] = { "event_mask", NULL };
    GdkEventMask event_mask;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:GdkWindow.set_events", kwlist, &py_event_mask))
        return NULL;
    if (pyg_flags_get_value(GDK_TYPE_EVENT_MASK, py_event_mask, (gint *)&event_mask))
        return NULL;

    gdk_window_set_events(GDK_WINDOW(self->obj), event_mask);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_set_icon(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *icon_window, *pixmap, *mask;
    static char *kwlist[] = { "icon_window", "pixmap", "mask", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:GdkWindow.set_icon", kwlist, &icon_window, &pixmap, &mask))
        return NULL;
    if (!pygobject_check(icon_window, &PyGdkWindow_Type)) {
        PyErr_SetString(PyExc_TypeError, "icon_window should be a GdkWindow");
        return NULL;
    }
    if (!pygobject_check(pixmap, &PyGdkPixmap_Type)) {
        PyErr_SetString(PyExc_TypeError, "pixmap should be a GdkPixmap");
        return NULL;
    }
    if (!pygobject_check(mask, &PyGdkPixmap_Type)) {
        PyErr_SetString(PyExc_TypeError, "mask should be a GdkPixmap");
        return NULL;
    }

    gdk_window_set_icon(GDK_WINDOW(self->obj), GDK_WINDOW(icon_window->obj), GDK_PIXMAP(pixmap->obj), GDK_PIXMAP(mask->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_set_icon_name(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    char *name;
    static char *kwlist[] = { "name", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s:GdkWindow.set_icon_name", kwlist, &name))
        return NULL;

    gdk_window_set_icon_name(GDK_WINDOW(self->obj), name);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_set_group(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *leader;
    static char *kwlist[] = { "leader", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:GdkWindow.set_group", kwlist, &leader))
        return NULL;
    if (!pygobject_check(leader, &PyGdkWindow_Type)) {
        PyErr_SetString(PyExc_TypeError, "leader should be a GdkWindow");
        return NULL;
    }

    gdk_window_set_group(GDK_WINDOW(self->obj), GDK_WINDOW(leader->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_set_decorations(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_decorations = NULL;
    static char *kwlist[] = { "decorations", NULL };
    GdkWMDecoration decorations;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:GdkWindow.set_decorations", kwlist, &py_decorations))
        return NULL;
    if (pyg_flags_get_value(GDK_TYPE_WM_DECORATION, py_decorations, (gint *)&decorations))
        return NULL;

    gdk_window_set_decorations(GDK_WINDOW(self->obj), decorations);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_set_functions(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_functions = NULL;
    static char *kwlist[] = { "functions", NULL };
    GdkWMFunction functions;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:GdkWindow.set_functions", kwlist, &py_functions))
        return NULL;
    if (pyg_flags_get_value(GDK_TYPE_WM_FUNCTION, py_functions, (gint *)&functions))
        return NULL;

    gdk_window_set_functions(GDK_WINDOW(self->obj), functions);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_register_dnd(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkWindow.register_dnd", kwlist))
        return NULL;

    gdk_window_register_dnd(GDK_WINDOW(self->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_invalidate_rect(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_rect;
    static char *kwlist[] = { "rect", "invalidate_children", NULL };
    int invalidate_children;
    GdkRectangle *rect = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "Oi:GdkWindow.invalidate_rect", kwlist, &py_rect, &invalidate_children))
        return NULL;
    if (pyg_boxed_check(py_rect, GDK_TYPE_RECTANGLE))
        rect = pyg_boxed_get(py_rect, GdkRectangle);
    else {
        PyErr_SetString(PyExc_TypeError, "rect should be a GdkRectangle");
        return NULL;
    }

    gdk_window_invalidate_rect(GDK_WINDOW(self->obj), rect, invalidate_children);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_freeze_updates(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkWindow.freeze_updates", kwlist))
        return NULL;

    gdk_window_freeze_updates(GDK_WINDOW(self->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_thaw_updates(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkWindow.thaw_updates", kwlist))
        return NULL;

    gdk_window_thaw_updates(GDK_WINDOW(self->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_window_process_updates(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int update_children;
    static char *kwlist[] = { "update_children", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "i:GdkWindow.process_updates", kwlist, &update_children))
        return NULL;

    gdk_window_process_updates(GDK_WINDOW(self->obj), update_children);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyMethodDef _PyGdkWindow_methods[] = {
    { "drag_begin", (PyCFunction)_wrap_gdk_drag_begin, METH_VARARGS|METH_KEYWORDS },
    { "input_set_extension_events", (PyCFunction)_wrap_gdk_input_set_extension_events, METH_VARARGS|METH_KEYWORDS },
    { "property_get", (PyCFunction)_wrap_gdk_property_get, METH_VARARGS|METH_KEYWORDS },
    { "property_change", (PyCFunction)_wrap_gdk_property_change, METH_VARARGS|METH_KEYWORDS },
    { "property_delete", (PyCFunction)_wrap_gdk_property_delete, METH_VARARGS|METH_KEYWORDS },
    { "selection_convert", (PyCFunction)_wrap_gdk_selection_convert, METH_VARARGS|METH_KEYWORDS },
    { "destroy", (PyCFunction)_wrap_gdk_window_destroy, METH_VARARGS|METH_KEYWORDS },
    { "get_window_type", (PyCFunction)_wrap_gdk_window_get_window_type, METH_VARARGS|METH_KEYWORDS },
    { "show", (PyCFunction)_wrap_gdk_window_show, METH_VARARGS|METH_KEYWORDS },
    { "hide", (PyCFunction)_wrap_gdk_window_hide, METH_VARARGS|METH_KEYWORDS },
    { "withdraw", (PyCFunction)_wrap_gdk_window_withdraw, METH_VARARGS|METH_KEYWORDS },
    { "move", (PyCFunction)_wrap_gdk_window_move, METH_VARARGS|METH_KEYWORDS },
    { "resize", (PyCFunction)_wrap_gdk_window_resize, METH_VARARGS|METH_KEYWORDS },
    { "move_resize", (PyCFunction)_wrap_gdk_window_move_resize, METH_VARARGS|METH_KEYWORDS },
    { "reparent", (PyCFunction)_wrap_gdk_window_reparent, METH_VARARGS|METH_KEYWORDS },
    { "clear", (PyCFunction)_wrap_gdk_window_clear, METH_VARARGS|METH_KEYWORDS },
    { "clear_area", (PyCFunction)_wrap_gdk_window_clear_area, METH_VARARGS|METH_KEYWORDS },
    { "clear_area_e", (PyCFunction)_wrap_gdk_window_clear_area_e, METH_VARARGS|METH_KEYWORDS },
    { "raise_", (PyCFunction)_wrap_gdk_window_raise, METH_VARARGS|METH_KEYWORDS },
    { "lower", (PyCFunction)_wrap_gdk_window_lower, METH_VARARGS|METH_KEYWORDS },
    { "set_override_redirect", (PyCFunction)_wrap_gdk_window_set_override_redirect, METH_VARARGS|METH_KEYWORDS },
    { "scroll", (PyCFunction)_wrap_gdk_window_scroll, METH_VARARGS|METH_KEYWORDS },
    { "shape_combine_mask", (PyCFunction)_wrap_gdk_window_shape_combine_mask, METH_VARARGS|METH_KEYWORDS },
    { "set_child_shapes", (PyCFunction)_wrap_gdk_window_set_child_shapes, METH_VARARGS|METH_KEYWORDS },
    { "merge_child_shapes", (PyCFunction)_wrap_gdk_window_merge_child_shapes, METH_VARARGS|METH_KEYWORDS },
    { "is_visible", (PyCFunction)_wrap_gdk_window_is_visible, METH_VARARGS|METH_KEYWORDS },
    { "is_viewable", (PyCFunction)_wrap_gdk_window_is_viewable, METH_VARARGS|METH_KEYWORDS },
    { "set_static_gravities", (PyCFunction)_wrap_gdk_window_set_static_gravities, METH_VARARGS|METH_KEYWORDS },
    { "set_hints", (PyCFunction)_wrap_gdk_window_set_hints, METH_VARARGS|METH_KEYWORDS },
    { "begin_paint_rect", (PyCFunction)_wrap_gdk_window_begin_paint_rect, METH_VARARGS|METH_KEYWORDS },
    { "end_paint", (PyCFunction)_wrap_gdk_window_end_paint, METH_VARARGS|METH_KEYWORDS },
    { "set_title", (PyCFunction)_wrap_gdk_window_set_title, METH_VARARGS|METH_KEYWORDS },
    { "set_role", (PyCFunction)_wrap_gdk_window_set_role, METH_VARARGS|METH_KEYWORDS },
    { "set_transient_for", (PyCFunction)_wrap_gdk_window_set_transient_for, METH_VARARGS|METH_KEYWORDS },
    { "set_background", (PyCFunction)_wrap_gdk_window_set_background, METH_VARARGS|METH_KEYWORDS },
    { "set_back_pixmap", (PyCFunction)_wrap_gdk_window_set_back_pixmap, METH_VARARGS|METH_KEYWORDS },
    { "set_cursor", (PyCFunction)_wrap_gdk_window_set_cursor, METH_VARARGS|METH_KEYWORDS },
    { "get_geometry", (PyCFunction)_wrap_gdk_window_get_geometry, METH_VARARGS },
    { "get_position", (PyCFunction)_wrap_gdk_window_get_position, METH_VARARGS },
    { "get_origin", (PyCFunction)_wrap_gdk_window_get_origin, METH_VARARGS },
    { "get_deskrelative_origin", (PyCFunction)_wrap_gdk_window_get_deskrelative_origin, METH_VARARGS },
    { "get_root_origin", (PyCFunction)_wrap_gdk_window_get_root_origin, METH_VARARGS },
    { "get_pointer", (PyCFunction)_wrap_gdk_window_get_pointer, METH_VARARGS },
    { "get_parent", (PyCFunction)_wrap_gdk_window_get_parent, METH_VARARGS|METH_KEYWORDS },
    { "get_toplevel", (PyCFunction)_wrap_gdk_window_get_toplevel, METH_VARARGS|METH_KEYWORDS },
    { "get_children", (PyCFunction)_wrap_gdk_window_get_children, METH_VARARGS },
    { "get_events", (PyCFunction)_wrap_gdk_window_get_events, METH_VARARGS|METH_KEYWORDS },
    { "set_events", (PyCFunction)_wrap_gdk_window_set_events, METH_VARARGS|METH_KEYWORDS },
    { "set_icon", (PyCFunction)_wrap_gdk_window_set_icon, METH_VARARGS|METH_KEYWORDS },
    { "set_icon_name", (PyCFunction)_wrap_gdk_window_set_icon_name, METH_VARARGS|METH_KEYWORDS },
    { "set_group", (PyCFunction)_wrap_gdk_window_set_group, METH_VARARGS|METH_KEYWORDS },
    { "set_decorations", (PyCFunction)_wrap_gdk_window_set_decorations, METH_VARARGS|METH_KEYWORDS },
    { "set_functions", (PyCFunction)_wrap_gdk_window_set_functions, METH_VARARGS|METH_KEYWORDS },
    { "register_dnd", (PyCFunction)_wrap_gdk_window_register_dnd, METH_VARARGS|METH_KEYWORDS },
    { "invalidate_rect", (PyCFunction)_wrap_gdk_window_invalidate_rect, METH_VARARGS|METH_KEYWORDS },
    { "freeze_updates", (PyCFunction)_wrap_gdk_window_freeze_updates, METH_VARARGS|METH_KEYWORDS },
    { "thaw_updates", (PyCFunction)_wrap_gdk_window_thaw_updates, METH_VARARGS|METH_KEYWORDS },
    { "process_updates", (PyCFunction)_wrap_gdk_window_process_updates, METH_VARARGS|METH_KEYWORDS },
    { NULL, NULL, 0 }
};

PyTypeObject PyGdkWindow_Type = {
    PyObject_HEAD_INIT(NULL)
    0,				/* ob_size */
    "Window",		/* tp_name */
    sizeof(PyGObject),		/* tp_basicsize */
    0,				/* tp_itemsize */
    /* methods */
    (destructor)0,			/* tp_dealloc */
    (printfunc)0,			/* tp_print */
    (getattrfunc)0,			/* tp_getattr */
    (setattrfunc)0,			/* tp_setattr */
    (cmpfunc)0,			/* tp_compare */
    (reprfunc)0,			/* tp_repr */
    0,				/* tp_as_number */
    0,				/* tp_as_sequence */
    0,				/* tp_as_mapping */
    (hashfunc)0,			/* tp_hash */
    (ternaryfunc)0,			/* tp_call */
    (reprfunc)0,			/* tp_str */
    (getattrofunc)0,		/* tp_getattro */
    (setattrofunc)0,		/* tp_setattro */
    0,				/* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /* tp_flags */
    NULL, /* Documentation string */
    (traverseproc)0,		/* tp_traverse */
    (inquiry)0,			/* tp_clear */
    (richcmpfunc)0,			/* tp_richcompare */
    offsetof(PyGObject, weakreflist), /* tp_weaklistoffset */
    (getiterfunc)0,			/* tp_iter */
    (iternextfunc)0,		/* tp_iternext */
    _PyGdkWindow_methods,			/* tp_methods */
    0,				/* tp_members */
    0,			/* tp_getset */
    NULL,				/* tp_base */
    NULL,				/* tp_dict */
    (descrgetfunc)0,		/* tp_descr_get */
    (descrsetfunc)0,		/* tp_descr_set */
    offsetof(PyGObject, inst_dict),	/* tp_dictoffset */
    (initproc)pygobject_no_constructor,		/* tp_init */
};



/* ----------- GdkPixmap ----------- */

static int
_wrap_gdk_pixmap_new(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *py_window;
    static char *kwlist[] = { "window", "width", "height", "depth", NULL };
    int width, height, depth = -1;
    GdkWindow *window = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "Oii|i:GdkPixmap.__init__", kwlist, &py_window, &width, &height, &depth))
        return -1;
    if (py_window && pygobject_check(py_window, &PyGdkWindow_Type))
        window = GDK_WINDOW(py_window->obj);
    else if ((PyObject *)py_window != Py_None) {
        PyErr_SetString(PyExc_TypeError, "window should be a GdkWindow or None");
        return -1;
    }

    self->obj = (GObject *)gdk_pixmap_new(window, width, height, depth);
    if (!self->obj) {
        PyErr_SetString(PyExc_RuntimeError, "could not create GdkPixmap object");
        return -1;
    }
    pygobject_register_wrapper((PyObject *)self);
    return 0;
}

static PyMethodDef _PyGdkPixmap_methods[] = {
    { NULL, NULL, 0 }
};

PyTypeObject PyGdkPixmap_Type = {
    PyObject_HEAD_INIT(NULL)
    0,				/* ob_size */
    "Pixmap",		/* tp_name */
    sizeof(PyGObject),		/* tp_basicsize */
    0,				/* tp_itemsize */
    /* methods */
    (destructor)0,			/* tp_dealloc */
    (printfunc)0,			/* tp_print */
    (getattrfunc)0,			/* tp_getattr */
    (setattrfunc)0,			/* tp_setattr */
    (cmpfunc)0,			/* tp_compare */
    (reprfunc)0,			/* tp_repr */
    0,				/* tp_as_number */
    0,				/* tp_as_sequence */
    0,				/* tp_as_mapping */
    (hashfunc)0,			/* tp_hash */
    (ternaryfunc)0,			/* tp_call */
    (reprfunc)0,			/* tp_str */
    (getattrofunc)0,		/* tp_getattro */
    (setattrofunc)0,		/* tp_setattro */
    0,				/* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /* tp_flags */
    NULL, /* Documentation string */
    (traverseproc)0,		/* tp_traverse */
    (inquiry)0,			/* tp_clear */
    (richcmpfunc)0,			/* tp_richcompare */
    offsetof(PyGObject, weakreflist), /* tp_weaklistoffset */
    (getiterfunc)0,			/* tp_iter */
    (iternextfunc)0,		/* tp_iternext */
    _PyGdkPixmap_methods,			/* tp_methods */
    0,				/* tp_members */
    0,			/* tp_getset */
    NULL,				/* tp_base */
    NULL,				/* tp_dict */
    (descrgetfunc)0,		/* tp_descr_get */
    (descrsetfunc)0,		/* tp_descr_set */
    offsetof(PyGObject, inst_dict),	/* tp_dictoffset */
    (initproc)_wrap_gdk_pixmap_new,		/* tp_init */
};



/* ----------- GdkGC ----------- */

static PyObject *
_wrap_gdk_gc_set_foreground(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_color;
    static char *kwlist[] = { "color", NULL };
    GdkColor *color = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:GdkGC.set_foreground", kwlist, &py_color))
        return NULL;
    if (pyg_boxed_check(py_color, GDK_TYPE_COLOR))
        color = pyg_boxed_get(py_color, GdkColor);
    else {
        PyErr_SetString(PyExc_TypeError, "color should be a GdkColor");
        return NULL;
    }

    gdk_gc_set_foreground(GDK_GC(self->obj), color);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_gc_set_background(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_color;
    static char *kwlist[] = { "color", NULL };
    GdkColor *color = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:GdkGC.set_background", kwlist, &py_color))
        return NULL;
    if (pyg_boxed_check(py_color, GDK_TYPE_COLOR))
        color = pyg_boxed_get(py_color, GdkColor);
    else {
        PyErr_SetString(PyExc_TypeError, "color should be a GdkColor");
        return NULL;
    }

    gdk_gc_set_background(GDK_GC(self->obj), color);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_gc_set_font(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    GdkFont *font = NULL;
    static char *kwlist[] = { "font", NULL };
    PyObject *py_font;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:GdkGC.set_font", kwlist, &py_font))
        return NULL;
    if (pyg_boxed_check(py_font, GDK_TYPE_FONT))
        font = pyg_boxed_get(py_font, GdkFont);
    else {
        PyErr_SetString(PyExc_TypeError, "font should be a GdkFont");
        return NULL;
    }

    gdk_gc_set_font(GDK_GC(self->obj), font);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_gc_set_function(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_function = NULL;
    static char *kwlist[] = { "function", NULL };
    GdkFunction function;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:GdkGC.set_function", kwlist, &py_function))
        return NULL;
    if (pyg_enum_get_value(GDK_TYPE_FUNCTION, py_function, (gint *)&function))
        return NULL;

    gdk_gc_set_function(GDK_GC(self->obj), function);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_gc_set_fill(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_fill = NULL;
    static char *kwlist[] = { "fill", NULL };
    GdkFill fill;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:GdkGC.set_fill", kwlist, &py_fill))
        return NULL;
    if (pyg_enum_get_value(GDK_TYPE_FILL, py_fill, (gint *)&fill))
        return NULL;

    gdk_gc_set_fill(GDK_GC(self->obj), fill);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_gc_set_tile(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *tile;
    static char *kwlist[] = { "tile", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:GdkGC.set_tile", kwlist, &tile))
        return NULL;
    if (!pygobject_check(tile, &PyGdkPixmap_Type)) {
        PyErr_SetString(PyExc_TypeError, "tile should be a GdkPixmap");
        return NULL;
    }

    gdk_gc_set_tile(GDK_GC(self->obj), GDK_PIXMAP(tile->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_gc_set_stipple(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *stipple;
    static char *kwlist[] = { "stipple", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:GdkGC.set_stipple", kwlist, &stipple))
        return NULL;
    if (!pygobject_check(stipple, &PyGdkPixmap_Type)) {
        PyErr_SetString(PyExc_TypeError, "stipple should be a GdkPixmap");
        return NULL;
    }

    gdk_gc_set_stipple(GDK_GC(self->obj), GDK_PIXMAP(stipple->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_gc_set_ts_origin(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int x, y;
    static char *kwlist[] = { "x", "y", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "ii:GdkGC.set_ts_origin", kwlist, &x, &y))
        return NULL;

    gdk_gc_set_ts_origin(GDK_GC(self->obj), x, y);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_gc_set_clip_origin(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int x, y;
    static char *kwlist[] = { "x", "y", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "ii:GdkGC.set_clip_origin", kwlist, &x, &y))
        return NULL;

    gdk_gc_set_clip_origin(GDK_GC(self->obj), x, y);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_gc_set_clip_mask(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *mask;
    static char *kwlist[] = { "mask", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:GdkGC.set_clip_mask", kwlist, &mask))
        return NULL;
    if (!pygobject_check(mask, &PyGdkPixmap_Type)) {
        PyErr_SetString(PyExc_TypeError, "mask should be a GdkPixmap");
        return NULL;
    }

    gdk_gc_set_clip_mask(GDK_GC(self->obj), GDK_PIXMAP(mask->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_gc_set_clip_rectangle(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_rectangle;
    static char *kwlist[] = { "rectangle", NULL };
    GdkRectangle *rectangle = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:GdkGC.set_clip_rectangle", kwlist, &py_rectangle))
        return NULL;
    if (pyg_boxed_check(py_rectangle, GDK_TYPE_RECTANGLE))
        rectangle = pyg_boxed_get(py_rectangle, GdkRectangle);
    else {
        PyErr_SetString(PyExc_TypeError, "rectangle should be a GdkRectangle");
        return NULL;
    }

    gdk_gc_set_clip_rectangle(GDK_GC(self->obj), rectangle);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_gc_set_subwindow(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_mode = NULL;
    static char *kwlist[] = { "mode", NULL };
    GdkSubwindowMode mode;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:GdkGC.set_subwindow", kwlist, &py_mode))
        return NULL;
    if (pyg_enum_get_value(GDK_TYPE_SUBWINDOW_MODE, py_mode, (gint *)&mode))
        return NULL;

    gdk_gc_set_subwindow(GDK_GC(self->obj), mode);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_gc_set_exposures(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int exposures;
    static char *kwlist[] = { "exposures", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "i:GdkGC.set_exposures", kwlist, &exposures))
        return NULL;

    gdk_gc_set_exposures(GDK_GC(self->obj), exposures);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_gc_set_line_attributes(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_line_style = NULL, *py_cap_style = NULL, *py_join_style = NULL;
    GdkJoinStyle join_style;
    GdkLineStyle line_style;
    int line_width;
    static char *kwlist[] = { "line_width", "line_style", "cap_style", "join_style", NULL };
    GdkCapStyle cap_style;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "iOOO:GdkGC.set_line_attributes", kwlist, &line_width, &py_line_style, &py_cap_style, &py_join_style))
        return NULL;
    if (pyg_enum_get_value(GDK_TYPE_LINE_STYLE, py_line_style, (gint *)&line_style))
        return NULL;
    if (pyg_enum_get_value(GDK_TYPE_CAP_STYLE, py_cap_style, (gint *)&cap_style))
        return NULL;
    if (pyg_enum_get_value(GDK_TYPE_JOIN_STYLE, py_join_style, (gint *)&join_style))
        return NULL;

    gdk_gc_set_line_attributes(GDK_GC(self->obj), line_width, line_style, cap_style, join_style);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_gc_copy(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *src_gc;
    static char *kwlist[] = { "src_gc", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:GdkGC.copy", kwlist, &src_gc))
        return NULL;
    if (!pygobject_check(src_gc, &PyGdkGC_Type)) {
        PyErr_SetString(PyExc_TypeError, "src_gc should be a GdkGC");
        return NULL;
    }

    gdk_gc_copy(GDK_GC(self->obj), GDK_GC(src_gc->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_gc_set_colormap(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *colormap;
    static char *kwlist[] = { "colormap", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:GdkGC.set_colormap", kwlist, &colormap))
        return NULL;
    if (!pygobject_check(colormap, &PyGdkColormap_Type)) {
        PyErr_SetString(PyExc_TypeError, "colormap should be a GdkColormap");
        return NULL;
    }

    gdk_gc_set_colormap(GDK_GC(self->obj), GDK_COLORMAP(colormap->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_gc_get_colormap(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkGC.get_colormap", kwlist))
        return NULL;

    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)gdk_gc_get_colormap(GDK_GC(self->obj)));
}

static PyObject *
_wrap_gdk_gc_set_rgb_fg_color(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_color;
    static char *kwlist[] = { "color", NULL };
    GdkColor *color = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:GdkGC.set_rgb_fg_color", kwlist, &py_color))
        return NULL;
    if (pyg_boxed_check(py_color, GDK_TYPE_COLOR))
        color = pyg_boxed_get(py_color, GdkColor);
    else {
        PyErr_SetString(PyExc_TypeError, "color should be a GdkColor");
        return NULL;
    }

    gdk_gc_set_rgb_fg_color(GDK_GC(self->obj), color);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_gc_set_rgb_bg_color(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_color;
    static char *kwlist[] = { "color", NULL };
    GdkColor *color = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:GdkGC.set_rgb_bg_color", kwlist, &py_color))
        return NULL;
    if (pyg_boxed_check(py_color, GDK_TYPE_COLOR))
        color = pyg_boxed_get(py_color, GdkColor);
    else {
        PyErr_SetString(PyExc_TypeError, "color should be a GdkColor");
        return NULL;
    }

    gdk_gc_set_rgb_bg_color(GDK_GC(self->obj), color);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyMethodDef _PyGdkGC_methods[] = {
    { "set_foreground", (PyCFunction)_wrap_gdk_gc_set_foreground, METH_VARARGS|METH_KEYWORDS },
    { "set_background", (PyCFunction)_wrap_gdk_gc_set_background, METH_VARARGS|METH_KEYWORDS },
    { "set_font", (PyCFunction)_wrap_gdk_gc_set_font, METH_VARARGS|METH_KEYWORDS },
    { "set_function", (PyCFunction)_wrap_gdk_gc_set_function, METH_VARARGS|METH_KEYWORDS },
    { "set_fill", (PyCFunction)_wrap_gdk_gc_set_fill, METH_VARARGS|METH_KEYWORDS },
    { "set_tile", (PyCFunction)_wrap_gdk_gc_set_tile, METH_VARARGS|METH_KEYWORDS },
    { "set_stipple", (PyCFunction)_wrap_gdk_gc_set_stipple, METH_VARARGS|METH_KEYWORDS },
    { "set_ts_origin", (PyCFunction)_wrap_gdk_gc_set_ts_origin, METH_VARARGS|METH_KEYWORDS },
    { "set_clip_origin", (PyCFunction)_wrap_gdk_gc_set_clip_origin, METH_VARARGS|METH_KEYWORDS },
    { "set_clip_mask", (PyCFunction)_wrap_gdk_gc_set_clip_mask, METH_VARARGS|METH_KEYWORDS },
    { "set_clip_rectangle", (PyCFunction)_wrap_gdk_gc_set_clip_rectangle, METH_VARARGS|METH_KEYWORDS },
    { "set_subwindow", (PyCFunction)_wrap_gdk_gc_set_subwindow, METH_VARARGS|METH_KEYWORDS },
    { "set_exposures", (PyCFunction)_wrap_gdk_gc_set_exposures, METH_VARARGS|METH_KEYWORDS },
    { "set_line_attributes", (PyCFunction)_wrap_gdk_gc_set_line_attributes, METH_VARARGS|METH_KEYWORDS },
    { "copy", (PyCFunction)_wrap_gdk_gc_copy, METH_VARARGS|METH_KEYWORDS },
    { "set_colormap", (PyCFunction)_wrap_gdk_gc_set_colormap, METH_VARARGS|METH_KEYWORDS },
    { "get_colormap", (PyCFunction)_wrap_gdk_gc_get_colormap, METH_VARARGS|METH_KEYWORDS },
    { "set_rgb_fg_color", (PyCFunction)_wrap_gdk_gc_set_rgb_fg_color, METH_VARARGS|METH_KEYWORDS },
    { "set_rgb_bg_color", (PyCFunction)_wrap_gdk_gc_set_rgb_bg_color, METH_VARARGS|METH_KEYWORDS },
    { NULL, NULL, 0 }
};

PyTypeObject PyGdkGC_Type = {
    PyObject_HEAD_INIT(NULL)
    0,				/* ob_size */
    "GC",		/* tp_name */
    sizeof(PyGObject),		/* tp_basicsize */
    0,				/* tp_itemsize */
    /* methods */
    (destructor)0,			/* tp_dealloc */
    (printfunc)0,			/* tp_print */
    (getattrfunc)0,			/* tp_getattr */
    (setattrfunc)0,			/* tp_setattr */
    (cmpfunc)0,			/* tp_compare */
    (reprfunc)0,			/* tp_repr */
    0,				/* tp_as_number */
    0,				/* tp_as_sequence */
    0,				/* tp_as_mapping */
    (hashfunc)0,			/* tp_hash */
    (ternaryfunc)0,			/* tp_call */
    (reprfunc)0,			/* tp_str */
    (getattrofunc)0,		/* tp_getattro */
    (setattrofunc)0,		/* tp_setattro */
    0,				/* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /* tp_flags */
    NULL, /* Documentation string */
    (traverseproc)0,		/* tp_traverse */
    (inquiry)0,			/* tp_clear */
    (richcmpfunc)0,			/* tp_richcompare */
    offsetof(PyGObject, weakreflist), /* tp_weaklistoffset */
    (getiterfunc)0,			/* tp_iter */
    (iternextfunc)0,		/* tp_iternext */
    _PyGdkGC_methods,			/* tp_methods */
    0,				/* tp_members */
    0,			/* tp_getset */
    NULL,				/* tp_base */
    NULL,				/* tp_dict */
    (descrgetfunc)0,		/* tp_descr_get */
    (descrsetfunc)0,		/* tp_descr_set */
    offsetof(PyGObject, inst_dict),	/* tp_dictoffset */
    (initproc)pygobject_no_constructor,		/* tp_init */
};



/* ----------- GdkImage ----------- */

static int
_wrap_gdk_image_new(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_type = NULL;
    static char *kwlist[] = { "type", "visual", "width", "height", NULL };
    int width, height;
    GdkImageType type;
    PyGObject *visual;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOii:GdkImage.__init__", kwlist, &py_type, &visual, &width, &height))
        return -1;
    if (pyg_enum_get_value(GDK_TYPE_IMAGE_TYPE, py_type, (gint *)&type))
        return -1;
    if (!pygobject_check(visual, &PyGdkVisual_Type)) {
        PyErr_SetString(PyExc_TypeError, "visual should be a GdkVisual");
        return -1;
    }

    self->obj = (GObject *)gdk_image_new(type, GDK_VISUAL(visual->obj), width, height);
    if (!self->obj) {
        PyErr_SetString(PyExc_RuntimeError, "could not create GdkImage object");
        return -1;
    }
    pygobject_register_wrapper((PyObject *)self);
    return 0;
}

static PyObject *
_wrap_gdk_image_put_pixel(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int x, y, pixel;
    static char *kwlist[] = { "x", "y", "pixel", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "iii:GdkImage.put_pixel", kwlist, &x, &y, &pixel))
        return NULL;

    gdk_image_put_pixel(GDK_IMAGE(self->obj), x, y, pixel);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_image_get_pixel(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int x, y;
    static char *kwlist[] = { "x", "y", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "ii:GdkImage.get_pixel", kwlist, &x, &y))
        return NULL;

    return PyInt_FromLong(gdk_image_get_pixel(GDK_IMAGE(self->obj), x, y));
}

static PyMethodDef _PyGdkImage_methods[] = {
    { "put_pixel", (PyCFunction)_wrap_gdk_image_put_pixel, METH_VARARGS|METH_KEYWORDS },
    { "get_pixel", (PyCFunction)_wrap_gdk_image_get_pixel, METH_VARARGS|METH_KEYWORDS },
    { NULL, NULL, 0 }
};

PyTypeObject PyGdkImage_Type = {
    PyObject_HEAD_INIT(NULL)
    0,				/* ob_size */
    "Image",		/* tp_name */
    sizeof(PyGObject),		/* tp_basicsize */
    0,				/* tp_itemsize */
    /* methods */
    (destructor)0,			/* tp_dealloc */
    (printfunc)0,			/* tp_print */
    (getattrfunc)0,			/* tp_getattr */
    (setattrfunc)0,			/* tp_setattr */
    (cmpfunc)0,			/* tp_compare */
    (reprfunc)0,			/* tp_repr */
    0,				/* tp_as_number */
    0,				/* tp_as_sequence */
    0,				/* tp_as_mapping */
    (hashfunc)0,			/* tp_hash */
    (ternaryfunc)0,			/* tp_call */
    (reprfunc)0,			/* tp_str */
    (getattrofunc)0,		/* tp_getattro */
    (setattrofunc)0,		/* tp_setattro */
    0,				/* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /* tp_flags */
    NULL, /* Documentation string */
    (traverseproc)0,		/* tp_traverse */
    (inquiry)0,			/* tp_clear */
    (richcmpfunc)0,			/* tp_richcompare */
    offsetof(PyGObject, weakreflist), /* tp_weaklistoffset */
    (getiterfunc)0,			/* tp_iter */
    (iternextfunc)0,		/* tp_iternext */
    _PyGdkImage_methods,			/* tp_methods */
    0,				/* tp_members */
    0,			/* tp_getset */
    NULL,				/* tp_base */
    NULL,				/* tp_dict */
    (descrgetfunc)0,		/* tp_descr_get */
    (descrsetfunc)0,		/* tp_descr_set */
    offsetof(PyGObject, inst_dict),	/* tp_dictoffset */
    (initproc)_wrap_gdk_image_new,		/* tp_init */
};



/* ----------- GdkPixbuf ----------- */

static int
_wrap_gdk_pixbuf_new(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_colorspace = NULL;
    static char *kwlist[] = { "colorspace", "has_alpha", "bits_per_sample", "width", "height", NULL };
    int has_alpha, bits_per_sample, width, height;
    GdkColorspace colorspace;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "Oiiii:GdkPixbuf.__init__", kwlist, &py_colorspace, &has_alpha, &bits_per_sample, &width, &height))
        return -1;
    if (pyg_enum_get_value(GDK_TYPE_COLORSPACE, py_colorspace, (gint *)&colorspace))
        return -1;

    self->obj = (GObject *)gdk_pixbuf_new(colorspace, has_alpha, bits_per_sample, width, height);
    if (!self->obj) {
        PyErr_SetString(PyExc_RuntimeError, "could not create GdkPixbuf object");
        return -1;
    }
    pygobject_register_wrapper((PyObject *)self);
    return 0;
}

static PyObject *
_wrap_gdk_pixbuf_get_colorspace(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkPixbuf.get_colorspace", kwlist))
        return NULL;

    return PyInt_FromLong(gdk_pixbuf_get_colorspace(GDK_PIXBUF(self->obj)));
}

static PyObject *
_wrap_gdk_pixbuf_get_n_channels(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkPixbuf.get_n_channels", kwlist))
        return NULL;

    return PyInt_FromLong(gdk_pixbuf_get_n_channels(GDK_PIXBUF(self->obj)));
}

static PyObject *
_wrap_gdk_pixbuf_get_has_alpha(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkPixbuf.get_has_alpha", kwlist))
        return NULL;

    return PyInt_FromLong(gdk_pixbuf_get_has_alpha(GDK_PIXBUF(self->obj)));
}

static PyObject *
_wrap_gdk_pixbuf_get_bits_per_sample(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkPixbuf.get_bits_per_sample", kwlist))
        return NULL;

    return PyInt_FromLong(gdk_pixbuf_get_bits_per_sample(GDK_PIXBUF(self->obj)));
}

static PyObject *
_wrap_gdk_pixbuf_get_width(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkPixbuf.get_width", kwlist))
        return NULL;

    return PyInt_FromLong(gdk_pixbuf_get_width(GDK_PIXBUF(self->obj)));
}

static PyObject *
_wrap_gdk_pixbuf_get_height(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkPixbuf.get_height", kwlist))
        return NULL;

    return PyInt_FromLong(gdk_pixbuf_get_height(GDK_PIXBUF(self->obj)));
}

static PyObject *
_wrap_gdk_pixbuf_get_rowstride(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkPixbuf.get_rowstride", kwlist))
        return NULL;

    return PyInt_FromLong(gdk_pixbuf_get_rowstride(GDK_PIXBUF(self->obj)));
}

static PyObject *
_wrap_gdk_pixbuf_copy(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkPixbuf.copy", kwlist))
        return NULL;

    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)gdk_pixbuf_copy(GDK_PIXBUF(self->obj)));
}

static PyObject *
_wrap_gdk_pixbuf_add_alpha(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int substitute_color;
    static char *kwlist[] = { "substitute_color", "r", "g", "b", NULL };
    char r, g, b;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "iccc:GdkPixbuf.add_alpha", kwlist, &substitute_color, &r, &g, &b))
        return NULL;

    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)gdk_pixbuf_add_alpha(GDK_PIXBUF(self->obj), substitute_color, r, g, b));
}

static PyObject *
_wrap_gdk_pixbuf_copy_area(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int src_x, src_y, width, height, dest_x, dest_y;
    static char *kwlist[] = { "src_x", "src_y", "width", "height", "dest_pixbuf", "dest_x", "dest_y", NULL };
    PyGObject *dest_pixbuf;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "iiiiOii:GdkPixbuf.copy_area", kwlist, &src_x, &src_y, &width, &height, &dest_pixbuf, &dest_x, &dest_y))
        return NULL;
    if (!pygobject_check(dest_pixbuf, &PyGdkPixbuf_Type)) {
        PyErr_SetString(PyExc_TypeError, "dest_pixbuf should be a GdkPixbuf");
        return NULL;
    }

    gdk_pixbuf_copy_area(GDK_PIXBUF(self->obj), src_x, src_y, width, height, GDK_PIXBUF(dest_pixbuf->obj), dest_x, dest_y);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_pixbuf_saturate_and_pixelate(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *dest;
    static char *kwlist[] = { "dest", "saturation", "pixelate", NULL };
    int pixelate;
    double saturation;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "Odi:GdkPixbuf.saturate_and_pixelate", kwlist, &dest, &saturation, &pixelate))
        return NULL;
    if (!pygobject_check(dest, &PyGdkPixbuf_Type)) {
        PyErr_SetString(PyExc_TypeError, "dest should be a GdkPixbuf");
        return NULL;
    }

    gdk_pixbuf_saturate_and_pixelate(GDK_PIXBUF(self->obj), GDK_PIXBUF(dest->obj), saturation, pixelate);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_pixbuf_scale(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_interp_type = NULL;
    int dest_x, dest_y, dest_width, dest_height;
    double offset_x, offset_y, scale_x, scale_y;
    PyGObject *dest;
    static char *kwlist[] = { "dest", "dest_x", "dest_y", "dest_width", "dest_height", "offset_x", "offset_y", "scale_x", "scale_y", "interp_type", NULL };
    GdkInterpType interp_type;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiiiiddddO:GdkPixbuf.scale", kwlist, &dest, &dest_x, &dest_y, &dest_width, &dest_height, &offset_x, &offset_y, &scale_x, &scale_y, &py_interp_type))
        return NULL;
    if (!pygobject_check(dest, &PyGdkPixbuf_Type)) {
        PyErr_SetString(PyExc_TypeError, "dest should be a GdkPixbuf");
        return NULL;
    }
    if (pyg_enum_get_value(GDK_TYPE_INTERP_TYPE, py_interp_type, (gint *)&interp_type))
        return NULL;

    gdk_pixbuf_scale(GDK_PIXBUF(self->obj), GDK_PIXBUF(dest->obj), dest_x, dest_y, dest_width, dest_height, offset_x, offset_y, scale_x, scale_y, interp_type);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_pixbuf_composite(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_interp_type = NULL;
    int dest_x, dest_y, dest_width, dest_height, overall_alpha;
    double offset_x, offset_y, scale_x, scale_y;
    PyGObject *dest;
    static char *kwlist[] = { "dest", "dest_x", "dest_y", "dest_width", "dest_height", "offset_x", "offset_y", "scale_x", "scale_y", "interp_type", "overall_alpha", NULL };
    GdkInterpType interp_type;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiiiiddddOi:GdkPixbuf.composite", kwlist, &dest, &dest_x, &dest_y, &dest_width, &dest_height, &offset_x, &offset_y, &scale_x, &scale_y, &py_interp_type, &overall_alpha))
        return NULL;
    if (!pygobject_check(dest, &PyGdkPixbuf_Type)) {
        PyErr_SetString(PyExc_TypeError, "dest should be a GdkPixbuf");
        return NULL;
    }
    if (pyg_enum_get_value(GDK_TYPE_INTERP_TYPE, py_interp_type, (gint *)&interp_type))
        return NULL;

    gdk_pixbuf_composite(GDK_PIXBUF(self->obj), GDK_PIXBUF(dest->obj), dest_x, dest_y, dest_width, dest_height, offset_x, offset_y, scale_x, scale_y, interp_type, overall_alpha);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_pixbuf_composite_color(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_interp_type = NULL;
    int dest_x, dest_y, dest_width, dest_height, overall_alpha, check_x, check_y, check_size, color1, color2;
    double offset_x, offset_y, scale_x, scale_y;
    PyGObject *dest;
    static char *kwlist[] = { "dest", "dest_x", "dest_y", "dest_width", "dest_height", "offset_x", "offset_y", "scale_x", "scale_y", "interp_type", "overall_alpha", "check_x", "check_y", "check_size", "color1", "color2", NULL };
    GdkInterpType interp_type;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiiiiddddOiiiiii:GdkPixbuf.composite_color", kwlist, &dest, &dest_x, &dest_y, &dest_width, &dest_height, &offset_x, &offset_y, &scale_x, &scale_y, &py_interp_type, &overall_alpha, &check_x, &check_y, &check_size, &color1, &color2))
        return NULL;
    if (!pygobject_check(dest, &PyGdkPixbuf_Type)) {
        PyErr_SetString(PyExc_TypeError, "dest should be a GdkPixbuf");
        return NULL;
    }
    if (pyg_enum_get_value(GDK_TYPE_INTERP_TYPE, py_interp_type, (gint *)&interp_type))
        return NULL;

    gdk_pixbuf_composite_color(GDK_PIXBUF(self->obj), GDK_PIXBUF(dest->obj), dest_x, dest_y, dest_width, dest_height, offset_x, offset_y, scale_x, scale_y, interp_type, overall_alpha, check_x, check_y, check_size, color1, color2);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_pixbuf_scale_simple(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int dest_width, dest_height;
    static char *kwlist[] = { "dest_width", "dest_height", "interp_type", NULL };
    PyObject *py_interp_type = NULL;
    GdkInterpType interp_type;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "iiO:GdkPixbuf.scale_simple", kwlist, &dest_width, &dest_height, &py_interp_type))
        return NULL;
    if (pyg_enum_get_value(GDK_TYPE_INTERP_TYPE, py_interp_type, (gint *)&interp_type))
        return NULL;

    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)gdk_pixbuf_scale_simple(GDK_PIXBUF(self->obj), dest_width, dest_height, interp_type));
}

static PyObject *
_wrap_gdk_pixbuf_composite_color_simple(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int dest_width, dest_height, overall_alpha, check_size, color1, color2;
    static char *kwlist[] = { "dest_width", "dest_height", "interp_type", "overall_alpha", "check_size", "color1", "color2", NULL };
    PyObject *py_interp_type = NULL;
    GdkInterpType interp_type;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "iiOiiii:GdkPixbuf.composite_color_simple", kwlist, &dest_width, &dest_height, &py_interp_type, &overall_alpha, &check_size, &color1, &color2))
        return NULL;
    if (pyg_enum_get_value(GDK_TYPE_INTERP_TYPE, py_interp_type, (gint *)&interp_type))
        return NULL;

    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)gdk_pixbuf_composite_color_simple(GDK_PIXBUF(self->obj), dest_width, dest_height, interp_type, overall_alpha, check_size, color1, color2));
}

static PyObject *
_wrap_gdk_pixbuf_render_to_drawable(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *drawable, *gc;
    static char *kwlist[] = { "drawable", "gc", "src_x", "src_y", "dest_x", "dest_y", "width", "height", "dither", "x_dither", "y_dither", NULL };
    int src_x, src_y, dest_x, dest_y, width, height, x_dither, y_dither;
    PyObject *py_dither = NULL;
    GdkRgbDither dither;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOiiiiiiOii:GdkPixbuf.render_to_drawable", kwlist, &drawable, &gc, &src_x, &src_y, &dest_x, &dest_y, &width, &height, &py_dither, &x_dither, &y_dither))
        return NULL;
    if (!pygobject_check(drawable, &PyGdkDrawable_Type)) {
        PyErr_SetString(PyExc_TypeError, "drawable should be a GdkDrawable");
        return NULL;
    }
    if (!pygobject_check(gc, &PyGdkGC_Type)) {
        PyErr_SetString(PyExc_TypeError, "gc should be a GdkGC");
        return NULL;
    }
    if (pyg_enum_get_value(GDK_TYPE_RGB_DITHER, py_dither, (gint *)&dither))
        return NULL;

    gdk_pixbuf_render_to_drawable(GDK_PIXBUF(self->obj), GDK_DRAWABLE(drawable->obj), GDK_GC(gc->obj), src_x, src_y, dest_x, dest_y, width, height, dither, x_dither, y_dither);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_pixbuf_render_to_drawable_alpha(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_alpha_mode = NULL, *py_dither = NULL;
    int src_x, src_y, dest_x, dest_y, width, height, alpha_threshold, x_dither, y_dither;
    GdkPixbufAlphaMode alpha_mode;
    GdkRgbDither dither;
    PyGObject *drawable;
    static char *kwlist[] = { "drawable", "src_x", "src_y", "dest_x", "dest_y", "width", "height", "alpha_mode", "alpha_threshold", "dither", "x_dither", "y_dither", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiiiiiiOiOii:GdkPixbuf.render_to_drawable_alpha", kwlist, &drawable, &src_x, &src_y, &dest_x, &dest_y, &width, &height, &py_alpha_mode, &alpha_threshold, &py_dither, &x_dither, &y_dither))
        return NULL;
    if (!pygobject_check(drawable, &PyGdkDrawable_Type)) {
        PyErr_SetString(PyExc_TypeError, "drawable should be a GdkDrawable");
        return NULL;
    }
    if (pyg_enum_get_value(GDK_TYPE_PIXBUF_ALPHA_MODE, py_alpha_mode, (gint *)&alpha_mode))
        return NULL;
    if (pyg_enum_get_value(GDK_TYPE_RGB_DITHER, py_dither, (gint *)&dither))
        return NULL;

    gdk_pixbuf_render_to_drawable_alpha(GDK_PIXBUF(self->obj), GDK_DRAWABLE(drawable->obj), src_x, src_y, dest_x, dest_y, width, height, alpha_mode, alpha_threshold, dither, x_dither, y_dither);
    Py_INCREF(Py_None);
    return Py_None;
}

#line 1432 "gdk.override"
static PyObject *
_wrap_gdk_pixbuf_render_pixmap_and_mask(PyGObject *self, PyObject *args,
					PyObject *kwargs)
{
    static char *kwlist[] = { "alpha_threshold", NULL};
    int alpha_threshold = 127;
    GdkPixmap *pixmap;
    GdkBitmap *mask;
    PyObject *pypixmap, *pymask, *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,
				     "|i:GdkPixbuf.render_pixmap_and_mask", kwlist,
				     &alpha_threshold))
	return NULL;
    gdk_pixbuf_render_pixmap_and_mask(GDK_PIXBUF(self->obj), &pixmap, &mask,
				      alpha_threshold);

    if (pixmap) {
	pypixmap = pygobject_new((GObject *) pixmap);
	gdk_pixmap_unref(pixmap);
    } else {
	Py_INCREF(Py_None);
	pypixmap = Py_None;
    }

    if (mask) {
	pymask = pygobject_new((GObject *) mask);
	gdk_bitmap_unref(mask);
    } else {
	Py_INCREF(Py_None);
	pymask = Py_None;
    }
    
    ret = Py_BuildValue("(NN)", pypixmap, pymask);
    return ret;
}

#line 4729 "gdk.c"


static PyObject *
_wrap_gdk_pixbuf_get_from_drawable(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *src, *cmap;
    static char *kwlist[] = { "src", "cmap", "src_x", "src_y", "dest_x", "dest_y", "width", "height", NULL };
    int src_x, src_y, dest_x, dest_y, width, height;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOiiiiii:GdkPixbuf.get_from_drawable", kwlist, &src, &cmap, &src_x, &src_y, &dest_x, &dest_y, &width, &height))
        return NULL;
    if (!pygobject_check(src, &PyGdkDrawable_Type)) {
        PyErr_SetString(PyExc_TypeError, "src should be a GdkDrawable");
        return NULL;
    }
    if (!pygobject_check(cmap, &PyGdkColormap_Type)) {
        PyErr_SetString(PyExc_TypeError, "cmap should be a GdkColormap");
        return NULL;
    }

    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)gdk_pixbuf_get_from_drawable(GDK_PIXBUF(self->obj), GDK_DRAWABLE(src->obj), GDK_COLORMAP(cmap->obj), src_x, src_y, dest_x, dest_y, width, height));
}

static PyMethodDef _PyGdkPixbuf_methods[] = {
    { "get_colorspace", (PyCFunction)_wrap_gdk_pixbuf_get_colorspace, METH_VARARGS|METH_KEYWORDS },
    { "get_n_channels", (PyCFunction)_wrap_gdk_pixbuf_get_n_channels, METH_VARARGS|METH_KEYWORDS },
    { "get_has_alpha", (PyCFunction)_wrap_gdk_pixbuf_get_has_alpha, METH_VARARGS|METH_KEYWORDS },
    { "get_bits_per_sample", (PyCFunction)_wrap_gdk_pixbuf_get_bits_per_sample, METH_VARARGS|METH_KEYWORDS },
    { "get_width", (PyCFunction)_wrap_gdk_pixbuf_get_width, METH_VARARGS|METH_KEYWORDS },
    { "get_height", (PyCFunction)_wrap_gdk_pixbuf_get_height, METH_VARARGS|METH_KEYWORDS },
    { "get_rowstride", (PyCFunction)_wrap_gdk_pixbuf_get_rowstride, METH_VARARGS|METH_KEYWORDS },
    { "copy", (PyCFunction)_wrap_gdk_pixbuf_copy, METH_VARARGS|METH_KEYWORDS },
    { "add_alpha", (PyCFunction)_wrap_gdk_pixbuf_add_alpha, METH_VARARGS|METH_KEYWORDS },
    { "copy_area", (PyCFunction)_wrap_gdk_pixbuf_copy_area, METH_VARARGS|METH_KEYWORDS },
    { "saturate_and_pixelate", (PyCFunction)_wrap_gdk_pixbuf_saturate_and_pixelate, METH_VARARGS|METH_KEYWORDS },
    { "scale", (PyCFunction)_wrap_gdk_pixbuf_scale, METH_VARARGS|METH_KEYWORDS },
    { "composite", (PyCFunction)_wrap_gdk_pixbuf_composite, METH_VARARGS|METH_KEYWORDS },
    { "composite_color", (PyCFunction)_wrap_gdk_pixbuf_composite_color, METH_VARARGS|METH_KEYWORDS },
    { "scale_simple", (PyCFunction)_wrap_gdk_pixbuf_scale_simple, METH_VARARGS|METH_KEYWORDS },
    { "composite_color_simple", (PyCFunction)_wrap_gdk_pixbuf_composite_color_simple, METH_VARARGS|METH_KEYWORDS },
    { "render_to_drawable", (PyCFunction)_wrap_gdk_pixbuf_render_to_drawable, METH_VARARGS|METH_KEYWORDS },
    { "render_to_drawable_alpha", (PyCFunction)_wrap_gdk_pixbuf_render_to_drawable_alpha, METH_VARARGS|METH_KEYWORDS },
    { "render_pixmap_and_mask", (PyCFunction)_wrap_gdk_pixbuf_render_pixmap_and_mask, METH_VARARGS|METH_KEYWORDS },
    { "get_from_drawable", (PyCFunction)_wrap_gdk_pixbuf_get_from_drawable, METH_VARARGS|METH_KEYWORDS },
    { NULL, NULL, 0 }
};

PyTypeObject PyGdkPixbuf_Type = {
    PyObject_HEAD_INIT(NULL)
    0,				/* ob_size */
    "Pixbuf",		/* tp_name */
    sizeof(PyGObject),		/* tp_basicsize */
    0,				/* tp_itemsize */
    /* methods */
    (destructor)0,			/* tp_dealloc */
    (printfunc)0,			/* tp_print */
    (getattrfunc)0,			/* tp_getattr */
    (setattrfunc)0,			/* tp_setattr */
    (cmpfunc)0,			/* tp_compare */
    (reprfunc)0,			/* tp_repr */
    0,				/* tp_as_number */
    0,				/* tp_as_sequence */
    0,				/* tp_as_mapping */
    (hashfunc)0,			/* tp_hash */
    (ternaryfunc)0,			/* tp_call */
    (reprfunc)0,			/* tp_str */
    (getattrofunc)0,		/* tp_getattro */
    (setattrofunc)0,		/* tp_setattro */
    0,				/* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /* tp_flags */
    NULL, /* Documentation string */
    (traverseproc)0,		/* tp_traverse */
    (inquiry)0,			/* tp_clear */
    (richcmpfunc)0,			/* tp_richcompare */
    offsetof(PyGObject, weakreflist), /* tp_weaklistoffset */
    (getiterfunc)0,			/* tp_iter */
    (iternextfunc)0,		/* tp_iternext */
    _PyGdkPixbuf_methods,			/* tp_methods */
    0,				/* tp_members */
    0,			/* tp_getset */
    NULL,				/* tp_base */
    NULL,				/* tp_dict */
    (descrgetfunc)0,		/* tp_descr_get */
    (descrsetfunc)0,		/* tp_descr_set */
    offsetof(PyGObject, inst_dict),	/* tp_dictoffset */
    (initproc)_wrap_gdk_pixbuf_new,		/* tp_init */
};



/* ----------- GdkPixbufAnimation ----------- */

static int
_wrap_gdk_pixbuf_animation_new_from_file(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    char *filename;
    static char *kwlist[] = { "filename", "error", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s:GdkPixbufAnimation.__init__", kwlist, &filename))
        return -1;

    self->obj = (GObject *)gdk_pixbuf_animation_new_from_file(filename, NULL);
    if (!self->obj) {
        PyErr_SetString(PyExc_RuntimeError, "could not create GdkPixbufAnimation object");
        return -1;
    }
    pygobject_register_wrapper((PyObject *)self);
    return 0;
}

static PyObject *
_wrap_gdk_pixbuf_animation_get_width(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkPixbufAnimation.get_width", kwlist))
        return NULL;

    return PyInt_FromLong(gdk_pixbuf_animation_get_width(GDK_PIXBUF_ANIMATION(self->obj)));
}

static PyObject *
_wrap_gdk_pixbuf_animation_get_height(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkPixbufAnimation.get_height", kwlist))
        return NULL;

    return PyInt_FromLong(gdk_pixbuf_animation_get_height(GDK_PIXBUF_ANIMATION(self->obj)));
}

static PyObject *
_wrap_gdk_pixbuf_animation_is_static_image(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkPixbufAnimation.is_static_image", kwlist))
        return NULL;

    return PyInt_FromLong(gdk_pixbuf_animation_is_static_image(GDK_PIXBUF_ANIMATION(self->obj)));
}

static PyObject *
_wrap_gdk_pixbuf_animation_get_static_image(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkPixbufAnimation.get_static_image", kwlist))
        return NULL;

    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)gdk_pixbuf_animation_get_static_image(GDK_PIXBUF_ANIMATION(self->obj)));
}

static PyMethodDef _PyGdkPixbufAnimation_methods[] = {
    { "get_width", (PyCFunction)_wrap_gdk_pixbuf_animation_get_width, METH_VARARGS|METH_KEYWORDS },
    { "get_height", (PyCFunction)_wrap_gdk_pixbuf_animation_get_height, METH_VARARGS|METH_KEYWORDS },
    { "is_static_image", (PyCFunction)_wrap_gdk_pixbuf_animation_is_static_image, METH_VARARGS|METH_KEYWORDS },
    { "get_static_image", (PyCFunction)_wrap_gdk_pixbuf_animation_get_static_image, METH_VARARGS|METH_KEYWORDS },
    { NULL, NULL, 0 }
};

PyTypeObject PyGdkPixbufAnimation_Type = {
    PyObject_HEAD_INIT(NULL)
    0,				/* ob_size */
    "PixbufAnimation",		/* tp_name */
    sizeof(PyGObject),		/* tp_basicsize */
    0,				/* tp_itemsize */
    /* methods */
    (destructor)0,			/* tp_dealloc */
    (printfunc)0,			/* tp_print */
    (getattrfunc)0,			/* tp_getattr */
    (setattrfunc)0,			/* tp_setattr */
    (cmpfunc)0,			/* tp_compare */
    (reprfunc)0,			/* tp_repr */
    0,				/* tp_as_number */
    0,				/* tp_as_sequence */
    0,				/* tp_as_mapping */
    (hashfunc)0,			/* tp_hash */
    (ternaryfunc)0,			/* tp_call */
    (reprfunc)0,			/* tp_str */
    (getattrofunc)0,		/* tp_getattro */
    (setattrofunc)0,		/* tp_setattro */
    0,				/* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /* tp_flags */
    NULL, /* Documentation string */
    (traverseproc)0,		/* tp_traverse */
    (inquiry)0,			/* tp_clear */
    (richcmpfunc)0,			/* tp_richcompare */
    offsetof(PyGObject, weakreflist), /* tp_weaklistoffset */
    (getiterfunc)0,			/* tp_iter */
    (iternextfunc)0,		/* tp_iternext */
    _PyGdkPixbufAnimation_methods,			/* tp_methods */
    0,				/* tp_members */
    0,			/* tp_getset */
    NULL,				/* tp_base */
    NULL,				/* tp_dict */
    (descrgetfunc)0,		/* tp_descr_get */
    (descrsetfunc)0,		/* tp_descr_set */
    offsetof(PyGObject, inst_dict),	/* tp_dictoffset */
    (initproc)_wrap_gdk_pixbuf_animation_new_from_file,		/* tp_init */
};



/* ----------- GdkPixbufAnimationIter ----------- */

static PyObject *
_wrap_gdk_pixbuf_animation_iter_get_delay_time(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkPixbufAnimationIter.get_delay_time", kwlist))
        return NULL;

    return PyInt_FromLong(gdk_pixbuf_animation_iter_get_delay_time(GDK_PIXBUF_ANIMATION_ITER(self->obj)));
}

static PyObject *
_wrap_gdk_pixbuf_animation_iter_get_pixbuf(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkPixbufAnimationIter.get_pixbuf", kwlist))
        return NULL;

    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)gdk_pixbuf_animation_iter_get_pixbuf(GDK_PIXBUF_ANIMATION_ITER(self->obj)));
}

static PyObject *
_wrap_gdk_pixbuf_animation_iter_on_currently_loading_frame(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GdkPixbufAnimationIter.on_currently_loading_frame", kwlist))
        return NULL;

    return PyInt_FromLong(gdk_pixbuf_animation_iter_on_currently_loading_frame(GDK_PIXBUF_ANIMATION_ITER(self->obj)));
}

static PyMethodDef _PyGdkPixbufAnimationIter_methods[] = {
    { "get_delay_time", (PyCFunction)_wrap_gdk_pixbuf_animation_iter_get_delay_time, METH_VARARGS|METH_KEYWORDS },
    { "get_pixbuf", (PyCFunction)_wrap_gdk_pixbuf_animation_iter_get_pixbuf, METH_VARARGS|METH_KEYWORDS },
    { "on_currently_loading_frame", (PyCFunction)_wrap_gdk_pixbuf_animation_iter_on_currently_loading_frame, METH_VARARGS|METH_KEYWORDS },
    { NULL, NULL, 0 }
};

PyTypeObject PyGdkPixbufAnimationIter_Type = {
    PyObject_HEAD_INIT(NULL)
    0,				/* ob_size */
    "PixbufAnimationIter",		/* tp_name */
    sizeof(PyGObject),		/* tp_basicsize */
    0,				/* tp_itemsize */
    /* methods */
    (destructor)0,			/* tp_dealloc */
    (printfunc)0,			/* tp_print */
    (getattrfunc)0,			/* tp_getattr */
    (setattrfunc)0,			/* tp_setattr */
    (cmpfunc)0,			/* tp_compare */
    (reprfunc)0,			/* tp_repr */
    0,				/* tp_as_number */
    0,				/* tp_as_sequence */
    0,				/* tp_as_mapping */
    (hashfunc)0,			/* tp_hash */
    (ternaryfunc)0,			/* tp_call */
    (reprfunc)0,			/* tp_str */
    (getattrofunc)0,		/* tp_getattro */
    (setattrofunc)0,		/* tp_setattro */
    0,				/* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /* tp_flags */
    NULL, /* Documentation string */
    (traverseproc)0,		/* tp_traverse */
    (inquiry)0,			/* tp_clear */
    (richcmpfunc)0,			/* tp_richcompare */
    offsetof(PyGObject, weakreflist), /* tp_weaklistoffset */
    (getiterfunc)0,			/* tp_iter */
    (iternextfunc)0,		/* tp_iternext */
    _PyGdkPixbufAnimationIter_methods,			/* tp_methods */
    0,				/* tp_members */
    0,			/* tp_getset */
    NULL,				/* tp_base */
    NULL,				/* tp_dict */
    (descrgetfunc)0,		/* tp_descr_get */
    (descrsetfunc)0,		/* tp_descr_set */
    offsetof(PyGObject, inst_dict),	/* tp_dictoffset */
    (initproc)pygobject_no_constructor,		/* tp_init */
};



/* ----------- GdkVisual ----------- */

static int
_wrap_gdk_visual_get_best_with_both(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int depth;
    static char *kwlist[] = { "depth", "visual_type", NULL };
    PyObject *py_visual_type = NULL;
    GdkVisualType visual_type;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "iO:GdkVisual.__init__", kwlist, &depth, &py_visual_type))
        return -1;
    if (pyg_enum_get_value(GDK_TYPE_VISUAL_TYPE, py_visual_type, (gint *)&visual_type))
        return -1;

    self->obj = (GObject *)gdk_visual_get_best_with_both(depth, visual_type);
    if (!self->obj) {
        PyErr_SetString(PyExc_RuntimeError, "could not create GdkVisual object");
        return -1;
    }
    pygobject_register_wrapper((PyObject *)self);
    return 0;
}

static PyMethodDef _PyGdkVisual_methods[] = {
    { NULL, NULL, 0 }
};

static PyObject *
_wrap_gdk_visual__get_type(PyGObject *self, void *closure)
{
    return PyInt_FromLong(GDK_VISUAL(self->obj)->type);
}

static PyObject *
_wrap_gdk_visual__get_depth(PyGObject *self, void *closure)
{
    return PyInt_FromLong(GDK_VISUAL(self->obj)->depth);
}

static PyObject *
_wrap_gdk_visual__get_byte_order(PyGObject *self, void *closure)
{
    return PyInt_FromLong(GDK_VISUAL(self->obj)->byte_order);
}

static PyObject *
_wrap_gdk_visual__get_colormap_size(PyGObject *self, void *closure)
{
    return PyInt_FromLong(GDK_VISUAL(self->obj)->colormap_size);
}

static PyObject *
_wrap_gdk_visual__get_bits_per_rgb(PyGObject *self, void *closure)
{
    return PyInt_FromLong(GDK_VISUAL(self->obj)->bits_per_rgb);
}

static PyObject *
_wrap_gdk_visual__get_red_mask(PyGObject *self, void *closure)
{
    return PyInt_FromLong(GDK_VISUAL(self->obj)->red_mask);
}

static PyObject *
_wrap_gdk_visual__get_red_shift(PyGObject *self, void *closure)
{
    return PyInt_FromLong(GDK_VISUAL(self->obj)->red_shift);
}

static PyObject *
_wrap_gdk_visual__get_red_prec(PyGObject *self, void *closure)
{
    return PyInt_FromLong(GDK_VISUAL(self->obj)->red_prec);
}

static PyObject *
_wrap_gdk_visual__get_green_mask(PyGObject *self, void *closure)
{
    return PyInt_FromLong(GDK_VISUAL(self->obj)->green_mask);
}

static PyObject *
_wrap_gdk_visual__get_green_shift(PyGObject *self, void *closure)
{
    return PyInt_FromLong(GDK_VISUAL(self->obj)->green_shift);
}

static PyObject *
_wrap_gdk_visual__get_green_prec(PyGObject *self, void *closure)
{
    return PyInt_FromLong(GDK_VISUAL(self->obj)->green_prec);
}

static PyObject *
_wrap_gdk_visual__get_blue_mask(PyGObject *self, void *closure)
{
    return PyInt_FromLong(GDK_VISUAL(self->obj)->blue_mask);
}

static PyObject *
_wrap_gdk_visual__get_blue_shift(PyGObject *self, void *closure)
{
    return PyInt_FromLong(GDK_VISUAL(self->obj)->blue_shift);
}

static PyObject *
_wrap_gdk_visual__get_blue_prec(PyGObject *self, void *closure)
{
    return PyInt_FromLong(GDK_VISUAL(self->obj)->blue_prec);
}

static PyGetSetDef gdk_visual_getsets[] = {
    { "type", (getter)_wrap_gdk_visual__get_type, (setter)0 },
    { "depth", (getter)_wrap_gdk_visual__get_depth, (setter)0 },
    { "byte_order", (getter)_wrap_gdk_visual__get_byte_order, (setter)0 },
    { "colormap_size", (getter)_wrap_gdk_visual__get_colormap_size, (setter)0 },
    { "bits_per_rgb", (getter)_wrap_gdk_visual__get_bits_per_rgb, (setter)0 },
    { "red_mask", (getter)_wrap_gdk_visual__get_red_mask, (setter)0 },
    { "red_shift", (getter)_wrap_gdk_visual__get_red_shift, (setter)0 },
    { "red_prec", (getter)_wrap_gdk_visual__get_red_prec, (setter)0 },
    { "green_mask", (getter)_wrap_gdk_visual__get_green_mask, (setter)0 },
    { "green_shift", (getter)_wrap_gdk_visual__get_green_shift, (setter)0 },
    { "green_prec", (getter)_wrap_gdk_visual__get_green_prec, (setter)0 },
    { "blue_mask", (getter)_wrap_gdk_visual__get_blue_mask, (setter)0 },
    { "blue_shift", (getter)_wrap_gdk_visual__get_blue_shift, (setter)0 },
    { "blue_prec", (getter)_wrap_gdk_visual__get_blue_prec, (setter)0 },
    { NULL, (getter)0, (setter)0 },
};

PyTypeObject PyGdkVisual_Type = {
    PyObject_HEAD_INIT(NULL)
    0,				/* ob_size */
    "Visual",		/* tp_name */
    sizeof(PyGObject),		/* tp_basicsize */
    0,				/* tp_itemsize */
    /* methods */
    (destructor)0,			/* tp_dealloc */
    (printfunc)0,			/* tp_print */
    (getattrfunc)0,			/* tp_getattr */
    (setattrfunc)0,			/* tp_setattr */
    (cmpfunc)0,			/* tp_compare */
    (reprfunc)0,			/* tp_repr */
    0,				/* tp_as_number */
    0,				/* tp_as_sequence */
    0,				/* tp_as_mapping */
    (hashfunc)0,			/* tp_hash */
    (ternaryfunc)0,			/* tp_call */
    (reprfunc)0,			/* tp_str */
    (getattrofunc)0,		/* tp_getattro */
    (setattrofunc)0,		/* tp_setattro */
    0,				/* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /* tp_flags */
    NULL, /* Documentation string */
    (traverseproc)0,		/* tp_traverse */
    (inquiry)0,			/* tp_clear */
    (richcmpfunc)0,			/* tp_richcompare */
    offsetof(PyGObject, weakreflist), /* tp_weaklistoffset */
    (getiterfunc)0,			/* tp_iter */
    (iternextfunc)0,		/* tp_iternext */
    _PyGdkVisual_methods,			/* tp_methods */
    0,				/* tp_members */
    gdk_visual_getsets,			/* tp_getset */
    NULL,				/* tp_base */
    NULL,				/* tp_dict */
    (descrgetfunc)0,		/* tp_descr_get */
    (descrsetfunc)0,		/* tp_descr_set */
    offsetof(PyGObject, inst_dict),	/* tp_dictoffset */
    (initproc)_wrap_gdk_visual_get_best_with_both,		/* tp_init */
};



/* ----------- functions ----------- */

static PyObject *
_wrap_gdk_screen_width(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":screen_width", kwlist))
        return NULL;

    return PyInt_FromLong(gdk_screen_width());
}

static PyObject *
_wrap_gdk_screen_height(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":screen_height", kwlist))
        return NULL;

    return PyInt_FromLong(gdk_screen_height());
}

static PyObject *
_wrap_gdk_screen_width_mm(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":screen_width_mm", kwlist))
        return NULL;

    return PyInt_FromLong(gdk_screen_width_mm());
}

static PyObject *
_wrap_gdk_screen_height_mm(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":screen_height_mm", kwlist))
        return NULL;

    return PyInt_FromLong(gdk_screen_height_mm());
}

static PyObject *
_wrap_gdk_flush(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":flush", kwlist))
        return NULL;

    gdk_flush();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_beep(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":beep", kwlist))
        return NULL;

    gdk_beep();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_set_double_click_time(PyObject *self, PyObject *args, PyObject *kwargs)
{
    int msec;
    static char *kwlist[] = { "msec", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "i:set_double_click_time", kwlist, &msec))
        return NULL;

    gdk_set_double_click_time(msec);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_colormap_get_system(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":colormap_get_system", kwlist))
        return NULL;

    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)gdk_colormap_get_system());
}

static PyObject *
_wrap_gdk_colormap_get_system_size(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":colormap_get_system_size", kwlist))
        return NULL;

    return PyInt_FromLong(gdk_colormap_get_system_size());
}

#line 219 "gdk.override"
static PyObject *
_wrap_gdk_color_parse(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "spec", NULL };
    const char *spec;
    GdkColor color;
    GdkColor *new_color;
    
    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s:color_parse", kwlist,
				     &spec))
        return NULL;

    gdk_color_parse (spec, &color);
    
    new_color = gdk_color_copy (&color);
    
    /* pyg_boxed_new handles NULL checking */    
    return pyg_boxed_new (GDK_TYPE_COLOR, new_color, FALSE, TRUE);
}
#line 5325 "gdk.c"


static PyObject *
_wrap_gdk_set_show_events(PyObject *self, PyObject *args, PyObject *kwargs)
{
    int show_events;
    static char *kwlist[] = { "show_events", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "i:set_show_events", kwlist, &show_events))
        return NULL;

    gdk_set_show_events(show_events);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_get_show_events(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":get_show_events", kwlist))
        return NULL;

    return PyInt_FromLong(gdk_get_show_events());
}

#line 240 "gdk.override"
static PyObject *
_wrap_gdk_fontset_load(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "fontset_name", NULL };
    char *fontset_name;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s:fontset_load", kwlist,
				     &fontset_name))
        return NULL;

    /* pyg_boxed_new handles NULL checking */
    return pyg_boxed_new(GDK_TYPE_FONT, gdk_fontset_load(fontset_name),
			 FALSE, TRUE);
}
#line 5368 "gdk.c"


static PyObject *
_wrap_gdk_font_from_description(PyObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_font_desc;
    static char *kwlist[] = { "font_desc", NULL };
    PangoFontDescription *font_desc = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:font_from_description", kwlist, &py_font_desc))
        return NULL;
    if (pyg_boxed_check(py_font_desc, PANGO_TYPE_FONT_DESCRIPTION))
        font_desc = pyg_boxed_get(py_font_desc, PangoFontDescription);
    else {
        PyErr_SetString(PyExc_TypeError, "font_desc should be a PangoFontDescription");
        return NULL;
    }

    /* pyg_boxed_new handles NULL checking */
    return pyg_boxed_new(GDK_TYPE_FONT, gdk_font_from_description(font_desc), TRUE, TRUE);
}

static PyObject *
_wrap_gdk_gc_new(PyObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *drawable;
    static char *kwlist[] = { "drawable", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:gc_new", kwlist, &drawable))
        return NULL;
    if (!pygobject_check(drawable, &PyGdkDrawable_Type)) {
        PyErr_SetString(PyExc_TypeError, "drawable should be a GdkDrawable");
        return NULL;
    }

    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)gdk_gc_new(GDK_DRAWABLE(drawable->obj)));
}

static PyObject *
_wrap_gdk_pixbuf_new_from_file(PyObject *self, PyObject *args, PyObject *kwargs)
{
    char *filename;
    static char *kwlist[] = { "filename", "error", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s:pixbuf_new_from_file", kwlist, &filename))
        return NULL;

    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)gdk_pixbuf_new_from_file(filename, NULL));
}

static PyObject *
_wrap_gdk_pixbuf_new_from_stream(PyObject *self, PyObject *args, PyObject *kwargs)
{
    int stream_length, stream_len, copy_pixels;
    static char *kwlist[] = { "stream_length", "stream", "copy_pixels", "error", NULL };
    guchar *stream;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "is#i:pixbuf_new_from_stream", kwlist, &stream_length, &stream, &stream_len, &copy_pixels))
        return NULL;

    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)gdk_pixbuf_new_from_stream(stream_length, stream, copy_pixels, NULL));
}

static PyObject *
_wrap_gdk_bitmap_create_from_data(PyObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *window;
    static char *kwlist[] = { "window", "data", "width", "height", NULL };
    char *data;
    int width, height;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "Osii:bitmap_create_from_data", kwlist, &window, &data, &width, &height))
        return NULL;
    if (!pygobject_check(window, &PyGdkWindow_Type)) {
        PyErr_SetString(PyExc_TypeError, "window should be a GdkWindow");
        return NULL;
    }

    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)gdk_bitmap_create_from_data(GDK_WINDOW(window->obj), data, width, height));
}

static PyObject *
_wrap_gdk_pixmap_create_from_data(PyObject *self, PyObject *args, PyObject *kwargs)
{
    char *data;
    PyObject *py_fg, *py_bg;
    int width, height, depth;
    PyGObject *window;
    static char *kwlist[] = { "window", "data", "width", "height", "depth", "fg", "bg", NULL };
    GdkColor *fg = NULL, *bg = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OsiiiOO:pixmap_create_from_data", kwlist, &window, &data, &width, &height, &depth, &py_fg, &py_bg))
        return NULL;
    if (!pygobject_check(window, &PyGdkWindow_Type)) {
        PyErr_SetString(PyExc_TypeError, "window should be a GdkWindow");
        return NULL;
    }
    if (pyg_boxed_check(py_fg, GDK_TYPE_COLOR))
        fg = pyg_boxed_get(py_fg, GdkColor);
    else {
        PyErr_SetString(PyExc_TypeError, "fg should be a GdkColor");
        return NULL;
    }
    if (pyg_boxed_check(py_bg, GDK_TYPE_COLOR))
        bg = pyg_boxed_get(py_bg, GdkColor);
    else {
        PyErr_SetString(PyExc_TypeError, "bg should be a GdkColor");
        return NULL;
    }

    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)gdk_pixmap_create_from_data(GDK_WINDOW(window->obj), data, width, height, depth, fg, bg));
}

#line 274 "gdk.override"
static PyObject *
_wrap_gdk_pixmap_create_from_xpm(PyObject *self, PyObject *args,
				 PyObject *kwargs)
{
    static char *kwlist[] = { "window", "transparent_color", "filename", NULL};
    PyGObject *window;
    PyObject *py_trans_color, *ret;
    GdkColor *trans_color = NULL;
    gchar *filename;
    GdkPixmap *pixmap;
    GdkBitmap *mask;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,
				     "OOs:pixmap_create_from_xpm", kwlist,
				     &window, &py_trans_color, &filename))
	return NULL;
    if (!pygobject_check(window, &PyGdkWindow_Type)) {
	PyErr_SetString(PyExc_TypeError, "window must be a GdkWindow");
	return NULL;
    }
    if (pyg_boxed_check(py_trans_color, GDK_TYPE_COLOR))
	trans_color = pyg_boxed_get(py_trans_color, GdkColor);
    else if (py_trans_color != Py_None) {
	PyErr_SetString(PyExc_TypeError,
			"transparent_color must be a colour or None");
	return NULL;
    }
    pixmap = gdk_pixmap_create_from_xpm(GDK_WINDOW(window->obj), &mask,
					trans_color, filename);
    if (pixmap == NULL) {
	PyErr_SetString(PyExc_IOError, "can't load pixmap");
	return NULL;
    }
    ret = Py_BuildValue("(NN)",
			pygobject_new((GObject *)pixmap),
			pygobject_new((GObject *)mask));
    gdk_pixmap_unref(pixmap);
    gdk_bitmap_unref(mask);
    return ret;
}
#line 5528 "gdk.c"


#line 316 "gdk.override"
static PyObject *
_wrap_gdk_pixmap_colormap_create_from_xpm(PyObject *self, PyObject *args,
					  PyObject *kwargs)
{
    static char *kwlist[] = { "window", "colormap", "transparent_color",
			      "filename", NULL };
    PyObject *py_window, *py_colormap, *py_trans_color, *ret;
    GdkWindow *window = NULL;
    GdkColormap *colormap = NULL;
    GdkColor *trans_color = NULL;
    gchar *filename;
    GdkPixmap *pixmap;
    GdkBitmap *mask;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,
				     "OOOs:pixmap_colormap_create_from_xpm",
				     kwlist, &py_window, &py_colormap,
				     &py_trans_color, &filename))
	return NULL;
    if (pygobject_check(py_window, &PyGdkWindow_Type))
	window = GDK_WINDOW(pygobject_get(py_window));
    else if (py_window != Py_None) {
	PyErr_SetString(PyExc_TypeError, "window must be a GdkWindow or None");
	return NULL;
    }
    if (pygobject_check(py_colormap, &PyGdkColormap_Type))
	colormap = GDK_COLORMAP(pygobject_get(py_colormap));
    else if (py_colormap != Py_None) {
	PyErr_SetString(PyExc_TypeError,
			"colormap must be a GdkColormap or None");
	return NULL;
    }
    if (pyg_boxed_check(py_trans_color, GDK_TYPE_COLOR))
	trans_color = pyg_boxed_get(py_trans_color, GdkColor);
    else if (py_trans_color != Py_None) {
	PyErr_SetString(PyExc_TypeError,
			"transparent_color must be a colour or None");
	return NULL;
    }
    pixmap = gdk_pixmap_colormap_create_from_xpm(window, colormap, &mask,
						 trans_color, filename);
    if (pixmap == NULL) {
	PyErr_SetString(PyExc_IOError, "can't load pixmap");
	return NULL;
    }
    ret = Py_BuildValue("(NN)",
			pygobject_new((GObject *)pixmap),
			pygobject_new((GObject *)mask));
    gdk_pixmap_unref(pixmap);
    gdk_bitmap_unref(mask);
    return ret;
}
#line 5584 "gdk.c"


#line 370 "gdk.override"
static PyObject *
_wrap_gdk_pixmap_create_from_xpm_d(PyObject *self, PyObject *args,
				   PyObject *kwargs)
{
    static char *kwlist[] = { "window", "transparent_color", "data", NULL };
    PyGObject *window;
    PyObject *py_trans_color, *py_data, *ret;
    GdkColor *trans_color = NULL;
    gchar **data;
    int len, i;
    GdkPixmap *pixmap;
    GdkBitmap *mask;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,
				     "O!OO!:pixmap_create_from_xpm_d", kwlist,
				     &window, &py_trans_color,
				     &PyList_Type, &py_data))
	return NULL;
    if (!pygobject_check(window, &PyGdkWindow_Type)) {
	PyErr_SetString(PyExc_TypeError, "window must be a GdkWindow");
	return NULL;
    }
    if (pyg_boxed_check(py_trans_color, GDK_TYPE_COLOR))
	trans_color = pyg_boxed_get(py_trans_color, GdkColor);
    else if (py_trans_color != Py_None) {
	PyErr_SetString(PyExc_TypeError,
			"transparent_color must be a colour or None");
	return NULL;
    }
    len = PyList_Size(py_data);
    data = g_new(gchar *, len);
    for (i = 0; i < len; i ++) {
	PyObject *item = PyList_GetItem(py_data, i);
	if (!PyString_Check(item)) {
	    PyErr_SetString(PyExc_TypeError, "data items must be strings");
	    g_free(data);
	    return NULL;
	}
	data[i] = PyString_AsString(item);
    }
    pixmap = gdk_pixmap_create_from_xpm_d(GDK_WINDOW(window->obj), &mask,
					  trans_color, data);
    g_free(data);
    if (pixmap == NULL) {
	PyErr_SetString(PyExc_IOError, "can't load pixmap");
	return NULL;
    }
    ret = Py_BuildValue("(NN)",
			pygobject_new((GObject *)pixmap),
			pygobject_new((GObject *)mask));
    gdk_pixmap_unref(pixmap);
    gdk_bitmap_unref(mask);
    return ret;
}
#line 5642 "gdk.c"


#line 426 "gdk.override"
static PyObject *
_wrap_gdk_pixmap_colormap_create_from_xpm_d(PyObject *self, PyObject *args,
					    PyObject *kwargs)
{
    static char *kwlist[] = { "window", "colormap", "transparent_color",
			      "data", NULL };
    PyObject *py_window, *py_colormap, *py_trans_color, *py_data, *ret;
    GdkWindow *window = NULL;
    GdkColormap *colormap = NULL;
    GdkColor *trans_color = NULL;
    gchar **data;
    int len, i;
    GdkPixmap *pixmap;
    GdkBitmap *mask;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,
				     "OOOO!:pixmap_colormap_create_from_xpm_d",
				     kwlist, &py_window, &py_colormap,
				     &py_trans_color,
				     &PyList_Type, &py_data))
	return NULL;
    if (pygobject_check(py_window, &PyGdkWindow_Type))
	window = GDK_WINDOW(pygobject_get(py_window));
    else if (py_window != Py_None) {
	PyErr_SetString(PyExc_TypeError, "window must be a GdkWindow or None");
	return NULL;
    }
    if (pygobject_check(py_colormap, &PyGdkColormap_Type))
	colormap = GDK_COLORMAP(pygobject_get(py_colormap));
    else if (py_colormap != Py_None) {
	PyErr_SetString(PyExc_TypeError,
			"colormap must be a GdkColormap or None");
	return NULL;
    }
    if (pyg_boxed_check(py_trans_color, GDK_TYPE_COLOR))
	trans_color = pyg_boxed_get(py_trans_color, GdkColor);
    else if (py_trans_color != Py_None) {
	PyErr_SetString(PyExc_TypeError,
			"transparent_color must be a colour or None");
	return NULL;
    }
    len = PyList_Size(py_data);
    data = g_new(gchar *, len);
    for (i = 0; i < len; i ++) {
	PyObject *item = PyList_GetItem(py_data, i);
	if (!PyString_Check(item)) {
	    PyErr_SetString(PyExc_TypeError, "data items must be strings");
	    g_free(data);
	    return NULL;
	}
	data[i] = PyString_AsString(item);
    }
    pixmap = gdk_pixmap_colormap_create_from_xpm_d(window, colormap, &mask,
						   trans_color, data);
    g_free(data);
    if (pixmap == NULL) {
	PyErr_SetString(PyExc_IOError, "can't load pixmap");
	return NULL;
    }
    ret = Py_BuildValue("(NN)",
			pygobject_new((GObject *)pixmap),
			pygobject_new((GObject *)mask));
    gdk_pixmap_unref(pixmap);
    gdk_bitmap_unref(mask);
    return ret;
}
#line 5712 "gdk.c"


static PyObject *
_wrap_gdk_rgb_xpixel_from_rgb(PyObject *self, PyObject *args, PyObject *kwargs)
{
    int rgb;
    static char *kwlist[] = { "rgb", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "i:rgb_xpixel_from_rgb", kwlist, &rgb))
        return NULL;

    return PyInt_FromLong(gdk_rgb_xpixel_from_rgb(rgb));
}

static PyObject *
_wrap_gdk_rgb_gc_set_foreground(PyObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *gc;
    static char *kwlist[] = { "gc", "rgb", NULL };
    int rgb;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "Oi:rgb_gc_set_foreground", kwlist, &gc, &rgb))
        return NULL;
    if (!pygobject_check(gc, &PyGdkGC_Type)) {
        PyErr_SetString(PyExc_TypeError, "gc should be a GdkGC");
        return NULL;
    }

    gdk_rgb_gc_set_foreground(GDK_GC(gc->obj), rgb);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_rgb_gc_set_background(PyObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *gc;
    static char *kwlist[] = { "gc", "rgb", NULL };
    int rgb;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "Oi:rgb_gc_set_background", kwlist, &gc, &rgb))
        return NULL;
    if (!pygobject_check(gc, &PyGdkGC_Type)) {
        PyErr_SetString(PyExc_TypeError, "gc should be a GdkGC");
        return NULL;
    }

    gdk_rgb_gc_set_background(GDK_GC(gc->obj), rgb);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_rgb_ditherable(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":rgb_ditherable", kwlist))
        return NULL;

    return PyInt_FromLong(gdk_rgb_ditherable());
}

static PyObject *
_wrap_gdk_rgb_set_verbose(PyObject *self, PyObject *args, PyObject *kwargs)
{
    int verbose;
    static char *kwlist[] = { "verbose", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "i:rgb_set_verbose", kwlist, &verbose))
        return NULL;

    gdk_rgb_set_verbose(verbose);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_rgb_set_install(PyObject *self, PyObject *args, PyObject *kwargs)
{
    int install;
    static char *kwlist[] = { "install", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "i:rgb_set_install", kwlist, &install))
        return NULL;

    gdk_rgb_set_install(install);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_rgb_set_min_colors(PyObject *self, PyObject *args, PyObject *kwargs)
{
    int min_colors;
    static char *kwlist[] = { "min_colors", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "i:rgb_set_min_colors", kwlist, &min_colors))
        return NULL;

    gdk_rgb_set_min_colors(min_colors);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_rgb_get_cmap(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":rgb_get_cmap", kwlist))
        return NULL;

    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)gdk_rgb_get_cmap());
}

static PyObject *
_wrap_gdk_rgb_get_visual(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":rgb_get_visual", kwlist))
        return NULL;

    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)gdk_rgb_get_visual());
}

static PyObject *
_wrap_gdk_selection_owner_get(PyObject *self, PyObject *args, PyObject *kwargs)
{
    int selection;
    static char *kwlist[] = { "selection", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "i:selection_owner_get", kwlist, &selection))
        return NULL;

    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)gdk_selection_owner_get(selection));
}

static PyObject *
_wrap_gdk_selection_send_notify(PyObject *self, PyObject *args, PyObject *kwargs)
{
    int requestor, selection, target, property, time;
    static char *kwlist[] = { "requestor", "selection", "target", "property", "time", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "iiiii:selection_send_notify", kwlist, &requestor, &selection, &target, &property, &time))
        return NULL;

    gdk_selection_send_notify(requestor, selection, target, property, time);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_visual_get_best_depth(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":visual_get_best_depth", kwlist))
        return NULL;

    return PyInt_FromLong(gdk_visual_get_best_depth());
}

static PyObject *
_wrap_gdk_visual_get_best_type(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":visual_get_best_type", kwlist))
        return NULL;

    return PyInt_FromLong(gdk_visual_get_best_type());
}

static PyObject *
_wrap_gdk_visual_get_system(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":visual_get_system", kwlist))
        return NULL;

    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)gdk_visual_get_system());
}

static PyObject *
_wrap_gdk_visual_get_best(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":visual_get_best", kwlist))
        return NULL;

    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)gdk_visual_get_best());
}

static PyObject *
_wrap_gdk_visual_get_best_with_depth(PyObject *self, PyObject *args, PyObject *kwargs)
{
    int depth;
    static char *kwlist[] = { "depth", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "i:visual_get_best_with_depth", kwlist, &depth))
        return NULL;

    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)gdk_visual_get_best_with_depth(depth));
}

static PyObject *
_wrap_gdk_visual_get_best_with_type(PyObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_visual_type = NULL;
    static char *kwlist[] = { "visual_type", NULL };
    GdkVisualType visual_type;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:visual_get_best_with_type", kwlist, &py_visual_type))
        return NULL;
    if (pyg_enum_get_value(GDK_TYPE_VISUAL_TYPE, py_visual_type, (gint *)&visual_type))
        return NULL;

    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)gdk_visual_get_best_with_type(visual_type));
}

static PyObject *
_wrap_gdk_set_sm_client_id(PyObject *self, PyObject *args, PyObject *kwargs)
{
    char *sm_client_id;
    static char *kwlist[] = { "sm_client_id", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s:set_sm_client_id", kwlist, &sm_client_id))
        return NULL;

    gdk_set_sm_client_id(sm_client_id);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gdk_get_default_root_window(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":get_default_root_window", kwlist))
        return NULL;

    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)gdk_get_default_root_window());
}

PyMethodDef pygdk_functions[] = {
    { "screen_width", (PyCFunction)_wrap_gdk_screen_width, METH_VARARGS|METH_KEYWORDS },
    { "screen_height", (PyCFunction)_wrap_gdk_screen_height, METH_VARARGS|METH_KEYWORDS },
    { "screen_width_mm", (PyCFunction)_wrap_gdk_screen_width_mm, METH_VARARGS|METH_KEYWORDS },
    { "screen_height_mm", (PyCFunction)_wrap_gdk_screen_height_mm, METH_VARARGS|METH_KEYWORDS },
    { "flush", (PyCFunction)_wrap_gdk_flush, METH_VARARGS|METH_KEYWORDS },
    { "beep", (PyCFunction)_wrap_gdk_beep, METH_VARARGS|METH_KEYWORDS },
    { "set_double_click_time", (PyCFunction)_wrap_gdk_set_double_click_time, METH_VARARGS|METH_KEYWORDS },
    { "colormap_get_system", (PyCFunction)_wrap_gdk_colormap_get_system, METH_VARARGS|METH_KEYWORDS },
    { "colormap_get_system_size", (PyCFunction)_wrap_gdk_colormap_get_system_size, METH_VARARGS|METH_KEYWORDS },
    { "color_parse", (PyCFunction)_wrap_gdk_color_parse, METH_VARARGS|METH_KEYWORDS },
    { "set_show_events", (PyCFunction)_wrap_gdk_set_show_events, METH_VARARGS|METH_KEYWORDS },
    { "get_show_events", (PyCFunction)_wrap_gdk_get_show_events, METH_VARARGS|METH_KEYWORDS },
    { "fontset_load", (PyCFunction)_wrap_gdk_fontset_load, METH_VARARGS|METH_KEYWORDS },
    { "font_from_description", (PyCFunction)_wrap_gdk_font_from_description, METH_VARARGS|METH_KEYWORDS },
    { "gc_new", (PyCFunction)_wrap_gdk_gc_new, METH_VARARGS|METH_KEYWORDS },
    { "pixbuf_new_from_file", (PyCFunction)_wrap_gdk_pixbuf_new_from_file, METH_VARARGS|METH_KEYWORDS },
    { "pixbuf_new_from_stream", (PyCFunction)_wrap_gdk_pixbuf_new_from_stream, METH_VARARGS|METH_KEYWORDS },
    { "bitmap_create_from_data", (PyCFunction)_wrap_gdk_bitmap_create_from_data, METH_VARARGS|METH_KEYWORDS },
    { "pixmap_create_from_data", (PyCFunction)_wrap_gdk_pixmap_create_from_data, METH_VARARGS|METH_KEYWORDS },
    { "pixmap_create_from_xpm", (PyCFunction)_wrap_gdk_pixmap_create_from_xpm, METH_VARARGS|METH_KEYWORDS },
    { "pixmap_colormap_create_from_xpm", (PyCFunction)_wrap_gdk_pixmap_colormap_create_from_xpm, METH_VARARGS|METH_KEYWORDS },
    { "pixmap_create_from_xpm_d", (PyCFunction)_wrap_gdk_pixmap_create_from_xpm_d, METH_VARARGS|METH_KEYWORDS },
    { "pixmap_colormap_create_from_xpm_d", (PyCFunction)_wrap_gdk_pixmap_colormap_create_from_xpm_d, METH_VARARGS|METH_KEYWORDS },
    { "rgb_xpixel_from_rgb", (PyCFunction)_wrap_gdk_rgb_xpixel_from_rgb, METH_VARARGS|METH_KEYWORDS },
    { "rgb_gc_set_foreground", (PyCFunction)_wrap_gdk_rgb_gc_set_foreground, METH_VARARGS|METH_KEYWORDS },
    { "rgb_gc_set_background", (PyCFunction)_wrap_gdk_rgb_gc_set_background, METH_VARARGS|METH_KEYWORDS },
    { "rgb_ditherable", (PyCFunction)_wrap_gdk_rgb_ditherable, METH_VARARGS|METH_KEYWORDS },
    { "rgb_set_verbose", (PyCFunction)_wrap_gdk_rgb_set_verbose, METH_VARARGS|METH_KEYWORDS },
    { "rgb_set_install", (PyCFunction)_wrap_gdk_rgb_set_install, METH_VARARGS|METH_KEYWORDS },
    { "rgb_set_min_colors", (PyCFunction)_wrap_gdk_rgb_set_min_colors, METH_VARARGS|METH_KEYWORDS },
    { "rgb_get_cmap", (PyCFunction)_wrap_gdk_rgb_get_cmap, METH_VARARGS|METH_KEYWORDS },
    { "rgb_get_visual", (PyCFunction)_wrap_gdk_rgb_get_visual, METH_VARARGS|METH_KEYWORDS },
    { "selection_owner_get", (PyCFunction)_wrap_gdk_selection_owner_get, METH_VARARGS|METH_KEYWORDS },
    { "selection_send_notify", (PyCFunction)_wrap_gdk_selection_send_notify, METH_VARARGS|METH_KEYWORDS },
    { "visual_get_best_depth", (PyCFunction)_wrap_gdk_visual_get_best_depth, METH_VARARGS|METH_KEYWORDS },
    { "visual_get_best_type", (PyCFunction)_wrap_gdk_visual_get_best_type, METH_VARARGS|METH_KEYWORDS },
    { "visual_get_system", (PyCFunction)_wrap_gdk_visual_get_system, METH_VARARGS|METH_KEYWORDS },
    { "visual_get_best", (PyCFunction)_wrap_gdk_visual_get_best, METH_VARARGS|METH_KEYWORDS },
    { "visual_get_best_with_depth", (PyCFunction)_wrap_gdk_visual_get_best_with_depth, METH_VARARGS|METH_KEYWORDS },
    { "visual_get_best_with_type", (PyCFunction)_wrap_gdk_visual_get_best_with_type, METH_VARARGS|METH_KEYWORDS },
    { "set_sm_client_id", (PyCFunction)_wrap_gdk_set_sm_client_id, METH_VARARGS|METH_KEYWORDS },
    { "get_default_root_window", (PyCFunction)_wrap_gdk_get_default_root_window, METH_VARARGS|METH_KEYWORDS },
    { NULL, NULL, 0 }
};


/* ----------- enums and flags ----------- */

void
pygdk_add_constants(PyObject *module, const gchar *strip_prefix)
{
    pyg_enum_add_constants(module, GDK_TYPE_CURSOR_TYPE, strip_prefix);
    pyg_flags_add_constants(module, GDK_TYPE_DRAG_ACTION, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_DRAG_PROTOCOL, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_FILTER_RETURN, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_EVENT_TYPE, strip_prefix);
    pyg_flags_add_constants(module, GDK_TYPE_EVENT_MASK, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_VISIBILITY_STATE, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_SCROLL_DIRECTION, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_NOTIFY_TYPE, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_CROSSING_MODE, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_PROPERTY_STATE, strip_prefix);
    pyg_flags_add_constants(module, GDK_TYPE_WINDOW_STATE, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_SETTING_ACTION, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_FONT_TYPE, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_CAP_STYLE, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_FILL, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_FUNCTION, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_JOIN_STYLE, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_LINE_STYLE, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_SUBWINDOW_MODE, strip_prefix);
    pyg_flags_add_constants(module, GDK_TYPE_GC_VALUES_MASK, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_IMAGE_TYPE, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_EXTENSION_MODE, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_INPUT_SOURCE, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_INPUT_MODE, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_AXIS_USE, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_PROP_MODE, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_FILL_RULE, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_OVERLAP_TYPE, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_RGB_DITHER, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_SELECTION, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_TARGET, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_SELECTION_TYPE, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_BYTE_ORDER, strip_prefix);
    pyg_flags_add_constants(module, GDK_TYPE_MODIFIER_TYPE, strip_prefix);
    pyg_flags_add_constants(module, GDK_TYPE_INPUT_CONDITION, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_STATUS, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_GRAB_STATUS, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_VISUAL_TYPE, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_WINDOW_CLASS, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_WINDOW_TYPE, strip_prefix);
    pyg_flags_add_constants(module, GDK_TYPE_WINDOW_ATTRIBUTES_TYPE, strip_prefix);
    pyg_flags_add_constants(module, GDK_TYPE_WINDOW_HINTS, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_WINDOW_TYPE_HINT, strip_prefix);
    pyg_flags_add_constants(module, GDK_TYPE_WM_DECORATION, strip_prefix);
    pyg_flags_add_constants(module, GDK_TYPE_WM_FUNCTION, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_GRAVITY, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_WINDOW_EDGE, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_PIXBUF_ALPHA_MODE, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_COLORSPACE, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_PIXBUF_ERROR, strip_prefix);
    pyg_enum_add_constants(module, GDK_TYPE_INTERP_TYPE, strip_prefix);
}

/* intialise stuff extension classes */
void
pygdk_register_classes(PyObject *d)
{
    PyObject *module;

    if ((module = PyImport_ImportModule("gobject")) != NULL) {
        PyObject *moddict = PyModule_GetDict(module);

        _PyGObject_Type = (PyTypeObject *)PyDict_GetItemString(moddict, "GObject");
    } else {
        Py_FatalError("could not import gobject");
        return;
    }
    if ((module = PyImport_ImportModule("pango")) != NULL) {
        PyObject *moddict = PyModule_GetDict(module);

        _PyPangoContext_Type = (PyTypeObject *)PyDict_GetItemString(moddict, "Context");
        _PyPangoFont_Type = (PyTypeObject *)PyDict_GetItemString(moddict, "Font");
        _PyPangoLayout_Type = (PyTypeObject *)PyDict_GetItemString(moddict, "Layout");
    } else {
        Py_FatalError("could not import pango");
        return;
    }


#line 6102 "gdk.c"
    pyg_register_boxed(d, "Event", GDK_TYPE_EVENT, &PyGdkEvent_Type);
    pyg_register_boxed(d, "Font", GDK_TYPE_FONT, &PyGdkFont_Type);
    pyg_register_boxed(d, "Color", GDK_TYPE_COLOR, &PyGdkColor_Type);
    pyg_register_boxed(d, "Cursor", GDK_TYPE_CURSOR, &PyGdkCursor_Type);
    pyg_register_boxed(d, "Rectangle", GDK_TYPE_RECTANGLE, &PyGdkRectangle_Type);
    pygobject_register_class(d, "GdkColormap", GDK_TYPE_COLORMAP, &PyGdkColormap_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pygobject_register_class(d, "GdkDevice", GDK_TYPE_DEVICE, &PyGdkDevice_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pygobject_register_class(d, "GdkDragContext", GDK_TYPE_DRAG_CONTEXT, &PyGdkDragContext_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pygobject_register_class(d, "GdkDrawable", GDK_TYPE_DRAWABLE, &PyGdkDrawable_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pygobject_register_class(d, "GdkWindow", GDK_TYPE_WINDOW, &PyGdkWindow_Type, Py_BuildValue("(O)", &PyGdkDrawable_Type));
    pygobject_register_class(d, "GdkPixmap", GDK_TYPE_PIXMAP, &PyGdkPixmap_Type, Py_BuildValue("(O)", &PyGdkDrawable_Type));
    pygobject_register_class(d, "GdkGC", GDK_TYPE_GC, &PyGdkGC_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pygobject_register_class(d, "GdkImage", GDK_TYPE_IMAGE, &PyGdkImage_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pygobject_register_class(d, "GdkPixbuf", GDK_TYPE_PIXBUF, &PyGdkPixbuf_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pygobject_register_class(d, "GdkPixbufAnimation", GDK_TYPE_PIXBUF_ANIMATION, &PyGdkPixbufAnimation_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pygobject_register_class(d, "GdkPixbufAnimationIter", GDK_TYPE_PIXBUF_ANIMATION_ITER, &PyGdkPixbufAnimationIter_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pygobject_register_class(d, "GdkVisual", GDK_TYPE_VISUAL, &PyGdkVisual_Type, Py_BuildValue("(O)", &PyGObject_Type));
}
