#include <glib.h>
#include <stdio.h>

/* #define HASH_FUNC g_str_hash */
#define HASH_FUNC procedural_db_hash_func


static guint
procedural_db_hash_func (gconstpointer key)
{
  const gchar *string;
  guint result;
  int c;

  /*
   * I tried a zillion different hash functions and asked many other
   * people for advice.  Many people had their own favorite functions,
   * all different, but no-one had much idea why they were good ones.
   * I chose the one below (multiply by 9 and add new character)
   * because of the following reasons:
   *
   * 1. Multiplying by 10 is perfect for keys that are decimal strings,
   *    and multiplying by 9 is just about as good.
   * 2. Times-9 is (shift-left-3) plus (old).  This means that each
   *    character's bits hang around in the low-order bits of the
   *    hash value for ever, plus they spread fairly rapidly up to
   *    the high-order bits to fill out the hash value.  This seems
   *    works well both for decimal and non-decimal strings.
   *
   * tclHash.c --
   *
   *      Implementation of in-memory hash tables for Tcl and Tcl-based
   *      applications.
   *
   * Copyright (c) 1991-1993 The Regents of the University of California.
   * Copyright (c) 1994 Sun Microsystems, Inc.
   */

  string = (const gchar *) key;
  result = 0;
  while (1)
    {
      c = *string;
      string++;
      if (c == 0)
	break;
      result += (result << 5) + c;
    }

  return result;
}

void
process_line (gchar *buffer, gint lineno)
{
  int i;
  guint len = strlen(buffer);

  if (buffer[len-1] == '\n')
    buffer[len-1] = '\0';

  for (i=0; i<100; i++)
    HASH_FUNC (buffer);

}

#define BUFSIZE 1024

int main ()
{
  gchar buffer[BUFSIZE];
  gint lineno = 0;
  
  /* Read and process the lines from stdin 
   */
  while (fgets (buffer, BUFSIZE-1, stdin) != NULL)
    {
      process_line (buffer, lineno);
      lineno++;
    }

  return 0;
}


