/* arcps.c */
/*
 * HPGL supplies the needed arc as:
 *	AA xcenter,ycenter,angle,chord
 *
 * PostScript needs it as:
 *	xcenter ycenter radius start_deg end_deg arc stroke
 *
 * where the drawing starting point has no relationship to the current point,
 * which is set by the HPGL PA command.  The start and ending degree values
 * need to be computed. PostScript arc moves counterclockwise, while arcn
 * moves clockwise from start to end degree locations.
 *
 * A positive HPGL angle means counterclockwise arc, while negative means
 * a clockwise arc (PS arcn).
 *
 * The radius is determined by:
 *	sqrt(x*x + y*y)
 *
 * where x and y are the distances from the current point to the center.
 *
 * The starting offset angle between the current point and the arc center:
 *	180/pi(atan(x/y))  [the atan returns radians]
 *
 * The angle quadrant needs to be determined as well, and will be an offset
 * starting base angle.  The PostScript base is along the X axis, to the right.
 * The angle increases its value in the counterclockwise direction.  It is
 * determined by the signs of the differences between the current point
 * and arc center:
 *	X	Y	start arc
 *	+	+	   90
 *	+	-	    0
 *	-	-	  180
 *	-	+	  270
 */

#include "defn.h"

arcps(type)
int	type;
{
    float	radius;
    float	angle = 0;
    float	start_deg = 0;
    float	end_deg = 0;
    float	offset_deg = 0;
    float	chord_angle = 0;
    float	Xc, Yc;
    float	Xdiff, Ydiff;

    end_draw();

    switch (type)
    {
    case ARCA:
	if (SIGNED_NUMERIC)
	    lastXmove = Xc = getval() * XSCALE + offX;
	if (SIGNED_NUMERIC)
	    lastYmove = Yc = getval() * YSCALE + offY;
	if (SIGNED_NUMERIC)
	    angle = getval();
	if (SIGNED_NUMERIC)
	    chord_angle = getval();
	if (PENDOWN)
	{
	    printf("newpath\n");
	    debugp((stderr,"newpath\n"));
	    printf("  %g %g %s\n", absX, absY, MOVE);
	    debugp((stderr,"  %g %g %s\n", absX, absY, MOVE));
	}
	Xdiff = absX - Xc;
	Ydiff = absY - Yc;
	if (Xdiff < 0 && Ydiff > 0 )
	    offset_deg = 90;
	if (Xdiff < 0 && Ydiff < 0 )
	    offset_deg = 180;
	if (Xdiff > 0 && Ydiff < 0 )
	    offset_deg = 270;
	radius = sqrt(fabs(Xdiff*Xdiff) + fabs(Ydiff*Ydiff));
	if (Xdiff == 0 || Ydiff == 0)
	{
	    if (Ydiff > 0)
		start_deg = 90;
	    if (Xdiff < 0)
		start_deg = 180;
	    if (Ydiff < 0)
		start_deg = 270;
	}
	else if (fabs(Xdiff) < fabs(Ydiff))
	    start_deg = 180/M_PI*(fabs(atan(Xdiff/Ydiff)));
	else
	    start_deg = (180/M_PI*(fabs(atan(Ydiff/Xdiff)))) + 45;
	start_deg += offset_deg;
	if (angle > 0)
	    end_deg = start_deg + angle;
	else
	    end_deg = start_deg - fabs(angle);
	if (end_deg >= 360)
	    end_deg -= 360;
	if (end_deg < 0)
	    end_deg += 360;

	DRAW_FLAG = 1;

	break;

    case ARCR:

	break;

    default:

	debugp((stderr,"Unknown ARC command\n"));

    }
    if (angle < 0)
	AARC = "AAC";
    else
	AARC = "AA";

    printf("%g %g %g %g %g %s\n",Xc,Yc,radius,start_deg,end_deg,AARC);
    debugp((stderr,"%g %g %g %g %g %s\n",Xc,Yc,radius,start_deg,end_deg,AARC));

    debugp((stderr,"\tabsX=%g\tabsY=%g\tXc=%g\tYc=%g\n",absX,absY,Xc,Yc));
    debugp((stderr,"\tXdiff=%g\tYdiff=%g\n",Xdiff,Ydiff));
    debugp((stderr,"\tradius=%g\tstart_deg=%g\tend_deg=%g\tangle=%g\n",radius,start_deg,end_deg,angle));
}
