 /*
  * Khoros: $Id$
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vfdmax.c
 >>>>
 >>>>      Program Name: vfdmax
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Finds maxima in the Fast Hough domain  (see  vhough(1))  and
 >>>>	gives  one point result for each maximum in output image and
 >>>>	sub-pixel results the ascii file.
 >>>>	
 >>>>	

 >>>>            Author: Jean-Pierre Guerin, Jean-Francois Larue, Marc Viala
 >>>>
 >>>> Date Last Updated: Thu Mar 26 10:39:53 1992
 >>>>
 >>>>          Routines: main- the main program for vfdmax
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vfdmax.h"


/****************************************************************
 *
 * Routine Name:  main program for vfdmax
 *
 *       Input:  
 *        -i  input HOUGH domain image 
 *
 *
 *        [-o] image of found maxima
 *        [-o1] Output Hough Image with Moebius sides
 *        [-om] list of maxima output file
 *        [-t] the Value of Threshold  (value >= 0)
 *        [-w] the value of square Window Size (odd)  (3 < value < 15)
 *        [-p] selects 1 for printing
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct  xvimage *image1, *image2, *readimage(), *writeimage();
IMA_TYP        *data3;
long vff_type;

FILE            *printdev ;

/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
  READINPUT (image1);
  CHECKINPUT (program, image1);

  if ( image1->col_size != image1->row_size )
    {
    (void)fprintf(stderr,"%s : Image must be square ( col_size = row_size ) ...\n",program);
    exit(1);
    }

    vff_type = VVF_HOUGH_TYP;     /* ==> type image */

    image2 = createimage(image1->col_size, image1->row_size, 
                     vff_type, 1,
                     1,"", 0, 0, VFF_MS_NONE,
                     VFF_MAPTYP_NONE, VFF_LOC_IMPLICIT, 0);
   
    if (vfdmax->om_flag)
    {
       if (! vwrite_ascii(vfdmax->om_file, &printdev))
       {
          (void) fprintf(stderr,
               "%s:  Can't open ascii output file: %s\n",program, vfdmax->om_file);
          exit(1);
       }
    }
    else
       printdev = NULL;

/* -main_before_lib_call_end */

/* -main_library_call */

  if (!lvfdmax(image1, image2, &data3,
               vfdmax->w_int, vfdmax->t_int, vfdmax->p_logic, printdev ))
    {
        (void) fprintf (stderr,"%s: lvfdmax failed ...\n", program);
        exit (1);
    }
  
/* -main_library_call_end */

/* -main_after_lib_call */

  if (vfdmax->o_flag == 1)
  {
    WRITEOUTPUT(image2); 
  }

  if (vfdmax->o1_flag == 1)
  {
    image2->col_size += vfdmax->w_int -1;
    image2->row_size += vfdmax->w_int -1;
    image2->imagedata = (char *)data3;
    writeimage(vfdmax->o1_file, image2);
  }
  else (void)free(data3);

  if (printdev != NULL)
      fclose(printdev);

/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vfdmax 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vfdmax :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tFinds maxima in the Fast Hough domain  (see  vhough(1))  and\n");
	fprintf(stderr, "\tgives  one point result for each maximum in output image and\n");
	fprintf(stderr, "\tsub-pixel results the ascii file.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input HOUGH domain image  (infile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-o]  image of found maxima (outfile) [null]\n");
	fprintf(stderr,"\t[-o1]  Output Hough Image with Moebius sides (outfile) [null]\n");
	fprintf(stderr,"\t[-om]  list of maxima output file (outfile) [null]\n");
	fprintf(stderr,"\t[-t]  the Value of Threshold (integer, >= 0) [10]\n");
	fprintf(stderr,"\t[-w]  the value of square Window Size (odd) (integer, 3 to 15) [3]\n");
	fprintf(stderr,"\t[-p]  selects 1 for printing (boolean) [false]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vfdmax\n");
	fprintf(stderr, "\t[-U] Gives the usage for vfdmax\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vfdmax.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vfdmax.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vfdmax
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input HOUGH domain image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) image of found maxima \n        {outfile}: "; 
char	*o1_pstr = 
	"\nEnter: (o1) Output Hough Image with Moebius sides \n        {outfile}: "; 
char	*om_pstr = 
	"\nEnter: (om) list of maxima output file \n        {outfile}: "; 
char	*t_pstr = 
	"\nEnter: (t) the Value of Threshold \n        {integer, >= 0 [10] }: "; 
char	*w_pstr = 
	"\nEnter: (w) the value of square Window Size (odd) \n        {integer, 3 to 15 [3] }: "; 
char	*p_pstr = 
	"\nEnter: (p) selects 1 for printing \n        {boolean, (y/n)  [no] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vfdmax", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vfdmax.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vfdmax: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vfdmax.ans");
		}

	     }

	}

	/*
	 * allocate the vfdmax structure
	 */
	vfdmax = (vfdmax_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vfdmax_struct));

	/*
	 * get required arguments for vfdmax
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vfdmax->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vfdmax->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vfdmax->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vfdmax->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vfdmax->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vfdmax
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vfdmax->o_flag = vget_outfile(fid, prompt_flag,
	"-o", o_pstr, &(vfdmax->o_file))
;

	vfdmax->o1_flag = vget_outfile(fid, prompt_flag,
	"-o1", o1_pstr, &(vfdmax->o1_file))
;

	vfdmax->om_flag = vget_outfile(fid, prompt_flag,
	"-om", om_pstr, &(vfdmax->om_file))
;

	vfdmax->t_flag = vget_int(fid, prompt_flag,
	"-t", t_pstr, &(vfdmax->t_int),
	10, 1, 1);

	vfdmax->w_flag = vget_int(fid, prompt_flag,
	"-w", w_pstr, &(vfdmax->w_int),
	3, 3, 15);

	vfdmax->p_flag = vget_logic(fid, prompt_flag,
	"-p", p_pstr, &(vfdmax->p_logic), 0);


}



