 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vhgline.h
 >>>>            Author: Patrick Arnoul, Jean-Pierre Guerin, Jean-Francois Larue
 >>>> Date Last Updated: Thu Mar 26 10:43:12 1992
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vhgline_h_
#define _vhgline_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    vhgline Argument Structure
*
****************************************************************/

typedef struct _vhgline  {

/*
 *  input plot file to be drawn (Required infile)
 */
char	*i_file;	/* input plot file to be drawn FILENAME */
int	 i_flag;	/* input plot file to be drawn FLAG */

/*
 *  resulting output image (Required outfile)
 */
char	*o_file;	/* resulting output image FILENAME */
int	 o_flag;	/* resulting output image FLAG */

/*
 *  Size of the Output Image (Optional integer)
 */
int	 s_int; 	/* Size of the Output Image INT */
int	 s_flag;	/* Size of the Output Image FLAG */

/*
 *  draw 4 lines surrounding the inverse transformed image (Optional logical)
 */
int	 d_logic;	/* draw 4 lines surrounding the inverse transformed image LOGIC */
int	 d_flag;  	/* draw 4 lines surrounding the inverse transformed image FLAG */

/*
 *  selects one (one pixel wide) or zero (Not Aliased Line) (Optional logical)
 */
int	 l_logic;	/* selects one (one pixel wide) or zero (Not Aliased Line) LOGIC */
int	 l_flag;  	/* selects one (one pixel wide) or zero (Not Aliased Line) FLAG */

}  vhgline_struct;

vhgline_struct *vhgline;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */

#define WRITEOUTPUT(image) \
    writeimage(vhgline->o_file, image)

/* -include_macros_end */

#endif
