 /*
  * Khoros: $Id$
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 *   Copyright, 1991, The Regents of the University of California.
 *   This software was produced under a U.S. Government contract
 *   (W-7405-ENG-36) by the Los Alamos National Laboratory, which is
 *   operated by the University of California for the U.S. Department
 *   of Energy.  The U.S. Government is licensed to use, reproduce,
 *   and distribute this software.  Neither the Government nor the
 *   University makes any warranty, express or implied, or assumes
 *   any liability responsibility for the use of this software.
 */


#include<stdio.h>

/*
 *  delete_empties () Delete empty clusters from set.  Cluster definition
 *                    can consist of mean vector (mandatory), number of
 *                    elements (mandatory), upper triangular covariance 
 *                    matrix, and/or a diagonal covariance matrix.  If any 
 *                    of these values are not available, the associated 
 *                    pointer should be passed in as NULL.
 *
 *                    Returned value is always 1.
 *
 *  Written by:  Patrick M. Kelly
 *  Date:        8/6/91
 */

int delete_empties ( num_entries, means, count, cov_upper, cov_diag, mapping )

int *num_entries;	/* Number of entries in the table */
float **means;		/* Mean vectors */
int *count;		/* Number of elements */
float ***cov_upper;	/* Upper triangular covariance matrix */
float **cov_diag;	/* Diagonal covariance matrix */
int **mapping;		/* Mapping for the cluster reduction */

{
	int i;				/* Loop control */
	int num_cur_entries;

	/*  CREATE THE MAPPING FOR THE CLUSTER NUMBERS  */

	*mapping = (int *) malloc ( sizeof(int) * *num_entries );
	if ( *mapping == NULL ) {
		fprintf(stderr,"MEMORY ALLOCATION FAILURE\n");
		exit (-1);
	}

	/*  PHISICALLY DELETE INVALID CLUSTERS  */

	num_cur_entries = 0;
	for ( i = 0 ; i < *num_entries ; i ++ ) {

		if ( count [i] == 0 ) {

			means [num_cur_entries] = means [i];
			count [num_cur_entries] = count [i];

			if ( cov_diag != NULL )
				cov_diag [num_cur_entries] = cov_diag [i];
			if ( cov_upper != NULL )
				cov_upper [num_cur_entries] = cov_upper [i];

			(*mapping) [i] = num_cur_entries ;

			num_cur_entries ++;

		} else {

			(*mapping) [i] = -1;

		}

	}

	if ( *num_entries == num_cur_entries ) {
		free ( *mapping );
		*mapping = NULL;
	} else {
		*num_entries = num_cur_entries;
	}

     return (1);
}

