/* This just defines the name of the default font file */
#include <fontdatafile.h>

#ifndef TRUE
#define FALSE 0
#define TRUE  1
#endif

#define BUFLEN	256	/* Length of an input line */
#define MAX_POINTS 256	/* Maximum # of points in a character */

typedef struct {
    char movedraw;  /* 0 for move, nonzero for draw */
    int  x,y;	    /* Coordinate to move/draw to */
} CPOINT;

typedef struct {
    int charno; 		/* Character index # */
    int num_points;		/* # of points in it */
    int lx, rx; 		/* Left and right limits */
    CPOINT c_def[MAX_POINTS];	/* Points of the character */
} CHARACTER;

typedef struct {
    unsigned short movedraw:1,
	     y:7,
	     pad:1,
	     x:7;
} BPOINT;

/*  A dictionary entry describing a single character */
typedef struct {
    int   char_pos;	/* Absolute offset in file */
    short char_idx,	/* Character index # in hershey table */
	  num_points;	/* # of points in the character */
} CHAR_INFO;

/*  A table entry describing component characters of a font */
typedef struct {
    char *font_name;
    int font_upper,
	font_lower,
	font_numbers,
	font_spaces,
	font_punct,
	font_ligatures;
} FONT_INFO;

int init_font();
int select_numeric_font();
int select_named_font();
BPOINT *get_font_char();
BPOINT *get_font_index();
