/*
    Definitions for lucasfilm format picture header and associated stuff
*/
#ifndef LFF_H_READ
#define LFF_H_READ

#define MAGIC_LFF	0164200		/* Magic # in lff image file */
#define MAGIC_CMAP	0164300		/* Magic # in color map file */

#define LFF_VERSION	1		/* Meaningless right now */

/* Format codes */
#define FORMAT_R	0x08		/* Format code for red plane */
#define FORMAT_G	0x04		/*		   green plane */
#define FORMAT_B	0x02		/*		   blue plane */
#define FORMAT_A	0x01		/*		   alpha plane */
#define FORMAT_RGB	0x0E		/*		   RGB picture */
#define FORMAT_RGBA	0x0F		/*		   RGBA picture */
#define FORMAT_BINARY	0x100		/* Format for binary 1 bit/pixel */

/* Storage codes */
#define STORAGE_DUMP	2		/* Storage code for dumping */
#define STORAGE_RLE	0		/* Storage code for run-length */

#define LFF_BLOCKSIZE	1024		/* Data block size */
#define CMAP_START	1024		/* Start of color map */
#define IMAGE_START	2048		/* Start of pixel data */

typedef struct {
    long tileptr, tilelength;
} TILEPTR;

/*
    The lucasfilm format header, with possible extensions in hdr_pad.
	This structure should be exactly 1024 (LFF_BLOCKSIZE) bytes long.
*/
typedef struct {
/* 0 */ long  hdr_magic;	/* Always MAGIC_LFF */
/* 4 */ short hdr_version;	/* Version number */
/* 6 */ char  hdr_label[246];	/* ASCII label describing picture */
/*252*/ long  hdr_labelptr;	/* Pointer to label continuation */
	short hdr_tilepad;	/* Width of a tile with bit padding, in bytes */
				/*  this is only for FORMAT_BINARY images */
	char  hdr_pad[158];	/* Padding (was 160 before hdr_tilepad) */
/*416*/ short hdr_height,	/* Pixel height of full picture */
/*418*/       hdr_width,	/* Pixel width of full picture */
/*420*/       hdr_tileheight,	/* Pixel height of each tile */
/*422*/       hdr_tilewidth,	/* Pixel width of each tile */
/*424*/       hdr_format,	/* Picture format */
/*426*/       hdr_storage,	/* Picture storage */
/*428*/       hdr_blocking,	/* Blocking factor (always 1024) */
/*430*/       hdr_alphamode,	/* Alpha mode (matted-to-black or unassociated) */
/*432*/       hdr_xoffset,	/* Horizontal offset for picture */
/*434*/       hdr_yoffset;	/* Vertical offset for picture */
/*436*/ char  hdr_pad2[12];
/*448*/ long  hdr_map_ptr;	/* Pointer into file */
/*452*/ char  hdr_map_name[28]; /* Name of file */
/*480*/ char  hdr_pad3[32];
/* 480 + 32 = 512 */
} LFF_HDR;	/* This should be exactly 512 bytes long */

#define FLAG_PAD	0	/* No more data in this block */
#define FLAG_DUMP	1	/* Dumped packet  */
#define FLAG_RLE	2	/* Encoded packet */

/* Every encoded packet has this header for each run */
typedef struct {
	unsigned short count:12;	/* run-length count */
	unsigned short flag:4;		/* and flag */
} PACKET_HDR;
#define PACKET_SIZE	2	/* Sizeof(PACKET_HDR) */

extern int write_lff();
extern int pixel_length();  /* Return length of a specified pixel format */
extern char *pixerrmess();

/* Union containing a pointer to either a packed or unpacked line pointer */
typedef union {
    RPIXEL *rpixel;
    RGBPIXEL *rgbpixel;
} LINE_PTR;

#define PACKED	 0
#define UNPACKED 1

#endif	/* LFF_H_READ */
