.ds f. write_lff.tbl
.fp 1 R
.fp 2 I
.fp 3 B
.so date.trf
.TH WRITE_LFF 3L "\*(td" "Caltech CS Graphics Group" "Graphics Group Programmer's Manual"
.SH NAME
write_lff - write a lucasfilm format image file
.SH SYNOPSIS
\fB#include <pixlib.h>
.br
.in +3P
.ti -3P
write_lff(name, height, width, vtiles, htiles, format, storage, xoff, yoff, version, alphamode, pixfun)
.br
.ti -3P
char *name;
.ti -3P
int height, width, vtiles, htiles, format, storage, xoff, yoff, version, alphamode;
.in -3P
int (*pixfun)();
.sp
.in +3P
.ti -3P
write_lff_fd(fd, offset, height, width, vtiles, htiles, format, storage, xoff, yoff, version, alphamode, pixfun)
.br
.ti -3P
int fd;
.ti -3P
off_t offset;
.ti -3P
int height, width, vtiles, htiles, format, storage, xoff, yoff, version, alphamode;
.in -3P
int (*pixfun)();\fR
.SH DESCRIPTION
\fIWrite_lff\fR writes a lucasfilm format image file \fBname\fR. The other
parameters control the image written and the format of the output file,
and are:
.sp
.in +3P
.TS
.if \n+(b.=1 .nr d. \n(.c-\n(c.-1
.de 35
.ps \n(.s
.vs \n(.vu
.in \n(.iu
.if \n(.u .fi
.if \n(.j .ad
.if \n(.j=0 .na
..
.nf
.nr #~ 0
.if \n(.T .if n .nr #~ 0.6n
.ds #d .d
.if \(ts\n(.z\(ts\(ts .ds #d nl
.fc
.nr 33 \n(.s
.rm 46 47
.nr 46 0
.nr 38 \w\f2height, width\fP
.if \n(46<\n(38 .nr 46 \n(38
.nr 38 \w\f2vtiles, htiles\fP
.if \n(46<\n(38 .nr 46 \n(38
.nr 38 \w\f2format\fP
.if \n(46<\n(38 .nr 46 \n(38
.nr 38 \w\f2storage\fP
.if \n(46<\n(38 .nr 46 \n(38
.nr 38 \w\f2xoff, yoff\fP
.if \n(46<\n(38 .nr 46 \n(38
.nr 38 \w\f2version\fP
.if \n(46<\n(38 .nr 46 \n(38
.nr 38 \w\f2alphamode\fP
.if \n(46<\n(38 .nr 46 \n(38
.nr 38 \w\f2pixfun\fP
.if \n(46<\n(38 .nr 46 \n(38
.46
.rm 46
.nr 47 0
.nr 38 \wSize of the image in pixels
.if \n(47<\n(38 .nr 47 \n(38
.nr 38 \wNumber of image subtiles up and across
.if \n(47<\n(38 .nr 47 \n(38
.nr 38 \wImage channels to be stored
.if \n(47<\n(38 .nr 47 \n(38
.nr 38 \wImage encoding method
.if \n(47<\n(38 .nr 47 \n(38
.nr 38 \wScreen offset of image
.if \n(47<\n(38 .nr 47 \n(38
.nr 38 \wImage version number
.if \n(47<\n(38 .nr 47 \n(38
.nr 38 \wAlpha channel storage mode
.if \n(47<\n(38 .nr 47 \n(38
.nr 38 \wFunction to return pixels from image
.if \n(47<\n(38 .nr 47 \n(38
.47
.rm 47
.nr 38 1n
.nr 45 0
.nr 40 \n(45+((0*\n(38)/2)
.nr 46 +\n(40
.nr 41 \n(46+((6*\n(38)/2)
.nr 47 +\n(41
.nr TW \n(47
.if t .if (\n(TW+\n(.o)>7.65i .tm Table at line 51 file write_lff.tbl is too wide - \n(TW units
.fc  
.nr #T 0-1
.nr #a 0-1
.eo
.de T#
.nr 35 1m
.ds #d .d
.if \(ts\n(.z\(ts\(ts .ds #d nl
.mk ##
.nr ## -1v
.ls 1
.ls
..
.ec
.ta \n(46u \n(47u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f2height, width\f\n(31\h'|\n(41u'Size of the image in pixels
.ta \n(46u \n(47u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f2vtiles, htiles\f\n(31\h'|\n(41u'Number of image subtiles up and across
.ta \n(46u \n(47u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f2format\f\n(31\h'|\n(41u'Image channels to be stored
.ta \n(46u \n(47u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f2storage\f\n(31\h'|\n(41u'Image encoding method
.ta \n(46u \n(47u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f2xoff, yoff\f\n(31\h'|\n(41u'Screen offset of image
.ta \n(46u \n(47u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f2version\f\n(31\h'|\n(41u'Image version number
.ta \n(46u \n(47u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f2alphamode\f\n(31\h'|\n(41u'Alpha channel storage mode
.ta \n(46u \n(47u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f2pixfun\f\n(31\h'|\n(41u'Function to return pixels from image
.fc
.nr T. 1
.T# 1
.35
.TE
.if \n-(b.=0 .nr c. \n(.c-\n(d.-11
.in -3P
.sp
.PP
\fIFormat\fR may be any logical combination of the bits \fBFORMAT_R,
FORMAT_G, FORMAT_B,\fR and \fBFORMAT_A\fR, specifying the red, green,
blue, and alpha channels respectively. Normally the only combinations
used are \fBFORMAT_R, FORMAT_RGB\fR (24-bit RGB image) and \fBFORMAT_RGBA\fR
(32-bit RGB with alpha).
.PP
In addition, \fIformat\fR may be \fBFORMAT_BINARY\fR (exclusive of
the other formats). In this case, the image is stored 1 bit/pixel, LSB
leftmost within a byte.
.PP
\fIVtiles\fR and \fIhtiles\fR specify the number of subtiles to split
the image into. They must be integers >= 1, and divide integrally into
the image \fIheight\fR and \fIwidth\fR.
.PP
\fIStorage\fR controls the encoding method the image is to be stored with. The
valid codes are \fBSTORAGE_DUMP\fR (dumped pixels) and \fBSTORAGE_RLE\fR
(run-length encoded). \fBSTORAGE_RLE\fR is not allowed with \fBFORMAT_BINARY\fR
images.
.PP
\fIXoff\fR and \fIyoff\fR are the upper left corner of the image. Normally
they are (0,0). These values are stored in the header so the image will
be restored to the same screen location.
.PP
\fIVersion\fR is the image version number. This is unused and normally
has the value \fBLFF_VERSION\fR (0).
.PP
\fIAlphamode\fR is meaningful only if the alpha channel is stored. If 0,
then the alpha channel is matted to black with the image bytes, otherwise
it is unassociated with the image.
.PP
\fIPixfun\fR is the address of a function which will return image
pixels as \fIwrite_lff\fR encodes the image. The function will be called
as follows:
.sp
.in +3P
.nf
\fBint pixfun(row, column, length, pixels)
int row, column, length;
RGBPIXEL pixels[];\fR
.fi
.sp
.in -3P
.PP
\fIPixfun\fR must put \fIlength\fR pixels from the input image starting
at \fI(row,column)\fR into the \fIpixels[]\fR array. It should return
the actual number of pixels read, and an error will occur if the value
returned is not equal to \fIlength\fR.
.PP
If a binary image is being written, \fIpixels\fR is passed as an
RPIXEL * instead of a RGBPIXEL *. The pixels (bits) must be placed into
the array just as they will be stored in the file.
.PP
If the image is successfully written, \fBLFF_OK\fR will be returned.
Otherwise, \fIwrite_lff\fR will return an error code. A textual description
of the error may be obtained by calling \fIpixerrmess()\fR.
.PP
\fIOpen_lff_fd\fR writes a lucasfilm format image onto an already opened
file. \fIFd\fR must be a file descriptor of a file opened for writing.
In addition, an \fIoffset\fR (normally 0) into the file must be specified;
the image is written starting at that location.
.SH SEE ALSO
intro_pix(3L), pixerrmess(3L), readlff(3L), readpix(3L)
