/*
    char *pixerrmess(errcode)
    int errcode;

	Return a string corresponding to the specified error code
*/
#include "pixlib.h"

char *pixerrmess(errcode)
int errcode;
{
    switch(errcode) {
	case PIXLIB_OK:        return "Normal, successful completion";

	case PIX_REOPEN:    return "Another .pix file is currently open";
	case PIX_OPENERR:   return "Error opening file";
	case PIX_EOF:	    return "Premature end of file";
	case PIX_BADMAGIC:  return "Bad magic number";
	case PIX_BADFORMAT: return "Bad format code";

	case LFF_BADFILE:   return "Error opening file";
	case LFF_BADSIZE:   return "Bad height or width specified (<= 0)";
	case LFF_BADFORMAT: return "Unknown pixel format";
	case LFF_BADSTORAGE:return "Unknown storage code";
	case LFF_READ_ERR:  return "Error reading pixels";
	case LFF_WRITE_ERR: return "Error writing file";
	case LFF_REOPEN:    return "Another .lff file is currently open";
	case LFF_OPENERR:   return "Error opening file";
	case LFF_EOF:	    return "Premature end-of-file";
	case LFF_BADMAGIC:  return "Bad magic number";
	case LFF_BADTILE:   return "Bad tile height or width";
	case LFF_ENOMEM:    return "Memory allocation failed";
	default:	    return "Unknown pixlib error code";
    }
}

