/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Name : LineSegTheta
Type : double
Written on   : 20-Nov-90     By : A. Etemadi
Modified on  :               By : 
Directory    : ~atae/ORT/ORT/LPEG/src/LineRoutines

==============================================================================

Input parameters    : 
Following parameters are end points of lines. They could be line data produced
by the routine ReadHTLine

 StartCol		-- The column number of the start point of the line
 StartRow		-- The row number of the start point of the line
 EndCol		-- The column number of the end point of the line
 EndRow		-- The row number of the end point of the line

Output result       : 

 Theta			-- Orientation of the line in radians (see below for more detail)

Calling procedure:

 double StartCol;
 double StartRow;
 double EndCol;
 double EndRow;

 Orientation = LineSegTheta(  StartCol,
				  StartRow,
				  EndCol,
                              EndRow)

Functionality: 

This function finds the orientation of a line given its end points.
Note: the center of the image is used as the origin for the rows and columns. 
The orientation angle ranges from 0 to pi radians where pi/2 => theta => 0  
implies a +ve gradient, and pi > theta > pi/2 implies a -ve gradient. 
pi/2 points along the y axis. There's no error checking ie overflow, 
underflow etc.. Want to include it yourself ?

----------------------------------------------------------------------------*/

#include <stdio.h>     /* Standard C I/O library */
#include <math.h>      /* Standard C mathematics library */
#include <errno.h>     /* Standard C error handling routines */
/* #include <strings.h> */   /* Standard C string handling routines */
#include <ctype.h>     /* Standard C type identification routines */

#define PI     3.141593
#define PIBY2  1.570796

double LineSegTheta(StartCol,
		     StartRow,
		     EndCol,
	            EndRow)

 double StartCol;
 double StartRow;
 double EndCol;
 double EndRow;

{

 double dx,dy; 			/* Buffers */

 double Orientation;

#ifdef debug
          fprintf(stderr," Start of function LineSegTheta \n");
#endif

  dx = EndCol - StartCol;
  dy = EndRow - StartRow;

  if (dx == 0.0) return(PIBY2); 	/* Line is vertical */
  if (dy == 0.0) return(0.0);     	/* Line is Horizontal */

  Orientation =  atan2( dy, dx );

/*
 Make it so line orientation is always between 0 and pi.

*/

  if (Orientation < 0.0 )
      Orientation = Orientation + PI;

  if (Orientation > PI)
      Orientation = Orientation - PI;

  return(Orientation);

#ifdef debug
          fprintf(stderr," End of function LineSegTheta \n");
#endif

}
