/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Name : PtLinePerpDistance
Type : double
Written on   : 20-Nov-90     By : A. Etemadi
Modified on  :               By : 
Directory    : ~atae/ORT/C/src/LineRoutines

==============================================================================

Input parameters    : 

Point Data:

 PtCol			-- Column position of point
 PtRow			-- Column position of point

Line data:

 ColIntercept		-- Intercepts of the line
 RowIntercept		-- 
 Theta			-- Orientation of the line

Output parameters    : 

Output result       : 

 Distance		-- Perpendicular distance between the point and the line

Called functions :

 PtLinePerpIntercept
 LineLength

Calling procedure:

 double PtCol;
 double PtRow;

 double ColIntercept;
 double RowIntercept;
 double Theta;

 double Distance;
 
 distance = PtLinePerpDistance(PtCol,
		      		   PtRow,
		      		   ColIntercept,
		      		   RowIntercept,
		      		   Theta);

Functionality: 

This function finds the perpendicular distance from a point to a line.

----------------------------------------------------------------------------*/

#include <stdio.h>     /* Standard C I/O library */
#include <math.h>      /* Standard C mathematics library */
#include <errno.h>     /* Standard C error handling routines */
/* #include <strings.h> */   /* Standard C string handling routines */
#include <ctype.h>     /* Standard C type identification routines */

int PtLinePerpIntercept();
double LineLength();

double PtLinePerpDistance(PtCol,
		      	     PtRow,
		            ColIntercept,
		            RowIntercept,
		            Theta)

 double PtCol;
 double PtRow;

 double ColIntercept;
 double RowIntercept;
 double Theta;

{

 double InterceptPtCol;
 double InterceptPtRow;

 double Distance;

#ifdef debug
          fprintf(stderr," Start of function PtLinePerpDistance \n");
#endif

/*
 Find the intercept point of perpendicular dropped onto the line

*/

   PtLinePerpIntercept(PtCol,
                       PtRow,
                       ColIntercept,
                       RowIntercept,
                       Theta,
                       &InterceptPtCol,
                       &InterceptPtRow); 


    Distance = LineLength(InterceptPtCol,InterceptPtRow,
			     PtCol,PtRow);
    return(Distance);

#ifdef debug
          fprintf(stderr," End of function PtLinePerpDistance \n");
#endif

}

