/*LINTLIBRARY*/
#ifndef lint
static char sccsid[] = "@(#)amiga.c 1.2 92/01/05" ;
#endif

/*  @(#)amiga.c 1.2 92/01/05
 *
 *  Popi device driver for the Amiga.
 *  Written by Peter Chubb - Softway Pty Ltd.
 *
 *  Popi was originally written by Gerard J. Holzmann - AT&T Bell Labs.
 *  This version is based on the code in his Prentice Hall book,
 *  "Beyond Photography - the digital darkroom," ISBN 0-13-074410-7,
 *  which is copyright (c) 1988 by Bell Telephone Laboratories, Inc. 
 *
 *  Permission is given to distribute these extensions, as long as these
 *  introductory messages are not removed, and no monies are exchanged.
 *
 *  No responsibility is taken for any errors or inaccuracies inherent
 *  either to the comments or the code of this program, but if reported
 *  (see README file) then an attempt will be made to fix them.
 */

#include "popi.h"
#include "graphics.h"
#include <exec/types.h>
#include <intuition/intuition.h>
#include <proto/graphics.h>
#include <proto/intuition.h>
#define Debug _X
#include <proto/exec.h>

/*  These are the exportable routines used by the popi program.
 *
 *  disp_init(argc, argv)    - called from main at the start.
 *  disp_finish()            - called from main prior to exit.
 *  disp_imgstart(w,h,c)     - called prior to drawing an image.
 *  disp_imgend()            - called after drawing an image.
 *  disp_putline(l,y,w,c)    - to draw an image scanline triple.
 *  disp_getchar()           - to get the next character typed.
 *  disp_prompt()            - display popi prompt and clear input buffer.
 *  disp_error(errtype)      - display error message.
 *  disp_percentdone(n)      - display percentage value of conversion.
 *  disp_resize(w,h)         - resize popi image window (width, height).
 *  disp_colormap(n,r,g,b)   - load new colormap
 */


static struct NewScreen NewScreen = {
	0, /* LeftEdge */
	0, /* TopEdge */
	0, /* Width */
	0, /* HEight */
	4, /* No. Bitplanes */
	0, 1, /* DetailPen, BlockPen */
	HIRES | LACE, /* ViewModes */
	CUSTOMSCREEN, /* Screen type */
	(struct TextAttr *)NULL,	/* default font */
	"popi",		/* Screen Title */
	(struct Gadget *)NULL, /* Gadget list */
	(struct BitMap *)NULL /* custom bitmap */
 };

struct IntuitionBase *IntuitionBase;
struct GfxBase *GfxBase;
static struct Screen *disp;

/*ARGSUSED*/
void
disp_init(argc,argv)           /* called from main at the atart. */
int argc;
char *argv[];
{
  long cnum;

  if((IntuitionBase = (struct IntuitionBase *) OpenLibrary("intuition.library", 0))
	== NULL){
	fprintf(stderr, "Couldn't open intuition\n");
	exit(10);
  }
  if((GfxBase = (struct GfxBase *)OpenLibrary("graphics.library", 0))==NULL){
	fprintf(stderr, "Couldn't open Graphics library\n");
	CloseLibrary((struct Library *)IntuitionBase);
	exit(10);
  }

  NewScreen.Width  = Xsize;
  NewScreen.Height = Ysize;
  if((disp = OpenScreen(&NewScreen)) == NULL){
	fprintf(stderr, "Couldn't open new screen\n");
	CloseLibrary((struct Library *)IntuitionBase);
	CloseLibrary((struct Library *)GfxBase);
	exit(10);
  }
  SetDrMd((&(disp->RastPort)), (long)JAM1);
  for(cnum = 0; cnum < 16; cnum++)
	SetRGB4(&(disp->ViewPort), cnum, cnum, cnum, cnum);   

}


void
disp_finish()                  /* called from main prior to exit. */
{
    CloseScreen(disp);
    CloseLibrary((struct Library *)IntuitionBase);
    CloseLibrary((struct Library *)GfxBase);
}


void
disp_imgstart(width, height, ncolors)  /* called prior to drawing an image. */
int width, height, ncolors ;
{
	ScreenToFront(disp);
}


void
disp_imgend()                  /* called after drawing an image. */
{
}


void
disp_putline(lines, y, width, ncolors)	/* called to draw image scanline y. */
pixel_t **lines;
int y, width, ncolors;
{
    short x;
    pixel_t *line;

    line = ntsc_luma(lines, y, width);
    for (x = 0; x < width;)
    {
	SetAPen(&(disp->RastPort), (long)((*line++)>>4));
	WritePixel(&(disp->RastPort), (long)x++, (long)y);
    }
}


disp_getchar()                 /* get next user typed character. */
{
  return(getchar());
}


disp_prompt()                  /* display popi prompt. */
{
  PRINTF("-> ");
  return 3;
}


void
disp_error(errtype, pos)            /* display error message. */
int	errtype,
	pos;
{
    extern int  errno;
    extern char *sys_errlist[];

    if (errtype & ERR_PARSE)
    {
        int     i;
 
        for (i=1; i < pos; ++i)
            PUTC('-', stderr);
        PUTC('^', stderr);
        PUTC('\n', stderr);
    }
 
    FPRINTF(stderr, "%s\n", ErrBuf);
    /* we assume errno hasn't been reset by the preceding output */
    if (errtype & ERR_SYS)
        FPRINTF(stderr, "\t(%s)\n", sys_errlist[errno]);
}

void
disp_percentdone(percent)
int	percent;
{
    static int	lastpercent = 100;

    if (!Verbose)
	return;
    if (percent == 100)
    {
	printf("\r    \n");
	return;
    }
    if (percent != lastpercent && percent % 5 == 0)
    {
	printf("\r%2d%% ", percent);
	fflush(stdout);
	lastpercent = percent;
    }
}


void
disp_resize(width, height)        /* Resize popi image window. */
int width, height ;
{
}


void
disp_colormap(n, red, green, blue)      /* Load new colormap. */
int n ;
unsigned char *red, *green, *blue ;
{
}
