/* mountain.h,v 1.1.1.1 1995/02/27 07:38:34 explorer Exp */

/*
 * Peter Janssen - janssen@cs.kuleuven.ac.be
 */

#ifndef MOUNTAIN_H
#define MOUNTAIN_H

#define GeomMountainCreate(p1, p2, n, d, e, l, s, g)  \
            GeomCreate((GeomRef)MountainCreate(p1, p2, n, d, e, l, s, g), MountainMethods())

#define     X  0
#define     Y  1
#define   LOW  0
#define  HIGH  1


typedef struct HeightValue {
       Float                 Value;
       struct HeightValue   *Next;
} HeightValue;

typedef struct StartGridStruct {
       int       Size;
       Float   **Data;
} StartGridStruct;

typedef struct CalcList {
       struct CalcList     *Previous;
       int                  x;
       int                  y;
       Float                Data[3][3];
       int                  ToDo[3][3];
       struct CalcList     *Next;
} CalcList;

typedef struct HeightCache {
       int    x;
       int    y;
       Float  z;
} HeightCache;

typedef struct Mountain {
       int           Number;
       int           IterationLevel;
       int           EvolveLevel;
       Float         FractalDimension;
       Float         Scale;

       int           GridMax;

       int           StartGridSize;
       Float       **StartGridData;
       int           EvolvedSize;
       Float       **EvolvedData;

       HeightCache **Cache1, **Cache2;
       Float         D2Bounds[2][2];
       Float         XSize;
       Float         YSize;
       Float         InvXSize;
       Float         InvYSize;

       int          *MaxSize;

       Vector        IntersectPos;
       Vector        Normal;

       CalcList     *ToCalcList;

} Mountain;

extern GeomRef   MountainCreate _PROTO((Vec2d, Vec2d, int, Float, int, int,
					Float, StartGridStruct *));
extern int       MountainIntersect INTERSECT_PROTO;
extern int       MountainNormal NORMAL_PROTO;
extern void      MountainUV UV_PROTO;
extern void      MountainStats STATS_PROTO;
extern char     *MountainName NAME_PROTO;
extern Methods  *MountainMethods METHODS_PROTO;
extern void      MountainBounds BOUNDS_PROTO;
extern void      MountainMethodRegister _PROTO((UserMethodType));

#endif /* MOUNTAIN_H */
