/* sphere.h,v 1.1.1.1 1995/02/27 07:38:36 explorer Exp */

/*
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 */

#ifndef SPHERE_H
#define SPHERE_H

#define GeomSphereCreate(r,p)	GeomCreate((GeomRef)SphereCreate(r,p), \
					SphereMethods())

/*
 * Sphere
 */
typedef struct {
  Float r, rsq;		/* radius, radius squared */
  Float x, y, z;	/* position */
} Sphere;

extern GeomRef  SphereCreate _PROTO((Float, Vector *));
extern Methods	*SphereMethods METHODS_PROTO;
extern int	SphereIntersect INTERSECT_PROTO;
extern int      SphereNormal NORMAL_PROTO;
extern int      SphereEnter ENTER_PROTO;
extern void     SphereUV UV_PROTO;
extern void	SphereBounds BOUNDS_PROTO;
extern char	*SphereName NAME_PROTO;
extern void     SphereStats STATS_PROTO;
extern void     SphereMethodRegister _PROTO((UserMethodType));

#endif /* SPHERE_H */
