/* cloud.h,v 1.1.1.1 1995/02/27 07:38:41 explorer Exp */

/*
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 */

#ifndef CLOUD_H
#define CLOUD_H

#define TextCloudCreate(s,h,l,n,c,o,t) TextCreate( \
			(TextRef)CloudTextCreate(s,h,l,n,c,o,t), CloudTextApply)
typedef struct {
  Float	beta;
  Float omega;
  Float lambda;
  Float scale;
  Float cthresh;
  Float range;
  Float transcale;
  Float maxval;
  int	octaves;
} CloudText;

extern CloudText *CloudTextCreate _PROTO((Float, Float, Float, int,
					  Float, Float, Float));
extern void CloudTextApply _PROTO((CloudText *, Geom *, Ray *, Vector *,
				   Vector *, Vector *, Surface *));

#endif /* CLOUDTEXT_H */
