/* stats.h,v 1.1.1.1 1995/02/27 07:38:45 explorer Exp */

/*
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 */

#ifndef STATS_H
#define STATS_H

#include "libobj/geom.h"

/*
 * Statistics
 */
typedef struct RSStats {
  unsigned long EyeRays;	/* # of eye rays spawned */
  unsigned long ShadowRays;	/* # of shadow rays spawned */
  unsigned long ReflectRays;	/* # of reflected rays */
  unsigned long RefractRays;	/* # of refracted rays */
  unsigned long HitRays;	/* # of rays that hit something. */
  unsigned long BVTests;	/* # of bounding volume tests. */
  unsigned long SuperSampled;	/* # of supersampled pixels. */
  unsigned long ShadowHits;	/* # of shadow ray hits */
  unsigned long CacheHits;	/* # of shadow cache hits */
  unsigned long CacheMisses;	/* # of shadow cache misses */
  Float Utime;			/* User time */
  Float Stime;			/* System time */
  FILE *fstats;			/* Stats/info file pointer. */
} RSStats;

extern RSStats Stats;
extern void StatsPrint _PROTO((void));
extern void StatsAddRep _PROTO((Geom *));

#endif				/* STATS_H */
