/* $Id: strwin.c,v 1.23 90/05/09 22:11:21 pturner Exp Locker: pturner $
 *
 * strings, lines, and boxes
 *
 */

#include <stdio.h>
#include <math.h>
#include <sys/types.h>
#include <sunwindow/attr.h>
#include <sunwindow/defaults.h>
#include <suntool/frame.h>
#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include <suntool/panel.h>
#include <pixrect/pixrect.h>
#include "defines.h"
#include "objdefs.h"
#include "globals.h"

void define_strings_popup();

extern Pixfont *winfont;
extern Window main_frame, main_panel;

plotstr pstr[MAXSTR];

Frame strings_frame;
static Panel strings_panel;
static Panel_item string_item;
static Panel_item strings_item;
static Panel_item strings_font_item;
static Panel_item strings_rot_item;
static Panel_item strings_size_item;
static Panel_item strings_loc_item;
static Panel_item strings_pen_item;
static Panel_item strings_just_item;
Panel_item strings_x_item;
Panel_item strings_y_item;

static Panel_item lines_arrow_item;
static Panel_item lines_asize_item;
static Panel_item lines_pen_item;
static Panel_item boxes_pen_item;
static Panel_item lines_loc_item;
static Panel_item boxes_loc_item;

static void do_strings_proc();

void drawgraph();

extern int box_color, line_color, line_arrow, line_loctype, box_loctype;
extern double line_asize;

/* default string parameters */
int string_pen = 1, string_font = 2, string_rot = 0, string_just = 0, string_loctype = 1;
double string_size = 1.0;

void do_boxes_proc()
{
    extern Cursor cursor_box;
    extern Canvas canvas;

    set_action(0);
    set_action(MAKE_BOX_1ST);
    box_color = (int) panel_get_value(boxes_pen_item) + 1;
    box_loctype = (int) panel_get_value(boxes_loc_item);
    window_set(canvas, WIN_CURSOR, cursor_box, 0);
}

void do_lines_proc()
{
    extern Cursor cursor_line;
    extern Canvas canvas;

    set_action(0);
    set_action(MAKE_LINE_1ST);
    line_color = (int) panel_get_value(lines_pen_item) + 1;
    line_arrow = (int) panel_get_value(lines_arrow_item);
    line_loctype = (int) panel_get_value(lines_loc_item);
    line_asize = (int) panel_get_value(lines_asize_item) / 50.0;
    window_set(canvas, WIN_CURSOR, cursor_line, 0);
}

void do_move_proc()
{
    extern Cursor cursor_move;
    extern Canvas canvas;

    set_action(0);
    set_action(MOVE_OBJECT_1ST);
    window_set(canvas, WIN_CURSOR, cursor_move, 0);
}

void do_delete_object_proc()
{
    extern Cursor cursor_del;
    extern Canvas canvas;

    set_action(0);
    set_action(DEL_OBJECT);
    window_set(canvas, WIN_CURSOR, cursor_del, 0);
}

updatestrings()
{
    panel_set_value(strings_font_item, string_font);
    panel_set_value(strings_pen_item, string_pen - 1);
    panel_set_value(strings_size_item, (int) (50 * string_size));
    panel_set_value(strings_rot_item, string_rot);
    panel_set_value(strings_loc_item, string_loctype);
    panel_set_value(strings_just_item, string_just);
}

update_lines_boxes()
{
    panel_set_value(lines_pen_item, line_color - 1);
    panel_set_value(lines_arrow_item, line_arrow);
    panel_set_value(lines_asize_item, (int) (50 * line_asize));
    panel_set_value(lines_loc_item, line_loctype);
    panel_set_value(boxes_pen_item, box_color - 1);
    panel_set_value(boxes_loc_item, box_loctype);
}

void define_string_defaults()
{
    string_font = (int) panel_get_value(strings_font_item);
    string_pen = (int) panel_get_value(strings_pen_item) + 1;
    string_rot = (int) panel_get_value(strings_rot_item);
    string_size = (int) panel_get_value(strings_size_item) / 50.0;
    string_loctype = (int) panel_get_value(strings_loc_item);
    string_just = (int) panel_get_value(strings_just_item);
}

void define_string(s, wx, wy)
    char *s;
    double wx, wy;
{
    int i;
    double xconv(), yconv();

    i = next_string();
    if (i >= 0) {
	strcpy(pstr[i].s, s);
	pstr[i].font = string_font;
	pstr[i].color = string_pen;
	pstr[i].rot = string_rot;
	pstr[i].size = string_size;
	pstr[i].loctype = string_loctype;
	pstr[i].just = string_just;
	if (string_loctype) {
	    pstr[i].x = xconv(wx);
	    pstr[i].y = yconv(wy);
	} else {
	    pstr[i].x = wx;
	    pstr[i].y = wy;
	}
    }
}

void strings_loc_proc()
{
    extern Cursor cursor_strloc;
    extern Canvas canvas;

    set_action(0);
    set_action(STR_LOC);
    window_set(canvas, WIN_CURSOR, cursor_strloc, 0);
}

static void strings_edit_proc()
{
    extern Cursor cursor_strloc;
    extern Canvas canvas;

    set_action(0);
    set_action(STR_EDIT);
    window_set(canvas, WIN_CURSOR, cursor_strloc, 0);
}

void do_clear_lines()
{
    int i;

    for (i = 0; i < MAXLINES; i++) {
	kill_line(i);
    }
    nlines = 0;
}

void do_clear_boxes()
{
    int i;

    for (i = 0; i < MAXBOXES; i++) {
	kill_box(i);
    }
    nboxes = 0;
}

void do_clear_text()
{
    int i;

    for (i = 0; i < MAXSTR; i++) {
	kill_string(i);
    }
    nstrings = 0;
}


static void strings_done_proc()
{
    window_set(strings_frame, WIN_SHOW, FALSE, 0);
}

void do_strings_popup()
{
    window_set(strings_frame, WIN_SHOW, TRUE, 0);
}

void define_strings_popup()
{

    strings_frame = window_create(main_frame, FRAME,
				  WIN_Y, 50,
				  WIN_FONT, winfont,
				  FRAME_LABEL, "Strings and things",
				  FRAME_SHOW_LABEL, TRUE,
			     WIN_ERROR_MSG, "Couldn't create strings_frame",
				  0);
    strings_panel = window_create(strings_frame, PANEL,
				  WIN_FONT, winfont,
				WIN_VERTICAL_SCROLLBAR, scrollbar_create(0),
				  0);

    panel_create_item(strings_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
		      panel_button_image(strings_panel, "Text", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(1),
		      PANEL_NOTIFY_PROC, strings_loc_proc,
		      0);
    panel_create_item(strings_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
		 panel_button_image(strings_panel, "Edit text", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(15),
		      PANEL_ITEM_Y, ATTR_ROW(1),
		      PANEL_NOTIFY_PROC, strings_edit_proc,
		      0);
    strings_font_item = panel_create_item(strings_panel, PANEL_CYCLE,
					  PANEL_LABEL_STRING, "Font:",
					  PANEL_CHOICE_STRINGS,
					  "Romanc",
					  "Romand",
					  "Romans",
					  "Romant",
					  "Italicc",
					  "Italict",
					  "Scriptc",
					  "Scripts",
					  "Greekc",
					  "Greeks",
					  0,
					  PANEL_ITEM_X, ATTR_COL(1),
					  PANEL_ITEM_Y, ATTR_ROW(3),
					  0);
    strings_pen_item = panel_create_item(strings_panel, PANEL_CYCLE,
					 PANEL_LABEL_STRING, "Pen:",
					 PANEL_CHOICE_STRINGS,
					 "Pen 1",
					 "Pen 2",
					 "Pen 3",
					 "Pen 4",
					 "Pen 5",
					 "Pen 6",
					 "Pen 7",
					 "Pen 8", 0,
					 PANEL_ITEM_X, ATTR_COL(1),
					 PANEL_ITEM_Y, ATTR_ROW(4),
					 0);
    strings_just_item = panel_create_item(strings_panel, PANEL_CYCLE,
				       PANEL_LABEL_STRING, "Justification:",
					  PANEL_CHOICE_STRINGS,
					  "Left",
					  "Right",
					  "Centered",
					  0,
					  PANEL_ITEM_X, ATTR_COL(1),
					  PANEL_ITEM_Y, ATTR_ROW(5),
					  0);
    strings_loc_item = panel_create_item(strings_panel, PANEL_CYCLE,
					 PANEL_LABEL_STRING, "Position in:",
					 PANEL_CHOICE_STRINGS,
					 "World coordinates",
					 "Viewport coordinates",
					 0,
					 PANEL_ITEM_X, ATTR_COL(1),
					 PANEL_ITEM_Y, ATTR_ROW(6),
					 0);
    strings_rot_item = panel_create_item(strings_panel, PANEL_SLIDER,
					 PANEL_ITEM_X, ATTR_COL(1),
					 PANEL_ITEM_Y, ATTR_ROW(7),
				   PANEL_LABEL_STRING, "Rotation (degrees)",
					 PANEL_VALUE, 0,
					 PANEL_MIN_VALUE, 0,
					 PANEL_MAX_VALUE, 360,
					 0);
    strings_size_item = panel_create_item(strings_panel, PANEL_SLIDER,
					  PANEL_ITEM_X, ATTR_COL(1),
					  PANEL_ITEM_Y, ATTR_ROW(8),
					  PANEL_LABEL_STRING, "Char size",
					  PANEL_VALUE, 50,
					  PANEL_MIN_VALUE, 10,
					  PANEL_MAX_VALUE, 300,
					  0);
    panel_create_item(strings_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
		      panel_button_image(strings_panel, "Line", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(10),
		      PANEL_NOTIFY_PROC, do_lines_proc,
		      0);
    lines_pen_item = panel_create_item(strings_panel, PANEL_CYCLE,
				       PANEL_CHOICE_STRINGS,
				       "Pen 1",
				       "Pen 2",
				       "Pen 3",
				       "Pen 4",
				       "Pen 5",
				       "Pen 6",
				       "Pen 7",
				       "Pen 8", 0,
				       PANEL_ITEM_X, ATTR_COL(10),
				       PANEL_ITEM_Y, ATTR_ROW(10),
				       0);
    lines_arrow_item = panel_create_item(strings_panel, PANEL_CYCLE,
					 PANEL_LABEL_STRING, "Arrow:",
					 PANEL_CHOICE_STRINGS,
					 "None",
					 "At start",
					 "At end",
					 "Both ends",
					 0,
					 PANEL_ITEM_X, ATTR_COL(20),
					 PANEL_ITEM_Y, ATTR_ROW(10),
					 0);
    lines_loc_item = panel_create_item(strings_panel, PANEL_CYCLE,
				       PANEL_LABEL_STRING, "Position in:",
				       PANEL_CHOICE_STRINGS,
				       "World coordinates",
				       "Viewport coordinates",
				       0,
				       PANEL_ITEM_X, ATTR_COL(40),
				       PANEL_ITEM_Y, ATTR_ROW(10),
				       0);
    lines_asize_item = panel_create_item(strings_panel, PANEL_SLIDER,
					 PANEL_ITEM_X, ATTR_COL(1),
					 PANEL_ITEM_Y, ATTR_ROW(11),
				      PANEL_LABEL_STRING, "Arrow head size",
					 PANEL_VALUE, 50,
					 PANEL_MIN_VALUE, 10,
					 PANEL_MAX_VALUE, 300,
					 0);
    panel_create_item(strings_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
		      panel_button_image(strings_panel, "Box", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(12),
		      PANEL_NOTIFY_PROC, do_boxes_proc,
		      0);
    boxes_pen_item = panel_create_item(strings_panel, PANEL_CYCLE,
				       PANEL_CHOICE_STRINGS,
				       "Pen 1",
				       "Pen 2",
				       "Pen 3",
				       "Pen 4",
				       "Pen 5",
				       "Pen 6",
				       "Pen 7",
				       "Pen 8", 0,
				       PANEL_ITEM_X, ATTR_COL(10),
				       PANEL_ITEM_Y, ATTR_ROW(12),
				       0);
    boxes_loc_item = panel_create_item(strings_panel, PANEL_CYCLE,
				       PANEL_LABEL_STRING, "Position in:",
				       PANEL_CHOICE_STRINGS,
				       "World coordinates",
				       "Viewport coordinates",
				       0,
				       PANEL_ITEM_X, ATTR_COL(20),
				       PANEL_ITEM_Y, ATTR_ROW(12),
				       0);
    panel_create_item(strings_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
		      panel_button_image(strings_panel, "Move", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(14),
		      PANEL_NOTIFY_PROC, do_move_proc,
		      0);
    panel_create_item(strings_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
		    panel_button_image(strings_panel, "Delete", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(15),
		      PANEL_NOTIFY_PROC, do_delete_object_proc,
		      0);
    panel_create_item(strings_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
	       panel_button_image(strings_panel, "Clear lines", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(17),
		      PANEL_NOTIFY_PROC, do_clear_lines,
		      0);
    panel_create_item(strings_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
	       panel_button_image(strings_panel, "Clear boxes", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(15),
		      PANEL_ITEM_Y, ATTR_ROW(17),
		      PANEL_NOTIFY_PROC, do_clear_boxes,
		      0);
    panel_create_item(strings_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
		panel_button_image(strings_panel, "Clear text", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(30),
		      PANEL_ITEM_Y, ATTR_ROW(17),
		      PANEL_NOTIFY_PROC, do_clear_text,
		      0);
    panel_create_item(strings_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
		      panel_button_image(strings_panel, "Done", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(19),
		      PANEL_NOTIFY_PROC, strings_done_proc,
		      0);
    updatestrings();
    update_lines_boxes();
    window_fit(strings_panel);
    window_fit(strings_frame);
}
