/* **********************************************************************/
/* PROGRAM : 3dfont							*/
/* 	a 3d font display program written with SUIT			*/
/* 									*/
/* Matrix Routines Originally Coded by Rod Early, June 1989		*/
/* Additions made by Matt Conway. March 1991				*/
/* Font info supplied by cs graphics class, converted to 		*/
/* 	compacted integer format by Tom Crea, June 1991			*/
/* This used to be in several files, but was brought together into	*/
/*	a single file by Randy Pausch in June 1991. (grrr). :)	     	*/
/* **********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "suit.h"

/*********** Tom's font data ************/ 
static int char40[] = {57,
820, 0, 800, 20, 760, 100, 710, 200, 660, 300, 630, 400, 580, 500,
550, 600, 530, 700, 500, 800, 480, 900, 460, 1000, 450, 1100, 440,
1200, 430, 1300, 430, 1400, 440, 1500, 450, 1600, 469, 1700, 490,
1800, 520, 1900, 540, 2000, 560, 2100, 600, 2200, 640, 2300, 680,
2400, 720, 2500, 780, 2600, 820, 2650, 650, 2650, 620, 2600, 550,
2500, 500, 2400, 450, 2300, 400, 2200, 360, 2100, 320, 2000, 290,
1900, 270, 1800, 240, 1700, 230, 1600, 220, 1500, 209, 1400, 205,
1300, 209, 1200, 220, 1100, 230, 1000, 250, 900, 270, 800, 310, 700,
340, 600, 380, 500, 430, 400, 469, 300, 540, 200, 600, 100, 650, 0};

static int char57[] = {88, 150, 1040, 200, 1040, 300, 1040, 390, 1040,
400, 1000, 450, 900, 500, 839, 570, 800, 600, 780, 700, 770, 800, 780,
900, 800, 1000, 870, 1030, 900, 1100, 1000, 1130, 1100, 1160, 1200,
1190, 1300, 1200, 1400, 1200, 1510, 1190, 1500, 1100, 1420, 1080,
1400, 1000, 1350, 900, 1290, 800, 1280, 700, 1290, 600, 1290, 550,
1300, 500, 1330, 400, 1360, 350, 1400, 300, 1440, 250, 1500, 200,
1560, 180, 1600, 140, 1700, 120, 1800, 110, 1900, 120, 2000, 130,
2100, 160, 2200, 200, 2270, 220, 2300, 300, 2400, 400, 2500, 500,
2550, 600, 2580, 700, 2600, 800, 2600, 900, 2590, 1000, 2570, 1100,
2500, 1200, 2420, 1220, 2400, 1280, 2300, 1300, 2280, 1340, 2200,
1360, 2100, 1390, 2000, 1400, 1950, 1410, 1900, 1420, 1800, 1430,
1700, 1430, 1600, 1420, 1500, 1410, 1400, 1410, 1300, 1400, 1200,
1370, 1170, 1350, 1000, 1310, 900, 1250, 800, 1200, 750, 1150, 700,
1100, 650, 1000, 600, 900, 570, 800, 550, 700, 550, 600, 560, 550,
560, 400, 600, 300, 690, 220, 800, 200, 820, 170, 900, 150, 1000, 29,
700, 1490, 650, 1500, 600, 1520, 500, 1570, 460, 1600, 410, 1700, 360,
1800, 350, 1900, 360, 2000, 380, 2100, 400, 2150, 430, 2200, 500,
2290, 600, 2340, 700, 2360, 800, 2360, 900, 2350, 1000, 2300, 1090,
2200, 1140, 2100, 1160, 2000, 1170, 1900, 1150, 1800, 1120, 1700,
1040, 1600, 1000, 1570, 900, 1530, 839, 1500, 800, 1500};

static int char32[] = {1, 100, 100};

static int char33[] = {6, 350, 2650, 590, 2650, 590, 1640, 520, 1075,
410, 1075, 350, 1640, 4, 350, 889, 590, 889, 590, 600, 350, 600};

static int char34[] = {18, 140, 2604, 398, 2604, 398, 2316, 394, 2242,
389, 2146, 381, 2107, 359, 2063, 324, 2015, 267, 1985, 197, 1958, 140,
1945, 140, 2045, 197, 2068, 245, 2094, 271, 2133, 276, 2198, 276,
2321, 140, 2321, 18, 582, 2604, 857, 2604, 853, 2316, 857, 2242, 849,
2198, 839, 2124, 814, 2059, 779, 2020, 726, 1993, 665, 1962, 582,
1945, 586, 2050, 656, 2072, 691, 2098, 722, 2155, 731, 2242, 731,
2321, 586, 2321};

static int char35[] = {28, 52, 1357, 359, 1357, 446, 1795, 153, 1795,
157, 2031, 477, 2031, 591, 2560, 809, 2560, 691, 2031, 1046, 2031,
1151, 2560, 1387, 2560, 1282, 2031, 1527, 2031, 1527, 1804, 1243,
1804, 1155, 1352, 1435, 1352, 1435, 1148, 1107, 1148, 997, 569, 783,
569, 888, 1148, 542, 1148, 438, 569, 223, 569, 324, 1148, 52, 1148, 4,
661, 1800, 1024, 1800, 932, 1366, 582, 1366};

static int char36[] = {44, 690, 2770, 850, 2770, 850, 2620, 1000,
2590, 1150, 2520, 1300, 2410, 1360, 2270, 1400, 2080, 1180, 2080,
1140, 2250, 1020, 2380, 850, 2420, 850, 1720, 1200, 1600, 1330, 1500,
1440, 1300, 1460, 1150, 1450, 1050, 1360, 820, 1250, 690, 1030, 570,
850, 550, 850, 250, 690, 250, 690, 540, 500, 580, 300, 680, 100, 1050,
100, 1190, 310, 1190, 330, 1000, 500, 790, 690, 730, 690, 1500, 400,
1600, 230, 1729, 160, 1870, 140, 2100, 180, 2260, 260, 2430, 400,
2540, 580, 2600, 690, 2620, 700, 690, 24, 20, 500, 2360, 400, 2270,
350, 2100, 360, 1950, 500, 1820, 690, 1750, 700, 850, 730, 1050, 800,
1210, 1000, 1230, 1150, 1180, 1300, 1050, 1400, 850, 1470, 1330, 1500,
1440, 1300, 1460, 1150, 1450, 1050, 1360, 820, 1250, 690, 1030, 570,
850, 550, 850, 250, 690, 250, 24, 20, 500, 2360, 400, 2270, 350, 2100,
360, 1950, 500, 1820, 690, 1750, 700, 850, 730, 1050, 800, 1210, 1000,
1230, 1150, 1180, 1300, 1050, 1400, 850, 1470, 1330, 1500, 1440, 1300,
1460, 1150, 1450, 1050, 1360, 820, 1250, 690, 1030, 570, 850, 550,
850, 250, 690, 250};

static int char37[] = {28, 100, 2200, 150, 2300, 230, 2400, 300, 2460,
400, 2500, 500, 2520, 600, 2520, 700, 2510, 800, 2470, 900, 2400, 980,
2300, 1020, 2200, 1030, 2100, 1020, 2000, 1010, 1900, 970, 1800, 900,
1700, 800, 1629, 700, 1590, 600, 1570, 500, 1570, 400, 1600, 300,
1650, 206, 1718, 149, 1800, 100, 1900, 79, 1994, 74, 2094, 15, 300,
2150, 400, 2280, 500, 2320, 600, 2320, 700, 2300, 810, 2210, 850,
2100, 857, 1990, 810, 1900, 739, 1804, 600, 1770, 500, 1779, 400,
1810, 320, 1890, 284, 2003, 4, 600, 550, 800, 550, 1900, 2600, 1720,
2600, 27, 1470, 1180, 1520, 1280, 1600, 1380, 1670, 1440, 1770, 1480,
1870, 1500, 1970, 1500, 2070, 1490, 2170, 1450, 2270, 1380, 2350,
1280, 2390, 1180, 2402, 1085, 2406, 972, 2380, 814, 2314, 692, 2214,
615, 2113, 569, 1970, 550, 1870, 550, 1770, 580, 1670, 630, 1576, 698,
1519, 780, 1470, 880, 1449, 974, 1444, 1074, 15, 1670, 1130, 1770,
1260, 1870, 1300, 1970, 1300, 2070, 1280, 2180, 1190, 2220, 1080,
2227, 970, 2188, 845, 2109, 782, 1970, 750, 1870, 760, 1770, 790,
1690, 870, 1654, 983};

static int char38[] = {55, 1490, 600, 1320, 810, 1300, 800, 1200, 710,
1100, 640, 1000, 580, 900, 560, 800, 540, 700, 530, 600, 550, 500,
580, 400, 620, 300, 700, 220, 800, 170, 900, 150, 1000, 150, 1100,
160, 1200, 180, 1300, 230, 1400, 300, 1480, 400, 1570, 600, 1710, 460,
1900, 410, 2000, 380, 2100, 380, 2200, 400, 2300, 450, 2400, 500,
2450, 600, 2530, 700, 2580, 800, 2600, 900, 2600, 1000, 2580, 1100,
2530, 1200, 2460, 1300, 2310, 1320, 2200, 1320, 2100, 1290, 2000,
1230, 1900, 1140, 1800, 920, 1679, 1300, 1200, 1340, 1300, 1390, 1400,
1400, 1530, 1610, 1530, 1600, 1400, 1580, 1300, 1530, 1200, 1490,
1100, 1450, 1020, 1800, 600, 15, 740, 1550, 1190, 980, 1100, 900,
1000, 820, 900, 780, 800, 760, 700, 760, 600, 790, 500, 850, 450, 900,
400, 1000, 390, 1100, 400, 1210, 430, 1300, 520, 1400, 15, 800, 1840,
700, 1950, 650, 2000, 620, 2100, 610, 2200, 630, 2300, 700, 2370, 800,
2400, 900, 2400, 1000, 2370, 1060, 2300, 1090, 2200, 1080, 2100, 1030,
2000, 920, 1900};

static int char39[] = {16, 180, 1950, 180, 2050, 250, 2070, 280, 2100,
300, 2140, 320, 2200, 320, 2300, 180, 2300, 180, 2600, 450, 2600, 450,
2300, 430, 2200, 400, 2100, 360, 2050, 320, 2000, 290, 1979};

static int char41[] = {35, 262, 0, 328, 104, 398, 214, 494, 410, 573,
593, 634, 798, 691, 999, 717, 1191, 726, 1313, 735, 1400, 731, 1505,
726, 1627, 700, 1806, 643, 1998, 591, 2124, 503, 2303, 433, 2416, 372,
2508, 302, 2604, 262, 2661, 104, 2661, 153, 2595, 271, 2403, 367,
2203, 416, 2037, 457, 1908, 486, 1666, 494, 1370, 486, 1130, 451, 899,
407, 698, 346, 502, 267, 301, 162, 100, 101, 0};

static int char42[] = {15, 471, 2368, 171, 2473, 114, 2321, 433, 2229,
227, 1976, 363, 1876, 547, 2155, 717, 1876, 853, 1967, 661, 2229, 962,
2290, 906, 2473, 617, 2373, 639, 2687, 455, 2687};

static int char43[] = {12, 726, 1144, 726, 579, 922, 579, 922, 1144,
1514, 1144, 1509, 1352, 918, 1352, 922, 1936, 726, 1936, 726, 1352,
144, 1352, 144, 1144};

static int char44[] = {15, 250, 170, 250, 300, 300, 330, 350, 400,
400, 490, 430, 600, 260, 600, 250, 889, 550, 889, 550, 600, 530, 500,
500, 410, 430, 300, 400, 270, 300, 190};

static int char45[] = {4, 135, 1480, 800, 1480, 800, 1280, 135, 1280};

static int char46[] = {4, 250, 600, 250, 889, 530, 889, 530, 600};

static int char47[] = {4, 650, 2600, 800, 2600, 130, 540, -20, 540};

static int char48[] = {62, 120, 1550, 125, 1729, 150, 1940, 175, 2080,
200, 2130, 250, 2270, 300, 2360, 350, 2420, 400, 2470, 450, 2500, 500,
2530, 550, 2560, 600, 2580, 650, 2590, 700, 2595, 750, 2600, 800,
2600, 850, 2595, 900, 2590, 950, 2580, 1000, 2560, 1050, 2530, 1100,
2500, 1150, 2470, 1200, 2420, 1250, 2360, 1300, 2280, 1350, 2150,
1375, 2020, 1400, 1929, 1425, 1820, 1440, 1550, 1425, 1280, 1400,
1200, 1375, 1100, 1350, 1000, 1300, 860, 1250, 780, 1200, 710, 1150,
670, 1100, 630, 1050, 600, 1000, 580, 950, 560, 900, 550, 850, 545,
800, 540, 750, 540, 700, 545, 650, 550, 600, 570, 550, 590, 500, 600,
450, 630, 400, 680, 350, 730, 300, 790, 250, 860, 200, 1000, 175,
1050, 150, 1200, 125, 1370, 38, 360, 1550, 375, 1710, 400, 1940, 450,
2140, 500, 2210, 550, 2280, 600, 2310, 650, 2340, 700, 2360, 750,
2370, 800, 2370, 850, 2360, 900, 2340, 950, 2320, 1000, 2280, 1050,
2230, 1100, 2150, 1150, 1950, 1170, 1779, 1190, 1550, 1170, 1300,
1150, 1200, 1100, 989, 1050, 900, 1000, 850, 950, 810, 900, 790, 850,
770, 800, 760, 750, 760, 700, 770, 650, 790, 600, 810, 550, 850, 500,
900, 450, 980, 400, 1160, 375, 1390};

static int char49[] = {13, 750, 600, 980, 600, 980, 2600, 810, 2600,
780, 2500, 740, 2400, 687, 2320, 600, 2260, 500, 2240, 400, 2220, 290,
2200, 290, 2020, 750, 2020}; static int char50[] = {55, 100, 600,
1420, 600, 1420, 830, 340, 830, 360, 900, 400, 970, 419, 1000, 520,
1100, 600, 1180, 700, 1250, 800, 1300, 1100, 1450, 1200, 1540, 1300,
1629, 1350, 1700, 1400, 1800, 1430, 1900, 1440, 2000, 1430, 2100,
1400, 2200, 1360, 2300, 1300, 2400, 1200, 2500, 1100, 2550, 1000,
2570, 900, 2590, 800, 2600, 700, 2590, 600, 2570, 500, 2550, 400,
2500, 300, 2400, 200, 2250, 170, 2100, 150, 1910, 390, 1910, 400,
2100, 500, 2280, 600, 2340, 700, 2380, 800, 2390, 900, 2380, 1000,
2340, 1100, 2260, 1180, 2100, 1190, 2000, 1180, 1900, 1100, 1750,
1000, 1650, 600, 1420, 500, 1360, 400, 1300, 300, 1200, 200, 1070,
150, 900}; static int char51[] = {123, 130, 1960, 150, 2080, 200,
2290, 250, 2370, 300, 2440, 350, 2480, 400, 2515, 450, 2540, 500,
2570, 550, 2580, 600, 2590, 650, 2595, 700, 2600, 750, 2605, 800,
2600, 850, 2595, 900, 2590, 950, 2580, 1000, 2570, 1050, 2540, 1100,
2510, 1150, 2490, 1200, 2450, 1250, 2400, 1300, 2320, 1350, 2200,
1370, 2020, 1350, 1910, 1300, 1800, 1250, 1750, 1200, 1690, 1150,
1660, 1130, 1629, 1150, 1610, 1200, 1590, 1250, 1560, 1300, 1520,
1350, 1470, 1400, 1350, 1430, 1130, 1400, 960, 1350, 860, 1300, 780,
1250, 730, 1200, 680, 1150, 650, 1100, 620, 1050, 600, 1000, 580, 950,
570, 900, 560, 850, 550, 800, 545, 750, 540, 700, 545, 650, 550, 600,
560, 550, 570, 500, 580, 450, 590, 400, 610, 350, 650, 300, 680, 250,
740, 200, 790, 150, 900, 100, 1080, 90, 1180, 330, 1180, 350, 1030,
400, 900, 450, 850, 500, 810, 550, 780, 600, 770, 650, 760, 700, 750,
750, 755, 800, 750, 850, 760, 900, 780, 950, 800, 1000, 820, 1050,
850, 1100, 900, 1150, 1000, 1180, 1130, 1150, 1290, 1100, 1400, 1050,
1450, 1000, 1480, 950, 1490, 900, 1500, 800, 1510, 630, 1510, 630,
1729, 700, 1729, 750, 1735, 800, 1740, 850, 1745, 900, 1750, 950,
1770, 1000, 1790, 1050, 1829, 1100, 1950, 1110, 2050, 1100, 2150,
1050, 2270, 1000, 2310, 950, 2350, 900, 2360, 850, 2370, 800, 2375,
750, 2380, 700, 2375, 650, 2370, 600, 2360, 550, 2340, 500, 2300, 450,
2250, 400, 2160, 385, 2070, 370, 1960}; static int char52[] = {11,
939, 600, 1180, 600, 1180, 1070, 1470, 1070, 1470, 1300, 1180, 1300,
1180, 2600, 989, 2600, 80, 1340, 80, 1080, 939, 1080, 3, 300, 1300,
939, 1300, 939, 2200}; static int char53[] = {61, 1536, 2596, 1536,
2329, 704, 2329, 630, 1821, 700, 1868, 796, 1895, 897, 1912, 989,
1908, 1098, 1904, 1203, 1862, 1334, 1795, 1435, 1700, 1522, 1596,
1566, 1510, 1597, 1406, 1610, 1298, 1614, 1198, 1610, 1103, 1588,
1004, 1540, 900, 1488, 796, 1404, 683, 1299, 601, 1199, 551, 1103,
529, 1002, 524, 901, 529, 796, 533, 704, 556, 604, 615, 498, 692, 398,
796, 341, 900, 319, 1004, 311, 1103, 556, 1103, 578, 1004, 643, 895,
700, 841, 792, 782, 893, 759, 997, 759, 1103, 778, 1203, 827, 1304,
913, 1356, 1004, 1391, 1103, 1396, 1203, 1387, 1307, 1365, 1406, 1334,
1492, 1269, 1578, 1199, 1623, 1103, 1673, 997, 1682, 901, 1682, 796,
1664, 678, 1601, 599, 1524, 363, 1524, 494, 2596}; static int char54[]
= {73, 354, 1796, 363, 1889, 389, 1985, 438, 2098, 498, 2198, 599,
2303, 700, 2355, 796, 2373, 906, 2373, 1006, 2338, 1068, 2303, 1129,
2238, 1155, 2168, 1168, 2085, 1400, 2085, 1378, 2203, 1343, 2294,
1286, 2390, 1199, 2469, 1098, 2539, 1006, 2569, 901, 2595, 792, 2595,
700, 2587, 595, 2556, 498, 2499, 394, 2425, 293, 2307, 235, 2198, 193,
2094, 144, 1889, 131, 1787, 123, 1675, 123, 1579, 123, 1470, 123,
1378, 136, 1295, 144, 1191, 162, 1095, 188, 995, 241, 868, 302, 763,
363, 702, 490, 602, 595, 567, 700, 541, 801, 532, 884, 528, 1006, 554,
1094, 598, 1194, 667, 1299, 768, 1365, 868, 1413, 985, 1439, 1099,
1448, 1200, 1439, 1291, 1418, 1396, 1382, 1492, 1330, 1596, 1243,
1692, 1199, 1723, 1094, 1784, 997, 1815, 901, 1832, 796, 1841, 700,
1828, 599, 1796, 494, 1732, 403, 1658, 359, 1601, 346, 1696, 350,
1740, 24, 696, 768, 604, 798, 490, 885, 416, 999, 385, 1090, 376,
1204, 389, 1300, 419, 1396, 498, 1505, 586, 1575, 696, 1614, 792,
1636, 897, 1627, 1006, 1596, 1103, 1496, 1151, 1396, 1181, 1300, 1194,
1195, 1181, 1077, 1172, 999, 1120, 899, 997, 794, 893, 750, 809, 746};
static int char55[] = {22, 390, 600, 500, 1000, 600, 1290, 700, 1500,
800, 1690, 900, 1860, 1000, 2020, 1100, 2190, 1200, 2370, 120, 2370,
120, 2600, 1460, 2600, 1460, 2390, 1400, 2300, 1300, 2150, 1200, 2000,
1100, 1850, 1000, 1650, 900, 1440, 800, 1190, 700, 830, 650, 600};
static int char56[] = {77, 918, 2600, 1014, 2569, 1100, 2535, 1146,
2499, 1200, 2470, 1270, 2400, 1300, 2356, 1330, 2300, 1365, 2211,
1380, 2100, 1370, 2000, 1350, 1900, 1300, 1820, 1285, 1800, 1200,
1715, 1185, 1700, 1120, 1650, 1200, 1620, 1220, 1600, 1291, 1553,
1347, 1496, 1378, 1444, 1400, 1380, 1430, 1300, 1440, 1200, 1450,
1150, 1440, 1100, 1430, 1000, 1400, 920, 1365, 846, 1330, 800, 1300,
770, 1240, 700, 1200, 665, 1098, 619, 1000, 580, 900, 555, 800, 545,
770, 540, 700, 545, 600, 555, 500, 580, 450, 600, 400, 630, 300, 700,
250, 750, 220, 800, 170, 850, 155, 900, 130, 1000, 115, 1100, 110,
1150, 115, 1200, 130, 1300, 160, 1400, 200, 1445, 230, 1500, 300,
1570, 350, 1600, 400, 1629, 430, 1650, 400, 1670, 360, 1700, 300,
1750, 250, 1800, 209, 1900, 180, 2000, 175, 2080, 180, 2100, 200,
2200, 240, 2300, 300, 2400, 400, 2495, 500, 2540, 600, 2580, 665,
2600, 779, 2613, 40, 879, 2421, 918, 2403, 958, 2395, 1002, 2373,
1063, 2334, 1111, 2255, 1130, 2180, 1140, 2120, 1140, 2020, 1110,
1950, 1090, 1920, 1060, 1879, 1010, 1829, 991, 1820, 945, 1800, 904,
1790, 853, 1779, 802, 1770, 750, 1770, 704, 1779, 648, 1790, 607,
1800, 576, 1820, 535, 1850, 509, 1890, 489, 1940, 467, 1979, 453,
2029, 448, 2070, 442, 2130, 458, 2190, 467, 2250, 484, 2270, 512,
2316, 540, 2340, 576, 2370, 622, 2390, 663, 2400, 731, 2416, 783,
2421, 46, 786, 1560, 814, 1562, 889, 1550, 939, 1530, 1000, 1510,
1050, 1470, 1090, 1430, 1130, 1390, 1170, 1340, 1190, 1280, 1200,
1220, 1210, 1160, 1200, 1120, 1190, 1060, 1180, 1010, 1150, 953, 1110,
912, 1070, 871, 1020, 835, 971, 814, 922, 798, 858, 784, 807, 778,
761, 776, 704, 784, 637, 796, 607, 809, 540, 835, 504, 855, 442, 907,
417, 947, 402, 989, 376, 1050, 366, 1110, 361, 1180, 366, 1240, 381,
1300, 402, 1350, 430, 1400, 463, 1440, 498, 1470, 550, 1500, 602,
1520, 653, 1540, 699, 1550, 735, 1560}; static int char58[] = {4, 310,
2080, 600, 2080, 600, 1790, 310, 1790, 4, 310, 889, 600, 889, 600,
600, 310, 600}; static int char59[] = {4, 320, 2050, 600, 2050, 600,
1770, 320, 1770, 16, 320, 889, 600, 889, 600, 600, 580, 500, 550, 400,
500, 310, 450, 250, 380, 200, 320, 180, 320, 300, 350, 330, 400, 380,
430, 430, 460, 500, 490, 600, 320, 600}; static int char60[] = {7,
136, 1162, 1496, 565, 1501, 800, 411, 1271, 1501, 1704, 1501, 1926,
136, 1357}; static int char61[] = {4, 140, 1590, 1510, 1590, 1510,
1400, 140, 1400, 4, 140, 1110, 1510, 1110, 1510, 920, 140, 920};
static int char62[] = {7, 136, 571, 136, 794, 1247, 1252, 136, 1704,
136, 1932, 1514, 1365, 1514, 1147}; static int char63[] = {4, 922,
597, 918, 885, 687, 885, 687, 597, 50, 918, 1378, 945, 1451, 1063,
1567, 1181, 1684, 1269, 1790, 1361, 1896, 1404, 2028, 1409, 2188,
1374, 2347, 1304, 2459, 1168, 2575, 1076, 2624, 1002, 2648, 897, 2667,
843, 2667, 792, 2667, 704, 2653, 595, 2629, 498, 2590, 398, 2527, 302,
2397, 258, 2297, 227, 2202, 214, 2103, 214, 2040, 459, 2040, 459,
2107, 471, 2207, 498, 2302, 538, 2356, 595, 2401, 700, 2451, 792,
2465, 853, 2474, 941, 2464, 1014, 2430, 1103, 2374, 1177, 2302, 1203,
2198, 1199, 2157, 1194, 2103, 1172, 1999, 1103, 1886, 1002, 1786, 906,
1695, 805, 1596, 726, 1479, 687, 1370, 691, 1176, 918, 1176}; static
int char64[] = {168, 2010, 310, 1900, 280, 1800, 250, 1700, 230, 1600,
209, 1500, 200, 1400, 190, 1300, 190, 1200, 200, 1100, 220, 1000, 250,
900, 270, 800, 310, 700, 370, 600, 430, 500, 500, 400, 580, 300, 690,
290, 700, 230, 800, 180, 900, 150, 1000, 120, 1100, 100, 1200, 100,
1400, 110, 1500, 130, 1600, 160, 1700, 200, 1800, 250, 1900, 300,
2000, 360, 2100, 440, 2200, 540, 2300, 600, 2350, 700, 2430, 800,
2490, 900, 2540, 1000, 2580, 1100, 2620, 1200, 2630, 1300, 2650, 1400,
2670, 1500, 2670, 1600, 2660, 1700, 2650, 1800, 2630, 1900, 2600,
2000, 2570, 2100, 2520, 2200, 2460, 2300, 2400, 2400, 2310, 2500,
2200, 2550, 2100, 2600, 2000, 2650, 1900, 2670, 1800, 2680, 1700,
2680, 1600, 2660, 1500, 2640, 1400, 2620, 1300, 2560, 1200, 2510,
1100, 2430, 1000, 2330, 900, 2300, 870, 2200, 810, 2100, 780, 2000,
760, 1900, 760, 1800, 770, 1700, 800, 1650, 850, 1600, 970, 1500, 870,
1400, 810, 1300, 780, 1200, 770, 1100, 780, 1000, 820, 900, 880, 880,
900, 810, 1000, 770, 1100, 750, 1200, 750, 1300, 760, 1400, 780, 1500,
820, 1600, 870, 1700, 939, 1800, 1030, 1900, 1100, 1950, 1200, 2000,
1300, 2040, 1400, 2050, 1500, 2060, 1600, 2040, 1700, 1979, 1800,
1850, 1810, 1810, 1879, 2000, 2110, 2000, 1810, 1110, 1810, 1070,
1829, 1000, 1900, 950, 1950, 939, 2000, 950, 2100, 980, 2200, 1040,
2250, 1100, 2340, 1200, 2400, 1300, 2430, 1400, 2460, 1500, 2470,
1600, 2460, 1700, 2430, 1800, 2400, 1900, 2340, 2000, 2280, 2100,
2200, 2180, 2100, 2250, 2000, 2320, 1900, 2370, 1800, 2400, 1700,
2450, 1600, 2460, 1500, 2470, 1400, 2470, 1300, 2460, 1200, 2440,
1100, 2400, 1000, 2370, 900, 2300, 800, 2230, 700, 2150, 650, 2100,
570, 2000, 500, 1900, 440, 1800, 400, 1700, 360, 1600, 340, 1500, 330,
1400, 340, 1300, 350, 1200, 370, 1100, 400, 1000, 450, 900, 520, 800,
600, 720, 700, 640, 800, 570, 900, 510, 1000, 450, 1100, 419, 1200,
410, 1300, 400, 1500, 400, 1600, 410, 1700, 430, 1800, 450, 1900, 480,
1929, 500, 27, 1300, 930, 1200, 950, 1100, 1020, 1050, 1070, 1030,
1100, 1010, 1200, 1010, 1300, 1020, 1400, 1040, 1500, 1080, 1600,
1140, 1700, 1200, 1760, 1300, 1829, 1400, 1860, 1500, 1879, 1600,
1829, 1660, 1800, 1710, 1700, 1720, 1600, 1700, 1500, 1679, 1400,
1640, 1300, 1600, 1200, 1550, 1100, 1500, 1050, 1450, 1000, 1400,
970};

static int char65[] = {8, 50, 600, 800, 2650, 1120, 2650, 1829, 600,
1540, 600, 1330, 1220, 540, 1220, 320, 600, 3, 620, 1430, 960, 2330,
1280, 1430};

static int char66[] = {31, 220, 600, 220, 2650, 1170, 2650, 1300,
2630, 1360, 2600, 1400, 2570, 1500, 2500, 1600, 2400, 1629, 2300,
1660, 2200, 1670, 2100, 1660, 2000, 1620, 1900, 1570, 1800, 1500,
1750, 1390, 1690, 1500, 1640, 1570, 1600, 1600, 1580, 1670, 1500,
1720, 1420, 1750, 1300, 1760, 1200, 1750, 1100, 1720, 1000, 1690, 910,
1610, 800, 1500, 700, 1400, 640, 1300, 610, 1200, 600, 16, 490, 1770,
490, 2430, 1000, 2430, 1100, 2400, 1140, 2400, 1200, 2380, 1300, 2330,
1320, 2300, 1380, 2200, 1400, 2100, 1390, 2000, 1350, 1900, 1300,
1840, 1210, 1800, 1100, 1775, 1000, 1770, 16, 490, 820, 490, 1530,
1100, 1530, 1200, 1520, 1300, 1500, 1400, 1440, 1430, 1400, 1480,
1300, 1500, 1200, 1480, 1100, 1440, 1000, 1400, 925, 1360, 900, 1300,
860, 1200, 825, 1100, 820};

static int char67[] = {56, 1600, 2020, 1850, 2020, 1800, 2200, 1700,
2360, 1600, 2490, 1500, 2550, 1400, 2600, 1300, 2630, 1200, 2660,
1100, 2680, 1000, 2690, 800, 2650, 700, 2610, 600, 2560, 500, 2500,
400, 2400, 300, 2270, 200, 2029, 150, 1800, 130, 1600, 150, 1400, 200,
1200, 300, 950, 400, 820, 500, 720, 600, 650, 700, 600, 900, 550,
1000, 540, 1100, 550, 1300, 590, 1500, 680, 1600, 750, 1700, 850,
1800, 1020, 1900, 1340, 1629, 1340, 1500, 1000, 1300, 820, 1100, 780,
1000, 780, 800, 810, 680, 900, 580, 1000, 430, 1300, 410, 1500, 410,
1700, 500, 2100, 600, 2270, 800, 2400, 1000, 2470, 1200, 2440, 1300,
2400, 1400, 2320, 1510, 2210, 1600, 2020};

static int char68[] = {26, 250, 600, 250, 2650, 1100, 2650, 1200,
2640, 1300, 2620, 1400, 2580, 1500, 2520, 1600, 2440, 1700, 2320,
1770, 2200, 1810, 2100, 1840, 2000, 1860, 1900, 1879, 1800, 1890,
1600, 1879, 1400, 1860, 1300, 1840, 1200, 1779, 1100, 1729, 1000,
1650, 900, 1600, 839, 1500, 750, 1400, 680, 1300, 630, 1220, 600, 23,
520, 820, 520, 2420, 1030, 2420, 1100, 2420, 1200, 2400, 1300, 2360,
1400, 2280, 1480, 2200, 1530, 2100, 1570, 2000, 1600, 1900, 1610,
1800, 1620, 1700, 1620, 1600, 1610, 1500, 1600, 1400, 1580, 1300,
1560, 1200, 1510, 1100, 1400, 950, 1300, 860, 1200, 839, 1100, 820};

static int char69[] = {12, 1737, 598, 1737, 846, 508, 842, 508, 1531,
1627, 1531, 1627, 1775, 516, 1770, 516, 2430, 1728, 2430, 1728, 2648,
254, 2648, 254, 598};

static int char70[] = {10, 260, 600, 260, 2650, 1629, 2650, 1629,
2420, 520, 2420, 520, 1770, 1500, 1770, 1500, 1540, 520, 1540, 520,
600};

static int char71[] = {93, 1970, 2029, 1720, 2029, 1700, 2110, 1660,
2200, 1600, 2270, 1560, 2300, 1500, 2350, 1400, 2400, 1300, 2430,
1200, 2450, 1100, 2460, 1000, 2440, 900, 2420, 800, 2390, 700, 2320,
600, 2230, 500, 2080, 419, 1900, 410, 1800, 400, 1500, 410, 1400, 430,
1300, 480, 1160, 520, 1100, 580, 1000, 650, 939, 700, 889, 750, 860,
820, 820, 900, 790, 1000, 770, 1100, 760, 1200, 770, 1300, 780, 1400,
820, 1500, 880, 1600, 960, 1700, 1090, 1729, 1200, 1760, 1300, 1770,
1460, 1140, 1460, 1140, 1690, 2000, 1690, 2000, 590, 1829, 590, 1770,
850, 1650, 750, 1550, 670, 1450, 620, 1390, 590, 1310, 570, 1240, 550,
1130, 530, 1020, 530, 900, 550, 800, 580, 700, 610, 600, 660, 500,
720, 400, 820, 300, 960, 250, 1030, 200, 1170, 160, 1300, 140, 1400,
130, 1500, 120, 1600, 130, 1700, 140, 1800, 160, 1900, 180, 2000, 220,
2100, 270, 2200, 320, 2300, 400, 2390, 500, 2490, 600, 2550, 700,
2600, 800, 2630, 900, 2670, 1000, 2680, 1100, 2690, 1200, 2690, 1300,
2680, 1400, 2660, 1500, 2640, 1600, 2590, 1700, 2520, 1800, 2420,
1890, 2300, 1929, 2200, 1960, 2100};

static int char72[] = {12, 230, 2650, 230, 600, 500, 600, 500, 1550,
1550, 1550, 1550, 600, 1820, 600, 1820, 2650, 1550, 2650, 1550, 1770,
500, 1770, 500, 2650};

static int char73[] = {4, 300, 600, 550, 600, 550, 2650, 300, 2650};

static int char74[] = {30, 298, 1248, 302, 999, 341, 900, 403, 827,
498, 773, 599, 750, 700, 764, 822, 809, 893, 900, 928, 995, 945, 1094,
945, 2628, 1190, 2628, 1194, 1013, 1164, 895, 1120, 800, 1063, 710,
993, 637, 897, 583, 796, 547, 700, 538, 599, 529, 494, 542, 394, 560,
306, 597, 171, 696, 117, 796, 74, 900, 44, 1022, 44, 1248};

static int char75[] = {12, 220, 2660, 490, 2660, 490, 1629, 1500,
2660, 1860, 2660, 989, 1810, 1860, 600, 1540, 600, 830, 1629, 490,
1300, 490, 600, 220, 600};

static int char76[] = {6, 214, 592, 214, 2632, 481, 2632, 481, 827,
1492, 827, 1488, 592};

static int char77[] = {13, 209, 600, 209, 2650, 590, 2650, 1180, 900,
1770, 2650, 2150, 2650, 2150, 600, 1879, 600, 1879, 2280, 1310, 600,
1050, 600, 480, 2280, 480, 600};

static int char78[] = {10, 227, 602, 471, 602, 471, 2255, 1435, 602,
1724, 606, 1728, 2652, 1470, 2652, 1470, 999, 516, 2652, 227, 2652};

static int char79[] = {60, 1098, 2678, 1002, 2674, 884, 2661, 796,
2635, 700, 2604, 604, 2543, 508, 2486, 394, 2390, 306, 2281, 245,
2190, 201, 2102, 166, 2002, 140, 1893, 123, 1793, 117, 1701, 114,
1601, 117, 1479, 123, 1391, 149, 1274, 171, 1195, 219, 1086, 271,
1003, 315, 916, 398, 820, 503, 728, 604, 663, 704, 619, 796, 589, 897,
571, 997, 554, 1103, 545, 1203, 545, 1304, 554, 1404, 576, 1501, 611,
1597, 654, 1698, 720, 1794, 794, 1868, 881, 1929, 968, 1999, 1077,
2048, 1191, 2069, 1291, 2087, 1391, 2096, 1500, 2096, 1596, 2091,
1687, 2087, 1796, 2069, 1893, 2043, 1993, 2004, 2098, 1960, 2203,
1903, 2294, 1802, 2408, 1698, 2495, 1601, 2556, 1505, 2604, 1404,
2635, 1299, 2661, 1207, 2674, 46, 984, 2469, 897, 2451, 796, 2416,
704, 2368, 612, 2294, 529, 2194, 477, 2102, 433, 1993, 407, 1893, 394,
1796, 385, 1687, 385, 1596, 385, 1492, 403, 1396, 416, 1300, 455,
1186, 498, 1090, 599, 977, 700, 881, 796, 824, 901, 781, 997, 759,
1098, 755, 1190, 763, 1291, 776, 1404, 810, 1514, 877, 1623, 960,
1706, 1073, 1759, 1169, 1794, 1278, 1816, 1370, 1829, 1479, 1837,
1583, 1829, 1687, 1816, 1793, 1802, 1879, 1762, 1998, 1719, 2094,
1645, 2194, 1597, 2255, 1509, 2325, 1400, 2395, 1295, 2434, 1194,
2460, 1098, 2473};

static int char80[] = {19, 260, 2650, 1250, 2650, 1300, 2640, 1400,
2620, 1500, 2570, 1600, 2480, 1700, 2320, 1729, 2200, 1735, 2100,
1740, 2000, 1700, 1820, 1600, 1660, 1500, 1570, 1400, 1515, 1300,
1480, 1250, 1475, 520, 1475, 520, 600, 260, 600, 14, 520, 2420, 1150,
2420, 1200, 2420, 1300, 2380, 1400, 2290, 1450, 2200, 1460, 2100,
1470, 2110, 1460, 2000, 1450, 1900, 1380, 1800, 1300, 1725, 1210,
1700, 520, 1700};

static int char81[] = {76, 1100, 540, 1200, 545, 1300, 560, 1400, 580,
1500, 620, 1600, 670, 1640, 685, 1929, 430, 2070, 600, 1800, 820,
1879, 900, 1900, 930, 1950, 1000, 1990, 1100, 2000, 1120, 2029, 1200,
2060, 1300, 2080, 1400, 2090, 1500, 2095, 1600, 2090, 1700, 2080,
1800, 2060, 1900, 2029, 2000, 2000, 2100, 1950, 2200, 1900, 2290,
1890, 2300, 1820, 2400, 1800, 2420, 1710, 2500, 1650, 2540, 1600,
2560, 1540, 2600, 1500, 2620, 1400, 2645, 1300, 2660, 1200, 2675,
1100, 2680, 1000, 2674, 900, 2660, 800, 2645, 700, 2620, 680, 2600,
600, 2560, 500, 2500, 400, 2410, 390, 2400, 350, 2350, 310, 2300, 300,
2280, 260, 2200, 200, 2100, 160, 2000, 140, 1900, 130, 1800, 120,
1700, 120, 1600, 130, 1500, 140, 1400, 160, 1300, 185, 1200, 200,
1130, 220, 1100, 260, 1000, 300, 939, 330, 900, 400, 810, 500, 730,
530, 700, 600, 670, 700, 620, 750, 600, 800, 580, 900, 560, 1000, 545,
63, 1100, 775, 1200, 780, 1300, 800, 1400, 830, 1430, 850, 1230, 1020,
1355, 1180, 1610, 970, 1629, 1000, 1700, 1100, 1750, 1200, 1779, 1300,
1800, 1350, 1812, 1400, 1820, 1500, 1825, 1600, 1820, 1700, 1812,
1800, 1800, 1879, 1790, 1900, 1765, 2000, 1710, 2100, 1700, 2120,
1650, 2200, 1600, 2260, 1560, 2300, 1500, 2340, 1400, 2390, 1350,
2415, 1300, 2430, 1200, 2447, 1100, 2450, 1000, 2447, 900, 2430, 820,
2400, 800, 2390, 700, 2340, 650, 2300, 600, 2250, 555, 2200, 500,
2120, 485, 2100, 440, 2000, 415, 1900, 400, 1860, 385, 1800, 377,
1700, 375, 1600, 380, 1500, 395, 1400, 400, 1370, 419, 1300, 460,
1200, 500, 1110, 550, 1040, 575, 1000, 600, 980, 680, 900, 750, 850,
800, 825, 889, 800, 950, 785, 1000, 780};

static int char82[] = {51, 270, 2660, 1250, 2660, 1300, 2650, 1350,
2640, 1400, 2630, 1450, 2620, 1500, 2610, 1550, 2600, 1600, 2580,
1650, 2550, 1700, 2510, 1750, 2450, 1800, 2350, 1820, 2300, 1829,
2250, 1840, 2200, 1850, 2100, 1840, 2000, 1820, 1950, 1810, 1900,
1800, 1870, 1760, 1800, 1700, 1720, 1570, 1610, 1650, 1560, 1700,
1520, 1720, 1500, 1750, 1450, 1779, 1400, 1800, 1300, 1820, 900, 1829,
800, 1850, 750, 1879, 700, 1920, 670, 1920, 600, 1600, 600, 1570, 700,
1550, 800, 1530, 900, 1540, 1000, 1530, 1100, 1520, 1200, 1510, 1300,
1500, 1320, 1450, 1400, 1400, 1450, 1300, 1490, 520, 1490, 520, 600,
270, 600, 20, 520, 2420, 1210, 2420, 1300, 2410, 1360, 2400, 1400,
2380, 1450, 2360, 1500, 2320, 1550, 2250, 1560, 2200, 1570, 2100,
1560, 2000, 1550, 1950, 1540, 1900, 1500, 1829, 1480, 1800, 1400,
1750, 1350, 1729, 1300, 1720, 1200, 1710, 520, 1710};

static int char83[] = {105, 136, 1225, 372, 1225, 381, 1148, 381,
1044, 407, 977, 433, 900, 498, 814, 525, 796, 599, 732, 704, 692, 796,
669, 897, 655, 997, 664, 1098, 674, 1203, 692, 1295, 728, 1378, 796,
1404, 832, 1439, 904, 1474, 999, 1501, 1094, 1488, 1198, 1431, 1298,
1404, 1329, 1304, 1406, 1199, 1438, 1103, 1470, 997, 1497, 897, 1524,
801, 1547, 700, 1569, 604, 1601, 498, 1637, 398, 1687, 302, 1777, 232,
1899, 214, 1994, 214, 2198, 235, 2297, 293, 2401, 367, 2492, 494,
2591, 604, 2628, 700, 2659, 796, 2677, 901, 2682, 1010, 2682, 1098,
2664, 1203, 2637, 1304, 2610, 1413, 2546, 1492, 2487, 1584, 2392,
1649, 2293, 1670, 2202, 1670, 2089, 1435, 2089, 1426, 2216, 1361,
2302, 1304, 2347, 1216, 2406, 1098, 2451, 997, 2469, 897, 2456, 796,
2451, 700, 2433, 621, 2397, 512, 2306, 455, 2207, 429, 2098, 455,
1994, 573, 1904, 696, 1850, 796, 1821, 906, 1791, 1010, 1764, 1098,
1732, 1194, 1709, 1304, 1673, 1418, 1642, 1505, 1604, 1597, 1515,
1698, 1393, 1737, 1289, 1741, 1198, 1737, 1103, 1719, 999, 1698, 909,
1632, 787, 1536, 674, 1426, 574, 1330, 515, 1199, 465, 1094, 461, 997,
456, 893, 461, 801, 461, 700, 469, 604, 479, 503, 524, 398, 569, 298,
669, 209, 787, 149, 909, 136, 1044};

static int char84[] = {8, 60, 2650, 1670, 2650, 1670, 2430, 1000,
2430, 1000, 600, 740, 600, 740, 2430, 60, 2430};

static int char85[] = {49, 240, 2650, 500, 2650, 500, 1180, 520, 1100,
550, 1000, 600, 920, 620, 900, 700, 839, 800, 800, 900, 760, 1000,
750, 1100, 760, 1200, 780, 1280, 800, 1300, 810, 1400, 870, 1500,
1000, 1550, 1100, 1550, 1160, 1550, 2650, 1820, 2650, 1820, 1150,
1810, 1100, 1800, 1050, 1790, 1000, 1740, 900, 1700, 820, 1679, 800,
1600, 720, 1580, 700, 1500, 660, 1400, 600, 1300, 580, 1200, 550,
1100, 550, 1000, 550, 900, 560, 800, 570, 700, 590, 600, 630, 500,
690, 480, 700, 400, 780, 380, 800, 320, 900, 300, 930, 260, 1000, 250,
1100, 240, 1140};

static int char86[] = {7, 810, 600, 1100, 600, 1820, 2650, 1530, 2650,
955, 960, 380, 2650, 90, 2650};

static int char87[] = {13, 60, 2650, 360, 2650, 740, 1000, 1200, 2650,
1480, 2650, 1940, 1000, 2320, 2650, 2610, 2650, 2090, 600, 1810, 600,
1330, 2280, 870, 600, 580, 600};

static int char88[] = {12, 394, 597, 945, 1438, 1488, 597, 1837, 597,
1107, 1642, 1802, 2646, 1474, 2646, 945, 1871, 438, 2646, 104, 2646,
783, 1632, 74, 597};

static int char89[] = {9, 820, 600, 820, 1410, 40, 2650, 360, 2650,
950, 1650, 1530, 2650, 1860, 2650, 1090, 1410, 1090, 600};

static int char90[] = {10, 1632, 606, 1632, 846, 411, 842, 1610, 2412,
1610, 2648, 171, 2648, 171, 2421, 1317, 2421, 88, 837, 88, 606};

static int char91[] = {8, 184, 0, 709, 0, 709, 196, 416, 196, 416,
2456, 704, 2456, 704, 2639, 184, 2639};

static int char92[] = {4, -20, 2650, 130, 2650, 800, 550, 650, 550};

static int char93[] = {8, 60, 0, 60, 200, 340, 200, 340, 2450, 60,
2450, 60, 2650, 590, 2650, 590, 0};

static int char94[] = {7, 130, 1550, 550, 2610, 760, 2610, 1200, 1550,
1000, 1550, 660, 2380, 320, 1550};

static int char95[] = {4, -60, 100, 1620, 100, 1620, 240, -60, 240};

static int char96[] = {15, 302, 2184, 302, 2284, 315, 2365, 350, 2411,
411, 2465, 459, 2492, 459, 2591, 372, 2560, 302, 2501, 254, 2456, 227,
2420, 197, 2347, 197, 1895, 446, 1895, 446, 2184};

static int char97[] = {65, 127, 1099, 157, 1173, 197, 1243, 293, 1317,
403, 1361, 503, 1378, 665, 1405, 792, 1426, 893, 1435, 997, 1457,
1046, 1479, 1098, 1522, 1098, 1745, 1076, 1793, 1014, 1841, 910, 1889,
801, 1911, 709, 1915, 599, 1902, 498, 1854, 442, 1793, 411, 1696, 403,
1649, 179, 1649, 188, 1758, 227, 1854, 267, 1924, 337, 1985, 419,
2037, 498, 2072, 604, 2111, 704, 2120, 801, 2120, 901, 2107, 1006,
2094, 1107, 2063, 1203, 2011, 1264, 1958, 1321, 1896, 1343, 1793,
1343, 794, 1361, 759, 1400, 720, 1448, 707, 1505, 720, 1505, 567,
1404, 545, 1308, 532, 1238, 554, 1194, 584, 1151, 632, 1120, 694,
1103, 750, 997, 676, 884, 598, 796, 554, 704, 528, 595, 519, 503, 532,
403, 563, 311, 606, 219, 676, 157, 785, 131, 872, 117, 1008, 19, 1002,
1291, 897, 1261, 796, 1247, 691, 1243, 599, 1217, 498, 1191, 398,
1108, 367, 995, 376, 877, 429, 794, 503, 759, 595, 737, 700, 742, 796,
763, 901, 803, 997, 872, 1068, 942, 1098, 999, 1098, 1326};

static int char98[] = {42, 150, 600, 150, 2650, 390, 2650, 390, 1900,
480, 2000, 500, 2020, 600, 2070, 700, 2100, 800, 2120, 900, 2120,
1000, 2100, 1100, 2060, 1200, 2010, 1300, 1910, 1370, 1800, 1400,
1750, 1420, 1700, 1450, 1600, 1460, 1500, 1470, 1400, 1470, 1300,
1460, 1200, 1450, 1100, 1420, 1000, 1400, 930, 1380, 900, 1330, 800,
1300, 750, 1250, 700, 1200, 650, 1130, 600, 1000, 560, 900, 550, 800,
540, 700, 550, 600, 580, 560, 600, 500, 650, 419, 700, 400, 720, 350,
760, 350, 600, 33, 500, 900, 450, 1000, 410, 1100, 395, 1200, 390,
1300, 395, 1400, 410, 1500, 430, 1600, 469, 1700, 500, 1740, 560,
1800, 600, 1829, 700, 1870, 800, 1879, 900, 1870, 1000, 1840, 1050,
1800, 1100, 1770, 1130, 1700, 1170, 1600, 1200, 1500, 1205, 1400,
1210, 1300, 1205, 1200, 1180, 1100, 1150, 1000, 1000, 810, 960, 800,
900, 770, 800, 760, 700, 770, 630, 800, 600, 810};

static int char99[] = {68, 1120, 1580, 1330, 1580, 1320, 1700, 1300,
1800, 1250, 1900, 1140, 2000, 1100, 2040, 1000, 2080, 900, 2110, 800,
2120, 700, 2110, 600, 2100, 500, 2060, 400, 2010, 300, 1920, 200,
1779, 160, 1700, 120, 1600, 100, 1500, 90, 1400, 80, 1300, 90, 1200,
96, 1099, 123, 995, 160, 900, 209, 800, 300, 700, 400, 620, 500, 580,
600, 550, 700, 530, 800, 530, 900, 550, 1000, 580, 1100, 630, 1180,
700, 1250, 800, 1310, 900, 1330, 995, 1340, 1110, 1120, 1110, 1094,
999, 1040, 900, 960, 820, 860, 770, 740, 750, 595, 773, 512, 814, 450,
900, 398, 977, 360, 1040, 320, 1150, 315, 1338, 328, 1488, 370, 1600,
389, 1651, 440, 1750, 500, 1800, 550, 1840, 600, 1870, 690, 1900, 740,
1910, 839, 1900, 900, 1879, 950, 1850, 1030, 1800, 1060, 1750, 1100,
1650};

static int char100[] = {17, 1170, 2650, 1400, 2650, 1400, 600, 1195,
600, 1195, 760, 989, 590, 800, 530, 620, 530, 320, 640, 160, 889, 90,
1200, 104, 1600, 255, 1925, 500, 2080, 700, 2120, 900, 2080, 1170,
1900, 16, 750, 1890, 850, 1860, 1000, 1790, 1120, 1570, 1180, 1350,
1140, 1100, 1020, 860, 920, 790, 750, 750, 540, 820, 450, 930, 350,
1180, 330, 1350, 360, 1570, 419, 1720, 560, 1840};

static int char101[] = {55, 1413, 1596, 1391, 1700, 1361, 1800, 1326,
1862, 1278, 1926, 1199, 1999, 1098, 2062, 993, 2085, 897, 2112, 805,
2116, 700, 2112, 599, 2094, 498, 2053, 398, 1999, 302, 1895, 223,
1800, 171, 1695, 149, 1596, 131, 1497, 117, 1397, 114, 1302, 104,
1203, 117, 1112, 140, 1017, 171, 918, 223, 827, 298, 737, 398, 655,
494, 592, 599, 565, 700, 542, 796, 529, 897, 538, 1028, 574, 1133,
628, 1225, 696, 1317, 800, 1382, 927, 1413, 1040, 1168, 1040, 1124,
945, 1081, 859, 1002, 791, 897, 746, 796, 732, 696, 746, 573, 796,
459, 900, 398, 1022, 376, 1144, 376, 1248, 1435, 1248, 1431, 1320,
1435, 1397, 1426, 1497, 13, 1199, 1461, 1181, 1592, 1155, 1700, 1103,
1800, 1014, 1881, 897, 1926, 796, 1940, 700, 1926, 604, 1886, 498,
1804, 442, 1709, 398, 1592, 381, 1461};

static int char102[] = {23, 250, 600, 250, 1879, 50, 1879, 50, 2090,
250, 2090, 250, 2360, 300, 2510, 380, 2600, 400, 2610, 500, 2650, 600,
2660, 700, 2650, 730, 2640, 730, 2470, 650, 2480, 600, 2470, 500,
2400, 490, 2300, 490, 2090, 720, 2090, 720, 1879, 490, 1879, 490,
600};

static int char103[] = {68, 136, 434, 376, 434, 398, 339, 442, 270,
494, 230, 604, 194, 704, 180, 809, 189, 901, 211, 993, 249, 1059, 316,
1103, 398, 1124, 496, 1138, 592, 1146, 692, 1151, 768, 1107, 728,
1063, 692, 997, 642, 901, 588, 801, 556, 687, 542, 604, 545, 498, 579,
403, 619, 298, 696, 214, 800, 157, 904, 117, 985, 88, 1086, 74, 1191,
66, 1265, 66, 1370, 83, 1487, 104, 1588, 140, 1692, 188, 1800, 258,
1899, 363, 1999, 490, 2072, 599, 2112, 704, 2116, 801, 2112, 897,
2089, 997, 2035, 1098, 1949, 1155, 1886, 1155, 2089, 1382, 2085, 1382,
818, 1374, 692, 1365, 588, 1352, 484, 1334, 393, 1299, 298, 1243, 199,
1199, 144, 1103, 76, 1010, 31, 901, 13, 801, 0, 704, -5, 599, 0, 498,
13, 389, 49, 298, 99, 206, 203, 166, 288, 30, 897, 782, 796, 750, 704,
750, 604, 773, 498, 832, 438, 900, 389, 1008, 363, 1103, 346, 1203,
337, 1298, 341, 1397, 363, 1497, 385, 1592, 433, 1691, 490, 1767, 599,
1832, 700, 1854, 805, 1854, 906, 1828, 976, 1782, 1068, 1679, 1103,
1592, 1129, 1497, 1138, 1402, 1146, 1302, 1138, 1203, 1124, 1094,
1094, 1004, 1037, 900, 984, 827};

static int char104[] = {46, 200, 2650, 200, 600, 430, 600, 430, 1600,
433, 1649, 451, 1696, 469, 1729, 485, 1745, 516, 1770, 540, 1800, 599,
1841, 661, 1876, 700, 1890, 750, 1904, 796, 1919, 850, 1915, 900,
1910, 950, 1890, 1000, 1870, 1050, 1835, 1085, 1796, 1113, 1750, 1127,
1700, 1130, 1600, 1130, 600, 1370, 600, 1370, 1750, 1369, 1801, 1352,
1849, 1330, 1900, 1295, 1962, 1243, 2002, 1186, 2050, 1133, 2076,
1046, 2102, 950, 2115, 853, 2116, 748, 2107, 700, 2085, 656, 2059,
600, 2029, 550, 2000, 500, 1960, 465, 1929, 430, 1900, 430, 2650};

static int char105[] = {4, 180, 2650, 419, 2650, 419, 2360, 180, 2360,
4, 180, 2080, 419, 2080, 419, 600, 180, 600};

static int char106[] = {4, 200, 2370, 419, 2370, 419, 2660, 200, 2660,
13, 200, 2080, 419, 2080, 419, 250, 410, 200, 400, 150, 360, 100, 300,
50, 200, 0, 100, -10, -50, -20, -50, 190, 100, 200, 200, 300};

static int char107[] = {12, 170, 600, 400, 600, 400, 1160, 670, 1380,
1120, 600, 1410, 600, 820, 1570, 1330, 2080, 1030, 2080, 400, 1460,
400, 2660, 170, 2660};

static int char108[] = {4, 195, 2650, 423, 2650, 423, 600, 195, 600};

static int char109[] = {76, 200, 600, 200, 2080, 430, 2080, 430, 1890,
450, 1900, 500, 1979, 550, 2029, 600, 2070, 650, 2080, 700, 2100, 750,
2110, 800, 2115, 850, 2120, 900, 2120, 950, 2115, 1000, 2110, 1050,
2100, 1100, 2080, 1150, 2050, 1200, 2000, 1250, 1940, 1270, 1900,
1300, 1940, 1350, 1990, 1400, 2040, 1450, 2070, 1500, 2090, 1550,
2100, 1600, 2110, 1650, 2115, 1700, 2120, 1750, 2120, 1800, 2115,
1850, 2110, 1900, 2100, 1950, 2080, 2000, 2060, 2050, 2000, 2100,
1950, 2130, 1870, 2160, 1779, 2160, 600, 1920, 600, 1920, 1660, 1900,
1710, 1850, 1840, 1800, 1879, 1750, 1890, 1700, 1900, 1650, 1910,
1600, 1910, 1550, 1900, 1500, 1890, 1450, 1860, 1400, 1820, 1350,
1750, 1290, 1610, 1290, 600, 1060, 600, 1060, 1610, 1030, 1779, 1000,
1820, 950, 1870, 900, 1890, 850, 1900, 800, 1910, 750, 1910, 700,
1900, 650, 1879, 600, 1850, 550, 1810, 500, 1750, 450, 1629, 430,
1570, 430, 600, 200, 600};

static int char110[] = {32, 293, 597, 289, 2062, 516, 2062, 512, 1899,
582, 1976, 652, 2031, 726, 2071, 805, 2094, 906, 2112, 1028, 2121,
1142, 2107, 1247, 2085, 1321, 2044, 1391, 1981, 1448, 1854, 1470,
1695, 1474, 592, 1260, 592, 1260, 1695, 1251, 1773, 1207, 1818, 1155,
1854, 1098, 1871, 1014, 1895, 954, 1908, 857, 1899, 744, 1886, 652,
1845, 569, 1786, 525, 1704, 516, 1614, 516, 597};

static int char111[] = {46, 100, 1300, 100, 1400, 110, 1500, 130,
1600, 150, 1700, 200, 1800, 270, 1900, 330, 1970, 400, 2020, 500,
2070, 600, 2100, 700, 2120, 800, 2120, 900, 2110, 1000, 2090, 1100,
2050, 1200, 1979, 1300, 1870, 1340, 1800, 1380, 1700, 1410, 1600,
1420, 1500, 1430, 1400, 1420, 1300, 1420, 1200, 1410, 1100, 1400,
1000, 1350, 900, 1300, 800, 1220, 700, 1100, 610, 1000, 580, 900, 560,
800, 560, 700, 560, 600, 570, 500, 590, 400, 640, 320, 700, 300, 720,
240, 800, 200, 860, 180, 900, 150, 1000, 120, 1100, 110, 1200, 33,
320, 1300, 330, 1400, 350, 1500, 380, 1600, 400, 1650, 419, 1700, 500,
1800, 600, 1879, 700, 1879, 800, 1879, 900, 1870, 1000, 1820, 1030,
1800, 1100, 1700, 1150, 1600, 1170, 1500, 1180, 1400, 1180, 1300,
1170, 1200, 1160, 1100, 1120, 1000, 1100, 950, 1060, 900, 1000, 839,
900, 800, 800, 780, 700, 780, 600, 810, 550, 820, 460, 900, 380, 1000,
350, 1100, 330, 1200};

static int char112[] = {37, 389, -10, 162, -10, 162, 2076, 354, 2076,
354, 1899, 398, 1945, 467, 2003, 498, 2035, 604, 2085, 700, 2107, 796,
2116, 893, 2112, 1002, 2094, 1098, 2053, 1199, 1999, 1299, 1899, 1369,
1804, 1413, 1695, 1431, 1596, 1453, 1501, 1466, 1402, 1466, 1302,
1453, 1203, 1439, 1094, 1418, 1008, 1391, 904, 1330, 800, 1295, 750,
1234, 696, 1124, 610, 1002, 556, 897, 538, 801, 532, 704, 541, 591,
588, 498, 646, 385, 768, 31, 796, 772, 691, 789, 595, 837, 516, 907,
455, 1003, 411, 1090, 389, 1195, 381, 1304, 381, 1396, 398, 1496, 429,
1601, 467, 1696, 521, 1770, 599, 1841, 700, 1889, 796, 1906, 906,
1893, 997, 1845, 1059, 1801, 1103, 1745, 1146, 1687, 1177, 1614, 1199,
1496, 1216, 1400, 1216, 1304, 1199, 1200, 1177, 1095, 1146, 999, 1098,
899, 997, 810, 897, 785};

static int char113[] = {37, 1160, -10, 1400, -10, 1400, 2090, 1200,
2090, 1200, 1900, 1100, 1990, 1000, 2060, 900, 2110, 800, 2120, 700,
2120, 600, 2110, 500, 2090, 400, 2040, 340, 2000, 300, 1970, 240,
1900, 206, 1845, 162, 1773, 130, 1700, 110, 1600, 90, 1500, 83, 1293,
90, 1100, 110, 1000, 140, 900, 201, 778, 280, 674, 389, 601, 433, 583,
494, 556, 604, 529, 700, 520, 801, 533, 901, 565, 1000, 610, 1100,
690, 1160, 770, 31, 320, 1300, 324, 1393, 337, 1501, 363, 1596, 385,
1651, 410, 1700, 500, 1800, 600, 1879, 700, 1900, 800, 1900, 900,
1879, 1000, 1800, 1090, 1700, 1129, 1596, 1151, 1497, 1160, 1400,
1155, 1293, 1151, 1189, 1129, 1099, 1100, 1030, 1020, 900, 1000, 870,
900, 810, 800, 790, 700, 790, 600, 800, 500, 880, 469, 900, 400, 1000,
340, 1100, 320, 1200};

static int char114[] = {27, 200, 600, 430, 600, 430, 1400, 432, 1450,
435, 1500, 440, 1550, 460, 1600, 500, 1679, 510, 1700, 550, 1750, 600,
1800, 650, 1829, 700, 1850, 800, 1870, 900, 1879, 900, 2120, 780,
2120, 740, 2110, 700, 2100, 650, 2075, 600, 2045, 550, 2000, 500,
1950, 460, 1900, 430, 1840, 430, 2080, 200, 2080};

static int char115[] = {88, 100, 1030, 320, 1030, 330, 1000, 340, 950,
350, 900, 380, 850, 400, 839, 450, 800, 500, 780, 550, 760, 600, 740,
650, 730, 730, 730, 800, 740, 850, 760, 900, 780, 980, 800, 1020, 850,
1050, 920, 1070, 989, 1040, 1080, 970, 1130, 900, 1180, 500, 1270,
400, 1300, 300, 1350, 230, 1400, 200, 1430, 170, 1500, 140, 1600, 130,
1700, 160, 1800, 200, 1900, 290, 2000, 350, 2050, 400, 2070, 500,
2100, 600, 2110, 700, 2120, 800, 2110, 900, 2100, 1000, 2060, 1050,
2040, 1100, 2000, 1150, 1950, 1170, 1900, 1200, 1850, 1210, 1800,
1230, 1670, 1000, 1670, 1000, 1729, 980, 1800, 900, 1870, 800, 1890,
700, 1900, 600, 1890, 500, 1870, 410, 1800, 370, 1750, 350, 1700, 370,
1650, 380, 1600, 400, 1570, 450, 1530, 600, 1480, 950, 1400, 1070,
1350, 1150, 1310, 1200, 1270, 1250, 1200, 1280, 1100, 1290, 1000,
1280, 900, 1240, 800, 1200, 730, 1100, 650, 1000, 590, 900, 560, 800,
540, 700, 530, 600, 540, 500, 560, 400, 580, 300, 620, 209, 700, 140,
800, 110, 900, 100, 920};

static int char116[] = {28, 254, 1871, 254, 696, 284, 628, 328, 597,
394, 565, 433, 551, 481, 547, 525, 538, 569, 538, 617, 538, 674, 542,
713, 569, 713, 759, 674, 746, 612, 741, 569, 746, 529, 764, 498, 791,
477, 818, 477, 1871, 717, 1871, 717, 2071, 467, 2071, 467, 2469, 258,
2469, 258, 2076, 66, 2076, 61, 1871};

static int char117[] = {34, 184, 2081, 419, 2081, 419, 1021, 438, 899,
481, 837, 529, 794, 599, 763, 700, 750, 796, 755, 866, 772, 932, 816,
1002, 872, 1076, 981, 1111, 1104, 1124, 1204, 1124, 2081, 1356, 2081,
1356, 598, 1120, 598, 1120, 768, 1098, 728, 1006, 628, 935, 584, 884,
563, 796, 541, 709, 528, 604, 532, 525, 537, 394, 593, 350, 615, 284,
676, 249, 728, 214, 794, 184, 903};

static int char118[] = {7, 796, 597, 1361, 2067, 1103, 2067, 669, 872,
298, 2071, 44, 2071, 551, 597};

static int char119[] = {13, 440, 600, 20, 2080, 280, 2080, 560, 920,
860, 2080, 1150, 2080, 1420, 920, 1720, 2080, 2000, 2080, 1550, 600,
1300, 600, 989, 1720, 710, 600};

static int char120[] = {12, 311, 606, 683, 1173, 1068, 593, 1326, 593,
814, 1365, 1334, 2107, 1076, 2111, 683, 1562, 315, 2102, 52, 2102,
551, 1370, 52, 606};

static int char121[] = {19, 150, 230, 200, 220, 270, 205, 300, 209,
350, 220, 400, 250, 430, 300, 530, 580, 60, 2080, 300, 2080, 680, 960,
1100, 2080, 1340, 2080, 650, 200, 500, 50, 400, 0, 300, -20, 200, 0,
150, 15};

static int char122[] = {10, 150, 2080, 1250, 2080, 1250, 1879, 400,
820, 1290, 820, 1290, 600, 90, 600, 90, 800, 950, 1850, 150, 1850};

static int char123[] = {42, 604, -3, 508, 21, 433, 60, 376, 147, 359,
225, 346, 297, 341, 404, 346, 927, 324, 1083, 284, 1170, 232, 1209,
140, 1233, 140, 1441, 223, 1465, 284, 1528, 337, 1606, 354, 1703, 354,
2299, 385, 2474, 471, 2575, 542, 2629, 770, 2648, 770, 2483, 608,
2449, 569, 2406, 547, 2304, 547, 1698, 534, 1635, 503, 1533, 464,
1427, 376, 1339, 459, 1262, 512, 1184, 538, 1087, 547, 995, 547, 903,
547, 414, 547, 322, 582, 230, 612, 200, 774, 167, 774, -3};

static int char124[] = {4, 290, 0, 450, 0, 450, 2660, 290, 2660};

static int char125[] = {66, 90, 0, 200, 0, 300, 0, 400, 60, 430, 100,
500, 200, 520, 300, 520, 400, 520, 500, 520, 600, 520, 700, 520, 800,
516, 904, 525, 1004, 550, 1100, 600, 1160, 650, 1200, 700, 1220, 740,
1230, 740, 1420, 700, 1430, 600, 1500, 530, 1600, 520, 1700, 520,
1800, 520, 1900, 520, 2000, 520, 2100, 520, 2200, 520, 2300, 510,
2400, 500, 2440, 480, 2500, 400, 2600, 300, 2660, 200, 2660, 90, 2660,
90, 2600, 90, 2480, 200, 2460, 300, 2400, 310, 2300, 310, 2200, 310,
2100, 310, 2000, 310, 1900, 310, 1800, 320, 1700, 330, 1600, 360,
1500, 400, 1440, 430, 1400, 510, 1320, 469, 1300, 400, 1210, 330,
1100, 306, 1004, 310, 900, 310, 800, 310, 700, 310, 600, 310, 500,
310, 400, 300, 300, 230, 200, 90, 190};

static int char126[] = {43, 367, 1418, 367, 1466, 372, 1505, 381,
1562, 403, 1604, 433, 1644, 477, 1670, 529, 1679, 569, 1670, 621,
1636, 897, 1444, 954, 1405, 1006, 1378, 1059, 1348, 1124, 1343, 1186,
1348, 1234, 1365, 1304, 1405, 1343, 1448, 1387, 1514, 1418, 1601,
1431, 1696, 1439, 1745, 1308, 1749, 1304, 1684, 1278, 1614, 1251,
1562, 1207, 1535, 1151, 1518, 1094, 1527, 1054, 1548, 993, 1583, 665,
1796, 608, 1832, 564, 1841, 508, 1841, 451, 1836, 389, 1806, 324,
1753, 280, 1692, 249, 1601, 232, 1500, 227, 1418};


/****************** Rod and Matt's Matrix Stuff *******************/

#define MATSIZE		4
#define MAXINDEX	(MATSIZE - 1)
#define X 0		/* for indexing into the matricies and vectors */
#define Y 1
#define Z 2
#define W 3


typedef double Matrix[MATSIZE][MATSIZE];
typedef double Vector[MATSIZE];

void PrintMatrix(Matrix mat);
void MatMul(Matrix M1, Matrix M2, Matrix Res);
void MakeIdentityMatrix(Matrix arr);
void PrintVector(Vector Vec);
void TransformVector (Matrix M, Vector VecIn, Vector VecOut);
void ApplyScale(Matrix M, double sx, double sy, double sz);
void ApplyTranslation(Matrix M, double dx, double dy, double dz);
void ApplyRotationX(Matrix M, double radians);
void ApplyRotationY(Matrix M, double radians);
void ApplyRotationZ(Matrix M, double radians);
void CopyMatrix(Matrix dest, Matrix source);
void CopyVector(Vector dest, Vector source);



void PrintMatrix(Matrix mat)
    {
    int i,j;

    for(i=0; i< MATSIZE; i++)
	{
	for (j=0; j< MATSIZE; j++)
	    {
	    fprintf(stderr, "\t%f", mat[i][j]);
	    }
	fprintf(stderr,"\n");
	}
    fprintf(stderr,"----------------------------------\n\n");
    }


void PrintVector(Vector Vec)
    {
    int i;

    for(i=0; i< MATSIZE; i++)
	{
	fprintf(stderr, "%f, ", Vec[i]);
	}
    fprintf(stderr,"\n");
    }


void MakeIdentityMatrix(Matrix arr)
    {
    int i, j;
    
    for (i=0; i<4; i++)
	{
	for (j=0;j<4;j++)
	    {
	    arr[i][j] = 0.0;
	    if (i == j)
		arr[i][j] = 1.0;
	    }
	}
    }


void MatMul(Matrix M1, Matrix M2, Matrix Res)
    {
    double	temp;
    int	i,j,k;
    
    for (i=0; i<=MAXINDEX; i++)
	for (j=0; j<=MAXINDEX; j++)
	    {
	    temp = 0;
	    for (k=0; k<=MAXINDEX; k++)
		{
		temp += M1[i][k] * M2[k][j];
		}
	    Res[i][j] = temp;
	    }
    }


void TransformVector (Matrix M, Vector VecIn, Vector VecOut)
    {
    double temp;
    int i, j;
    
    for (i=0; i<=MAXINDEX; i++)
	{
	temp = 0;
	for (j=0; j<=MAXINDEX; j++)
	    {
	    temp += M[i][j] * VecIn[j];
	    }
	VecOut[i] = temp;
	}
    }	


void CopyMatrix (Matrix dest, Matrix source)
    {
    int	i,j;
    
    for (i=0; i<=MAXINDEX; i++)
	for (j=0; j<=MAXINDEX; j++)
	    dest[i][j] = source[i][j];
    }


void CopyVector(Vector dest, Vector source)
    {
    int	i;
    
    for (i=0; i<=MAXINDEX; i++)
	dest[i] = source[i];
    }


void ApplyRotationX(Matrix M, double radians)
    {
    Matrix temp, result;

    MakeIdentityMatrix(temp);
    temp[1][1] = cos (radians);
    temp[1][2] = -sin(radians);
    temp[2][1] = sin(radians);
    temp[2][2] = cos(radians);

    MatMul(temp, M, result);
    CopyMatrix(M, result);
    }
    

void ApplyRotationY(Matrix M, double radians)
    {
    Matrix temp, result;

    MakeIdentityMatrix(temp);
    temp[0][0] = cos (radians);
    temp[0][2] = sin(radians);
    temp[2][0] = -sin(radians);
    temp[2][2] = cos(radians);

    MatMul(temp, M, result);
    CopyMatrix(M, result);
    }


void ApplyRotationZ(Matrix M, double radians)
    {
    Matrix temp, result;

    MakeIdentityMatrix(temp);
    temp[0][0] = cos (radians);
    temp[0][1] = -sin(radians);
    temp[1][0] = sin(radians);
    temp[1][1] = cos(radians);

    MatMul(temp, M, result);
    CopyMatrix(M, result);
    }



void ApplyTranslation(Matrix M, double dx, double dy, double dz)
    {
    Matrix temp, result;

    MakeIdentityMatrix(temp);
    temp[0][3] = dx;
    temp[1][3] = dy;
    temp[2][3] = dz;
    MatMul(temp, M, result);

    CopyMatrix(M, result);
    }

void ApplyScale(Matrix M, double sx, double sy, double sz)
    {
     Matrix temp, result;

     MakeIdentityMatrix(temp);
     temp[0][0] = sx;
     temp[1][1] = sy;
     temp[2][2] = sz;
     MatMul(temp, M, result);
     CopyMatrix(M, result);
    }



/********************** Font viewer **********************/

#define	MAXCHARS	256
#define LETTER_Z_DEPTH	200.0
#define PI			3.14159
#define FLOAT_EQUAL(A,B)	( ABS((A) -(B)) < 0.0001 ) 
#define RADIANS(deg)		( ( deg * PI ) / 180.0)
#define DEGREES(rad)		( (rad * 180) / PI    )
#define SQR(X)			( X * X )

/* to keep the dumb compiler happy */
extern int scanf(const char *format, ...);
extern double atof(const char *s);
extern double atan2 (double x, double y);
extern double sqrt(double x);
extern double asin(double x);

/* 
  The font is a collection of 256 letters, not all of which are actually
  used.  Each letter is a collection of polylines.  The letter "A", for
  example, contains two polylines - one traces the outside of the letter, the
  second traces the "hole" of the "A".  This is stored as a number of runs 
  in the following struct. 
*/

typedef struct font_type {
    int width;
    int num_Runs;		/* number of closed curves for a letterform */
    int min;			/* decender depth (of this letter) */
    int max;			/* ascender height (of this letter) */
    int * data;			/* ptr to one one of the above arrays */
}font_type;

font_type font[MAXCHARS];

typedef struct foo {
    double x;
    double y;
    double z;
} gpPoint, *gpPointPtr;

/* For bounding volumes of individual characters */
typedef struct foo3  {
    Matrix  charmat;
    gpPoint origin;
    gpPoint top;
    } charDataType;


typedef struct foo2 {
    boolean	exists;
    DynArray	polylineList; /* a DynArray of DynArrays of gpPoint */
    double	width;
    double	min;
    double	max;
} letter, *letterPtr;

/* global transformation matrix */
Matrix global_mat;

/* current bounding volume -- remains pristine. Just like fonts.*/
struct box {
     gpPoint	origin;		/* back left bottom */
     gpPoint    top;		/* front right top */
} boundingBox;

double min,max;

DynArray charData;

void spin (gpPoint origin, gpPoint top, Matrix mat, double angle);

SUIT_object drawingArea, 
    xRot, 
    yRot, 
    zRot, 
    xTrans, 
    yTrans,
    zTrans,
    xScale,
    yScale,
    zScale,
    Zslider, 
    TypedString, 
    strAngle,
    charAngle,
    animate,
    axes,
    zoomer;



gpPoint TransForm(Matrix mat, double x, double y, double z)
    {
    gpPoint	retval;
    Vector	vecin, vecout;

    vecin[0] = x;
    vecin[1] = y;
    vecin[2] = z;
    vecin[3] = 1;
    
    TransformVector (mat, vecin, vecout);

    retval.x = vecout[0];
    retval.y = vecout[1];
    
    if ( SUIT_getBoolean(drawingArea, "do fake 3D") )
	{
	retval.x += z;
	retval.y += z;
	}

    return(retval);
    }


void turnFake3dOnOrOff (SUIT_object o)
    {
    SUIT_setBoolean(drawingArea, "do fake 3D", 
		    SUIT_getBoolean(o, "current value") );
    }

int minDecender (int *arr, int maxCoords)
    {
    int i;
    
    int min=30000;

    for (i=2; i<maxCoords; i+=2)
	{
	if (*(arr+i) < min)
	    min = *(arr + i);
	}	

    return min;
    }


int maxAscender (int *arr, int maxCoords)
    {
    int i;
    
    int max = -1;

    for (i=2; i<maxCoords; i+=2)
	{
	if (*(arr+i) > max)
	    max = *(arr + i);
	}	

    return max;
    }

void InitializeIntegerFonts(void)
    {
    int ch;
    int	i;
       
    for ( i = 0 ; i < MAXCHARS ; i++ )
	font[i].data = NULL;

    font['('].width = 1170;
    font['('].num_Runs = 1;
    font['('].data = char40;
    
    font['9'].width = 1800;
    font['9'].num_Runs = 2;
    font['9'].data = char57;
    
    font[' '].width = 790;
    font[' '].num_Runs = 1;
    font[' '].data = char32;
    
    font['!'].width = 790;
    font['!'].num_Runs = 2;
    font['!'].data = char33;
    
    font['"'].width = 955;
    font['"'].num_Runs = 2;
    font['"'].data = char34;
    
    font['#'].width = 1580;
    font['#'].num_Runs = 2;
    font['#'].data = char35;
    
    font['$'].width = 1580;
    font['$'].num_Runs = 3;
    font['$'].data = char36;
    
    font['%'].width = 2530;
    font['%'].num_Runs = 5;
    font['%'].data = char37;
    
    font['&'].width = 1890;
    font['&'].num_Runs = 3;
    font['&'].data = char38;
    
    font['\''].width = 630;
    font['\''].num_Runs = 1;
    font['\''].data = char39;
    
    font[')'].width = 950;
    font[')'].num_Runs = 1;
    font[')'].data = char41;
    
    font['*'].width = 1100;
    font['*'].num_Runs = 1;
    font['*'].data = char42;
    
    font['+'].width = 1560;
    font['+'].num_Runs = 1;
    font['+'].data = char43;
    
    font[','].width = 790;
    font[','].num_Runs = 1;
    font[','].data = char44;
    
    font['-'].width = 945;
    font['-'].num_Runs = 1;
    font['-'].data = char45;
    
    font['.'].width = 790;
    font['.'].num_Runs = 1;
    font['.'].data = char46;
    
    font['/'].width = 790;
    font['/'].num_Runs = 1;
    font['/'].data = char47;
    
    font['0'].width = 1580;
    font['0'].num_Runs = 2;
    font['0'].data = char48;
    
    font['1'].width = 1580;
    font['1'].num_Runs = 1;
    font['1'].data = char49;
    
    font['2'].width = 1580;
    font['2'].num_Runs = 1;
    font['2'].data = char50;
    
    font['3'].width = 1580;
    font['3'].num_Runs = 1;
    font['3'].data = char51;
    
    font['4'].width = 1580;
    font['4'].num_Runs = 2;
    font['4'].data = char52;
    
    font['5'].width = 1480;
    font['5'].num_Runs = 1;
    font['5'].data = char53;
    
    font['6'].width = 1580;
    font['6'].num_Runs = 2;
    font['6'].data = char54;
    
    font['7'].width = 1580;
    font['7'].num_Runs = 1;
    font['7'].data = char55;
    
    font['8'].width = 1580;
    font['8'].num_Runs = 3;
    font['8'].data = char56;
    
    font[':'].width = 790;
    font[':'].num_Runs = 2;
    font[':'].data = char58;
    
    font[';'].width = 790;
    font[';'].num_Runs = 2;
    font[';'].data = char59;
    
    font['<'].width = 1650;
    font['<'].num_Runs = 1;
    font['<'].data = char60;
    
    font['='].width = 1650;
    font['='].num_Runs = 2;
    font['='].data = char61;
    
    font['>'].width = 1660;
    font['>'].num_Runs = 1;
    font['>'].data = char62;
    
    font['?'].width = 1580;
    font['?'].num_Runs = 2;
    font['?'].data = char63;
    
    font['@'].width = 2880;
    font['@'].num_Runs = 2;
    font['@'].data = char64;
    
    font['A'].width = 1890;
    font['A'].num_Runs = 2;
    font['A'].data = char65;
    
    font['B'].width = 1890;
    font['B'].num_Runs = 3;
    font['B'].data = char66;
    
    font['C'].width = 2040;
    font['C'].num_Runs = 1;
    font['C'].data = char67;
    
    font['D'].width = 2040;
    font['D'].num_Runs = 2;
    font['D'].data = char68;
    
    font['E'].width = 1895;
    font['E'].num_Runs = 1;
    font['E'].data = char69;
    
    font['F'].width = 1729;
    font['F'].num_Runs = 1;
    font['F'].data = char70;
    
    font['G'].width = 2200;
    font['G'].num_Runs = 1;
    font['G'].data = char71;
    
    font['H'].width = 2040;
    font['H'].num_Runs = 1;
    font['H'].data = char72;
    
    font['I'].width = 790;
    font['I'].num_Runs = 1;
    font['I'].data = char73;
    
    font['J'].width = 1330;
    font['J'].num_Runs = 1;
    font['J'].data = char74;
    
    font['K'].width = 1890;
    font['K'].num_Runs = 1;
    font['K'].data = char75;
    
    font['L'].width = 1580;
    font['L'].num_Runs = 1;
    font['L'].data = char76;
    
    font['M'].width = 2350;
    font['M'].num_Runs = 1;
    font['M'].data = char77;
    
    font['N'].width = 2050;
    font['N'].num_Runs = 1;
    font['N'].data = char78;
    
    font['O'].width = 2200;
    font['O'].num_Runs = 2;
    font['O'].data = char79;
    
    font['P'].width = 1890;
    font['P'].num_Runs = 2;
    font['P'].data = char80;
    
    font['Q'].width = 2200;
    font['Q'].num_Runs = 2;
    font['Q'].data = char81;
    
    font['R'].width = 2040;
    font['R'].num_Runs = 2;
    font['R'].data = char82;
    
    font['S'].width = 1879;
    font['S'].num_Runs = 1;
    font['S'].data = char83;
    
    font['T'].width = 1729;
    font['T'].num_Runs = 1;
    font['T'].data = char84;
    
    font['U'].width = 2040;
    font['U'].num_Runs = 1;
    font['U'].data = char85;
    
    font['V'].width = 1890;
    font['V'].num_Runs = 1;
    font['V'].data = char86;
    
    font['W'].width = 2670;
    font['W'].num_Runs = 1;
    font['W'].data = char87;
    
    font['X'].width = 1779;
    font['X'].num_Runs = 1;
    font['X'].data = char88;
    
    font['Y'].width = 1890;
    font['Y'].num_Runs = 1;
    font['Y'].data = char89;
    
    font['Z'].width = 1729;
    font['Z'].num_Runs = 1;
    font['Z'].data = char90;
    
    font['['].width = 790;
    font['['].num_Runs = 1;
    font['['].data = char91;
    
    font['\\'].width = 800;
    font['\\'].num_Runs = 1;
    font['\\'].data = char92;
    
    font[']'].width = 790;
    font[']'].num_Runs = 1;
    font[']'].data = char93;
    
    font['^'].width = 1320;
    font['^'].num_Runs = 1;
    font['^'].data = char94;
    
    font['_'].width = 1580;
    font['_'].num_Runs = 1;
    font['_'].data = char95;
    
    font['`'].width = 640;
    font['`'].num_Runs = 1;
    font['`'].data = char96;
    
    font['a'].width = 1580;
    font['a'].num_Runs = 2;
    font['a'].data = char97;
    
    font['b'].width = 1580;
    font['b'].num_Runs = 2;
    font['b'].data = char98;
    
    font['c'].width = 1430;
    font['c'].num_Runs = 1;
    font['c'].data = char99;
    
    font['d'].width = 1577;
    font['d'].num_Runs = 2;
    font['d'].data = char100;
    
    font['e'].width = 1480;
    font['e'].num_Runs = 2;
    font['e'].data = char101;
    
    font['f'].width = 790;
    font['f'].num_Runs = 1;
    font['f'].data = char102;
    
    font['g'].width = 1580;
    font['g'].num_Runs = 2;
    font['g'].data = char103;
    
    font['h'].width = 1580;
    font['h'].num_Runs = 1;
    font['h'].data = char104;
    
    font['i'].width = 630;
    font['i'].num_Runs = 2;
    font['i'].data = char105;
    
    font['j'].width = 640;
    font['j'].num_Runs = 2;
    font['j'].data = char106;
    
    font['k'].width = 1415;
    font['k'].num_Runs = 1;
    font['k'].data = char107;
    
    font['l'].width = 640;
    font['l'].num_Runs = 1;
    font['l'].data = char108;
    
    font['m'].width = 2360;
    font['m'].num_Runs = 1;
    font['m'].data = char109;
    
    font['n'].width = 1580;
    font['n'].num_Runs = 1;
    font['n'].data = char110;
    
    font['o'].width = 1580;
    font['o'].num_Runs = 2;
    font['o'].data = char111;
    
    font['p'].width = 1580;
    font['p'].num_Runs = 2;
    font['p'].data = char112;
    
    font['q'].width = 1580;
    font['q'].num_Runs = 2;
    font['q'].data = char113;
    
    font['r'].width = 950;
    font['r'].num_Runs = 1;
    font['r'].data = char114;
    
    font['s'].width = 1410;
    font['s'].num_Runs = 1;
    font['s'].data = char115;
    
    font['t'].width = 790;
    font['t'].num_Runs = 1;
    font['t'].data = char116;
    
    font['u'].width = 1580;
    font['u'].num_Runs = 1;
    font['u'].data = char117;
    
    font['v'].width = 1420;
    font['v'].num_Runs = 1;
    font['v'].data = char118;
    
    font['w'].width = 2040;
    font['w'].num_Runs = 1;
    font['w'].data = char119;
    
    font['x'].width = 1415;
    font['x'].num_Runs = 1;
    font['x'].data = char120;
    
    font['y'].width = 1410;
    font['y'].num_Runs = 1;
    font['y'].data = char121;
    
    font['z'].width = 1420;
    font['z'].num_Runs = 1;
    font['z'].data = char122;
    
    font['{'].width = 960;
    font['{'].num_Runs = 1;
    font['{'].data = char123;
    
    font['|'].width = 740;
    font['|'].num_Runs = 1;
    font['|'].data = char124;
    
    font['}'].width = 930;
    font['}'].num_Runs = 1;
    font['}'].data = char125;
    
    font['~'].width = 1650;
    font['~'].num_Runs = 1;
    font['~'].data = char126;


    for (ch=0; ch<=MAXCHARS; ch++) 
	{
	if (font[ch].data != NULL)
	    {
	    font[ch].min = minDecender(font[ch].data, font[ch].data[0]);
	    font[ch].max = maxAscender(font[ch].data, font[ch].data[0]);
	    }
	}
    }

DrawLines (double startx, double x1, double y1, double x2, double y2)
    {
    Matrix mat;
    gpPoint	result1, result2;

    CopyMatrix (mat, global_mat);  

    result1 = TransForm(mat, startx + x1, y1, 0.0);
    result2 = TransForm(mat, startx + x2, y2, 0.0);
    GP_lineCoord(result1.x, result1.y, result2.x, result2.y);
    
    result1 = TransForm(mat,startx + x1, y1, LETTER_Z_DEPTH);
    result2 = TransForm(mat,startx + x2, y2, LETTER_Z_DEPTH);
    GP_lineCoord(result1.x, result1.y, result2.x, result2.y);
    
    result1 = TransForm(mat, startx + x1, y1, 0.0);
    result2 = TransForm(mat, startx + x1, y1, LETTER_Z_DEPTH);
    GP_lineCoord(result1.x, result1.y, result2.x, result2.y);
    }


void PaintLetter(double	startx, char ch, int pos)
    {	
    int	i, j, idx, runidx;
    double x1, y1, x2, y2, firstx, firsty;
    int pairsToRead;
    int numRuns;
    

    idx =0;
    numRuns = font[ch].num_Runs;
    for (i=0; i<numRuns; i++)
	{
	pairsToRead = font[ch].data[idx];
	idx ++;
	firstx = (double) font[ch].data[idx];
	firsty = (double) font[ch].data[idx+1];

	for (j=0; j<pairsToRead; j++)
	    {
	    x1 =  (double) font[ch].data[idx];
	    y1 =  (double) font[ch].data[idx+1];
		
	    if (j == pairsToRead -1)
		{
		x2 =  firstx;
		y2 =  firsty;
		}
	    else 
		{
		x2 =  (double) font[ch].data[idx+2];
		y2 =  (double) font[ch].data[idx+3];
		}	
		
	    idx +=2;
	    DrawLines (startx, x1, y1, x2, y2); 	
	    }
	}
}


void PaintLetters (SUIT_object o)
    {
    int	i;
    double	startX = 0.0;
    char	*data = SUIT_getText(drawingArea, "data");
    
    for ( i = 0 ; i < strlen(data) ; i++ )
	{
	int	ch = data[i];
	if (font[ch].data == NULL)
	    fprintf(stderr, "ERROR: character '%c' not in data\n", (char) ch );
	else
	    {	
	    PaintLetter(startX, ch, i);
	    startX += (double)font[ch].width;
	    }
	}
    if (SUIT_getBoolean(drawingArea, "show rectangle") && (strlen (data) != 0))
	GP_rectangleCoord(boundingBox.origin.x, boundingBox.origin.y,
			  boundingBox.top.x, boundingBox.top.y);

    if (SUIT_getBoolean (drawingArea, "show axis lines"))
	{
	GP_rectangle win = SUIT_getWindow (drawingArea, "window");

	GP_lineCoord (0.0, win.bottom_left.y, 0.0, win.top_right.y);
	GP_lineCoord (win.bottom_left.x, 0.0, win.top_right.x, 0.0);
	}
    }


void Do_XRotation(SUIT_object o)
    {
    double rot;
    char *temp;

    temp = SUIT_createSafeString(SUIT_getText(xRot, "current value"));
    rot = atof(temp);
    SUIT_free(temp);

    ApplyRotationX(global_mat, RADIANS(rot));
    SUIT_redisplayRequired(drawingArea);
    }


void Do_YRotation(SUIT_object o)
    {
    double rot;
    char *temp;

    temp = SUIT_createSafeString(SUIT_getText(yRot, "current value"));
    rot = atof(temp);
    SUIT_free(temp);

    ApplyRotationY(global_mat, RADIANS(rot));
    SUIT_redisplayRequired(drawingArea);
    }


void Do_ZRotation(SUIT_object o)
    {
    double rot;
    char *temp;

    temp = SUIT_createSafeString(SUIT_getText(zRot, "current value"));
    rot = atof(temp);
    SUIT_free(temp);

    ApplyRotationZ (global_mat, RADIANS(rot));
    SUIT_redisplayRequired(drawingArea);

    }


void Do_Scale(SUIT_object o)
    {
    double sx, sy, sz;
    char *temp;

    temp = SUIT_createSafeString(SUIT_getText(xScale, "current value"));
    sx = atof(temp);
    SUIT_free(temp);

    temp = SUIT_createSafeString(SUIT_getText(yScale, "current value"));
    sy = atof(temp);
    SUIT_free(temp);

    temp = SUIT_createSafeString(SUIT_getText(zScale, "current value"));
    sz = atof(temp);
    SUIT_free(temp);

    ApplyScale (global_mat, sx, sy, sz);
    SUIT_redisplayRequired(drawingArea);
    }



void Do_Translation(SUIT_object o)
    {
    double dx, dy, dz;
    char *temp;

    temp = SUIT_createSafeString(SUIT_getText(xTrans, "current value"));
    dx = atof(temp);
    SUIT_free(temp);

    temp = SUIT_createSafeString(SUIT_getText(yTrans, "current value"));
    dy = atof(temp);
    SUIT_free(temp);

    temp = SUIT_createSafeString(SUIT_getText(zTrans, "current value"));
    dz = atof(temp);
    SUIT_free(temp);

    ApplyTranslation(global_mat, dx, dy, dz);
    SUIT_redisplayRequired(drawingArea);
    }


void ComputeNewBoundingVolume(char *newstr)
    {
    double strwid;
    int len, i;
    char *str;
    double boxMin, boxMax, ch_left;
    charDataType chdat;

    strwid = 0.0;
    boxMin = 100.0;
    boxMax = -100.0;
    ch_left = 0.0;
    str = SUIT_createSafeString(SUIT_getText(TypedString, "current value"));
    len = strlen (str);

    /* Dispose of the old character matrices and create the new ones */

    DynDestroy(charData);
    charData = DynCreate(sizeof(charDataType), 10);

    for (i=0; i < len; i++)
	{
	strwid += (double)font[str[i]].width / 100.0;
	if (boxMin > (double)font[str[i]].min/ 100.0)
	    boxMin = (double)font[str[i]].min/ 100.0;

	if (boxMax < (double)font[str[i]].max/ 100.0)
	    boxMax = (double)font[str[i]].max/ 100.0;

	  /* Add in the transformation matrix for each individual character */

	MakeIdentityMatrix(chdat.charmat);
	chdat.origin.x =  ch_left;
	chdat.origin.y = 0.0;
	chdat.origin.z= 0.0;

	ch_left += (double)font[str[i]].width/ 100.0;

	chdat.top.x = ch_left;
	chdat.top.y = (double)font[str[i]].max/ 100.0;
	chdat.top.z = LETTER_Z_DEPTH;

	DynAdd(charData, &chdat);

	}

    boundingBox.top.x    = strwid;
    boundingBox.top.y    = boxMax;
    boundingBox.top.z    = LETTER_Z_DEPTH;
    
    boundingBox.origin.x = 0.0;
    boundingBox.origin.y = boxMin;
    boundingBox.origin.z = 0.0;

    SUIT_free(str);
    }


    /*==================================================================*/
    /*				Callbacks 				*/
    /*==================================================================*/

void newLettersTyped (SUIT_object o)
    {
    SUIT_setText(drawingArea, "data", SUIT_getText(o, "current value") );
    ComputeNewBoundingVolume(SUIT_getText(o, "current value"));
    }

void zoom (SUIT_object me)
    {
    GP_rectangle oldwin, newwin;
    double val;

    val = SUIT_getDouble (zoomer, "current value");
    oldwin = SUIT_getWindow(drawingArea, "base window");

    newwin.bottom_left.x = oldwin.bottom_left.x * val;
    newwin.bottom_left.y = oldwin.bottom_left.y * val; 
    newwin.top_right.x = oldwin.top_right.x * val;
    newwin.top_right.y = oldwin.top_right.y * val;

    SUIT_setWindow(drawingArea, "window", newwin);
    }


void Do_reset (SUIT_object o)
    {
    MakeIdentityMatrix (global_mat);
    
    SUIT_redisplayRequired (drawingArea);
    }


void Do_charDiagonal(SUIT_object o)
    {
    char *instr;
    charDataType *pchdat;
    int i;
    double ang;
    char *temp;
    
    SUIT_setBoolean (charAngle, "rotating chars", TRUE);
    
    fprintf(stderr, "Not yet doing character diagonals");
    
    /* Find the bounding boxes for each individual character */
    
    instr = SUIT_createSafeString((SUIT_getText(TypedString, "current value")));
    temp =  SUIT_createSafeString(SUIT_getText(charAngle, "current value"));
    ang  = RADIANS(atof(temp));
    
    
    for (i=0;i<DynSize(charData); i++)
	{
	pchdat = DynGet(charData, i);
	
	spin (pchdat->origin, pchdat->top, pchdat->charmat, ang);

	}
    SUIT_redisplayRequired (drawingArea);
    }
    


void Do_strDiagonal(SUIT_object o)
    {
    double requestedAng;
    char *temp;

    /* find the actual rotation that has been requested. Convert to RADS */
    temp = SUIT_createSafeString(SUIT_getText(strAngle, "current value"));
    requestedAng  = RADIANS(atof(temp));
    SUIT_free(temp);

    spin (boundingBox.origin, boundingBox.top, global_mat, requestedAng);
      
    SUIT_redisplayRequired (drawingArea);
    }


void spin (gpPoint origin, gpPoint top, Matrix mat, double angle)
    {
    double Xang, Yang, requestedAng;
    Vector boxOriginIn, boxTopCornerIn;		/* before transform */
    Vector boxOriginOut, boxTopCornerOut;	
    Vector p1, p2;				/* after transform */
    Matrix tempMat;
    double dx, dy, dz;
    char *temp;

      
    /* find originial position of box */
    boxOriginIn[X] = origin.x;
    boxOriginIn[Y] = origin.y;
    boxOriginIn[Z] = origin.z;
    boxOriginIn[W] = 1.0;

    boxTopCornerIn[X] = top.x;
    boxTopCornerIn[Y] = top.y;
    boxTopCornerIn[Z] = top.z; 
    boxTopCornerIn[W] = 1.0;
   
    /* now transform the bounding volume through the global mat. */
    TransformVector(global_mat, boxOriginIn, boxOriginOut);
    TransformVector(global_mat, boxTopCornerIn, boxTopCornerOut);
    dx = boxOriginOut[X];
    dy = boxOriginOut[Y];
    dz = boxOriginOut[Z];

    /* initialize translation martrix */
    MakeIdentityMatrix (tempMat);
    ApplyTranslation (tempMat, -dx, -dy, -dz);

    /* now translate the box back to the origin */
    TransformVector (tempMat, boxOriginOut, p1);
    TransformVector (tempMat, boxTopCornerOut, p2);

    /* compute the angles necessary to bring the vector in line
       with the Z axis. 
       First into the YZ plane, then onto the Z axis */

    /* these angles will be returned in radians!! No conversion necessary */
        
    Yang = atan2 (p2[Z], p2[X]) - PI / 2.0;
    Xang = atan2 (p2[Y], sqrt(SQR(p2[Z]) + SQR(p2[X])));

    /* find the actual rotation that has been requested. Convert to RADS */
    temp = SUIT_createSafeString(SUIT_getText(strAngle, "current value"));
    requestedAng  = atof(temp);
    SUIT_free(temp);

    /* now do everything to the global_mat */
    ApplyTranslation (mat, -dx, -dy, -dz);
    ApplyRotationY(mat, Yang);
    ApplyRotationX(mat, Xang);
    ApplyRotationZ(mat, RADIANS(requestedAng));
    ApplyRotationX(mat, -Xang);
    ApplyRotationY(mat, -Yang);
    ApplyTranslation (mat, dx, dy, dz);
    }

void toggleAnimation (SUIT_object me)
    {
    if (SUIT_getBoolean(me, "current value"))
	{
	SUIT_setInteger(drawingArea, "time to wait", 0);
	}
    else
	{
	SUIT_setInteger(drawingArea, "time to wait", INDEFINITE);
	}
	
    }

void HitDrawingArea (SUIT_object me, SUIT_event ev)
    {
    GP_rectangle oldwin, newwin;
    
    oldwin = SUIT_getWindow (me, "window");
    newwin.bottom_left.x = oldwin.bottom_left.x - ev.worldLocation.x;
    newwin.bottom_left.y = oldwin.bottom_left.y - ev.worldLocation.y;
    newwin.top_right.x = oldwin.top_right.x - ev.worldLocation.x;
    newwin.top_right.y = oldwin.top_right.y - ev.worldLocation.y;

    SUIT_setWindow (me, "window", newwin);
    }


void RotateOverX (SUIT_object o)
    {
    SUIT_setInteger (axes, "current hit", X);
    }

void RotateOverY (SUIT_object o)
    {
    SUIT_setInteger (axes, "current hit", Y);
    }

void RotateOverZ (SUIT_object o)
    {
    SUIT_setInteger (axes, "current hit", Z);
    }


void CreateObjects(void)
    {
    SUIT_window win;
    SUIT_viewport vp;

    /*==================================================================*/
    /*				Drawing area 				*/
    /*==================================================================*/
    drawingArea = SUIT_createObject("my drawing area", "drawing area");
    SUIT_addDisplayToObject(drawingArea, "standard", HitDrawingArea, PaintLetters);
    win = GP_defRectangle(0, -10, 100, 30);
    SUIT_setWindow (drawingArea, "window", win);
    
    /*==================================================================*/
    /*				type-in boxes				*/
    /*==================================================================*/
    TypedString = SUIT_createTypeInBox("string to type", newLettersTyped);
    SUIT_setText (TypedString, "current value", "ABA");

    SUIT_setBoolean(TypedString, "any keystroke triggers", TRUE);

    xRot = SUIT_createTypeInBox ("x rotation", NULL);
    yRot = SUIT_createTypeInBox ("y rotation", NULL);
    zRot = SUIT_createTypeInBox ("z rotation", NULL);

    strAngle = SUIT_createTypeInBox ("string diagonal angle", NULL);


    /*==================================================================*/
    /* 				Buttons					*/
    /*==================================================================*/
    animate = SUIT_createOnOffSwitch("animate X", toggleAnimation);

    SUIT_createButton ("X rotate", 	Do_XRotation);
    SUIT_createButton ("Y rotate", 	Do_YRotation);
    SUIT_createButton ("Z rotate", 	Do_ZRotation);  
    SUIT_createButton ("Reset",	Do_reset);
    SUIT_createButton ("String diagonal", Do_strDiagonal);

    SUIT_createDoneButton(NULL);
    SUIT_createAbortButton(NULL);
    }

    

void main (int argc, char *argv[])
{
    int hit;
    int wait;

    InitializeIntegerFonts();
    MakeIdentityMatrix (global_mat);
    SUIT_init(argv[0]);
    CreateObjects();
    charData = DynCreate(sizeof(Matrix), 10);
    SUIT_beginDisplay();

    ComputeNewBoundingVolume(SUIT_getText(TypedString, "current value"));
        
    while (TRUE) {
	wait = SUIT_getInteger(drawingArea, "time to wait");
	SUIT_checkAndProcessInput(wait);
	if (wait == 0) {
	    Do_XRotation(NULL);
	    Do_YRotation(NULL);	
	    Do_ZRotation(NULL);	
	}
    }
}
