#ifndef lint
static char rcsid[] = "$Header: /usr/people/sam/tiff/libtiff/RCS/tif_msdos.c,v 1.2 92/09/01 15:44:20 sam Exp $";
#endif

/*
 * Copyright (c) 1988, 1989, 1990, 1991, 1992 Sam Leffler
 * Copyright (c) 1991, 1992 Silicon Graphics, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Sam Leffler and Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Sam Leffler and Silicon Graphics.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 * IN NO EVENT SHALL SAM LEFFLER OR SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 */

/*
 * TIFF Library MSDOS-specific Routines.
 */
#include "tiffioP.h"

static int
_tiffReadProc(fd, buf, size)
	int fd;
	char *buf;
	int size;
{
	return (read(fd, buf, size));
}

static int
_tiffWriteProc(fd, buf, size)
	int fd;
	char *buf;
	int size;
{
	return (write(fd, buf, size));
}

static int
_tiffSeekProc(fd, off, whence)
	int fd;
	long off;
	int whence;
{
	return (lseek(fd, off, whence));
}

static int
_tiffMapProc(int fd, char **pbase, long *psize)
{
	return (0);
}

static void
_tiffUnmapProc(int fd, char *base, long size)
{
}

static int
_tiffCloseProc(fd)
	int fd;
{
	return (close(fd));
}

#include <sys/stat.h>

static long
_tiffSizeProc(int fd)
{
	struct stat sb;
	return (fstat(fd, &sb) < 0 ? 0 : sb.st_size);
}

/*
 * Open a TIFF file descriptor for read/writing.
 */
TIFF *
TIFFFdOpen(fd, name, mode)
	int fd;
	const char *name, *mode;
{
	TIFF *tif;

	tif = TIFFClientOpen(name, mode,
	    (void*) fd,
	    _tiffReadProc, _tiffWriteProc, _tiffSeekProc, _tiffCloseProc,
	    _tiffSizeProc, _tiffMapProc, _tiffUnmapProc);
	if (tif)
		tif->tif_fd = fd;
	return (tif);
}

/*
 * Open a TIFF file for read/writing.
 */
TIFF *
TIFFOpen(name, mode)
	const char *name, *mode;
{
	static char module[] = "TIFFOpen";
	int m, fd;

	m = _TIFFgetMode(mode, module);
	if (m == -1)
		return ((TIFF *)0);
	fd = open(name, m|O_BINARY, 0666);
	if (fd < 0) {
		TIFFError(module, "%s: Cannot open", name);
		return ((TIFF *)0);
	}
	return (TIFFFdOpen(fd, name, mode));
}

#ifdef __GNUC__
extern	char *malloc();
extern	char *realloc();
#else
#include <malloc.h>
#endif

void *
_TIFFmalloc(s)
	size_t s;
{
	return (malloc(s));
}

void
_TIFFfree(p)
	void *p;
{
	free(p);
}

void *
_TIFFrealloc(p, s)
	void *p;
	size_t s;
{
	return (realloc(p, s));
}
