#include <stdio.h>
#include "art.h"
#include "gram.h"
#include "objs.h"
#include "macro.h"

extern attr	astack[], *astackp;
extern mats	mstack[], *mstackp;

extern matrix	trans;

extern float	eval_fexpr();
extern object	*compinit(), *csginit();

extern symbol	**ostackp, *ostack[];

/*
 * defobj
 *
 *	define an object
 */
defobj(s, type, d)
	char	*s;
	int	type;
	details	*d;
{
	symbol	*sym;

	sym = insertsym(ostackp, s);

	sym->type = type;
	sym->u.det = d;
}

/*
 * lookup
 *
 *	check to see if string represents a predefined object type
 */
symbol *
lookup(string)
	char	*string;
{
	symbol	*sym, **symptr;

	symptr = ostackp;

	while ((sym = findsym(*symptr, string)) == (symbol *)NULL)
		if (symptr-- == ostack)
			return((symbol *)NULL);

	return(sym);
}

/*
 * objectinit
 *
 *	return an initialised object 
 */
object *
objectinit(sym, d)
	symbol	*sym;
	details	*d;
{
	int	type;
	object	*o;
	details	*nd1, *nd2, *nd3;
	details	*nd, *dl, *nxtd, *otherdt, *argdt, *nxtdl;
	surface	s;
	int	sset;
	char	buf[BUFSIZ];

					/* might have a composite */
	if (sym == (symbol *)NULL || sym->type == COMP_OBJ)
		return(compinit(sym, d));

	if (sym->type == CSG_OBJ)
		return(csginit(sym, d));

	astackp++;
	*astackp = *(astackp - 1);
	mstackp++;
	*mstackp = *(mstackp - 1);
	mident4(mstackp->vm);

	astackp->txtlist = (texture *)NULL;

	s = *astackp->s;

	o = (object *)smalloc(sizeof(object));

	o->type = type = sym->type;
	o->incsg = FALSE;

	o->nxt = (object *)NULL;

					/* reverse list */
	argdt = (details *)NULL;
	for (dl = d; dl != (details *)NULL; dl = nxtdl) {
		nxtdl = dl->nxt;
		dl->nxt = argdt;
		argdt = dl;
	}

	otherdt = (details *)NULL;

	if (sym->u.det != (details *)NULL) {
		for (dl = sym->u.det; dl != (details *)NULL; dl = dl->nxt) {
			nd = (details *)smalloc(sizeof(details));
			*nd = *dl;
			nd->nxt = otherdt;
			otherdt = nd;
			if (nd->type == COMPLEXVERTEX) {
				nd1 = (details *)smalloc(sizeof(details));
				*nd1 = *nd->u.det;
				if (nd1->nxt != (details *)NULL) {
					nd1->nxt = nd2 = (details *)smalloc(sizeof(details));
					*nd2 = *nd->u.det;
					if (nd2->nxt != (details *)NULL) {
						nd2->nxt = nd3 = (details *)smalloc(sizeof(details));
						*nd3 = *nd->u.det;
					}
				}
				nd->u.det = nd1;
			}
		}
	}

	if (argdt == (details *)NULL) {
		argdt = otherdt;
		otherdt = (details *)NULL;
	}

	nd = (details *)NULL;

	sset = FALSE;

	for (dl = argdt; dl != (details *)NULL; dl = nxtd) {

		if ((nxtd = dl->nxt) == (details *)NULL) {
			nxtd = otherdt;
			otherdt = (details *)NULL;
		}

		switch (dl->type) {
		case COLOUR:
			s.c.r = dl->u.c.r;
			s.c.g = dl->u.c.g;
			s.c.b = dl->u.c.b;
			sset = TRUE;
			free(dl);
			break;
		case AMBIENT:
			s.a.r = dl->u.c.r;
			s.a.g = dl->u.c.g;
			s.a.b = dl->u.c.b;
			sset = TRUE;
			free(dl);
			break;
		case TEXTURE:
			free(dl);
			break;
		case MATERIAL:
			s.ri = dl->u.mat.ri;
			s.kd = dl->u.mat.kd;
			s.ks = dl->u.mat.ks;
			s.ksexp = dl->u.mat.ksexp;
			sset = TRUE;
			free(dl);
			break;
		case REFLECTANCE:
			s.refl = dl->u.f;
			sset = TRUE;
			free(dl);
			break;
		case TRANSPARENCY:
			s.trans = dl->u.f;
			sset = TRUE;
			free(dl);
			break;
		case ABSORPTION:
			s.falloff = dl->u.f;
			sset = TRUE;
			free(dl);
			break;
		case ART_TRANSLATE:
			art_translate(dl->u.v.x, dl->u.v.y, dl->u.v.z);
			free(dl);
			break;
		case ART_SCALE:
			art_scale(dl->u.v.x, dl->u.v.y, dl->u.v.z);
			free(dl);
			break;
		case ART_ROTATE:
			art_rotate(dl->u.rot.ang, dl->u.rot.axis);
			free(dl);
			break;
		case ON:
			astackp->options |= dl->u.i;
			free(dl);
			break;
		case OFF:
			astackp->options &= ~dl->u.i;
			free(dl);
			break;
		default:
			dl->nxt = nd;
			nd = dl;
		}
	}

	if (sset) {
		astackp->s = (surface *)smalloc(sizeof(surface));
		*astackp->s = s;
		astackp->slevel = astackp - astack;
	}

	if (astackp->s->trans != 0.0 && astackp->s->ri == 0.0)
		astackp->s->ri = 1.0;

	switch (type) {
	case SPHERE:
	case ELLIPSOID:
		sphereinit(o, nd);
		break;
	case BOX:
		boxinit(o, nd);
		break;
	case CYLINDER:
		cylinit(o, nd);
		break;
	case POLYGON:
		polygoninit(o, nd);
		break;
	case CONE:
		coneinit(o, nd);
		break;
	case RING:
		ringinit(o, nd);
		break;
	case TORUS:
		torusinit(o, nd);
		break;
	case SUPERQUADRIC:
		superinit(o, nd);
		break;
	case GEOMETRY:
		geometryinit(o, nd);
		break;
	/*

	case ALGEBRAIC:
		alginit(o, nd);
		break;
		*/
	default:
		/*
		sprintf(buf, "art: unkown object type %d in objectinit.\n", type);
		fatal(buf);
	*/
		;
	}

	astackp--;
	mstackp--;

	return(o);
}
