#include <math.h>
#include <stdio.h>
#include "art.h"
#include "macro.h"
#include "gram.h"

extern mats	*mstackp;
extern hlist	*fhlist;
extern float	tolerance;

/*
 * ringinit
 *
 *	initialise the function pointers and fields for a sphere object,
 * returning its pointer.
 */
void
ringinit(o, d)
	object	*o;
	details *d;
{
	ring	*rng;
	details	*ld;
	vector	cent, radii1, radii2;
	int	first;

	rng = o->obj.rng = (ring *)smalloc(sizeof(ring));

	cent.x = cent.y = cent.z = 0.0;
	first = 1;
	radii1.x = radii1.y = 1.0;
	radii2.x = 0.0;

	while (d != (details *)NULL) {
		switch (d->type) {
		case CENTER:
			cent = d->u.v;
			break;
		case RADIUS:
			if (first) {
				radii2.x = radii2.y = d->u.f;
				radii1.x = radii1.y = d->u.f;
				first = 0;
			} else
				radii1.x = radii1.y = d->u.f;
			break;
		case RADII:
			if (first) {
				radii1.x = radii2.x = d->u.v.x;
				radii1.y = radii2.y = d->u.v.y;
				first = 0;
			} else {
				radii1.x = d->u.v.x;
				radii1.y = d->u.v.y;
			}
			break;
		default:
			warning("art: illegal field in ring ignored.\n");
		}
		ld = d;
		d = d->nxt;
		free(ld);
	}

	pushmatrix();
		translate(cent.x, cent.y, cent.z);

		pushmatrix();
			scale(radii1.x, radii1.y, 1.0);

			circle(0.0, 0.0, 1.0);
		popmatrix();

		if (radii2.x != radii1.x) {
			pushmatrix();
				scale(radii2.x, radii2.y, 1.0);

				circle(0.0, 0.0, 1.0);
			popmatrix();
		}
	
	popmatrix();
}
