#include "vogle.h"
#include "vopl.h"

extern	double log10();

/*
 * plot2
 *
 *	display the 2-d graph described by x and y;
 */
plot2(x, y, n)
	float	x[], y[];
	int	n;
{
	int	i;
	char	err_buf[EBUF_SIZE];
	float	tx, ty, left, right, bottom, top;
	float	a, b, c, d;

	/*
	 * Set the view up so that clipping happens...
	 */

	pushmatrix();
	pushviewport();
	pushattributes();

	getviewport(&left, &right, &bottom, &top);

	viewport(left + (1.0 + XMIN) / 2.0 * (right - left),
		right - (1.0 - XMAX) / 2.0 * (right - left),
		bottom + (1.0 + YMIN) / 2.0 * (top - bottom),
		top - (1.0 - YMAX) / 2.0 * (top - bottom));

	if (!plotdev.axes[XIND].scaleset)
		adjustscale(x, n, 'x');

	if (!plotdev.axes[YIND].scaleset)
		adjustscale(y, n, 'y');

        ortho2(WhatX(plotdev.axes[XIND].min), 
	       WhatX(plotdev.axes[XIND].max),
	       WhatY(plotdev.axes[YIND].min),
	       WhatY(plotdev.axes[YIND].max));
	
	/*
	 * Do whatever type of fit is required....
	 */
	switch (plotdev.fit) {
	case NO_LINES:
		/*
	 	 * Don't do a sniveling thing......
		 */
		break;

	case STRAIGHT_LINE:
		/*
		 * Just draw it.....
		 */

		move2(WhatX(x[0]), WhatY(y[0]));
		for (i = 1; i < n; i++)
			draw2(WhatX(x[i]), WhatY(y[i]));

		break;
	case LEAST_SQUARE:
		/*
 		 * Do an orthogonal polynomial fit.....
		 */

		/*
		 * If degree is zero then simply plot a line y = average y
		 */
		if (plotdev.degree == 0)
			avefit(x, y, n);
		/*
		 * If degree is 1 then it's a simple linear least square fit...
		 */
		else if (plotdev.degree == 1) 
			llsfit(x, y, n);
		else 
			orthofit(x, y, plotdev.degree, n);
		break;
	case CUBIC_SPLINE:
		/*
		 * Do cubic spline fits......
		 */
		/* 
		 * If no endslopes have been used then use VOGLE curve
		 * routine with cardinal splines.
		 */
		if (plotdev.splinetype == FREE) {
			curvebasis(cardinal);
			curveprecision(20);
			cubicsp(x, y, n);
		} else
			spline(x, y, n);
		break;
	case POWER_EQN:
		/*
		 * do power equation fit
		 */
		pefit(x, y, n);
		break;
	case SGR_FIT:
		/*
		 * do a saturated growth rate fit
		 */
		sgrfit(x, y, n);
		break;
	default:
		sprintf(err_buf, "plot2: unknown fit type %d", plotdev.fit);
		vopl_error(err_buf);
	}

	/* 
	 * Set up the marker size
	 */

	if (plotdev.markerspacing && plotdev.marker != (char *)NULL) {
		centertext(1);
		clipping(0);
		tx = plotdev.markerscale * TEXTWIDTH * WhatX((plotdev.axes[XIND].max - plotdev.axes[XIND].min));
		ty = plotdev.markerscale * TEXTWIDTH * WhatY((plotdev.axes[YIND].max - plotdev.axes[YIND].min));

		textsize(tx, ty);

		for (i = 0; i < n; i += plotdev.markerspacing) {
			move2(WhatX(x[i]), WhatY(y[i]));
			drawstr(plotdev.marker);
		}
		clipping(1);
	}

	popattributes();
	popviewport();
	popmatrix();
}
