#include <stdio.h>

extern char	*malloc();

/*
 * smalloc
 *
 *	allocates memory - checking for null
 */
char *
smalloc(size)
	unsigned	size;
{
	char	*p, *p2, buf[BUFSIZ];

	if ((p = malloc(size)) == (char *)NULL) {
		sprintf(buf, "smalloc: request for %d bytes from malloc returns NULL.\n", size);
		fatal(buf);
	}

	/*
	for (p2 = p; p2 != p + size; p2++)
		*p2 = 0xff;
	*/

	return(p);
}

/*
 * scalloc
 *
 *	allocates memory - checking for null - this was needed for the PC.
 */
char *
scalloc(size, n)
	unsigned 	size;
	unsigned	n;
{
	char	*p, *p2, buf[BUFSIZ];

#ifdef PC
	if ((long)size * (long)n > 65535L) {
		sprintf(buf, "scalloc: request for %ld bytes from malloc is too big (> 64K).\n", (long)size * (long)n);
		fatal(buf);
		}
#endif

	if ((p = malloc((unsigned) size * n)) == (char *)NULL) {
		sprintf(buf, "scalloc: request for %ld bytes from malloc returns NULL.\n", size * n);
		fatal(buf);
	}

	/*
	for (p2 = p; p2 != p + size * n; p2++)
		*p2 = 0xff;
	*/

	return(p);
}

