		NAME	EMSRTN
		TITLE	Routines for EMS handling.
		PAGE	132,60
  

;=========================================
;	EMS - Routines for EMS handling.
;

FALSE		=	0
TRUE		=	1
  
		.MODEL	LARGE,C

		.CODE

		PUBLIC	EMS_rdy
		PUBLIC	EMS_alloc
		PUBLIC	EMS_map
		PUBLIC	EMS_release
		PUBLIC	EMS_count
		PUBLIC	EMS_base
  
EMMXXXX0	db	"EMMXXXX0", 0
  
  

		SUBTTL int EMS_rdy();
		PAGE


		COMMENT	$

Name:		EMS_rdy

Function:	Returns status of EMS.

Caller:		Microsoft C

		int EMS_rdy();

Returns:
		TRUE	- EMS is active
		FALSE	- EMS is not active

Assumes:	Filename EMMXXXX0 is ALWAYS the device name of the
		EMS driver.

		$


EMS_rdy		proc	uses ds si
		mov	ah,3Dh
		push	cs
		pop	ds
		mov	dx,OFFSET EMMXXXX0	; File handle of EMS device driver
		xor	al,al			; Zero register
		int	21h			; DOS Services  ah=function 3Dh
						;  open file, al=mode, name @ds:dx
		jc	loc_2			; Jump if error
		mov	bx,ax
		mov	ah,3Eh			; '>'
		int	21h			; DOS Services  ah=function 3Eh
						;  close file, bx=file handle
		mov	ax,TRUE			; Good return value
		jmp	short loc_3
loc_2:
		mov	ax,FALSE		; Bad return value
loc_3:
		ret
EMS_rdy		endp


		SUBTTL void far *EMS_base();
		PAGE


		COMMENT	$

Name:		EMS_base

Function:	Returns base address of EMS page.

Caller:		Microsoft C

		void far *EMS_base();

Returns:
		32-bit EMS base address

Assumes:	EMS is active.

		$

EMS_base	proc
		mov	ah,41h
		int	67h			; EMS Memory        ah=func 41h
						;  get page frame segment in bx
		mov	dx,bx			; Return value segment part
		mov	ax,0			; Offset is always 0
		ret
EMS_base	endp


		SUBTTL int EMS_count();
		PAGE


		COMMENT	$

Name:		EMS_count

Function:	Returns count of unused EMS pages.

Caller:		Microsoft C

		int EMS_count();

Returns:
		Number of unused EMS pages.

Assumes:	EMS is active.

		$

EMS_count	proc	uses ds si
		mov	ah,42h			; 'B'
		int	67h			; EMS Memory        ah=func 42h
						;  get pages, bx=unused, dx=total
		mov	ax,bx			; Set number of unused pages
		ret
EMS_count	endp


		SUBTTL int EMS_alloc(n);
		PAGE


		COMMENT	$

Name:		EMS_alloc

Function:	Allocates a number of EMS pages and returns an EMS handle.

Caller:		Microsoft C

		int	EMS_alloc(n)
		int	n;		/* number of pages to allocate */

Returns:	EMS handle or
		FFFFH if can't allocate (this number may be dangerous).

Assumes:	EMS is active.

		$

EMS_alloc	proc	uses ds si, n:WORD
		mov	ah,43h			; 'C'
		mov	bx,n			; Get # of pages
		int	67h			; EMS Memory        ah=func 43h
						;  get handle dx, allocate pgs bx
		or	ah,ah
		jz	loc_1
		mov	dx,0FFFFH		; Error return
loc_1:
		mov	ax,dx			; Set handle
		ret
EMS_alloc	endp



		SUBTTL int EMS_map();
		PAGE


		COMMENT	$

Name:		EMS_map

Function:	Maps an EMS page to the address returned by EMS_base().

Caller:		Microsoft C

		int	EMS_map(handle, page)
		int	handle,		/* EMS handle */
			page;		/* page number */

Returns:	TRUE	- success
		FALSE	- failure

Assumes:	EMS is active.

		$

EMS_map		proc	uses dx bx, handle:WORD, p:WORD
		mov	dx,handle
		mov	bx,p
		mov	al,0			; Always map to physical page 0
		mov	ah,44h			; 'D'
		int	67h			; EMS Memory        ah=func 44h
						;  map memory, dx=handle
		or	ah,ah
		mov	ax,TRUE
		jz	loc_4			; Jump if zero
		mov	ax,FALSE
loc_4:
		ret
EMS_map		endp


		SUBTTL int EMS_release();
		PAGE


		COMMENT	$

Name:		EMS_release

Function:	Releases an EMS handle.

Caller:		Microsoft C

		int	EMS_release(handle)
		int	handle;		/* EMS handle */

Returns:	TRUE	- success
		FALSE	- failure

Assumes:	EMS is active.

		$

EMS_release	proc	uses ds si, handle:WORD
		mov	ah,45h			; 'E'
		mov	dx,handle		; Handle
		int	67h			; EMS Memory        ah=func 45h
						;  release handle dx, & memory
		or	ah,ah
		mov	ax,TRUE
		jz	loc_4			; Jump if zero
		mov	ax,FALSE
loc_4:
		ret
EMS_release	endp



		SUBTTL void lmemmove(to, from, n);
		PAGE


		COMMENT	$

Name:		lmemmove

Function:	Memory move for an explicitly far memory block.

Caller:		Microsoft C

		void lmemmove(to, from, n);

		UCHAR far *to,		/* far ptr to move to */
			  *from;	/* far ptr to move from */
		int	n;		/* number of bytes to move */

		$


		.CODE


lmemmove	proc	uses	ds es di si, to:DWORD, from:DWORD, n:WORD
		cld
		lds	si,from
		les	di,to
		mov	cx,n
		shr	cx,1
		rep	movsw
		jnc	@F
		movsb
@@:
		ret
lmemmove	endp



		end
