/* include for fractint graphics routines */

/* MEDIUM MEMORY MODEL, must be re-created for other modes */

struct videoinfo {              /* All we need to know about a Video Adapter */
        char    name[26];       /* Adapter name (IBM EGA, etc)          */
        char    comment[26];    /* Comments (UNTESTED, etc)             */
        int     videomodeax;    /* begin with INT 10H, AX=(this)        */
        int     videomodebx;    /*              ...and BX=(this)        */
        int     videomodecx;    /*              ...and CX=(this)        */
        int     videomodedx;    /*              ...and DX=(this)        */
                                /* NOTE:  IF AX==BX==CX==0, SEE BELOW   */
        int     dotmode;        /* video access method used by asm code */
                                /*      1 == BIOS 10H, AH=12,13 (SLOW)  */
                                /*      2 == access like EGA/VGA        */
                                /*      3 == access like MCGA           */
                                /*      4 == Tseng-like  SuperVGA*256   */
                                /*      5 == P'dise-like SuperVGA*256   */
                                /*      6 == Vega-like   SuperVGA*256   */
                                /*      7 == "Tweaked" IBM-VGA ...*256  */
                                /*      8 == "Tweaked" SuperVGA ...*256 */
                                /*      9 == Targa Format               */
                                /*      10 = Hercules                   */
                                /* NO!  11 = "disk video" (no screen)   */
                                /*      12 = 8514/A                     */
                                /*      13 = CGA 320x200x4, 640x200x2   */
                                /*      14 = Tandy 1000                 */
                                /*      15 = TRIDENT  SuperVGA*256      */
                                /*      16 = Chips&Tech SuperVGA*256    */
        int     xdots;          /* number of dots across the screen     */
        int     ydots;          /* number of dots down the screen       */
        int     colors;         /* number of colors available           */
        };


/* variables */

extern  int     dotmode;                        /* video access method      */
extern  int     oktoprint;                      /* 0 if printf() won't work */
extern  int     xdots, ydots;                   /* # of dots on the screen  */
extern  int     colors;                         /* maximum colors available */

/* adapter names */
#define settextmode() setvideomode(3, 0, 0, 0)
#define IBMMCGA320200256 2
#define TWKVGA360480256 10
#define SUPVGA640400256 13
#define SUPVGA640480256 14
#define SUPVGA800600256 15
#define SUPVGA1024768256 16
#define SUPVGA12801024256 18
#define IBM8514640480256 19
#define IBM85141024768256 20

/* functions */
extern int  initvideotable(void);
extern void fromvideotable(int);
extern void tovideotable(int);
extern void setvideomode(int, int, int, int);
extern void storedac(void);
extern void loaddac(void);
extern int  getcolor(int, int);
extern void putcolor(int, int, int);
extern void out_line(unsigned char *, int);
extern void get_line(int, int, int, unsigned char *);
extern void put_line(int, int, int, unsigned char *);
extern void putblock(int, int, int, int, int);

extern unsigned char dacbox[256][3];    /* Video-DAC (filled in by SETVIDEO) */
extern int rowcount;            /* row for out_line */

extern struct videoinfo videoentry;

extern int startgraphics(int);
