// This may look like C code, but it is really -*- C++ -*-

// <copyright>
// 
// Copyright (c) 1993-1995
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// 
// </copyright>

//<file>
//
// Name:       jumptable.h
//
// Purpose:    
//
// Created:    21 May 94    Gerald Pani
//
// Description:
//

//</file>

#ifndef hg_utils_jumptable_h
#define hg_utils_jumptable_h

#include <hyperg/utils/types.h>
#include <memory.h>

//<class>
//
// Name:       JumpTable
//
// Purpose:    
//
// Public Interface:
//
//</class>

class JumpTable {
  public:
     JumpTable();
     JumpTable( int size);
     JumpTable( const JumpTable& jt);     
     ~JumpTable();
     void setJump( int ndx, void*);
     void* getJump( int ndx) const;
     void setSize( int size);
     int size() { return size_;}
  private:
     void** table_;
     int size_;
};
 
inline JumpTable::JumpTable() : table_(nil), size_(0) {}

inline JumpTable::JumpTable( int size) : table_(nil), size_(0) {
     if (size > 0) {
	  size_ = size;
	  table_ = new void*[size_];
	  memset( (char*)table_, 0, sizeof(void*)*size_);
     }
}

inline JumpTable::JumpTable( const JumpTable& jt) {
     size_ = jt.size_;
     table_ = nil;
     if (size_) {
	  table_ = new void*[size_];
	  memcpy( (char*)table_, (char*)(jt.table_), sizeof(void*)*size_);
     }
}

inline JumpTable::~JumpTable() {
     delete table_;
}

inline void JumpTable::setJump( int ndx, void* f) {
     if (ndx < size_)
	  table_[ndx] = f;
}

inline void* JumpTable::getJump( int ndx) const {
     return (ndx < size_ ? table_[ndx] : nil);
}

inline void JumpTable::setSize( int size) {
     delete table_;
     table_ = nil;
     size_ = 0;
     if (size > 0) {
	  size_ = size;
	  table_ = new void*[size_];
	  memset( (char*)table_, 0, sizeof(void*)*size_);
     }
}

#endif
