// This may look like C code, but it is really -*- C++ -*-

//<copyright>
// 
// Copyright (c) 1993-1995
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// 
//</copyright>

//<file>
//
// Name:       statistics.h
//
// Purpose:    
//
// Created:    18 Feb 94    Gerald Pani
//
//
// Description:
//
//
//</file>

#ifndef hg_utils_statistics_h
#define hg_utils_statistics_h

#include <hyperg/utils/list.h>


//<class>
//
// Name:       Statistics
//
// Purpose:    
//
//
// Public Interface:
//
// - Statistics()
//   Default constructor.
//
// - void add( int count)
//   Add count items with current timestap.
//
// - void fetched( int& all, int&  hour, int& quarter, int& minute)
//   Gives added items: all (since start), hour (since last hour),
//   quarter (since last 15 minutes) and minute (since last minute).  
//
//
// Description:
//
// 
//</class>

class StatNode : public DLListNode {
public:
  StatNode( long t, int c) : DLListNode(), tm_(t), count_(c) {};
  long tm() const { return tm_;};
  int count() const { return count_;};
private:
  long tm_;
  int count_;
};

DLListdeclare(TmpStatList,StatNode)

class StatList : public TmpStatList {
  public:
     void remOld( long tm);
     void addNew( long tm, int count);
     int fetched( long tm) const;
};


class Statistics {
  public:
     Statistics() : fetched_(0) {};
     void add( int count = 1);
     void fetched( int& all, int&  hour, int& quarter, int& minute);
  private:
     StatList fHour_;
     long fetched_;
};

#endif





