// This may look like C code, but it is really -*- C++ -*-

// **********************************************************
// File hgstub.h
// ----------------------------------------------------------
// Created: G. Pani
// **********************************************************

#ifndef hgserver_h
#define hgserver_h

#ifdef __MSDOS__
#include <Dispatch/hdr.h>
#include <Dispatch/stream.h>
#include <Dispatch/reader.h>
#include <Dispatch/writer.h>
#include <Dispatch/dispat.h>
#else
#include <Dispatch/rpchdr.h>
#include <Dispatch/rpcstream.h>
#include <Dispatch/rpcreader.h>
#include <Dispatch/rpcwriter.h>
#include <Dispatch/dispatcher.h>
#if !defined(hpux) && !defined(UnixWare)
#include <osfcn.h>
#endif
#endif

#include <stdlib.h>
#include <string.h>

#include <hyper_g/objectid.h>
#include "rpcstuff.h"

// **********************************************************
// class HGReader
// ----------------------------------------------------------
// virtual void connectionClosed (int);
// 	wird vom Dispatcher aufgerufen.
// receive_GETLINKBYSRC
// 	liest: count recs
// 	setzt: stub->retcount = count;  stub->retflarecs = recs;
// 	ruft:  stub->quitRunning();  und beendet damit die Warteschleife des Aufrufers 
// andere receive_- Funktionen detto
// **********************************************************
class Server;

// --- empfangt die Antworten
class HGReader : public RpcReader, virtual public HGServHGStub {
  public:
     HGReader(rpcstream *, Server* );
     virtual ~HGReader();
  protected:
     virtual void connectionClosed(int);

     static void receive_Load				(RpcReader*, RpcHdr&, rpcstream&);
     static void receive_Browse				(RpcReader*, RpcHdr&, rpcstream&);
     static void receive_Pipe				(RpcReader*, RpcHdr&, rpcstream&);
     static void receive_Print				(RpcReader*, RpcHdr&, rpcstream&);

//     static void receive_GETLINKBYSRC		(RpcReader*, RpcHdr&, rpcstream&);
//     static void receive_GETOBJECT		(RpcReader*, RpcHdr&, rpcstream&);
//     static void receive_SETVERBOSE		(RpcReader*, RpcHdr&, rpcstream&);

  private:
     Server* stub;
};

// **********************************************************
// class Server
// ----------------------------------------------------------
// sendet low-level-rpc-requests an den dbserver und wartet auf Antwort
// 
// int GetLinkBySrc(ObjectID src, FLARecord*& out)
// 	sendet: GETLINKBYSRC src
// 	wartet in Schleife
//	out = retflarecs; return retcount;
// 
// andere Funktionen detto
// **********************************************************


// ---- rpcrequests

class Server : public RpcWriter, virtual public HGServHGStub {
 public:
     Server(const char* path, boolean binary = false);
     Server(const char* host, int port, boolean binary = false);
     ~Server();
     void 	run(int);
     void 	quitRunning(int);
     void 	flush();
     int 	good();

     
//     errorcode  error() const;

     // ---- rpc-Requests
//     int 	GetObject (char* id, RString& out);


     int 	Load (char* doc, char* anchor=nil);
     int 	Browse (char* anchor);
     int 	Pipe (char* cmd);
     int 	Print (char* printer);

private:
	friend class HGReader;
    HGReader* 	reader;
    int 	_running;


    // --- return-werte werden vom Empfaenger geschrieben
    FLARecord*	retflarecs;
    int 	retcount;

    ObjectID 	retID;
    boolean 	retvalue;
    RString 	retobject;
    ObjIdArray	retoids;
    int* 	retoffs;


     //errorcode	_error;
};

//inline errorcode Server::error() const {
//    return _error;
//}    

#endif


