/*
 * File :       textvw.h
 *
 * Purpose :    Interface to class TextViewer
 *
 * Created :    12 Jun 92    Keith Andrews, IICM
 *
 * Modified :   30 Jun 92    Keith Andrews, IICM
 *
 */

#ifndef textvw_h
#define textvw_h

#include <hyperg/viewer/viewer.h>



//
// class TextViewer
//
// Used to display TextDocuments or derived Documents.
//


class TextViewer : public Viewer {
public:
  TextViewer() ;
  ~TextViewer() ;

  virtual void Load(                             // load document
    const char* doc,                             //   document
    const char* anchors                          //   source anchors
  ) ;


  virtual void Browse(                           // browse current document
    const char* dest = 0                         //   optional destination anchor
  ) ;

//  virtual void Output( FILE* pipe ) ;
//  virtual int  Pipe( const char* command ) ;
//  virtual int MailTo( HGObject*, const char* address, HGObject::mail_mode ) ;

} ;


#endif
