//<copyright>
//
// Copyright (c) 1995
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
//</copyright>



//<file>
//
//
// Name:       fslider.h
//
// Purpose:    Interface to class FieldSlider
//
// Created:    19 May 95   Bernhard Marschall
// Modified:   19 May 95   Bernhard Marschall
//
//
// Description:
//
//</file>

#ifndef harmony_widgets_fslider_h
#define harmony_widgets_fslider_h


#include <InterViews/input.h>

class Adjustable;
class FieldEditor31;
class FieldObserver;


//<class>
//
// Name:                 FieldSlider
//
// Purpose:              FieldEditor coupled with Scrollbar
//
// Public Interface:
//
// Description:
//
//</class>


class FieldSlider : public InputHandler {
public:
  FieldSlider(
    float lower,                   // minimum value
    float upper,                   // maximum value
    float init,                    // initial value
    int precision = 0,             // number of decimals to print
    const char* pattern = nil      // pattern to define width of field editor
  );
  FieldSlider(
    Adjustable*,                   // adjustable (provides min, max and init)
    int precision = 0,             // number of decimals to print
    const char* pattern = nil      // pattern to define width of field editor
  );
  virtual ~FieldSlider();

  void set_value(float value);     // set value
  float get_value() const;         // read current value

  Adjustable* adjustable() const   // returns adjustable used for scrollbar
  { return adj_; }
  FieldEditor31* field() const     // returns field editor
  { return field_; }

private:
  void init(int precision, const char* pattern);
  void setField();
  void accept(FieldEditor31*, char);

  FieldEditor31* field_;
  Adjustable* adj_;
  int precision_;
  char format_[8];
  const boolean adjInside_;
  FieldObserver* fobs_;

  friend class FieldObserver;
};

#endif
