// <copyright>
// 
// Copyright (c) 1994-1995
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// 
// </copyright>

//<file>
//
// Name:       statistics.C
//
// Purpose:    
//
// Created:    18 Feb 94    Gerald Pani
//
// Description:
//
//
//</file>

#include "statistics.h"
#include <time.h>

void StatList::remOld( long t) {
     StatNode* n = nil;
     while ((n = getLast()) && n->tm() < t) {
	  remove( n);
	  delete n;
     }
}

void StatList::addNew( long tm, int cnt) {
     if (cnt) 
	  addHead( new StatNode( tm, cnt));
}

int StatList::fetched( long tm) const {
     int c = 0;
     for (const StatNode* n = first(); n && n->tm() >= tm; n = next( n))
	  c += n->count();
     return c;
}

void Statistics::add( int cnt) {
     long t = ::time( nil);
     fHour_.remOld( t - 3600);
     fHour_.addNew( t, cnt);
     fetched_ += cnt;
}

void Statistics::fetched( int& all, int& hour, int& quarter, int& minute) {
     long t = ::time( nil);
     fHour_.remOld( t - 3600);
     all = (int)fetched_;
     hour = fHour_.fetched( t - 3600);
     quarter = fHour_.fetched( t - 900);
     minute = fHour_.fetched( t - 60);
}

