// This may look like C code, but it is really -*- C++ -*-

//<copyright>
// 
// Copyright (c) 1993,94,95
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// 
//</copyright>

//<file>
//
// Name:        hg3dvw.h
//
// Purpose:     interface to class HgIv3dViewer
//
// Created:     21 Jun 93   Michael Pichler
//
// Changed:      3 Nov 95   Michael Pichler
//
//
//</file>



#ifndef hg_viewer_hg3d_hg3dvw_h
#define hg_viewer_hg3d_hg3dvw_h


#include <hyperg/viewer/vwstuff.h>
// abstract viewer base class HgViewer

#include <Dispatch/rpcservice.h>
#include <Dispatch/iocallback.h>
// #include <Dispatch/rpcbuf.h>

#include <hyperg/utils/str.h>
class Object;

#include "imgserver.h"

#include <InterViews/enter-scope.h>
class Session;


//<class>
//
// Name: Hg3dViewer; abstract
//
// Purpose:
//
// Hyper-G 3d Viewer, independent of look and feel.
// Used to display 3d documents, stored in sdf format.
// Derived classes add a particular look and feel.
//
//</class>


class SceneWindow;
class Hg3dViewer;
declareIOCallback (Hg3dViewer)


class Hg3dViewer: public HgViewer, public RpcService, public ImageServerCallback
{
  public:
    Hg3dViewer (HgViewerManager*, Session*);
    virtual ~Hg3dViewer ();

    // HgViewer
    virtual void load (                 // load document
      const char* doc,                  //   document info
      const char* anchors,              //   source anchors
      char* info = 0                    //   feedback for viewer manager
    );

    virtual int port () const;          // return document port

    virtual void browse (               // browse current document
      const char* dest = 0              //   optional destination anchor
    ) = 0;

    virtual void getPos (RString&);     // tell current position (for later browse)

    virtual void updateTitle ()  { }    // update title in message line

    // editing possibilities not yet supported (may be implemented in HgIv3dViewer
    // virtual void doEdit (const RString& /*object*/, const RString& /*anchors*/) {}
    // virtual void newDoc (int /*refno*/) {}

    virtual void cancelRequest (const char*);  // cancel (invalid) request

    void clearAllRequests ()  { imgserver_.clearAllRequests (); }

    void parseURL (const char* url, const char* docurl, RString& msg)
    { imgserver_.parseURL (url, docurl, msg); }  // parse URL into Hyper-G object

    virtual void terminate ();          // terminate viewer

    // ImageServerCallback: reading data
    int readImage (Material* mat, const char* filename);
    int readInlineURL (QvWWWInline* node, const char* filename);

    // ImageServerCallback: feedback
    void requestImage (const Material* mat);
    void requestURL (const QvWWWInline* node);
    void requestFinished ();

    // local
    const Object& docObj () const       // get whole document object
    { return docobj_; }
    const RString& objIdStr () const    // get current document ID: "0x8f"
    { return objidstr_; }
    const RString& docIdStr () const    // get current document ID: "ObjectID=0x8f\n"
    { return docidstr_; }
    const RString& docURL () const      // get current document URL
    { return docurl_; }
    // const RString& sourceAnchors () const
    // { return srcanchstr_; }

    void storeSourceAnchors ();         // store source anchors (from load)

    void requestInlineURL (QvWWWInline* node, const char* url, const char* docurl)
    { imgserver_.requestInlineURL (node, url, docurl); }

    void requestTextures ()  { imgserver_.handleRequests (1); }

  protected:
    SceneWindow* scene_;

  private:
    virtual void readingCompleted ()  { }  // readInput got whole document

    void createReader (int fd);
    int readInput (int fd);

    void storeanchor (Object&);         // store anchor definition

    IOCallback(Hg3dViewer) read_callback_;

    HgViewerManager* manager_;
    int terminated_;
    int pipe_port_;                     // document port number
    int to_close_;                      // document port to close
    Object docobj_;                     // the whole document object
    RString objidstr_;                  // object id string of current document
    RString docidstr_;                  // document info: "ObjectID=<objectidstring>\n"
    RString docurl_;                    // URL of current document
    RString srcanchstr_;                // source anchors (got from load)

    ImageServer imgserver_;

}; // Hg3dViewer


#endif
