// This may look like C code, but it is really -*- C++ -*-

//<copyright>
// 
// Copyright (c) 1993,94
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// 
//</copyright>

//<file>
//
// Name:        iv3dvw.h
//
// Purpose:     interface to class HgIv3dViewer
//
// Created:     10 Jul 92   Keith Andrews, IICM (template)
//
// Changed:     11 May 94   Michael Pichler
//
//
//</file>


#ifndef hg_viewer_hg3d_iv3dvw_h
#define hg_viewer_hg3d_iv3dvw_h


#include "hg3dvw.h"


#include <InterViews/enter-scope.h>
class ApplicationWindow;
class Session;


//
// class HgIv3dViewer
//
// InterViews Hyper-G 3d Viewer.
// Used to display 3d documents, stored in sdf format.
//


class HgIv3dViewer: public Hg3dViewer
{
  public:
    HgIv3dViewer (HgViewerManager* manager, Session* session);
    virtual ~HgIv3dViewer ();
  
    // HgViewer
    virtual void load (                            // load document
      const char* doc,                             //   document info
      const char* anchors,                         //   source anchors
      char* info = 0                               //   feedback for viewer manager
    );

    virtual void setLanguage (HgLanguage::Language);  // set language of user interface

    virtual void browse (                          // browse current document
      const char* dest = 0                         //   optional destination anchor
    );

    virtual void updateTitle ();                   // show title in message line

    virtual void iconify ();                       // window operations
    virtual void deiconify ();                     //   (self explanatory)
    virtual void moveto (float x, float y);
    // virtual void resize (float x, float y);
    virtual void map ();
    virtual void unmap ();
    virtual void raise ();
    virtual void lower ();

    // virtual void saveResources ();              // save X-defaults (not yet supported)

    // local
    void showScene (                               // show loaded scene
      int setsrcanchors = 1                        //   source anchors need not be set again
    );                                             //   when browse () is done without load ()
  
    void readingCompleted ();                      // beeing told that readInput completed
  
  protected:
    enum                                           // communication states
    { s_ready  = 0x0,  // ready
      s_load   = 0x1,  // got load
      s_browse = 0x2,  // got browse
      s_read   = 0x4,  // read data
      s_all    = 0x7   // got all -- show scene, then ready again
    };
    int state_;                                    // communication state

    RString browse_str_;                           // dest. anchors got from browse

    ApplicationWindow* appwin_;
};


#endif
