/*
 * grammar.y,v 2.1 1992/07/23 19:02:44 pete Exp
 *
 * grammar.y,v
 * Revision 2.1  1992/07/23  19:02:44  pete
 * Removing several error messages.
 *
 * Revision 2.0  1992/04/23  02:47:31  ware
 * First public release.
 *
 * Revision 1.8  1992/02/04  21:21:23  pete
 * Release 44
 *
 * Revision 1.7  1991/08/26  11:19:13  pete
 * Deleted old prototypes for malloc(), and str*().  Added productions
 * to handle constraint widgets.
 *
 * Revision 1.6  1991/05/06  16:07:05  pete
 * A working version
 *
 * Revision 1.5  1991/05/03  18:52:56  pete
 * Output is working again.
 *
 * Revision 1.4  91/05/02  17:15:34  pete
 * Compete rewrite
 * 
 * Revision 1.3  91/05/02  15:22:10  pete
 * Working on output.
 * 
 * Revision 1.2  1991/03/11  15:58:45  pete
 * Added actions and translations to grammar.
 *
 * Revision 1.1  1991/02/21  05:39:19  pete
 * Initial revision
 *
 */

%{
#include <stdio.h>
#include "build.h"
#include "input.h"
extern int  yylex ();
%}

%token	SUPERCLASS
%token	CLASS
%token	CLASS_PREFIX
%token	CLASS_NAME
%token	CLASS_RECORD
%token	CLASS_FIELD
%token	INST_RECORD
%token	INST_FIELD
%token	FIELD
%token	METHOD
%token	FUNCTION
%token	ARGS
%token	CODE
%token	WORD
%token	INSTANCE
%token	ACTIONS
%token	TRANSLATIONS
%token	CONSTRAINTS

%union
{
	char		*u_string;
	char		**u_str_list;
	field_t		*u_field;
	function_t	*u_function;
	arg_list_t	*u_args;
	arg_t		*u_arg;
	action_t	*u_action;
	translation_t	*u_translation;
}

%type <u_str_list>	class_fields
%type <u_field>		class_field
%type <u_field>		field_info
%type <u_field>		method_info
%type <u_function>	function_field_list
%type <u_args>		arguments 
%type <u_string>	codeline
%type <u_args>		arg_list
%type <u_arg>		arg
%type <u_field>		instance_field
%type <u_action>	action_field
%type <u_translation>	translation_field
%type <u_string>	type res_field value comment name res_class res_type
%type <u_string>	res_def default description
%type <u_string>	WORD
%%
classes		: /* empty */
		| classes class
		;

class		: CLASS WORD '=' '{' { input_class_start ($2); } class_info '}'
		  { input_class_done (); }
		;

class_info	: /* empty */
		| class_info assignment
		| class_info class_record
		| class_info function
		| class_info constraints_record
		| class_info instance_record
		| class_info actions_record
		| class_info translation_record
		;

/*----------------------------------------------------------------------*\
 * class_info rhs productions
\*----------------------------------------------------------------------*/

assignment	: WORD '=' WORD ';'
		  {
		  	input_var_add ($1, $3);
		  }
		;

class_record	: CLASS_RECORD WORD '=' '{' class_fields '}'
		  {
			input_class_record_add ($2, $5);
		  }
		;

function	: FUNCTION WORD WORD '=' '{' function_field_list '}'
		  {
			input_class_function_add ($2, $3, $6);
		  }
		;

instance_record: INSTANCE WORD '=' '{' instance_fields '}'
		  {
			input_class_instance_name ($2);
		  }
		;
		
constraints_record:	CONSTRAINTS WORD '=' '{' constraints_fields '}'
		  {
		  	input_class_constraints_name ($2);
		  }
		;
actions_record:	ACTIONS '=' '{' action_fields '}'
		;

translation_record:	TRANSLATIONS '=' '{' translation_fields '}'
		;

/*----------------------------------------------------------------------*\
 * class_record rhs productions
\*----------------------------------------------------------------------*/

class_fields	: /* empty */
		  { $$ = NULL; }
		| class_fields class_field
		  { $$ = input_class_add_field ($1, $2); }
		;

class_field	: FIELD '=' field_info
		  { $$ = $3; }
		| METHOD '=' method_info
		  { $$ = $3; }
		;

field_info	: '(' type type res_field value comment WORD ')' ';'
		  { $$ = make_field ($2, $3, $4, $5, $6, $7); }
		;

method_info	: '(' WORD ',' WORD ',' WORD ',' WORD ',' WORD ')' ';'
		  { $$ = make_method ($2, $4, $6, $8, $10); }
		;

/*----------------------------------------------------------------------*\
 * function rhs productions
\*----------------------------------------------------------------------*/
function_field_list: arguments codeline
		  { $$ = input_class_make_function ($1, $2); }
		;

arguments	: ARGS '=' '{' arg_list '}'
		  { $$ = $4; }
		;

codeline	: /* empty */
		  { $$ = NULL; }
		| CODE '=' '{' WORD '}'
		  { $$ = $4; }
		;

arg_list	: /* empty */
		  { $$ = NULL; }
		| arg_list arg
		  { $$ = input_add_arg ($1, $2); }
		;

arg		: '(' WORD ',' WORD ',' WORD ')'
		  { $$ = input_make_arg ($2, $4, $6); }
		;

/*----------------------------------------------------------------------*\
 * instance_record rhs productions
\*----------------------------------------------------------------------*/
instance_fields	:	/* empty */
		| instance_fields instance_field
		  {
			input_instance_record_add ($2);
		  }
		;

instance_field: '(' type res_field comment name res_class res_type res_def default description ')'
		  {
		  	$$ = input_instance_record_make ($2, $3, $4, $5, $6, $7,
						   $8, $9, $10);
		  }
		;

/*----------------------------------------------------------------------*\
 * constraints_record rhs productions
\*----------------------------------------------------------------------*/
constraints_fields	:	/* empty */
		| constraints_fields instance_field
		  {
			input_constraints_record_add ($2);
		  }
		;

type		: WORD ',' { $$ = $1; } ;
res_field	: WORD ',' { $$ = $1; } ;
value		: WORD ',' { $$ = $1; } ;
comment		: WORD ',' { $$ = $1; } ;
name		: WORD ',' { $$ = $1; } ;
res_class	: WORD ',' { $$ = $1; } ;
res_type	: WORD ',' { $$ = $1; } ;
res_def		: WORD ',' { $$ = $1; } ;
default		: WORD ',' { $$ = $1; } ;
description	: WORD     { $$ = $1; } ;

/*----------------------------------------------------------------------*\
 * actions_record rhs productions
\*----------------------------------------------------------------------*/
action_fields:		/* empty */
		| action_fields action_field
		  { input_action_field_add ($2); }
		;

action_field:	'(' WORD ',' WORD ',' WORD ')'
		  { $$ = input_action_field_make ($2, $4, $6); }
		;
			
/*----------------------------------------------------------------------*\
 * translation rhs productions
\*----------------------------------------------------------------------*/
translation_fields:		/* empty */
		| translation_fields translation_field
		  { input_translation_field_add ($2); }
		;

translation_field:	'(' WORD ',' WORD ',' WORD ')'
		  { $$ = input_translation_field_make ($2, $4, $6); }
		;
			
%%
