/*
 * lookup.c,v 2.0 1992/04/23 02:47:43 ware Exp
 * lookup.c,v
 * Revision 2.0  1992/04/23  02:47:43  ware
 * First public release.
 *
 * Revision 1.7  1992/04/18  01:55:44  ware
 * Fixed so the constraint resources are written
 *
 * Revision 1.6  1992/02/04  21:21:23  pete
 * Release 44
 *
 * Revision 1.5  1991/08/26  11:22:51  pete
 * Added lookup methods for constraint records.
 *
 * Revision 1.4  1991/05/20  17:36:31  pete
 * Class variable overrides should only be overwritten by the immediate
 * class or the original defining class.  Write lookup_class_override()
 * to work this way.
 *
 * Revision 1.3  91/05/06  16:07:05  pete
 * A working version
 * 
 * Revision 1.2  1991/05/03  18:53:00  pete
 * Output is working again.
 *
 */

#include <stdio.h>
#include "build.h"
#include INCLUDESTRINGS

XoProto (static field_t	*, field_copy, (field_t *field, field_t *def_field));

void
lookup_initialize ()
{
}

void
lookup_instance_add (class, field)
class_t		*class;
field_t		*field;
{
	if (!class || !field)
		return;
	table_add (class->cl_instance_fields, (char *) field);
}

void
lookup_constraints_add (class, field)
class_t		*class;
field_t		*field;
{
	if (!class || !field)
		return;
	table_add (class->cl_constraint_fields, (char *) field);
}

void
lookup_class_add (class, field)
class_t		*class;
field_t		*field;
{
	if (!class || !field)
		return;
	table_add (class->cl_class_fields, (char *) field);
}

void
lookup_method_add (class, func)
class_t		*class;
function_t	*func;
{
	if (!class || !func)
		return;
	table_add (class->cl_methods, (char *) func);
}


field_t *
lookup_instance_var (class, name, overflag)
class_t		*class;
char		*name;
int		*overflag;
{
	field_t		dummy;

	*overflag = 0;
	dummy.vf_name = name;
	dummy.vf_field = name;
	return ((field_t *) table_find (class->cl_instance_fields,
					(char *) &dummy));
}

field_t *
lookup_constraint_var (class, name, overflag)
class_t		*class;
char		*name;
int		*overflag;
{
	field_t		dummy;

	*overflag = 0;
	dummy.vf_name = name;
	dummy.vf_field = name;
	return ((field_t *) table_find (class->cl_constraint_fields,
					(char *) &dummy));
}

field_t *
lookup_class_var (class, name, overflag)
class_t		*class;
char		*name;
int		*overflag;
{
	field_t		dummy;
	*overflag = 0;
	dummy.vf_name = name;
	dummy.vf_field = name;
	return ((field_t *) table_find (class->cl_class_fields,
					(char *) &dummy));
}

field_t *
lookup_instance_override (class, field)
class_t		*class;
field_t		*field;
{
	char		class_name[BUFSIZ];
	char		field_name[BUFSIZ];
	field_t		*def_field;
	class_t		*def_class;
	int		override;

	if (!class || !field)
		return ((field_t *) NULL);
	if (!is_override (field))
		return ((field_t *) NULL);
	class_split (field->vf_field, class_name, field_name);
	if ((def_class = class_lookup (class_name)) == NULL)
	{
		fprintf (stderr, "lookup_instance_override: No such class %s for %s\n",
			 class_name, field->vf_field);
		return ((field_t *) NULL);
	}
	def_field = lookup_instance_var (def_class, field_name, &override);
	if (!def_field)
	{
		fprintf (stderr, "lookup_instance_override: No such field %s in class %s\n",
			 field_name, class_name);
		return ((field_t *) NULL);
	}
	return (field_copy (field, def_field));
}

field_t *
lookup_constraint_override (class, field)
class_t		*class;
field_t		*field;
{
	char		class_name[BUFSIZ];
	char		field_name[BUFSIZ];
	field_t		*def_field;
	class_t		*def_class;
	int		override;

	if (!class || !field)
		return ((field_t *) NULL);
	if (!is_override (field))
		return ((field_t *) NULL);
	class_split (field->vf_field, class_name, field_name);
	if ((def_class = class_lookup (class_name)) == NULL)
	{
		fprintf (stderr, "lookup_constraint_override: No such class %s for %s\n",
			 class_name, field->vf_field);
		return ((field_t *) NULL);
	}
	def_field = lookup_constraint_var (def_class, field_name, &override);
	if (!def_field)
	{
		fprintf (stderr, "lookup_constraint_override: No such field %s in class %s\n",
			 field_name, class_name);
		return ((field_t *) NULL);
	}
	return (field_copy (field, def_field));
}

function_t *
lookup_class_method (class, name)
class_t		*class;
char		*name;
{
	function_t	*f;
	function_t	dummy;
	char		classname[512];
	char		fieldname[512];

	if (!class || !name)
		return ((function_t *) NULL);

	class_split (name, classname, fieldname);
	if (!classname[0] || strcmp (class->cl_name, classname) == 0)
	{
		dummy.f_name = fieldname;
		f = (function_t *) table_find (class->cl_methods,
					       (char *) &dummy);
	}
	else
	{
		f = lookup_class_method (class_lookup (classname),
					 name);
	}

	return f;
}

field_t *
lookup_class_override (class, name, override, base)
class_t		*class;
char		*name;
int		*override;
class_t		*base;
{
	char		buf[BUFSIZ];
	field_t		*field;
	field_t		*def_field;
	int		over;

	if (!class)
		return ((field_t *) NULL);
	if (class != base)
	{
		over = 1;
		sprintf (buf, "%s.%s", class->cl_name, name);
	}
	else
	{
		over = 0;
		strcpy (buf, name);
	}
	field = lookup_class_var (base, buf, override);
	if (field)
	{
		if (over)
		{
			def_field = lookup_class_var (class, name, override);
			*override = over;
			return (field_copy (field, def_field));
		}
		else
		{
			*override = 0;
			return field;
		}
	}
	else
	{
		return lookup_class_override (class, name, override, class);
	}
}

static field_t *
field_copy (field, def_field)
field_t		*field;
field_t		*def_field;
{
	field_t		*ret_field;

	ret_field = (field_t *) malloc (sizeof (field_t));
	if (!ret_field)
		return ((field_t *) NULL);
	/*
	 * Basically, we want to fill in ret_field with
	 * each of the originally defined fields from def_field
	 * or from the newly defined fields in field
	 */
#define FIELD_COPY(name) ret_field->name = (field->name && *field->name)?\
	field->name:def_field->name
	FIELD_COPY (vf_type);
	FIELD_COPY (vf_field);
	FIELD_COPY (vf_value);
	FIELD_COPY (vf_comment);
	FIELD_COPY (vf_name);
	FIELD_COPY (vf_class);
	FIELD_COPY (vf_res_type);
	FIELD_COPY (vf_res_def);
	FIELD_COPY (vf_default);
	FIELD_COPY (vf_description);
	ret_field->vf_thetype = def_field->vf_thetype;
#undef FIELD_COPY
	return ret_field;
}

int
is_override (field)
field_t		*field;
{
	if (!field)
		return 0;
	if (!field->vf_field || !*field->vf_field)
		return 0;
	if (index (field->vf_field, '.') != NULL)
		return 1;
	else
		return 0;
}
