/* {{{ Log info, include files and prototypes */

/*
 * Box.c,v 2.2 1992/08/11 00:09:56 pete Exp
 * Box.c,v
 * Revision 2.2  1992/08/11  00:09:56  pete
 * Added stdio.h
 *
 * Revision 2.1  1992/06/23  00:28:43  pete
 * Changed interface to _XoMenuNew and _XoMenuDone.
 *
 * Revision 2.0  1992/04/23  02:50:31  ware
 * First public release.
 *
 * Revision 1.11  1992/02/27  14:30:29  ware
 * Compiled with GCC 2.0 and very strict checks.  Fixed Warnings
 *
 * Revision 1.10  1992/02/20  15:11:09  ware
 * Applied new indentation
 *
 * Revision 1.9  1992/02/04  21:22:46  pete
 * Release 44
 *
 * Revision 1.8  1991/11/30  15:51:19  pete
 * Cleaned up some nitpicky compile time warnings.
 *
 * Revision 1.7  1991/09/12  09:41:39  pete
 * Much work to get the geometry management working better.
 *
 * Revision 1.6  91/08/26  11:56:31  pete
 * Use XoProto() for conditional prototypes.  Working on getting traversals
 * and menus to work more efficiently.  Changed to following naming
 * conventions.
 *
 * Revision 1.5  91/07/19  00:59:55  pete
 * Use shorter file names.  Various speedups.
 *
 * Revision 1.4  91/05/22  17:49:36  pete
 * Get it to compile cleanely.  Menus almost work.
 *
 * Revision 1.3  91/05/17  04:47:25  pete
 * Fixed some warnings about unused variables, prototypes.
 *
 * Revision 1.2  1991/05/16  18:36:17  pete
 * Added query_geometry.  Cleaned up child layout.  Added SetValues()
 * test for all the resources.
 *
 * Revision 1.1  91/05/15  08:56:40  pete
 * Initial revision
 *
 */
#include <stdio.h>
#include <math.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xo/BoxP.h>

#include <X11/Xo/BoxRec.h>

XoProto (static void, SizeLayout, (Widget gw, Dimension *width, Dimension *height));
XoProto (static void, CalcLayout, (Widget gw));
XoProto (static void, DoLayout, (Widget gw));
XoProto (static int, FindLargest, (XoBoxWidget w, Widget *wide_widget_ret, Widget *high_widget_ret, Dimension *width_ret, Dimension *height_ret));

/* }}} */
/* {{{ Core Class Methods */

/*
 *----------------------------------------------------------------------
 * Core Class Methods
 *----------------------------------------------------------------------
 */

/* {{{ ClassInit */

static void
ClassInit ()
{
	_XoRegisterConverters ();
}

/* }}} */
/* {{{ Resize */

static void
Resize (gw)
	Widget          gw;
{
	DoLayout (gw);
}

/* }}} */
/* {{{ Initialize */

static void
Initialize (request, new, arglist, num_args)
	Widget          request;	/* as first created */
	Widget          new;		/* after other parent classes */
	ArgList         arglist;	/* list of arguments */
	Cardinal       *num_args;	/* how many */
{
}

/* }}} */
/* {{{ SetValues */

static Boolean
SetValues (current, request, new, args, num_args)
	Widget          current;	/* widget before the XtSetValues() */
	Widget          request;	/* after args applied but no
					 * set_values */
	Widget          new;		/* the allowed changes */
	ArgList         args;		/* list of arguments */
	Cardinal       *num_args;	/* how many arguments */
{
	XoBoxWidget     w = (XoBoxWidget) new;
	XoBoxWidget     cur = (XoBoxWidget) current;
	Boolean         redisplay = False;
	Boolean         manage = False;

	if (w->comp_base.do_layout && !cur->comp_base.do_layout)
		manage = True;
	if (w->box.hoffset != cur->box.hoffset)
		manage = True;
	if (w->box.voffset != cur->box.voffset)
		manage = True;
	if (w->box.shrink != cur->box.shrink)
		manage = True;
	if (w->box.stretch != cur->box.stretch)
		manage = True;
	if (w->box.insert_hspace != cur->box.insert_hspace)
		manage = True;
	if (w->box.insert_vspace != cur->box.insert_vspace)
		manage = True;
	if (manage)
		ChangeManaged (new);
	return redisplay;
}

/* }}} */
/* {{{ QueryGeometry */

static XtGeometryResult
QueryGeometry (gw, proposed, desired)
	Widget          gw;
	XtWidgetGeometry *proposed;
	XtWidgetGeometry *desired;
{
	XoBoxWidget     w = (XoBoxWidget) gw;
	int             num_rows;
	Dimension       width, height;

	num_rows = ceil (w->box.num_managed / (float) w->box.num_cols);
	if (num_rows <= 0)
		num_rows = 1;
	height = num_rows * (w->box.max_height + w->box.voffset)
		+ w->box.voffset;
	width = w->box.num_cols * (w->box.max_width + w->box.hoffset)
		+ w->box.hoffset;
	/*
	 * I'm just being asked my ideal size
	 */
	if (!proposed->request_mode)
	{
		if (width == w->core.width && height == w->core.height)
			return XtGeometryNo;
		else
		{
			desired->width = width;
			desired->height = height;
			desired->request_mode = CWWidth | CWHeight;
			return XtGeometryAlmost;
		}
	}

	if (XoGeoDimFlags (proposed) == CWWidth)
	{
		desired->height = height;
		desired->request_mode = CWHeight;
		return XtGeometryAlmost;
	}
	else if (XoGeoDimFlags (proposed) == CWHeight)
	{
		desired->width = width;
		desired->request_mode = CWWidth;
		return XtGeometryAlmost;
	}
	else
	{
		/*
		 * Parent is specifying both width and height, so just return
		 * if it's what we'd like to be
		 */
		if (proposed->width == width && proposed->height == height)
			return XtGeometryYes;
		else
			return XtGeometryNo;
	}
}

/* }}} */

/* }}} */
/* {{{ Composite Class Methods */

/*
 *----------------------------------------------------------------------
 * Composite Methods
 *----------------------------------------------------------------------
 */
/* {{{ GeometryManager - Responds to request for changes in size of position

 *		of children.  (See pp 228 of Asente & Swick). */

static XtGeometryResult
GeometryManager (gw, request, geo_ret)
	Widget          gw;
	XtWidgetGeometry *request;
	XtWidgetGeometry *geo_ret;
{
	XoBoxWidget     w;
	Dimension       max_width, save_max_width;
	Dimension       max_height, save_max_height;
	Widget          wide_widget;
	Widget          high_widget;
	XtWidgetGeometry ask;
	Boolean         ask_parent = False;
	XtGeometryResult geo;

	w = (XoBoxWidget) XtParent (gw);
	ask.request_mode = 0;
	ask.width = w->box.max_width;
	ask.height = w->box.max_height;
	FindLargest (w, &wide_widget, &high_widget, &max_width, &max_height);
	if (request->request_mode & CWWidth)
	{
		if (gw == wide_widget || request->width > max_width)
		{
			ask_parent = True;
			max_width = request->width;
		}
	}
	if (request->request_mode & CWHeight)
	{
		if (gw == high_widget || request->height > max_height)
		{
			ask_parent = True;
			max_height = request->height;
		}
	}
	/*
	 * If this request is not going to cause us to change max_width or
	 * max_height, it is meaningless.
	 */
	if (!ask_parent)
	{
		return XtGeometryNo;
	}

	/*
	 * Find out what our height and width would be.  First save the
	 * max_width and max_height so it can be restored.
	 */
	save_max_width = w->box.max_width;
	save_max_height = w->box.max_height;
	w->box.max_width = ask.width;
	w->box.max_height = ask.height;
	SizeLayout ((Widget) w, &ask.width, &ask.height);

	if (ask.width != w->core.width)
		ask.request_mode |= CWWidth;
	if (ask.height != w->core.height)
		ask.request_mode |= CWHeight;
	if (request->request_mode & XtCWQueryOnly)
		ask.request_mode |= XtCWQueryOnly;
	w->box.max_width = save_max_width;
	w->box.max_height = save_max_height;
	geo = XtMakeGeometryRequest ((Widget) w, &ask, &ask);
	if (geo == XtGeometryYes)
	{
		if (!request->request_mode & XtCWQueryOnly)
			ChangeManaged ((Widget) w);
		geo = XtGeometryDone;
	}
	else
		geo = XtGeometryNo;
	return geo;
}

/* }}} */
/* {{{ ChangeManaged - Used when the list of managed children changes.

 *		This may be anywhere from 1 to n children that changed
 *		from managed to unmanaged.  There is no way to tell
 *		which children actually changed (without internally
 *		keeping extra state.
 *
 *		This does no rearranging if do_layout is False.  This
 *		allows an application to add a number of children managed,
 *		and not have a lot of child shuffling occur as each
 *		newly managed child is created.
 */
static void
ChangeManaged (gw)
	Widget          gw;
{
	XoBoxWidget     w = (XoBoxWidget) gw;
	Dimension       width;
	Dimension       height;

	if (w->comp_base.do_layout)
	{
		CalcLayout (gw);
		SizeLayout (gw, &width, &height);
		XtMakeResizeRequest (gw, width, height,
				     (Dimension *) NULL, (Dimension *) NULL);
		DoLayout (gw);
	}
}

/* }}} */

/* }}} */
/* {{{ Private functions */

/*
 *----------------------------------------------------------------------
 * Private methods
 *----------------------------------------------------------------------
 */

/* {{{ SizeLayout */

static void
SizeLayout (gw, width_ret, height_ret)
	Widget          gw;
	Dimension      *width_ret;
	Dimension      *height_ret;
{
	XoBoxWidget     w = (XoBoxWidget) gw;

	*width_ret = w->box.num_cols * (w->box.max_width + w->box.hoffset);
	*height_ret = ceil (w->box.num_managed / (float) w->box.num_cols)
		* (w->box.max_height + w->box.voffset) + w->box.voffset;
}

/* }}} */
/* {{{ FindLargest */

static int
FindLargest (w, wide_widget_ret, high_widget_ret, width_ret, height_ret)
	XoBoxWidget     w;
	Widget         *wide_widget_ret;
	Widget         *high_widget_ret;
	Dimension      *width_ret;
	Dimension      *height_ret;
{
	WidgetList      l;
	int             num_managed;	/* how many widgets managed? */
	Dimension       this;
	XtGeometryResult result;	/* unused */
	XtWidgetGeometry geo;
	Widget          wide_widget = NULL;
	Widget          high_widget = NULL;
	Dimension       max_width = 0;
	Dimension       max_height = 0;

	num_managed = 0;
	for (l = w->composite.children; l < w->composite.children +
	     w->composite.num_children; l++)
	{
		if (!XtIsManaged (*l))
			continue;
		++num_managed;
		result = XtQueryGeometry (*l, (XtWidgetGeometry *) NULL, &geo);
		this = geo.width + 2 * geo.border_width;
		if (this > max_width)
		{
			wide_widget = *l;
			max_width = this;
		}
		this = geo.height + 2 * geo.border_width;
		if (this > max_height)
		{
			high_widget = *l;
			max_height = this;
		}
	}
	if (wide_widget_ret)
		*wide_widget_ret = wide_widget;
	if (high_widget_ret)
		*high_widget_ret = high_widget;
	if (width_ret)
		*width_ret = max_width;
	if (height_ret)
		*height_ret = max_height;
	return num_managed;
}

/* }}} */
/* {{{ CalcLayout */

static void
CalcLayout (gw)
	Widget          gw;
{
	XoBoxWidget     w = (XoBoxWidget) gw;

	w->box.num_managed = FindLargest (w, (Widget *) NULL, (Widget *) NULL,
				     &w->box.max_width, &w->box.max_height);
	if (w->box.num_managed < 9)
		w->box.num_cols = ceil (sqrt ((double) w->box.num_managed));
	else
		w->box.num_cols = floor (sqrt ((double) w->box.num_managed));
}

/* }}} */
/* {{{ DoLayout */

static void
DoLayout (gw)
	Widget          gw;
{
	XoBoxWidget     w = (XoBoxWidget) gw;
	WidgetList      l;
	int             i;
	Position        x, y;
	Dimension       hoffset;
	Dimension       voffset;
	Dimension       width;
	Dimension       height;
	int             num_rows;
	int             child_height;	/* must be signed value */
	int             child_width;	/* must be signed value */

	if (!w->box.num_managed)
		return;
	child_width = w->box.max_width;
	hoffset = w->box.hoffset;
	width = w->box.num_cols * (child_width + hoffset) + hoffset;
	/*
	 * Set the default values for horizontal space
	 */
	/*
	 * The following set of conditionals seek to adjust the horizontal
	 * spacing to some pleasing value.
	 */
	if (width < w->core.width)
	{
		if (w->box.stretch)
		{
			/*
			 * Fill up extra space by increasing the size of each
			 * of the children
			 */
			child_width = w->core.width - (w->box.num_cols * hoffset + hoffset);
			child_width /= w->box.num_cols;
		}
		else if (w->box.insert_hspace)
		{
			/*
			 * Fill up the extra space by increasing the distance
			 * between the children but keeping them the same
			 * size
			 */
			hoffset = w->core.width -
				(w->box.num_cols * w->box.max_width
				 + 2 * w->box.hoffset);
			if (w->box.num_cols > 1)
				hoffset /= (w->box.num_cols - 1);
		}
	}
	else if (width > w->core.width)
	{
		if (w->box.shrink)
		{
			child_width = (w->core.width - hoffset * (w->box.num_cols + 1))
				/ w->box.num_cols;
		}
	}
	if (child_width <= 1)
		child_width = 4;

	height = ceil (w->box.num_managed / (float) w->box.num_cols)
		* (w->box.max_height + w->box.voffset) + w->box.voffset;
	num_rows = ceil (w->box.num_managed / (float) w->box.num_cols);
	if (num_rows <= 0)
	{
		num_rows = 1;
	}
	child_height = w->box.max_height;
	voffset = w->box.voffset;
	if (height < w->core.height)
	{
		if (w->box.stretch)
		{
			child_height = w->core.height - (num_rows * voffset + voffset);
			child_height /= num_rows;
		}
		else if (w->box.insert_vspace)
		{
			voffset = w->core.height - (2 * w->box.voffset
					    + num_rows * w->box.max_height);
			if (num_rows > 1)
				voffset /= num_rows - 1;
			else
				voffset = w->box.voffset;
		}
	}
	else if (height > w->core.height)
	{
		if (w->box.shrink)
		{
			child_height = w->core.height - voffset * (num_rows + 1);
			child_height /= num_rows;
		}
	}
	if (child_height <= 1)
		child_height = 4;

	i = 0;
	x = w->box.hoffset;
	y = w->box.voffset;
	for (l = w->composite.children; l < w->composite.children +
	     w->composite.num_children; l++)
	{
		if (!XtIsManaged (*l))
			continue;
		XtConfigureWidget (*l, x, y, (Dimension) child_width,
				   (Dimension) child_height,
				   (*l)->core.border_width);
		if (++i == w->box.num_cols)
		{
			x = w->box.hoffset;
			y += child_height + voffset;
			i = 0;
		}
		else
		{
			x += child_width + hoffset;
		}
	}
}

/* }}} */

/* }}} */
