/*
 * Button.c,v 2.1 1992/08/11 00:10:43 pete Exp
 * Button.c,v
 * Revision 2.1  1992/08/11  00:10:43  pete
 * Removed Resize() and Redisplay() since they just used Labels
 *
 * Revision 2.0  1992/04/23  02:50:36  ware
 * First public release.
 *
 * Revision 1.12  1992/03/05  05:13:24  ware
 * *** empty log message ***
 *
 * Revision 1.11  1992/02/27  14:30:29  ware
 * Compiled with GCC 2.0 and very strict checks.  Fixed Warnings
 *
 * Revision 1.10  1992/02/20  15:11:09  ware
 * Applied new indentation
 *
 * Revision 1.9  1992/02/04  21:22:46  pete
 * Release 44
 *
 * Revision 1.8  1991/08/26  11:57:41  pete
 * Use XoProto() for conditional prototypes.  Working on getting traversals
 * and menus to work more efficiently.  Changed to following naming
 * conventions.
 *
 * Revision 1.7  91/07/19  00:59:55  pete
 * Use shorter file names.  Various speedups.
 *
 * Revision 1.6  1991/06/14  04:42:41  pete
 * Changed all the printfs to DBUG_PRINTs
 *
 * Revision 1.5  91/06/01  10:03:14  pete
 * Working on menubar
 *
 * Revision 1.4  91/05/22  17:49:37  pete
 * Get it to compile cleanely.  Menus almost work.
 *
 * Revision 1.3  91/05/21  15:08:04  pete
 * Use _XoRedisplaySelf().
 *
 * Revision 1.2  1991/05/20  17:53:41  pete
 * Initialize all the fields.
 *
 * Revision 1.1  91/05/15  08:56:41  pete
 * Initial revision
 *
 */

#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xo/ButtonP.h>
#include <X11/Xo/ObjBorder.h>
#include <X11/Xo/dbug.h>

#include <X11/Xo/ButtonRec.h>

XoProto (static void, TimerCallback, (XtPointer client_data, XtIntervalId *idptr));

/*
 *----------------------------------------------------------------------
 * Core Class Methods
 *----------------------------------------------------------------------
 */

static void
ClassInit ()
{
	_XoRegisterConverters ();
}

static void
Initialize (request, new, arglist, num_args)
	Widget          request;	/* as first created */
	Widget          new;		/* after other parent classes */
	ArgList         arglist;	/* list of arguments */
	Cardinal       *num_args;	/* how many */
{
	XoButtonWidget  w = (XoButtonWidget) new;

	DBUG_ENTER ("Button.Initialize");
	w->button.set = False;
	w->button.timer_id = (XtIntervalId) NULL;
	w->button.timer_ran = False;
	w->button.temp = False;
	DBUG_VOID_RETURN;
}

static Boolean
SetValues (current, request, new, args, num_args)
	Widget          current;	/* widget before the XtSetValues() */
	Widget          request;	/* after args applied but no
					 * set_values */
	Widget          new;		/* the allowed changes */
	ArgList         args;		/* list of arguments */
	Cardinal       *num_args;	/* how many arguments */
{
	return False;
}

/*
 *----------------------------------------------------------------------
 * Simple Class Methods
 *----------------------------------------------------------------------
 */

/*
 *----------------------------------------------------------------------
 * Label Class Methods
 *----------------------------------------------------------------------
 */

/*
 *----------------------------------------------------------------------
 * Button Class Methods
 *----------------------------------------------------------------------
 */

/*
 *----------------------------------------------------------------------
 * Actions
 *----------------------------------------------------------------------
 */

static void
Set (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	XoButtonWidget  w = (XoButtonWidget) gw;

	DBUG_ENTER ("Button.Set");
	w->button.set = True;
	DBUG_VOID_RETURN;
}

static void
Unset (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	XoButtonWidget  w = (XoButtonWidget) gw;

	DBUG_ENTER ("Button.Unset");
	/*
	 * Don't do anything if we are just passing through
	 */
	w->button.temp = w->button.set = False;
	DBUG_VOID_RETURN;
}

static void
UnsetTemp (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	XoButtonWidget  w = (XoButtonWidget) gw;

	DBUG_ENTER ("Button.UnsetTemp");
	/*
	 * Don't do anything if just passing through
	 */
	if (w->button.set)
	{
		w->button.temp = w->button.set;
		w->button.set = False;
	}
	DBUG_VOID_RETURN;
}


static void
SetTemp (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	XoButtonWidget  w = (XoButtonWidget) gw;

	DBUG_ENTER ("Button.SetTemp");
	w->button.set = w->button.temp;
	DBUG_VOID_RETURN;
}

static void
Notify (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	XoButtonWidget  w = (XoButtonWidget) gw;

	DBUG_ENTER ("Button.Notify");
	if (w->button.set)
		XtCallCallbackList (gw, w->button.callbacks,
				    (XtPointer) w->button.set);
	DBUG_VOID_RETURN;
}

static void
Highlight (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	XoButtonWidget  w = (XoButtonWidget) gw;
	Arg             args[10];
	Cardinal        cnt;

	DBUG_ENTER ("Button.Highlight");
	if (XoFocusCheck (gw, event))
	{
		if (w->simple.border_widget)
		{
			cnt = 0;
			XtSetArg (args[cnt], XtNinverted, True);
			++cnt;
			XtSetValues (w->simple.border_widget, args, cnt);
		}
	}
	DBUG_VOID_RETURN;
}

static void
Unhighlight (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	XoButtonWidget  w = (XoButtonWidget) gw;
	Arg             args[10];
	Cardinal        cnt;

	DBUG_ENTER ("Button.Unhighlight");
	if (w->simple.border_widget)
	{
		cnt = 0;
		XtSetArg (args[cnt], XtNinverted, False);
		++cnt;
		XtSetValues (w->simple.border_widget, args, cnt);
	}
	DBUG_VOID_RETURN;
}

static void
TimerCallback (client_data, idptr)
	XtPointer	client_data;
	XtIntervalId	*idptr;
{
	XoButtonWidget	w = (XoButtonWidget) client_data;

	if (w->button.set)
	{
		XtCallCallbackList ((Widget) w, w->button.callbacks,
				    (XtPointer) w->button.set);
		w->button.timer_id =
			XtAppAddTimeOut (XtWidgetToApplicationContext((Widget) w),
					 (unsigned long) w->button.repeat_interval,
					 TimerCallback, (XtPointer) w);
	}
}

static void
RepeatStart (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	XoButtonWidget	w = (XoButtonWidget) gw;

	DBUG_ENTER ("Button.RepeatStart");
	w->button.timer_id =
		XtAppAddTimeOut (XtWidgetToApplicationContext(gw),
				 (unsigned long) w->button.repeat_delay,
				 TimerCallback, (XtPointer) gw);
	DBUG_VOID_RETURN;
}

static void
RepeatEnd (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	XoButtonWidget	w = (XoButtonWidget) gw;

	DBUG_ENTER ("Button.RepeatEnd");
	if (w->button.timer_id)
		XtRemoveTimeOut (w->button.timer_id);
	w->button.timer_id = (XtIntervalId) NULL;
	DBUG_VOID_RETURN;
}

static void
KeyIgnore (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	DBUG_ENTER ("Button.KeyIgnore");
	DBUG_PRINT ("nyi", ("Not Yet Implemented"));
	DBUG_VOID_RETURN;
}

static void
KeyAccept (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	DBUG_ENTER ("Button.KeyAccept");
	DBUG_PRINT ("nyi", ("Not Yet Implemented"));
	DBUG_VOID_RETURN;
}

static void
ClipStart (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	DBUG_ENTER ("Button.ClipStart");
	DBUG_PRINT ("nyi", ("Not Yet Implemented"));
	DBUG_VOID_RETURN;
}

static void
ClipEnd (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	DBUG_ENTER ("Button.ClipEnd");
	DBUG_PRINT ("nyi", ("Not Yet Implemented"));
	DBUG_VOID_RETURN;
}

static void
ClipStuff (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	DBUG_ENTER ("Button.ClipStuff");
	DBUG_PRINT ("nyi", ("Not Yet Implemented"));
	DBUG_VOID_RETURN;
}

static void
ClipGet (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	DBUG_ENTER ("Button.ClipGet");
	DBUG_PRINT ("nyi", ("Not Yet Implemented"));
	DBUG_VOID_RETURN;
}

static void
ItemNext (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	DBUG_ENTER ("Button.ItemNext");
	XoTraverse (gw, XoTRAVERSE_NEXT, XoEventTime (event));
	DBUG_VOID_RETURN;
}

static void
ItemPrev (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	DBUG_ENTER ("Button.ItemPrev");
	XoTraverse (gw, XoTRAVERSE_PREVIOUS, XoEventTime (event));
	DBUG_VOID_RETURN;
}

static void
ItemUp (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	DBUG_ENTER ("Button.ItemUp");
	XoTraverse (gw, XoTRAVERSE_UP, XoEventTime (event));
	DBUG_VOID_RETURN;
}

static void
ItemDown (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	DBUG_ENTER ("Button.ItemDown");
	XoTraverse (gw, XoTRAVERSE_DOWN, XoEventTime (event));
	DBUG_VOID_RETURN;
}

static void
LineEnd (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	DBUG_ENTER ("Button.LineEnd");
	DBUG_PRINT ("nyi", ("Not Yet Implemented"));
	DBUG_VOID_RETURN;
}

static void
LineBegin (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	DBUG_ENTER ("Button.LineBegin");
	DBUG_PRINT ("nyi", ("Not Yet Implemented"));
	DBUG_VOID_RETURN;
}

static void
DataBegin (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	DBUG_ENTER ("Button.DataBegin");
	DBUG_PRINT ("nyi", ("Not Yet Implemented"));
	DBUG_VOID_RETURN;
}

static void
DataEnd (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	DBUG_ENTER ("Button.DataEnd");
	DBUG_PRINT ("nyi", ("Not Yet Implemented"));
	DBUG_VOID_RETURN;
}

static void
GrabFocus (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	Time            when;

	DBUG_ENTER ("Button.GrabFocus");
	/*
	 * Don't do anything if we are just passing through
	 */
	when = XoEventTime (event);
	(void) XtCallAcceptFocus (gw, &when);
	DBUG_VOID_RETURN;
}
