/*
 * MenuBarButton is a widget with actions specifically designed
 * to be part of a menubar.
 *
 * MenuBarB.c,v 2.2 1992/08/11 00:08:49 pete Exp
 * MenuBarB.c,v
 * Revision 2.2  1992/08/11  00:08:49  pete
 * Added handling of flag widget to indicate submenu.
 *
 * Revision 2.1  1992/06/23  00:28:53  pete
 * Changed interface to _XoMenuNew and _XoMenuDone.
 *
 * Revision 2.0  1992/04/23  02:51:16  ware
 * First public release.
 *
 * Revision 1.11  1992/02/27  14:30:29  ware
 * Compiled with GCC 2.0 and very strict checks.  Fixed Warnings
 *
 * Revision 1.10  1992/02/20  15:11:09  ware
 * Applied new indentation
 *
 * Revision 1.9  92/02/04  21:22:46  pete
 * Release 44
 *
 * Revision 1.8  1991/12/01  16:17:49  pete
 * Added WalkMenu() action to optimize menu popups as the mouse
 * is dragged across the menubar.
 *
 * Revision 1.7  1991/11/30  15:51:19  pete
 * Cleaned up some nitpicky compile time warnings.
 *
 * Revision 1.6  1991/08/30  17:39:35  pete
 * Changed to use the new XtNCallbackMenu callback protocol.  Changed
 * Menu to be a subclass of Column.
 *
 * Revision 1.5  91/08/26  11:57:54  pete
 * Use XoProto() for conditional prototypes.  Working on getting traversals
 * and menus to work more efficiently.  Changed to following naming
 * conventions.
 *
 * Revision 1.4  91/07/19  00:59:55  pete
 * Use shorter file names.  Various speedups.
 *
 * Revision 1.3  1991/06/14  17:38:10  pete
 * Added some documentation and generally cleaning up.  Got the button
 * to highlight correctly.
 *
 * Revision 1.2  91/06/14  04:45:48  pete
 * Added DBUG macros.  Working popup menus.
 *
 * Revision 1.1  91/06/01  10:03:23  pete
 * Working on menubar
 *
 */

#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xo/ObjBorder.h>		/* for inverted resource resource */
#include <X11/Xo/MenuBar.h>		/* for newPopup callback */
#include <X11/Xo/MenuBarBP.h>
#include <X11/Xo/dbug.h>

#include <X11/Xo/MenuBBRec.h>

XoProto (static void, DrawBorder, (XoMenuBarButtonWidget w, int drawborder));

/*
 *----------------------------------------------------------------------
 * Core Class Methods
 *----------------------------------------------------------------------
 */

/*
 * SetValues	- Do an updates needed for changed values.
 */

static Boolean
SetValues (current, request, new, args, num_args)
	Widget          current;	/* widget before the XtSetValues() */
	Widget          request;	/* after args applied but no
					 * set_values */
	Widget          new;		/* the allowed changes */
	ArgList         args;		/* list of arguments */
	Cardinal       *num_args;	/* how many arguments */
{
	Boolean         redisplay = False;
	XoMenuBarButtonWidget w = (XoMenuBarButtonWidget) new;

	DBUG_ENTER ("MenuBarButton.SetValues");
	/*
	 * w->menu_button.submenu: We don't handle changing this buttons
	 * popup menu while it is currently popped up, so there is no need to
	 * test for the change.
	 */
	if (!w->menu_bar_button.enable_popup
	    || !_XoIsPoppedUp (XoShellGet (w->menu_button.submenu)))
	{
		DrawBorder (w, False);
	}
	DBUG_RETURN (redisplay);
}

/*
 *----------------------------------------------------------------------
 * Simple Class Methods
 *----------------------------------------------------------------------
 */

/*
 *----------------------------------------------------------------------
 * Label Class Methods
 *----------------------------------------------------------------------
 */

/*
 *----------------------------------------------------------------------
 * Button Class Methods
 *----------------------------------------------------------------------
 */

/*
 *----------------------------------------------------------------------
 * MenuButton Class Methods
 *----------------------------------------------------------------------
 */

/*
 *----------------------------------------------------------------------
 * MenuBarButton Class Methods
 *----------------------------------------------------------------------
 */

/*
 *---------------------------------------------------------------------
 * Actions
 *---------------------------------------------------------------------
 */


static void
WalkMenu (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	XoMenuBarButtonWidget w = (XoMenuBarButtonWidget) gw;

	DBUG_ENTER ("MenuBarButton.WalkMenu");
	/*
	 * If there is no submenu or the submenu is already popped up, just
	 * return without bothering the parent
	 */
	if (w->menu_button.submenu && w->menu_bar_button.enable_popup)
	{
		_XoMenuNew (XtParent (gw), w->menu_button.submenu, gw,
			    _XoGravityAction (params, num_params, XoSOUTHWEST),
			    event, XoPOPUP_NEW);
		DrawBorder (w, True);
	}
	DBUG_VOID_RETURN;
}

/*
 * Highlight -	If enable_popup is True then draw the border and
 *		popup any submenu.   This should also cause any other
 *		submenus to be popped down.
 */
static void
Highlight (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	XoMenuBarButtonWidget w = (XoMenuBarButtonWidget) gw;

	DBUG_ENTER ("MenuBarButton.Highlight");
	/*
	 * If there is no submenu or the submenu is already popped up, just
	 * return without bothering the parent
	 */
	if (w->menu_button.submenu)
	{
		if (w->menu_bar_button.enable_popup
		    || _XoIsPoppedUp (XoShellGet (w->menu_button.submenu)))
		{
			_XoMenuNew (XtParent (gw), w->menu_button.submenu, gw,
				    _XoGravityAction (params, num_params,
						      XoSOUTHWEST),
				    event, XoPOPUP_NEW);
			DrawBorder (w, True);
		}
	}
	DBUG_VOID_RETURN;
}

/*
 * Unhighlight	- Do not display the border.  We explicitely do not
 *		  want to popdown any other menus because we do not
 *		  know that our submenu is supposed to be displayed.
 */

static void
Unhighlight (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	XoMenuBarButtonWidget w = (XoMenuBarButtonWidget) gw;

	DBUG_ENTER ("MenuBarButton.Unhighlight");
	DrawBorder (w, False);
	DBUG_VOID_RETURN;
}

/*
 * SubmenuPopup	- Cause our submenu to popup with _XoMenuNew().
 */

static void
SubmenuPopup (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	XoMenuBarButtonWidget w = (XoMenuBarButtonWidget) gw;

	DBUG_ENTER ("MenuBarButton.SubmenuPopup");
	/*
	 * If we have a submenu pop it up.
	 */
	if (w->menu_button.submenu)
	{
		_XoMenuNew (XtParent (gw), w->menu_button.submenu, gw,
			    _XoGravityAction (params, num_params, XoSOUTHWEST),
			    event, XoPOPUP_NEW);
	}
	DrawBorder (w, True);
	DBUG_VOID_RETURN;
}


static void
GrabFocus (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	DBUG_ENTER ("MenuBarButton.GrabFocus");
	DBUG_VOID_RETURN;
}

static void
EnableMenus (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	Boolean         flag;

	DBUG_ENTER ("MenuBarButton.EnableMenus");
	if (*num_params > 0 && params[0][0] == 'T')
		flag = True;
	else
		flag = False;
	XoEnablePopups (XtParent (gw), flag);
	DBUG_VOID_RETURN;
}

static void
ItemUp (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	DBUG_ENTER ("MenuBarButton.ItemUp");
	XoTraverse (gw, XoTRAVERSE_UP, XoEventTime (event));
	DBUG_VOID_RETURN;
}

static void
ItemDown (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	XoMenuBarButtonWidget w = (XoMenuBarButtonWidget) gw;

	DBUG_ENTER ("MenuBarButton.ItemDown");
	if (w->menu_button.submenu
	    && _XoIsPoppedUp (XoShellGet (w->menu_button.submenu)))
	{
		XoTraverseWidget (w->menu_button.submenu,
				  w->menu_button.submenu,
				  XoTRAVERSE_HOME,
				  XoEventTime (event));
	}
	else
	{
		_XoMenuNew (XtParent (gw), w->menu_button.submenu, gw,
			    _XoGravityAction (params, num_params, XoSOUTHWEST),
			    event, XoPOPUP_NEW);
	}
	DBUG_VOID_RETURN;
}

static void
MenuRight (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	DBUG_ENTER ("MenuBarButton.MenuRight");
	XoTraverse (gw, XoTRAVERSE_RIGHT, XoEventTime (event));
	DBUG_VOID_RETURN;
}

static void
MenuLeft (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	DBUG_ENTER ("MenuBarButton.MenuLeft");
	XoTraverse (gw, XoTRAVERSE_LEFT, XoEventTime (event));
	DBUG_VOID_RETURN;
}

static void
DataBegin (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	DBUG_ENTER ("MenuBarButton.DataBegin");
	DBUG_VOID_RETURN;
}

static void
DataEnd (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	DBUG_ENTER ("MenuBarButton.DataEnd");
	DBUG_VOID_RETURN;
}

static void
LineBegin (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	DBUG_ENTER ("MenuBarButton.LineBegin");
	DBUG_VOID_RETURN;
}

static void
LineEnd (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	DBUG_ENTER ("MenuBarButton.LineEnd");
	DBUG_VOID_RETURN;
}


/*
 *----------------------------------------------------------------------
 * Private Utilities
 *----------------------------------------------------------------------
 */

/*
 * DrawBorder -	Turns drawing of the border widget to on or off
 */
static void
DrawBorder (w, drawborder)
	XoMenuBarButtonWidget w;
	int             drawborder;
{
	Boolean         flag = !drawborder;
	Arg             args[10];
	Cardinal        cnt;

	DBUG_ENTER ("MenuBarButton.DrawBorder");
	if (w->simple.border_widget)
	{
		DBUG_PRINT ("border", ("border %s", drawborder ? "on" : "off"));
		cnt = 0;
		XtSetArg (args[cnt], XtNinverted, flag);
		++cnt;
		XtSetValues (w->simple.border_widget, args, cnt);
	}
	DBUG_VOID_RETURN;
}
