/*
 * ClassInit -	provide the default initialization function for most
 *		of the widgets.  Merely class _XoRegisterConverters.
 *
 * class_init.c,v 2.1 1992/08/11 00:05:45 pete Exp
 * class_init.c,v
 * Revision 2.1  1992/08/11  00:05:45  pete
 * Added IntrinsicP.h.
 *
 * Revision 2.0  1992/04/23  02:52:10  ware
 * First public release.
 *
 * Revision 1.5  1992/02/27  14:30:29  ware
 * Compiled with GCC 2.0 and very strict checks.  Fixed Warnings
 *
 * Revision 1.4  1992/02/20  15:11:09  ware
 * Applied new indentation
 *
 * Revision 1.3  1991/08/26  11:58:09  pete
 * Use XoProto() for conditional prototypes.  Working on getting traversals
 * and menus to work more efficiently.  Changed to following naming
 * conventions.
 *
 * Revision 1.2  91/07/19  00:59:55  pete
 * Use shorter file names.  Various speedups.
 *
 * Revision 1.1  1991/06/14  17:40:47  pete
 * Initial revision
 *
 */

#include <X11/Xo/XoP.h>

/*
 * This is the list of functions executed for each class initialization
 */

static XoFuncHooks *HookList;

/*
 * xoAddClassHooks - Add a function to a list of functions called
 *		add class initialization time
 */

void
XoAddClassHook (func, data)
	XoClassHook     func;
	XtPointer       data;
{
	XoFuncHooks    *node;

	if (!func)
		return;
	node = XtNew (XoFuncHooks);
	node->func = func;
	node->data = data;
	node->next = HookList;
	HookList = node;
}

void
XoRemoveClassHook (func, data)
	XoClassHook     func;
	XtPointer       data;
{
	XoFuncHooks    *ptr;
	XoFuncHooks    *prev;

	if (!func || !HookList)
		return;

	prev = NULL;
	for (ptr = HookList; ptr; ptr = ptr->next)
	{
		if (ptr->func == func && ptr->data == data)
			break;
		else
			prev = ptr;
	}
	if (prev)
		prev->next = ptr ? ptr->next : NULL;
	else
		HookList = ptr ? ptr->next : NULL;
}

/*
 * XoRemoveAllClassHooks - Empty the list of hook functions.  Use
 *		XoRemoveClassHook() to delete a particular one (much
 *		friendlier method.
 */

void
XoRemoveAllClassHooks ()
{
	XoFuncHooks    *ptr, *prev;

	ptr = HookList;
	while (ptr)
	{
		prev = ptr;
		ptr = ptr->next;
		XtFree ((char *) prev);
	}
	HookList = NULL;
}

/*
 * _XoCallClassHooks - Execute each of the functions saved on the
 *		added to the list with XoAddClassHook().
 */

void
_XoCallClassHooks ()
{
	XoFuncHooks    *ptr;

	for (ptr = HookList; ptr; ptr = ptr->next)
	{
		if (ptr->func)
			(*ptr->func) (ptr->data);
	}
}

/*
 * _XoClassInit - default method for initializing classes.
 */

void
_XoClassInit ()
{
	_XoRegisterConverters ();
	_XoCallClassHooks ();
}
