/*
 * icccm.c,v 2.3 1992/07/22 16:22:23 pete Exp
 * icccm.c,v
 * Revision 2.3  1992/07/22  16:22:23  pete
 * Missed one prototype.
 *
 * Revision 2.2  1992/07/22  16:21:49  pete
 * Moved XoWMAddDeleteHandler() prototype to Xo.h.  Changed serveral
 * _XoWMFocus*() functions to be static.  I'm not sure why, but I'd originally
 * thought they might be useful to other widgets.
 *
 * --pete
 *
 * Revision 2.1  1992/07/22  16:04:09  pete
 * Several new functions to handle WM_DELETE_WINDOW messages from the
 * window manager.
 *
 * Revision 2.0  1992/04/23  02:52:32  ware
 * First public release.
 *
 * Revision 1.3  1992/02/27  14:30:29  ware
 * Compiled with GCC 2.0 and very strict checks.  Fixed Warnings
 *
 * Revision 1.2  1992/02/20  15:11:09  ware
 * Applied new indentation
 *
 * Revision 1.1  1992/02/04  21:26:39  pete
 * Initial revision
 *
 */

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xmu/Atoms.h>
#include <X11/Xo/Xo.h>
#include <X11/Xo/dbug.h>

XoProto (static void, _XoWMFocusCallback, (Widget gw, XtPointer client_data, XtPointer call_data));
XoProto (static void, _XoWMFocusEventCallback, (Widget gw, XtPointer client_data, XtPointer call_data));
XoProto (static void, _XoWMFocusEventHandler, (Widget gw, XtPointer client_data, XEvent *event, Boolean *cont_to_dispatch));

XoProto (static void, _XoWMDeleteAction, (Widget gw, XEvent *event, String *params, Cardinal *num));
XoProto (static void, _XoWMDeleteCallback, (Widget gw, XtPointer client_data, XtPointer call_data));

static Atom     _XoAtomFocus;		/* used for WM_TAKE_FOCUS */
static Atom	_XoAtomDelete;		/* used form WM_DELETE_WINDOW */

void
XoWMAddFocusHandler (gw)
	Widget          gw;
{

	if (!XtIsShell (gw))
		gw = XoShellGet (gw);
	/*
	 * FIX: Need to handle mutiple displays, dummy!
	 */
	if (!_XoAtomFocus)
		_XoAtomFocus = XInternAtom (XtDisplay (gw), "WM_TAKE_FOCUS",
					    False);
	if (!XtIsRealized (gw))
	{
		XtAddCallback (gw, XtNpopupCallback, _XoWMFocusCallback,
			       (XtPointer) NULL);
	}
	else
	{
		XSetWMProtocols (XtDisplay (gw), XtWindow (gw), &_XoAtomFocus, 1);
	}
	/*
	 * FIX: I should probably be adding an action and augment the
	 * translations of this shell.  Then the application can both change
	 * the action or the user can have a different translation entirely.
	 */
	XtAddEventHandler (gw, FocusChangeMask, False, _XoWMFocusEventHandler,
			   (XtPointer) NULL);
}

static void
_XoWMFocusEventHandler (gw, client_data, event, cont_to_dispatch)
	Widget          gw;
	XtPointer       client_data;
	XEvent         *event;
	Boolean        *cont_to_dispatch;
{
	XFocusChangeEvent *e;

	DBUG_ENTER ("_XoWMFocusEventHandler");
	if (event->type != FocusIn && event->type != FocusOut)
		DBUG_VOID_RETURN;
	DBUG_PRINT ("focus", ("Got a focus event in %s", XoName (gw)));
	e = (XFocusChangeEvent *) event;
	/*
	 * If loosing the focus, don't do anything.
	 */
	if (e->type == FocusOut)
		DBUG_VOID_RETURN;
	(void) XoFocusCheck (gw, event);
	DBUG_VOID_RETURN;
}


static void
_XoWMFocusCallback (gw, client_data, call_data)
	Widget          gw;
	XtPointer       client_data;	/* data application added */
	XtPointer       call_data;	/* data from the widget */
{
	if (!XtIsShell (gw))
		gw = XoShellGet (gw);
	if (!_XoAtomFocus)
		_XoAtomFocus = XInternAtom (XtDisplay (gw), "WM_TAKE_FOCUS", False);
	if (!XtIsRealized (gw))
		XtRealizeWidget (gw);
	XSetWMProtocols (XtDisplay (gw), XtWindow (gw), &_XoAtomFocus, 1);
}

static void
_XoWMFocusEventCallback (gw, client_data, call_data)
	Widget          gw;
	XtPointer       client_data;	/* data application added */
	XtPointer       call_data;	/* data from the widget */
{
	DBUG_ENTER ("_XoWMFocusEventCallback");
	(void) XoFocusCheck (gw, (XEvent *) NULL);
	DBUG_VOID_RETURN;
}

/*
 *----------------------------------------------------------------------
 * WM_DELETE_WINDOW handling
 *----------------------------------------------------------------------
 */

static XtActionsRec _XoWMDeleteActionTable[] =
{
	{"_XoWMDelete",	_XoWMDeleteAction}
};

/*
 * XoWMAddDeleteHandler -
 *	Register the "_XoWMDelete()" action.  Then make sure the
 *	window manager knows this shell responds to it.
 */

void
XoWMAddDeleteHandler (gw)
	Widget		gw;
{
	static Boolean	added_quit;	/* only add once */
	char		*translation = "<Message>WM_PROTOCOLS: _XoWMDelete()";

	/*
	 * Only add this action once.  This way the application can override
	 * the value.
	 *
	 * FIX: Do this once per application context!
	 *
	 */
	if (!added_quit)
	{
		XtAppAddActions (XtWidgetToApplicationContext (gw),
				 _XoWMDeleteActionTable,
				 XtNumber (_XoWMDeleteActionTable));
		added_quit = True;
	}

	if (!XtIsShell (gw))
		gw = XoShellGet (gw);
	/*
	 * FIX: Need to handle mutiple displays, dummy!
	 */
	if (!_XoAtomDelete)
		_XoAtomDelete = XInternAtom (XtDisplay (gw),
					     "WM_DELETE_WINDOW",
					    False);
	if (!XtIsRealized (gw))
	{

		XtAddCallback (gw, XtNpopupCallback, _XoWMDeleteCallback,
			       (XtPointer) NULL);
	}
	else
	{
		(void) XSetWMProtocols (XtDisplay (gw), XtWindow (gw),
					&_XoAtomDelete, 1);
	}
	XtOverrideTranslations (gw, XtParseTranslationTable (translation));
}

/*
 * _XoWMDeleteAction -
 *	Default action for handling window manager delete window requests.
 *	Just exits the application.
 */

static void
_XoWMDeleteAction (gw, event, params, num_params)
	Widget		gw;
	XEvent		*event;
	String		*params;
	Cardinal	*num_params;
{
	exit (0);
}

/*
 * _XoWMDeleteCallback -
 *	Callback added so when the widget is popped up then the
 *	WM_DELETE_WINDOW protocol can be added.
 */

static void
_XoWMDeleteCallback (gw, client_data, call_data)
	Widget          gw;
	XtPointer       client_data;	/* data application added */
	XtPointer       call_data;	/* data from the widget */
{
	if (!XtIsShell (gw))
		gw = XoShellGet (gw);
	if (!_XoAtomDelete)
		_XoAtomDelete = XInternAtom (XtDisplay (gw),
					     "WM_DELETE_WINDOW",
					     False);
	if (!XtIsRealized (gw))
		XtRealizeWidget (gw);
	XSetWMProtocols (XtDisplay (gw), XtWindow (gw), &_XoAtomDelete, 1);
}
