/*
 * Utilities dealing with popup widgets
 *
 * is_popped.c,v 2.0 1992/04/23 02:52:38 ware Exp
 * is_popped.c,v
 * Revision 2.0  1992/04/23  02:52:38  ware
 * First public release.
 *
 * Revision 1.7  1992/02/27  14:30:29  ware
 * Compiled with GCC 2.0 and very strict checks.  Fixed Warnings
 *
 * Revision 1.6  1992/02/20  15:11:09  ware
 * Applied new indentation
 *
 * Revision 1.5  1992/02/12  00:52:27  ware
 * Added XoShellFirstPopped() to return the very first parent of this
 * widget that is popped up.
 *
 * Revision 1.4  92/02/04  21:25:33  pete
 * Release 44
 *
 * Revision 1.3  91/08/26  11:58:24  pete
 * Use XoProto() for conditional prototypes.  Working on getting traversals
 * and menus to work more efficiently.  Changed to following naming
 * conventions.
 *
 * Revision 1.2  91/07/19  00:59:55  pete
 * Use shorter file names.  Various speedups.
 *
 */

#include <X11/IntrinsicP.h>
#include <X11/ShellP.h>
#include <X11/Xo/XoP.h>

/*
 * _XoIsPoppedUp - Returns True if the widget is a shell and is popped up.
 */

Boolean
_XoIsPoppedUp (gw)
	Widget          gw;
{
	ShellWidget     w = (ShellWidget) gw;

	if (!gw || !XtIsShell (gw))
		return False;
	return w->shell.popped_up;
}

/*
 * Return the shell ancestor of a widget.  A widget is it's own ancestor so
 * if this is a shell we return it.
 */

Widget
XoShellGet (gw)
	Widget          gw;
{
	while (gw && !XtIsShell (gw))
		gw = XtParent (gw);
	return gw;
}

/*
 * Return the earliest popped up shell of this widget
 */
Widget
XoShellFirstPopped (gw)
	Widget          gw;
{
	Widget          shell;

	for (shell = XoShellGet (gw); shell; shell = XoShellGet (XtParent (shell)))
	{
		if (_XoIsPoppedUp (shell))
			break;
	}
	return (shell);
}

/*
 * Return the top of the widget tree.  You may want to
 * use XoToplevelGet() as doing the more intuitively correct thing
 */

Widget
XoShellTop (gw)
	Widget          gw;
{
	Widget          top = gw;

	while ((gw = XtParent (gw)))
		top = gw;
	return (top);
}

/*
 * Return the topmost shell that is realized of the widget.  This can
 * be used to find the realized, main shell of the application.  If an
 * application uses one toplevel shell that is never realized and several
 * subsidiary shells, this returns the subsidiary shell and not the
 * actual root of the widget tree.
 */

Widget
XoShellTopRealized (gw)
	Widget          gw;
{
	Widget          top;

	top = gw;
	while (gw)
	{
		if (_XoIsPoppedUp (gw))
			top = gw;
		gw = XtParent (gw);
	}
	return top;
}
