/*
 * Postscript utility functions
 *
 * ps.c,v 2.0 1992/04/23 02:52:56 ware Exp
 * ps.c,v
 * Revision 2.0  1992/04/23  02:52:56  ware
 * First public release.
 *
 * Revision 1.3  1992/02/27  14:30:29  ware
 * Compiled with GCC 2.0 and very strict checks.  Fixed Warnings
 *
 * Revision 1.2  1992/02/20  15:11:09  ware
 * Applied new indentation
 *
 * Revision 1.1  1991/07/19  00:58:43  pete
 * Initial revision
 *
 */

#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xo/XoP.h>
#include <X11/Xo/PS.h>
#include <X11/Xo/dbug.h>

typedef struct _xo_ps_info
{
	Widget          pi_start;	/* initial widget */
	int             pi_start_x;	/* x coordinate of start on root win */
	int             pi_start_y;	/* y coordinate of start on root win */
	int             pi_offset_x;	/* amount to translate in x */
	int             pi_offset_y;	/* amount to translate in y */
	float           pi_offset_sf_x;	/* amount to scale in x */
	float           pi_offset_sf_y;	/* amount to scale in y */
}               XoPSInfo;

XtPointer
_xoPSinit (start)
	Widget          start;
{
	XoPSInfo       *info;
	Position        root_x, root_y;
	Arg             args[10];
	Cardinal        cnt;

	if (!start)
		return ((XtPointer) NULL);
	info = XtNew (XoPSInfo);
	info->pi_start = start;
	cnt = 0;
	XtSetArg (args[cnt], XtNx, &root_x);
	++cnt;
	XtSetArg (args[cnt], XtNy, &root_y);
	++cnt;
	XtGetValues (start, args, cnt);
	XtTranslateCoords (gw, root_x, root_y, &root_x, &root_y);
	info->pi_start = XtTranslateCoordsrans
		void
	                _xoPStext (hardcopy, gw, font, color, x, y, text)
	XoHardCopy     *hardcopy;
	Widget          gw;
	XFontStruct    *font;
	Pixel           color;
	int             x;
	int             y;
	String          text;

	{
		int             ps_x;
		int             ps_y;

		DBUG_ENTER ("_xoPStext");
		if (!hardcopy || !gw || !font || !text)
			DBUG_VOID_RETURN;

		_xoPStranslate (hardcopy, gw, x, y, &ps_x, &ps_y);
		_xoPScolor (gw, color);
		printf ("%d %d moveto (%s) show\n",
			ps_x, ps_y, text);
		DBUG_VOID_RETURN;
	}

	void
	                _xoPStranslate (hardcopy, gw, x, y, x_ret, y_ret)
	XoHardCopy     *hardcopy;
	Widget          gw;
	int             x;
	int             y;
	int            *x_ret;
	int            *y_ret;

	{
		Position        root_x, root_y;
		XoPSInfo       *info;

		DBUG_ENTER ("_xoPSTranslate");
		if (!hardcopy || !gw || !x_ret || !y_ret)
			DBUG_VOID_RETURN;
		info = (XoPSInfo *) hardcopy->private;
		if (!info)
			DBUG_VOID_RETURN;
		XtTranslateCoords (gw, (Position) x, (Position) y,
				   &root_x, &root_y);
		/*
		 * Make these relative to the starting widget
		 */
		*x_ret = root_x - info->pi_start_x;
		*x_ret = root_y - info->pi_start_y;

		/*
		 * Now translate them into our postscript coordinates
		 */

		*y_ret = (info->pi_offset_y - *y_ret) * info->pi_offset_sf_y;
		*x_ret = (info->pi_offset_x - *x_ret) * info->pi_offset_sf_x;
		DBUG_VOID_RETURN;
	}

	void
	                _xoPScolor (gw, color)
	Widget          gw;
	Pixel           color;

	{
		printf ("%d color\n", color);
	}
