/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;

public class DirectColorModel
extends ColorModel {
    private int red_mask;
    private int green_mask;
    private int blue_mask;
    private int alpha_mask;
    private int red_offset;
    private int green_offset;
    private int blue_offset;
    private int alpha_offset;
    private int red_scale;
    private int green_scale;
    private int blue_scale;
    private int alpha_scale;
    private int accum_mask;

    public DirectColorModel(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, 0);
    }

    public DirectColorModel(int n, int n2, int n3, int n4, int n5) {
        super(n);
        this.red_mask = n2;
        this.green_mask = n3;
        this.blue_mask = n4;
        this.alpha_mask = n5;
        this.CalculateOffsets();
    }

    public final int getRedMask() {
        return this.red_mask;
    }

    public final int getGreenMask() {
        return this.green_mask;
    }

    public final int getBlueMask() {
        return this.blue_mask;
    }

    public final int getAlphaMask() {
        return this.alpha_mask;
    }

    private void DecomposeMask(int n, String string, int[] nArray) {
        int n2;
        if ((n & this.accum_mask) != 0) {
            throw new IllegalArgumentException(String.valueOf(string) + " mask bits not unique");
        }
        int n3 = 0;
        int n4 = 0;
        if (n != 0) {
            while ((n & 1) == 0) {
                n >>>= 1;
                ++n3;
            }
            while ((n & 1) == 1) {
                n >>>= 1;
                ++n4;
            }
        }
        if (n != 0) {
            throw new IllegalArgumentException(String.valueOf(string) + " mask bits not contiguous");
        }
        if (n3 + n4 > this.pixel_bits) {
            throw new IllegalArgumentException(String.valueOf(string) + " mask overflows pixel");
        }
        if (n4 < 8) {
            n2 = (1 << n4) - 1;
        } else {
            n2 = 0;
            if (n4 > 8) {
                n3 += n4 - 8;
            }
        }
        nArray[0] = n3;
        nArray[1] = n2;
    }

    private void CalculateOffsets() {
        int[] nArray = new int[2];
        this.DecomposeMask(this.red_mask, "red", nArray);
        this.red_offset = nArray[0];
        this.red_scale = nArray[1];
        this.DecomposeMask(this.green_mask, "green", nArray);
        this.green_offset = nArray[0];
        this.green_scale = nArray[1];
        this.DecomposeMask(this.blue_mask, "blue", nArray);
        this.blue_offset = nArray[0];
        this.blue_scale = nArray[1];
        this.DecomposeMask(this.alpha_mask, "alpha", nArray);
        this.alpha_offset = nArray[0];
        this.alpha_scale = nArray[1];
    }

    public final int getRed(int n) {
        int n2 = (n & this.red_mask) >>> this.red_offset;
        if (this.red_scale != 0) {
            n2 = n2 * 255 / this.red_scale;
        }
        return n2;
    }

    public final int getGreen(int n) {
        int n2 = (n & this.green_mask) >>> this.green_offset;
        if (this.green_scale != 0) {
            n2 = n2 * 255 / this.green_scale;
        }
        return n2;
    }

    public final int getBlue(int n) {
        int n2 = (n & this.blue_mask) >>> this.blue_offset;
        if (this.blue_scale != 0) {
            n2 = n2 * 255 / this.blue_scale;
        }
        return n2;
    }

    public final int getAlpha(int n) {
        if (this.alpha_mask == 0) {
            return 255;
        }
        int n2 = (n & this.alpha_mask) >>> this.alpha_offset;
        if (this.alpha_scale != 0) {
            n2 = n2 * 255 / this.alpha_scale;
        }
        return n2;
    }

    public final int getRGB(int n) {
        return this.getAlpha(n) << 24 | this.getRed(n) << 16 | this.getGreen(n) << 8 | this.getBlue(n);
    }
}

