/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Short
extends Number {
    public static final short MIN_VALUE = Short.MIN_VALUE;
    public static final short MAX_VALUE = Short.MAX_VALUE;
    public static final Class TYPE = Class.getPrimitiveClass("short");
    private short value;

    public static String toString(short s) {
        return Integer.toString(s, 10);
    }

    public static short parseShort(String string) throws NumberFormatException {
        return Short.parseShort(string, 10);
    }

    public static short parseShort(String string, int n) throws NumberFormatException {
        int n2 = Integer.parseInt(string, n);
        if (n2 < Short.MIN_VALUE || n2 > Short.MAX_VALUE) {
            throw new NumberFormatException();
        }
        return (short)n2;
    }

    public static Short valueOf(String string, int n) throws NumberFormatException {
        return new Short(Short.parseShort(string, n));
    }

    public static Short valueOf(String string) throws NumberFormatException {
        return new Short(Short.parseShort(string, 10));
    }

    public static Short decode(String string) throws NumberFormatException {
        if (string.startsWith("0x", 0)) {
            String string2 = string.substring(2);
            return new Short(Short.parseShort(string2, 16));
        }
        if (string.startsWith("#", 0)) {
            String string3 = string.substring(1);
            return new Short(Short.parseShort(string3, 16));
        }
        if (string.startsWith("0", 0) && string.length() > 1) {
            String string4 = string.substring(1);
            return new Short(Short.parseShort(string4, 8));
        }
        return new Short(Short.parseShort(string, 10));
    }

    public Short(short s) {
        this.value = s;
    }

    public Short(String string) throws NumberFormatException {
        this.value = Short.parseShort(string, 10);
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        short s = this.value;
        return Integer.toString(s, 10);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Short) {
            Short s = (Short)object;
            return this.value == s.value;
        }
        return false;
    }
}

