/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFileInputStream;

public class ZipFile
implements ZipConstants {
    RandomAccessFile raf;
    private String name;
    private Hashtable entries;
    long cenpos;
    private long endpos;
    long pos;
    private static final int STORED = 0;
    private static final int DEFLATED = 8;
    private static final int INBUFSIZ = 64;

    public ZipFile(String string) throws IOException {
        this.raf = new RandomAccessFile(string, "r");
        this.name = string;
        this.readCEN();
    }

    public ZipFile(File file) throws ZipException, IOException {
        this(file.getPath());
    }

    public ZipEntry getEntry(String string) {
        return (ZipEntry)this.entries.get(string);
    }

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        ZipFileInputStream zipFileInputStream = new ZipFileInputStream(this, zipEntry);
        switch (zipEntry.method) {
            case 0: {
                return zipFileInputStream;
            }
            case 8: {
                return new InflaterInputStream(zipFileInputStream, new Inflater(true));
            }
        }
        throw new ZipException("invalid compression method");
    }

    public String getName() {
        return this.name;
    }

    public Enumeration entries() {
        return this.entries.elements();
    }

    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
            this.raf = null;
        }
    }

    synchronized int read(long l, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (l != this.pos) {
            this.raf.seek(l);
        }
        if ((n3 = this.raf.read(byArray, n, n2)) > 0) {
            this.pos = l + (long)n3;
        }
        return n3;
    }

    synchronized int read(long l) throws IOException {
        int n;
        if (l != this.pos) {
            this.raf.seek(l);
        }
        if ((n = this.raf.read()) > 0) {
            this.pos = l + 1L;
        }
        return n;
    }

    private void readCEN() throws IOException {
        this.findEND();
        byte[] byArray = new byte[22];
        RandomAccessFile randomAccessFile = this.raf;
        randomAccessFile.readFully(byArray, 0, byArray.length);
        if (((long)(byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8) | (long)(byArray[2] & 0xFF | (byArray[3] & 0xFF) << 8) << 16) != 101010256L) {
            throw new ZipException("invalid END header signature");
        }
        this.cenpos = (long)(byArray[16] & 0xFF | (byArray[17] & 0xFF) << 8) | (long)(byArray[18] & 0xFF | (byArray[19] & 0xFF) << 8) << 16;
        int n = (int)((long)(byArray[12] & 0xFF | (byArray[13] & 0xFF) << 8) | (long)(byArray[14] & 0xFF | (byArray[15] & 0xFF) << 8) << 16);
        if (this.cenpos + (long)n != this.endpos) {
            throw new ZipException("invalid END header format");
        }
        int n2 = byArray[10] & 0xFF | (byArray[11] & 0xFF) << 8;
        if (n2 * 46 > n) {
            throw new ZipException("invalid END header format");
        }
        if ((byArray[8] & 0xFF | (byArray[9] & 0xFF) << 8) != n2) {
            throw new ZipException("cannot have more than one drive");
        }
        this.raf.seek(this.cenpos);
        byte[] byArray2 = new byte[n];
        RandomAccessFile randomAccessFile2 = this.raf;
        randomAccessFile2.readFully(byArray2, 0, byArray2.length);
        this.entries = new Hashtable(n2);
        int n3 = 0;
        while (n3 < n) {
            int n4 = n3 + 2;
            if (((long)(byArray2[n3] & 0xFF | (byArray2[n3 + 1] & 0xFF) << 8) | (long)(byArray2[n4] & 0xFF | (byArray2[n4 + 1] & 0xFF) << 8) << 16) != 33639248L) {
                throw new ZipException("invalid CEN header signature");
            }
            ZipEntry zipEntry = new ZipEntry();
            int n5 = n3 + 6;
            zipEntry.version = byArray2[n5] & 0xFF | (byArray2[n5 + 1] & 0xFF) << 8;
            n5 = n3 + 8;
            zipEntry.flag = byArray2[n5] & 0xFF | (byArray2[n5 + 1] & 0xFF) << 8;
            n5 = n3 + 10;
            zipEntry.method = byArray2[n5] & 0xFF | (byArray2[n5 + 1] & 0xFF) << 8;
            n5 = n3 + 12;
            int n6 = n5 + 2;
            zipEntry.time = (long)(byArray2[n5] & 0xFF | (byArray2[n5 + 1] & 0xFF) << 8) | (long)(byArray2[n6] & 0xFF | (byArray2[n6 + 1] & 0xFF) << 8) << 16;
            n5 = n3 + 16;
            n6 = n5 + 2;
            zipEntry.crc = (long)(byArray2[n5] & 0xFF | (byArray2[n5 + 1] & 0xFF) << 8) | (long)(byArray2[n6] & 0xFF | (byArray2[n6 + 1] & 0xFF) << 8) << 16;
            n5 = n3 + 24;
            n6 = n5 + 2;
            zipEntry.size = (long)(byArray2[n5] & 0xFF | (byArray2[n5 + 1] & 0xFF) << 8) | (long)(byArray2[n6] & 0xFF | (byArray2[n6 + 1] & 0xFF) << 8) << 16;
            n5 = n3 + 20;
            n6 = n5 + 2;
            zipEntry.csize = (long)(byArray2[n5] & 0xFF | (byArray2[n5 + 1] & 0xFF) << 8) | (long)(byArray2[n6] & 0xFF | (byArray2[n6 + 1] & 0xFF) << 8) << 16;
            n5 = n3 + 42;
            n6 = n5 + 2;
            zipEntry.offset = (long)(byArray2[n5] & 0xFF | (byArray2[n5 + 1] & 0xFF) << 8) | (long)(byArray2[n6] & 0xFF | (byArray2[n6 + 1] & 0xFF) << 8) << 16;
            if (zipEntry.offset + zipEntry.csize > this.cenpos) {
                throw new ZipException("invalid CEN entry size");
            }
            n5 = n3;
            n6 = n5 + 28;
            if ((n6 = byArray2[n6] & 0xFF | (byArray2[n6 + 1] & 0xFF) << 8) == 0 || (n3 += 46) + n6 > n) {
                throw new ZipException("invalid CEN entry name");
            }
            zipEntry.name = new String(byArray2, 0, n3, n6);
            n3 += n6;
            int n7 = n5 + 30;
            n6 = byArray2[n7] & 0xFF | (byArray2[n7 + 1] & 0xFF) << 8;
            if (n6 > 0) {
                if (n3 + n6 > n) {
                    throw new ZipException("invalid CEN entry extra data");
                }
                zipEntry.extra = new byte[n6];
                System.arraycopy(byArray2, n3, zipEntry.extra, 0, n6);
                n3 += n6;
            }
            if ((n6 = byArray2[n7 = n5 + 32] & 0xFF | (byArray2[n7 + 1] & 0xFF) << 8) > 0) {
                if (n3 + n6 > n) {
                    throw new ZipException("invalid CEN entry comment");
                }
                zipEntry.comment = new String(byArray2, 0, n3, n6);
                n3 += n6;
            }
            this.entries.put(zipEntry.name, zipEntry);
        }
        if (this.entries.size() != n2) {
            throw new ZipException("invalid CEN header format");
        }
    }

    private void findEND() throws IOException {
        long l = this.raf.length();
        this.raf.seek(l);
        long l2 = l - 65535L;
        l2 = l2 <= 0L ? 0L : l2;
        byte[] byArray = new byte[68];
        this.pos = l;
        while (this.pos > l2) {
            int n = (int)(this.pos - l2);
            n = n <= 64 ? n : 64;
            this.pos -= (long)n;
            this.raf.seek(this.pos);
            this.raf.readFully(byArray, 0, n);
            while (--n > 0) {
                int n2 = n + 2;
                if (((long)(byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8) | (long)(byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8) << 16) != 101010256L) continue;
                this.endpos = this.pos + (long)n;
                if (l - this.endpos < 22L) continue;
                this.raf.seek(this.endpos);
                byte[] byArray2 = new byte[22];
                RandomAccessFile randomAccessFile = this.raf;
                randomAccessFile.readFully(byArray2, 0, byArray2.length);
                int n3 = byArray2[20] & 0xFF | (byArray2[21] & 0xFF) << 8;
                if (this.endpos + 22L + (long)n3 != l) continue;
                this.raf.seek(this.endpos);
                this.pos = this.endpos;
                return;
            }
        }
        throw new ZipException("not a ZIP file (END header not found)");
    }

    static final int get16(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    static final long get32(byte[] byArray, int n) {
        int n2 = n + 2;
        return (long)(byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8) | (long)(byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8) << 16;
    }
}

