/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.Identity;
import java.security.IdentityScope;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.applet.AppletClassLoader;
import sun.applet.AppletSecurityException;
import sun.security.provider.IdentityDatabase;
import sun.security.provider.SystemIdentity;
import sun.security.provider.SystemSigner;

public class AppletSecurity
extends SecurityManager {
    private static boolean debug;
    static final int NETWORK_NONE = 1;
    static final int NETWORK_HOST = 2;
    static final int NETWORK_UNRESTRICTED = 3;
    private static final int PRIVELEGED_PORT = 1024;
    boolean initACL;
    String[] readACL;
    String[] writeACL;
    int networkMode;
    IdentityScope scope;
    Hashtable loadedClasses;

    public AppletSecurity() {
        this.reset();
    }

    public void reset() {
        String string = System.getProperty("appletviewer.security.mode");
        if (string == null) {
            string = "host";
        }
        this.networkMode = string.equals("unrestricted") ? 3 : (string.equals("none") ? 1 : 2);
        IdentityScope identityScope = IdentityScope.getSystemScope();
        if (identityScope instanceof IdentityDatabase) {
            this.scope = (IdentityDatabase)identityScope;
            this.debug("installing " + identityScope + " as the scope for signers.");
        } else {
            this.debug("no signer scope found.");
        }
        this.loadedClasses = new Hashtable();
    }

    boolean fromApplet() {
        return this.classLoaderDepth() == 1;
    }

    protected boolean assessTrust(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            Identity identity;
            if (objectArray[n] instanceof SystemIdentity ? ((SystemIdentity)(identity = (SystemIdentity)objectArray[n])).isTrusted() : objectArray[n] instanceof SystemSigner && ((SystemSigner)(identity = (SystemSigner)objectArray[n])).isTrusted()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean inApplet() {
        return this.inClassLoader();
    }

    public Object getSecurityContext() {
        ClassLoader classLoader = this.currentClassLoader();
        if (classLoader == null) {
            return null;
        }
        if (classLoader instanceof AppletClassLoader) {
            AppletClassLoader appletClassLoader = (AppletClassLoader)classLoader;
            return appletClassLoader.base;
        }
        throw new AppletSecurityException("getsecuritycontext.unknown");
    }

    public synchronized boolean getInCheck() {
        return super.getInCheck();
    }

    public synchronized void checkCreateClassLoader() {
        if (this.classLoaderDepth() == 2) {
            throw new AppletSecurityException("checkcreateclassloader");
        }
    }

    protected boolean inThreadGroup(ThreadGroup threadGroup) {
        ClassLoader classLoader = this.currentClassLoader();
        if (classLoader instanceof AppletClassLoader) {
            AppletClassLoader appletClassLoader = (AppletClassLoader)classLoader;
            ThreadGroup threadGroup2 = appletClassLoader.getThreadGroup();
            return threadGroup2.parentOf(threadGroup);
        }
        return false;
    }

    protected boolean inThreadGroup(Thread thread) {
        return this.inThreadGroup(thread.getThreadGroup());
    }

    public synchronized void checkAccess(Thread thread) {
        if (this.classLoaderDepth() == 3 && !this.inThreadGroup(thread)) {
            throw new AppletSecurityException("checkaccess.thread");
        }
    }

    public synchronized void checkAccess(ThreadGroup threadGroup) {
        if (this.classLoaderDepth() == 4 && !this.inThreadGroup(threadGroup)) {
            throw new AppletSecurityException("checkaccess.threadgroup", threadGroup.toString());
        }
    }

    public synchronized void checkExit(int n) {
        if (this.inApplet()) {
            throw new AppletSecurityException("checkexit", String.valueOf(n));
        }
    }

    public synchronized void checkExec(String string) {
        if (this.inApplet()) {
            throw new AppletSecurityException("checkexec", string);
        }
    }

    public synchronized void checkLink(String string) {
        switch (this.classLoaderDepth()) {
            case 2: 
            case 3: {
                throw new AppletSecurityException("checklink", string);
            }
        }
    }

    public synchronized void checkPropertiesAccess() {
        if (this.classLoaderDepth() == 2) {
            throw new AppletSecurityException("checkpropsaccess");
        }
    }

    public synchronized void checkPropertyAccess(String string) {
        if (this.classLoaderDepth() == 2) {
            String string2 = System.getProperty(String.valueOf(string) + ".applet");
            boolean bl = new Boolean(string2);
            if (bl) {
                return;
            }
            throw new AppletSecurityException("checkpropsaccess.key", string2);
        }
    }

    void parseACL(Vector vector, String string, String string2) {
        String string3 = System.getProperty("path.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string3);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.startsWith("~")) {
                vector.addElement(String.valueOf(System.getProperty("user.home")) + string4.substring(1));
                continue;
            }
            if (string4.equals("+")) {
                if (string2 == null) continue;
                this.parseACL(vector, string2, null);
                continue;
            }
            vector.addElement(string4);
        }
    }

    String[] parseACL(String string, String string2) {
        if (string == null) {
            return new String[0];
        }
        if (string.equals("*")) {
            return null;
        }
        Vector vector = new Vector();
        this.parseACL(vector, string, string2);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    void initializeACLs() {
        this.readACL = this.parseACL(System.getProperty("acl.read"), System.getProperty("acl.read.default"));
        this.writeACL = this.parseACL(System.getProperty("acl.write"), System.getProperty("acl.write.default"));
        this.initACL = true;
    }

    public synchronized void checkRead(String string) {
        ClassLoader classLoader = this.currentClassLoader();
        if (classLoader == null) {
            return;
        }
        if (!(classLoader instanceof AppletClassLoader)) {
            throw new AppletSecurityException("checkread.unknown", string);
        }
        AppletClassLoader appletClassLoader = (AppletClassLoader)classLoader;
        this.checkRead(string, appletClassLoader.base);
    }

    public synchronized void checkRead(String string, URL uRL) {
        if (uRL != null) {
            if (!this.initACL) {
                this.initializeACLs();
            }
            if (this.readACL == null) {
                return;
            }
            String string2 = null;
            try {
                string2 = new File(string).getCanonicalPath();
            }
            catch (IOException iOException) {
                throw new AppletSecurityException("checkread.exception1", iOException.getMessage(), string);
            }
            int n = this.readACL.length;
            while (n-- > 0) {
                if (!string2.startsWith(this.readACL[n])) continue;
                return;
            }
            String string3 = uRL.getHost();
            if (uRL.getProtocol().equals("file") && (string3 == null || string3.equals("") || string3.equals("~") || string3.equals("localhost"))) {
                String string4 = null;
                try {
                    string4 = new File(uRL.getFile()).getCanonicalPath();
                }
                catch (IOException iOException) {
                    throw new AppletSecurityException("checkread.exception2", iOException.toString());
                }
                if (string2.startsWith(string4)) {
                    return;
                }
            }
            throw new AppletSecurityException("checkread", string, string2);
        }
    }

    public void checkRead(String string, Object object) {
        this.checkRead(string);
        if (object != null) {
            this.checkRead(string, (URL)object);
        }
    }

    public synchronized void checkWrite(String string) {
        if (this.inApplet()) {
            if (!this.initACL) {
                this.initializeACLs();
            }
            if (this.writeACL == null) {
                return;
            }
            String string2 = null;
            try {
                string2 = new File(string).getCanonicalPath();
            }
            catch (IOException iOException) {
                throw new AppletSecurityException("checkwrite.exception", iOException.getMessage(), string);
            }
            int n = this.writeACL.length;
            while (n-- > 0) {
                if (!string2.startsWith(this.writeACL[n])) continue;
                return;
            }
            throw new AppletSecurityException("checkwrite", string, string2);
        }
    }

    public synchronized void checkDelete(String string) {
        this.checkWrite(string);
    }

    public synchronized void checkRead(FileDescriptor fileDescriptor) {
        if (this.inApplet() && !this.inClass("java.net.SocketInputStream") || !fileDescriptor.valid()) {
            throw new AppletSecurityException("checkread.fd");
        }
    }

    public synchronized void checkWrite(FileDescriptor fileDescriptor) {
        if (this.inApplet() && !this.inClass("java.net.SocketOutputStream") || !fileDescriptor.valid()) {
            throw new AppletSecurityException("checkwrite.fd");
        }
    }

    public synchronized void checkListen(int n) {
        if (this.inApplet() && n > 0 && n < 1024) {
            throw new AppletSecurityException("checklisten", String.valueOf(n));
        }
    }

    public synchronized void checkAccept(String string, int n) {
        if (this.inApplet() && n < 1024) {
            throw new AppletSecurityException("checkaccept", string, String.valueOf(n));
        }
        this.checkConnect(string, n);
    }

    public synchronized void checkConnect(String string, int n) {
        ClassLoader classLoader = this.currentClassLoader();
        if (classLoader == null) {
            return;
        }
        int n2 = this.classDepth("sun.net.www.http.HttpClient");
        if (n2 > 1) {
            return;
        }
        if (classLoader instanceof AppletClassLoader) {
            AppletClassLoader appletClassLoader = (AppletClassLoader)classLoader;
            this.checkConnect(appletClassLoader.base.getHost(), string);
            return;
        }
        throw new AppletSecurityException("checkconnect.unknown");
    }

    public void checkConnect(String string, int n, Object object) {
        this.checkConnect(string, n);
        if (object != null) {
            this.checkConnect(((URL)object).getHost(), string);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void checkConnect(String string, String string2, boolean bl) {
        if (string == null) {
            return;
        }
        switch (this.networkMode) {
            case 1: {
                throw new AppletSecurityException("checkconnect.networknone", string, string2);
            }
            case 2: {
                try {
                    this.inCheck = true;
                    if (!string.equals(string2)) {
                        try {
                            InetAddress inetAddress = InetAddress.getByName(string2);
                            InetAddress inetAddress2 = InetAddress.getByName(string);
                            if (inetAddress2.equals(inetAddress)) {
                                Object var5_7 = null;
                                this.inCheck = false;
                                return;
                            }
                            throw new AppletSecurityException("checkconnect.networkhost1", string2, string);
                        }
                        catch (UnknownHostException unknownHostException) {
                            throw new AppletSecurityException("checkconnect.networkhost2", string2, string);
                        }
                    }
                    try {
                        InetAddress inetAddress = InetAddress.getByName(string2);
                    }
                    catch (UnknownHostException unknownHostException) {
                        if (bl) {
                            Object var5_9 = null;
                            this.inCheck = false;
                            return;
                        }
                        throw new AppletSecurityException("checkconnect.networkhost3", string2);
                    }
                }
                catch (Throwable throwable) {
                    Object var5_10 = null;
                    this.inCheck = false;
                    throw throwable;
                }
                Object var5_8 = null;
                this.inCheck = false;
                return;
            }
            case 3: {
                return;
            }
        }
        throw new AppletSecurityException("checkconnect", string, string2);
    }

    public synchronized void checkConnect(String string, String string2) {
        this.checkConnect(string, string2, Boolean.getBoolean("trustProxy"));
    }

    public void checkMulticast(InetAddress inetAddress) {
        if (this.inApplet()) {
            throw new AppletSecurityException("checkMulticast");
        }
    }

    public void checkMulticast(InetAddress inetAddress, byte by) {
        if (this.inApplet()) {
            throw new AppletSecurityException("checkMulticast");
        }
    }

    public synchronized boolean checkTopLevelWindow(Object object) {
        return !this.inClassLoader();
    }

    public synchronized void checkPackageAccess(String string) {
        if (!this.inClassLoader()) {
            return;
        }
        int n = string.indexOf(46);
        while (n > 0) {
            String string2 = string.substring(0, n);
            if (Boolean.getBoolean("package.restrict.access." + string2)) {
                throw new AppletSecurityException("checkpackageaccess", string);
            }
            n = string.indexOf(46, n + 1);
        }
    }

    public synchronized void checkPackageDefinition(String string) {
        if (!this.inClassLoader()) {
            return;
        }
        int n = string.indexOf(46);
        while (n > 0) {
            String string2 = string.substring(0, n);
            if (Boolean.getBoolean("package.restrict.definition." + string2)) {
                throw new AppletSecurityException("checkpackagedefinition", string);
            }
            n = string.indexOf(46, n + 1);
        }
    }

    public synchronized void checkSetFactory() {
        if (this.inApplet() && !this.inClass("sun.net.www.MimeTable")) {
            throw new AppletSecurityException("cannotsetfactory");
        }
    }

    public void checkMemberAccess(Class clazz, int n) {
        ClassLoader classLoader;
        if (n != 0 && (classLoader = this.currentClassLoader()) != null && this.classLoaderDepth() <= 3 && classLoader != clazz.getClassLoader()) {
            throw new AppletSecurityException("checkmemberaccess");
        }
    }

    public void checkPrintJobAccess() {
        if (this.inApplet()) {
            throw new AppletSecurityException("checkgetprintjob");
        }
    }

    public void checkSystemClipboardAccess() {
        if (this.inApplet()) {
            throw new AppletSecurityException("checksystemclipboardaccess");
        }
    }

    public void checkAwtEventQueueAccess() {
        if (this.inApplet()) {
            throw new AppletSecurityException("checkawteventqueueaccess");
        }
    }

    public void checkSecurityAccess(String string) {
        if (this.inApplet()) {
            throw new AppletSecurityException("checksecurityaccess", string);
        }
    }

    public ThreadGroup getThreadGroup() {
        ClassLoader classLoader = this.currentClassLoader();
        if (classLoader != null && classLoader instanceof AppletClassLoader) {
            AppletClassLoader appletClassLoader = (AppletClassLoader)classLoader;
            return appletClassLoader.getThreadGroup();
        }
        return super.getThreadGroup();
    }

    public void debug(String string) {
        if (debug) {
            System.err.println(string);
        }
    }
}

